/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.impl.neomedia.transform;

import org.jitsi.impl.neomedia.transform.PacketTransformer;
import org.jitsi.impl.neomedia.transform.TransformEngine;
import org.jitsi.service.neomedia.RawPacket;
import org.jitsi.utils.logging.Logger;

public class REDTransformEngine
implements TransformEngine,
PacketTransformer {
    private static final Logger logger = Logger.getLogger(REDTransformEngine.class);
    private byte incomingPT;
    private byte outgoingPT;

    public REDTransformEngine(byte incomingPT, byte outgoingPT) {
        this.setIncomingPT(incomingPT);
        this.setOutgoingPT(outgoingPT);
    }

    public REDTransformEngine() {
        this(-1, -1);
    }

    public void setIncomingPT(byte incomingPT) {
        this.incomingPT = incomingPT;
        if (logger.isInfoEnabled()) {
            logger.info((Object)("Set incoming payload type " + incomingPT));
        }
    }

    public void setOutgoingPT(byte outgoingPT) {
        this.outgoingPT = outgoingPT;
        if (logger.isInfoEnabled()) {
            logger.info((Object)("Set outgoing payload type " + outgoingPT));
        }
    }

    @Override
    public void close() {
    }

    @Override
    public RawPacket[] reverseTransform(RawPacket[] pkts) {
        if (this.incomingPT == -1) {
            return pkts;
        }
        if (pkts != null && pkts.length > 0 && pkts[0] != null && pkts[0].getPayloadType() == this.incomingPT) {
            return this.reverseTransformSingle(pkts[0], pkts);
        }
        return pkts;
    }

    @Override
    public RawPacket[] transform(RawPacket[] pkts) {
        if (this.outgoingPT == -1) {
            return pkts;
        }
        for (RawPacket pkt : pkts) {
            if (pkt == null || pkt.getVersion() != 2) continue;
            byte[] buf = pkt.getBuffer();
            int len = pkt.getLength();
            int off = pkt.getOffset();
            int hdrLen = pkt.getHeaderLength();
            byte[] newBuf = buf;
            if (newBuf.length < len + 1) {
                newBuf = new byte[len + 1];
            }
            System.arraycopy(buf, off, newBuf, 0, hdrLen);
            System.arraycopy(buf, off + hdrLen, newBuf, hdrLen + 1, len - hdrLen);
            newBuf[hdrLen] = pkt.getPayloadType();
            pkt.setBuffer(newBuf);
            pkt.setOffset(0);
            pkt.setLength(len + 1);
            pkt.setPayloadType(this.outgoingPT);
        }
        return pkts;
    }

    private RawPacket[] reverseTransformSingle(RawPacket pkt, RawPacket[] pkts) {
        byte[] buf = pkt.getBuffer();
        int off = pkt.getOffset();
        int hdrLen = pkt.getHeaderLength();
        int idx = off + hdrLen;
        int pktCount = 1;
        while ((buf[idx] & 0x80) != 0) {
            ++pktCount;
            idx += 4;
        }
        idx = off + hdrLen;
        if (pkts.length < pktCount) {
            pkts = new RawPacket[pktCount];
        }
        if (pktCount != 1 && logger.isInfoEnabled()) {
            logger.info((Object)"Received a RED packet with more than one packet inside");
        }
        int payloadOffset = idx + (pktCount - 1) * 4 + 1;
        for (int i = 1; i < pktCount; ++i) {
            int blockLen = (buf[idx + 2] & 3) << 8 | buf[idx + 3] & 0xFF;
            byte[] newBuf = new byte[hdrLen + blockLen];
            System.arraycopy(buf, payloadOffset, newBuf, 0, hdrLen + blockLen);
            if (pkts[i] == null) {
                pkts[i] = new RawPacket();
            }
            pkts[i].setBuffer(newBuf);
            pkts[i].setOffset(0);
            pkts[i].setLength(hdrLen + blockLen);
            pkts[i].setPayloadType((byte)(buf[idx] & 0xF7));
            idx += 4;
            payloadOffset += blockLen;
        }
        pkt.setPayloadType((byte)(buf[idx] & 0x7F));
        System.arraycopy(buf, off, buf, off + payloadOffset - hdrLen, hdrLen);
        pkt.setOffset(off + payloadOffset - hdrLen);
        pkt.setLength(pkt.getLength() - (payloadOffset - hdrLen));
        pkts[0] = pkt;
        return pkts;
    }

    @Override
    public PacketTransformer getRTPTransformer() {
        return this;
    }

    @Override
    public PacketTransformer getRTCPTransformer() {
        return null;
    }
}

