/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.impl.neomedia.transform;

import java.net.InetSocketAddress;
import org.jitsi.impl.neomedia.MediaStreamImpl;
import org.jitsi.impl.neomedia.RTPPacketPredicate;
import org.jitsi.impl.neomedia.transform.SinglePacketTransformer;
import org.jitsi.impl.neomedia.transform.TransformEngine;
import org.jitsi.service.configuration.ConfigurationService;
import org.jitsi.service.libjitsi.LibJitsi;
import org.jitsi.service.neomedia.MediaStreamTarget;
import org.jitsi.service.neomedia.RawPacket;
import org.jitsi.service.packetlogging.PacketLoggingService;
import org.jitsi.utils.logging.Logger;

public class DebugTransformEngine
implements TransformEngine {
    private static final Logger logger = Logger.getLogger(DebugTransformEngine.class);
    private static final ConfigurationService cfg = LibJitsi.getConfigurationService();
    private static final String LOG_RTP_PAYLOAD_PNAME = "org.jitsi.impl.neomedia.transform.DebugTransformEngine.LOG_RTP_PAYLOAD";
    private static boolean LOG_RTP_PAYLOAD = cfg.getBoolean("org.jitsi.impl.neomedia.transform.DebugTransformEngine.LOG_RTP_PAYLOAD", false);
    private final MediaStreamImpl mediaStream;
    private final PacketLoggingService _pktLogging;
    private final SinglePacketTransformer rtcpTransformer = new MyRTCPPacketTransformer();
    private final SinglePacketTransformer rtpTransformer = new MyRTPPacketTransformer();

    private DebugTransformEngine(MediaStreamImpl mediaStream, PacketLoggingService pktLogging) {
        this.mediaStream = mediaStream;
        this._pktLogging = pktLogging;
    }

    public static DebugTransformEngine createDebugTransformEngine(MediaStreamImpl mediaStream) {
        PacketLoggingService pktLogging = LibJitsi.getPacketLoggingService();
        if (pktLogging != null && pktLogging.isLoggingEnabled(PacketLoggingService.ProtocolName.ARBITRARY)) {
            return new DebugTransformEngine(mediaStream, pktLogging);
        }
        return null;
    }

    @Override
    public SinglePacketTransformer getRTCPTransformer() {
        return this.rtcpTransformer;
    }

    @Override
    public SinglePacketTransformer getRTPTransformer() {
        return this.rtpTransformer;
    }

    private RawPacket transform(RawPacket pkt, boolean data, boolean sender) {
        InetSocketAddress dst;
        InetSocketAddress src;
        if (pkt == null) {
            return null;
        }
        if (this.mediaStream == null) {
            logger.warn((Object)"Not logging a packet because the mediaStream is null");
            return pkt;
        }
        PacketLoggingService pktLogging = this._pktLogging;
        if (pktLogging == null) {
            logger.warn((Object)"Not logging a packet because the PacketLoggingService is null.");
            return pkt;
        }
        if (data) {
            InetSocketAddress localDataAddress = this.mediaStream.getLocalDataAddress();
            if (localDataAddress == null) {
                logger.warn((Object)"Not logging a packet because the local data address is null");
                return pkt;
            }
            MediaStreamTarget target = this.mediaStream.getTarget();
            if (target == null) {
                logger.warn((Object)"Not logging a packet because the media stream target is null.");
                return pkt;
            }
            InetSocketAddress targetDataAddress = target.getDataAddress();
            if (targetDataAddress == null) {
                logger.warn((Object)"Not logging a packet because the media stream target address is null.");
                return pkt;
            }
            src = localDataAddress;
            dst = targetDataAddress;
        } else {
            InetSocketAddress localControlAddress = this.mediaStream.getLocalControlAddress();
            if (localControlAddress == null) {
                logger.warn((Object)"Not logging a packet because the local data address is null");
                return pkt;
            }
            MediaStreamTarget target = this.mediaStream.getTarget();
            if (target == null) {
                logger.warn((Object)"Not logging a packet because the media stream target is null.");
                return pkt;
            }
            InetSocketAddress targetControlAddress = target.getControlAddress();
            if (targetControlAddress == null) {
                logger.warn((Object)"Not logging a packet because the media stream target address is null.");
                return pkt;
            }
            src = localControlAddress;
            dst = targetControlAddress;
        }
        if (!sender) {
            InetSocketAddress swap = src;
            src = dst;
            dst = swap;
        }
        int len = pkt.getLength();
        if (!LOG_RTP_PAYLOAD && RTPPacketPredicate.INSTANCE.test(pkt)) {
            len = pkt.getHeaderLength();
        }
        pktLogging.logPacket(PacketLoggingService.ProtocolName.ARBITRARY, src.getAddress().getAddress(), src.getPort(), dst.getAddress().getAddress(), dst.getPort(), PacketLoggingService.TransportName.UDP, sender, (byte[])pkt.getBuffer().clone(), pkt.getOffset(), len);
        return pkt;
    }

    class MyRTCPPacketTransformer
    extends SinglePacketTransformer {
        MyRTCPPacketTransformer() {
        }

        @Override
        public RawPacket reverseTransform(RawPacket pkt) {
            return DebugTransformEngine.this.transform(pkt, false, false);
        }

        @Override
        public RawPacket transform(RawPacket pkt) {
            return DebugTransformEngine.this.transform(pkt, false, true);
        }
    }

    class MyRTPPacketTransformer
    extends SinglePacketTransformer {
        MyRTPPacketTransformer() {
        }

        @Override
        public RawPacket reverseTransform(RawPacket pkt) {
            return DebugTransformEngine.this.transform(pkt, true, false);
        }

        @Override
        public RawPacket transform(RawPacket pkt) {
            return DebugTransformEngine.this.transform(pkt, true, true);
        }
    }
}

