/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.impl.neomedia.rtcp;

import org.jitsi.service.neomedia.ByteArrayBuffer;
import org.jitsi.util.RTPUtils;

public class RTCPSenderInfoUtils {
    public static long getTimestamp(byte[] buf, int off, int len) {
        if (!RTCPSenderInfoUtils.isValid(buf, off, len)) {
            return -1L;
        }
        return RTPUtils.readUint32AsLong(buf, off + 16);
    }

    public static int setTimestamp(byte[] buf, int off, int len, int ts) {
        if (!RTCPSenderInfoUtils.isValid(buf, off, len)) {
            return -1;
        }
        return RTPUtils.writeInt(buf, off + 16, ts);
    }

    public static boolean isValid(byte[] buf, int off, int len) {
        return buf != null && buf.length >= off + len && len >= 20;
    }

    public static int setTimestamp(ByteArrayBuffer baf, int ts) {
        if (baf == null) {
            return -1;
        }
        return RTCPSenderInfoUtils.setTimestamp(baf.getBuffer(), baf.getOffset(), baf.getLength(), ts);
    }

    public static long getTimestamp(ByteArrayBuffer baf) {
        if (baf == null) {
            return -1L;
        }
        return RTCPSenderInfoUtils.getTimestamp(baf.getBuffer(), baf.getOffset(), baf.getLength());
    }

    public static int setOctetCount(ByteArrayBuffer baf, int octetCount) {
        if (baf == null) {
            return -1;
        }
        return RTCPSenderInfoUtils.setOctetCount(baf.getBuffer(), baf.getOffset(), baf.getLength(), octetCount);
    }

    public static int setPacketCount(ByteArrayBuffer baf, int packetCount) {
        if (baf == null) {
            return -1;
        }
        return RTCPSenderInfoUtils.setPacketCount(baf.getBuffer(), baf.getOffset(), baf.getLength(), packetCount);
    }

    private static int setPacketCount(byte[] buf, int off, int len, int packetCount) {
        if (!RTCPSenderInfoUtils.isValid(buf, off, len)) {
            return -1;
        }
        return RTPUtils.writeInt(buf, off + 20, packetCount);
    }

    private static int setOctetCount(byte[] buf, int off, int len, int octetCount) {
        if (!RTCPSenderInfoUtils.isValid(buf, off, len)) {
            return -1;
        }
        return RTPUtils.writeInt(buf, off + 24, octetCount);
    }
}

