/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.impl.neomedia.recording;

import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.jitsi.service.neomedia.RawPacket;
import org.jitsi.service.neomedia.recording.Synchronizer;
import org.jitsi.util.RTPUtils;

public class SynchronizerImpl
implements Synchronizer {
    private static final boolean USE_CNAME_AS_ENDPOINT_ID = false;
    private static final int PT_SENDER_REPORT = 200;
    private static final int PT_SDES = 202;
    private final Map<Long, SSRCDesc> ssrcs = new ConcurrentHashMap<Long, SSRCDesc>();
    private final Map<String, Endpoint> endpoints = new ConcurrentHashMap<String, Endpoint>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setRtpClockRate(long ssrc, long clockRate) {
        SSRCDesc ssrcDesc = this.getSSRCDesc(ssrc);
        if (ssrcDesc.clockRate == -1L) {
            SSRCDesc sSRCDesc = ssrcDesc;
            synchronized (sSRCDesc) {
                if (ssrcDesc.clockRate == -1L) {
                    ssrcDesc.clockRate = clockRate;
                } else if (ssrcDesc.clockRate != clockRate) {
                    ssrcDesc.clockRate = clockRate;
                    ssrcDesc.ntpTime = -1.0;
                    ssrcDesc.rtpTime = -1L;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setEndpoint(long ssrc, String endpointId) {
        SSRCDesc ssrcDesc;
        SSRCDesc sSRCDesc = ssrcDesc = this.getSSRCDesc(ssrc);
        synchronized (sSRCDesc) {
            ssrcDesc.endpointId = endpointId;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void mapRtpToNtp(long ssrc, long rtpTime, double ntpTime) {
        SSRCDesc ssrcDesc = this.getSSRCDesc(ssrc);
        if (rtpTime != -1L && ntpTime != -1.0 && (ssrcDesc.rtpTime == -1L || ssrcDesc.ntpTime == -1.0)) {
            SSRCDesc sSRCDesc = ssrcDesc;
            synchronized (sSRCDesc) {
                if (ssrcDesc.rtpTime == -1L || ssrcDesc.ntpTime == -1.0) {
                    ssrcDesc.rtpTime = rtpTime;
                    ssrcDesc.ntpTime = ntpTime;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void mapLocalToNtp(long ssrc, long localTime, double ntpTime) {
        SSRCDesc ssrcDesc = this.getSSRCDesc(ssrc);
        if (localTime != -1L && ntpTime != -1.0 && ssrcDesc.endpointId != null) {
            Endpoint endpoint = this.getEndpoint(ssrcDesc.endpointId);
            if (endpoint.localTime == -1L || endpoint.ntpTime == -1.0) {
                Endpoint endpoint2 = endpoint;
                synchronized (endpoint2) {
                    if (endpoint.localTime == -1L || endpoint.ntpTime == -1.0) {
                        endpoint.localTime = localTime;
                        endpoint.ntpTime = ntpTime;
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long getLocalTime(long ssrc, long rtp0) {
        long local2;
        double ntp2;
        String endpointId;
        double ntp1;
        long rtp1;
        long clockRate;
        SSRCDesc ssrcDesc = this.ssrcs.get(ssrc);
        if (ssrcDesc == null) {
            return -1L;
        }
        SSRCDesc sSRCDesc = ssrcDesc;
        synchronized (sSRCDesc) {
            clockRate = ssrcDesc.clockRate;
            rtp1 = ssrcDesc.rtpTime;
            ntp1 = ssrcDesc.ntpTime;
            endpointId = ssrcDesc.endpointId;
        }
        if (clockRate == -1L || rtp1 == -1L || ntp1 == -1.0 || endpointId == null) {
            return -1L;
        }
        Endpoint endpoint = this.endpoints.get(ssrcDesc.endpointId);
        if (endpoint == null) {
            return -1L;
        }
        Endpoint endpoint2 = endpoint;
        synchronized (endpoint2) {
            ntp2 = endpoint.ntpTime;
            local2 = endpoint.localTime;
        }
        if (ntp2 == -1.0 || local2 == -1L) {
            return -1L;
        }
        double diff1S = ntp1 - ntp2;
        double diff2S = (double)RTPUtils.rtpTimestampDiff(rtp0, rtp1) / (double)clockRate;
        long diffMs = Math.round((diff1S + diff2S) * 1000.0);
        long local0 = local2 + diffMs;
        return local0;
    }

    void addRTCPPacket(RawPacket pkt) {
        this.addRTCPPacket(pkt, System.currentTimeMillis());
    }

    void addRTCPPacket(RawPacket pkt, long localTime) {
        if (!this.isValidRTCP(pkt)) {
            return;
        }
        switch (this.getPacketType(pkt)) {
            case 200: {
                this.addSR(pkt, localTime);
                break;
            }
            case 202: {
                this.addSDES(pkt);
            }
        }
    }

    private void addSDES(RawPacket pkt) {
    }

    private void addSR(RawPacket pkt, long localTime) {
        long ssrc = pkt.getRTCPSSRC();
        long rtpTime = pkt.readUint32AsLong(16);
        long sec = pkt.readUint32AsLong(8);
        long fract = pkt.readUint32AsLong(12);
        double ntpTime = (double)sec + (double)fract / 4.294967296E9;
        if (localTime != -1L && ntpTime != -1.0) {
            this.mapLocalToNtp(ssrc, localTime, ntpTime);
        }
        if (rtpTime != -1L && ntpTime != -1.0) {
            this.mapRtpToNtp(ssrc, rtpTime, ntpTime);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SSRCDesc getSSRCDesc(long ssrc) {
        Map<Long, SSRCDesc> map = this.ssrcs;
        synchronized (map) {
            SSRCDesc ssrcDesc = this.ssrcs.get(ssrc);
            if (ssrcDesc == null) {
                ssrcDesc = new SSRCDesc();
                this.ssrcs.put(ssrc, ssrcDesc);
            }
            return ssrcDesc;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Endpoint getEndpoint(String endpointId) {
        Map<String, Endpoint> map = this.endpoints;
        synchronized (map) {
            Endpoint endpoint = this.endpoints.get(endpointId);
            if (endpoint == null) {
                endpoint = new Endpoint();
                this.endpoints.put(endpointId, endpoint);
            }
            return endpoint;
        }
    }

    private Set<CNAMEItem> getCnameItems(RawPacket pkt) {
        HashSet<CNAMEItem> ret = new HashSet<CNAMEItem>();
        byte[] buf = pkt.getBuffer();
        int off = pkt.getOffset();
        int len = pkt.getLength();
        int ptr = 4;
        while (ptr + 6 < len) {
            byte type = buf[off + ptr + 4];
            byte len2 = buf[off + ptr + 5];
            if (ptr + 6 + len2 >= len) break;
            if (type == 1) {
                CNAMEItem item = new CNAMEItem();
                item.ssrc = this.readUnsignedIntAsLong(buf, off + ptr);
                item.cname = this.readString(buf, off + ptr + 6, len2);
                ret.add(item);
            }
            ptr += 6 + len2;
        }
        return ret;
    }

    private String readString(byte[] buf, int off, int len) {
        String ret = "";
        for (int i = off; i < off + len; ++i) {
            ret = ret + (char)buf[i];
        }
        return ret;
    }

    public long readUnsignedIntAsLong(byte[] buf, int off) {
        int b0 = 0xFF & buf[off + 0];
        int b1 = 0xFF & buf[off + 1];
        int b2 = 0xFF & buf[off + 2];
        int b3 = 0xFF & buf[off + 3];
        return (long)(b0 << 24 | b1 << 16 | b2 << 8 | b3) & 0xFFFFFFFFL;
    }

    private boolean isValidRTCP(RawPacket pkt) {
        byte[] buf = pkt.getBuffer();
        int off = pkt.getOffset();
        int len = pkt.getLength();
        if (len < 4) {
            return false;
        }
        int v = (buf[off] & 0xC0) >>> 6;
        if (v != 2) {
            return false;
        }
        int lengthInWords = (buf[off + 2] & 0xFF) << 8 | buf[off + 3] & 0xFF;
        int lengthInBytes = (lengthInWords + 1) * 4;
        return len >= lengthInBytes;
    }

    private int getPacketType(RawPacket pkt) {
        return pkt.getBuffer()[pkt.getOffset() + 1] & 0xFF;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeMapping(long ssrc) {
        SSRCDesc ssrcDesc = this.ssrcs.get(ssrc);
        if (ssrcDesc != null) {
            SSRCDesc sSRCDesc = ssrcDesc;
            synchronized (sSRCDesc) {
                ssrcDesc.ntpTime = -1.0;
                ssrcDesc.rtpTime = -1L;
            }
        }
    }

    private static class CNAMEItem {
        long ssrc;
        String cname;

        private CNAMEItem() {
        }
    }

    private static class Endpoint {
        double ntpTime = -1.0;
        long localTime = -1L;

        private Endpoint() {
        }
    }

    private static class SSRCDesc {
        String endpointId = null;
        long clockRate = -1L;
        double ntpTime = -1.0;
        long rtpTime = -1L;

        private SSRCDesc() {
        }
    }
}

