/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.psi.impl.source.resolve.graphInference.constraints;

import java.util.List;
import org.jetbrains.kotlin.com.intellij.openapi.diagnostic.Logger;
import org.jetbrains.kotlin.com.intellij.psi.LambdaUtil;
import org.jetbrains.kotlin.com.intellij.psi.PsiClass;
import org.jetbrains.kotlin.com.intellij.psi.PsiClassType;
import org.jetbrains.kotlin.com.intellij.psi.PsiCodeBlock;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.com.intellij.psi.PsiExpression;
import org.jetbrains.kotlin.com.intellij.psi.PsiLambdaExpression;
import org.jetbrains.kotlin.com.intellij.psi.PsiMethod;
import org.jetbrains.kotlin.com.intellij.psi.PsiParameter;
import org.jetbrains.kotlin.com.intellij.psi.PsiSubstitutor;
import org.jetbrains.kotlin.com.intellij.psi.PsiType;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.resolve.graphInference.FunctionalInterfaceParameterizationUtil;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.resolve.graphInference.InferenceSession;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.resolve.graphInference.InferenceVariable;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.resolve.graphInference.PsiPolyExpressionUtil;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.resolve.graphInference.constraints.ConstraintFormula;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.resolve.graphInference.constraints.ExpressionCompatibilityConstraint;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.resolve.graphInference.constraints.StrictSubtypingConstraint;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.resolve.graphInference.constraints.TypeEqualityConstraint;
import org.jetbrains.kotlin.com.intellij.psi.util.PsiUtil;
import org.jetbrains.kotlin.com.intellij.psi.util.TypeConversionUtil;

public class LambdaExpressionCompatibilityConstraint
implements ConstraintFormula {
    private static final Logger LOG = Logger.getInstance(LambdaExpressionCompatibilityConstraint.class);
    private final PsiLambdaExpression myExpression;
    private PsiType myT;

    public LambdaExpressionCompatibilityConstraint(PsiLambdaExpression expression2, PsiType t) {
        this.myExpression = expression2;
        this.myT = t;
    }

    @Override
    public boolean reduce(InferenceSession session, List<ConstraintFormula> constraints) {
        block17: {
            if (!LambdaUtil.isFunctionalType(this.myT)) {
                session.registerIncompatibleErrorMessage(session.getPresentableText(this.myT) + " is not a functional interface");
                return false;
            }
            PsiType groundTargetType = FunctionalInterfaceParameterizationUtil.getGroundTargetType(this.myT, this.myExpression, false);
            PsiClassType.ClassResolveResult resolveResult = PsiUtil.resolveGenericsClassInType(groundTargetType);
            PsiMethod interfaceMethod = LambdaUtil.getFunctionalInterfaceMethod(resolveResult);
            if (interfaceMethod == null) {
                session.registerIncompatibleErrorMessage("No valid function type can be found for " + session.getPresentableText(this.myT));
                return false;
            }
            PsiSubstitutor substitutor2 = LambdaUtil.getSubstitutor(interfaceMethod, resolveResult);
            PsiParameter[] parameters2 = interfaceMethod.getParameterList().getParameters();
            PsiParameter[] lambdaParameters = this.myExpression.getParameterList().getParameters();
            if (lambdaParameters.length != parameters2.length) {
                session.registerIncompatibleErrorMessage("Incompatible parameter types in lambda expression");
                return false;
            }
            if (this.myExpression.hasFormalParameterTypes()) {
                for (int i = 0; i < lambdaParameters.length; ++i) {
                    constraints.add(new TypeEqualityConstraint(lambdaParameters[i].getType(), session.substituteWithInferenceVariables(substitutor2.substitute(parameters2[i].getType()))));
                }
                constraints.add(new StrictSubtypingConstraint(this.myT, groundTargetType));
            } else {
                for (PsiParameter parameter : parameters2) {
                    PsiType type3 = session.substituteWithInferenceVariables(substitutor2.substitute(parameter.getType()));
                    if (session.isProperType(type3)) continue;
                    return false;
                }
            }
            PsiType returnType = interfaceMethod.getReturnType();
            if (returnType == null) break block17;
            List<PsiExpression> returnExpressions = LambdaUtil.getReturnExpressions(this.myExpression);
            PsiElement lambdaBody = this.myExpression.getBody();
            if (returnType.equals(PsiType.VOID)) {
                if (!(lambdaBody instanceof PsiCodeBlock && this.myExpression.isVoidCompatible() || LambdaUtil.isExpressionStatementExpression(lambdaBody))) {
                    session.registerIncompatibleErrorMessage("Incompatible types: expected void but the lambda body is neither a statement expression nor a void-compatible block");
                    return false;
                }
            } else {
                if (lambdaBody instanceof PsiCodeBlock && !this.myExpression.isValueCompatible()) {
                    session.registerIncompatibleErrorMessage("Incompatible types: expected not void but the lambda body is a block that is not value-compatible");
                    return false;
                }
                PsiSubstitutor nestedSubstitutor = session.getInferenceSessionContainer().findNestedSubstitutor(this.myExpression, session.getInferenceSubstitution());
                returnType = nestedSubstitutor.substitute(substitutor2.substitute(returnType));
                boolean isProperType2 = InferenceSession.collectDependencies(returnType, null, type2 -> {
                    PsiClass psiClass = PsiUtil.resolveClassInClassTypeOnly(type2);
                    return psiClass instanceof InferenceVariable && nestedSubstitutor.getSubstitutionMap().containsValue(type2) ? (InferenceVariable)psiClass : null;
                });
                if (!isProperType2 || this.myExpression.hasFormalParameterTypes()) {
                    for (PsiExpression returnExpression : returnExpressions) {
                        constraints.add(new ExpressionCompatibilityConstraint(returnExpression, returnType));
                    }
                } else {
                    for (PsiExpression returnExpression : returnExpressions) {
                        if (PsiPolyExpressionUtil.isPolyExpression(returnExpression) || TypeConversionUtil.areTypesAssignmentCompatible(returnType, returnExpression)) continue;
                        PsiType type4 = returnExpression.getType();
                        if (type4 != null) {
                            session.registerIncompatibleErrorMessage("Bad return type in lambda expression: " + session.getPresentableText(type4) + " cannot be converted to " + session.getPresentableText(returnType));
                        } else {
                            session.registerIncompatibleErrorMessage(returnExpression.getText() + " is not compatible with " + session.getPresentableText(returnType));
                        }
                        return false;
                    }
                }
            }
        }
        return true;
    }

    @Override
    public void apply(PsiSubstitutor substitutor2, boolean cache2) {
        this.myT = substitutor2.substitute(this.myT);
    }

    public String toString() {
        return this.myExpression.getText() + " -> " + this.myT.getPresentableText();
    }
}

