/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.bundleplugin;

import aQute.bnd.header.Parameters;
import aQute.bnd.osgi.Analyzer;
import aQute.bnd.osgi.Builder;
import aQute.bnd.osgi.Instructions;
import aQute.bnd.osgi.Jar;
import aQute.bnd.osgi.Processor;
import aQute.bnd.osgi.Resource;
import aQute.lib.collections.ExtList;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Properties;
import java.util.jar.Manifest;
import org.apache.felix.bundleplugin.BundlePlugin;
import org.apache.felix.bundleplugin.ManifestWriter;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProject;
import org.apache.maven.shared.dependency.graph.DependencyNode;

@Mojo(name="manifest", requiresDependencyResolution=ResolutionScope.TEST, threadSafe=true, defaultPhase=LifecyclePhase.PROCESS_CLASSES)
public class ManifestPlugin
extends BundlePlugin {
    @Parameter(property="rebuildBundle")
    protected boolean rebuildBundle;
    protected File scrLocation;
    protected boolean exportScr;

    @Override
    protected void execute(MavenProject project, DependencyNode dependencyGraph, Map<String, String> instructions, Properties properties, Jar[] classpath) throws MojoExecutionException {
        Analyzer analyzer;
        try {
            analyzer = this.getAnalyzer(project, dependencyGraph, instructions, properties, classpath);
        }
        catch (FileNotFoundException e) {
            throw new MojoExecutionException("Cannot find " + e.getMessage() + " (manifest goal must be run after compile phase)", (Exception)e);
        }
        catch (IOException e) {
            throw new MojoExecutionException("Error trying to generate Manifest", (Exception)e);
        }
        catch (MojoFailureException e) {
            this.getLog().error((CharSequence)e.getLocalizedMessage());
            throw new MojoExecutionException("Error(s) found in manifest configuration", (Exception)((Object)e));
        }
        catch (Exception e) {
            this.getLog().error((CharSequence)"An internal error occurred", (Throwable)e);
            throw new MojoExecutionException("Internal error in maven-bundle-plugin", e);
        }
        File outputFile = new File(this.manifestLocation, "MANIFEST.MF");
        try {
            ManifestPlugin.writeManifest(analyzer, outputFile, this.niceManifest);
        }
        catch (Exception e) {
            throw new MojoExecutionException("Error trying to write Manifest to file " + outputFile, e);
        }
        finally {
            try {
                analyzer.close();
            }
            catch (IOException e) {
                throw new MojoExecutionException("Error trying to write Manifest to file " + outputFile, (Exception)e);
            }
        }
    }

    public Manifest getManifest(MavenProject project, DependencyNode dependencyGraph, Jar[] classpath) throws IOException, MojoFailureException, MojoExecutionException, Exception {
        return this.getManifest(project, dependencyGraph, new LinkedHashMap<String, String>(), new Properties(), classpath);
    }

    public Manifest getManifest(MavenProject project, DependencyNode dependencyGraph, Map<String, String> instructions, Properties properties, Jar[] classpath) throws IOException, MojoFailureException, MojoExecutionException, Exception {
        Analyzer analyzer = this.getAnalyzer(project, dependencyGraph, instructions, properties, classpath);
        Jar jar = analyzer.getJar();
        Manifest manifest = jar.getManifest();
        if (this.exportScr) {
            this.scrLocation.mkdirs();
            String bpHeader = analyzer.getProperty("Service-Component");
            Parameters map = Processor.parseHeader((String)bpHeader, null);
            for (String root : map.keySet()) {
                Map dir = (Map)jar.getDirectories().get(root);
                File location = new File(this.scrLocation, root);
                if (dir == null || dir.isEmpty()) {
                    Resource resource = jar.getResource(root);
                    if (resource == null) continue;
                    this.writeSCR(resource, location);
                    continue;
                }
                for (Map.Entry entry : dir.entrySet()) {
                    String path = (String)entry.getKey();
                    Resource resource = (Resource)entry.getValue();
                    this.writeSCR(resource, new File(location, path));
                }
            }
        }
        analyzer.close();
        return manifest;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void writeSCR(Resource resource, File destination) throws Exception {
        destination.getParentFile().mkdirs();
        FileOutputStream os = new FileOutputStream(destination);
        try {
            resource.write((OutputStream)os);
        }
        finally {
            ((OutputStream)os).close();
        }
    }

    protected Analyzer getAnalyzer(MavenProject project, DependencyNode dependencyGraph, Jar[] classpath) throws IOException, MojoExecutionException, Exception {
        return this.getAnalyzer(project, dependencyGraph, new LinkedHashMap<String, String>(), new Properties(), classpath);
    }

    protected Analyzer getAnalyzer(MavenProject project, DependencyNode dependencyGraph, Map<String, String> instructions, Properties properties, Jar[] classpath) throws IOException, MojoExecutionException, Exception {
        String failok;
        if (this.rebuildBundle && this.supportedProjectTypes.contains(project.getArtifact().getType())) {
            return this.buildOSGiBundle(project, dependencyGraph, instructions, properties, classpath);
        }
        File file = this.getOutputDirectory();
        if (file == null) {
            file = project.getArtifact().getFile();
        }
        if (!file.exists()) {
            if (file.equals(this.getOutputDirectory())) {
                file.mkdirs();
            } else {
                throw new FileNotFoundException(file.getPath());
            }
        }
        Builder analyzer = this.getOSGiBuilder(project, instructions, properties, classpath);
        analyzer.setJar(file);
        boolean isOutputDirectory = file.equals(this.getOutputDirectory());
        if (analyzer.getProperty("Export-Package") == null && analyzer.getProperty("-exportcontents") == null && analyzer.getProperty("Private-Package") == null && !isOutputDirectory) {
            String export = ManifestPlugin.calculateExportsFromContents(analyzer.getJar());
            analyzer.setProperty("Export-Package", export);
        }
        this.addMavenInstructions(project, dependencyGraph, analyzer);
        if (analyzer.getProperty("Embed-Dependency") != null && isOutputDirectory) {
            analyzer.build();
        } else {
            analyzer.mergeManifest(analyzer.getJar().getManifest());
            analyzer.getJar().setManifest(analyzer.calcManifest());
        }
        this.mergeMavenManifest(project, dependencyGraph, analyzer);
        boolean hasErrors = this.reportErrors("Manifest " + project.getArtifact(), (Analyzer)analyzer);
        if (hasErrors && (null == (failok = analyzer.getProperty("-failok")) || "false".equalsIgnoreCase(failok))) {
            throw new MojoFailureException("Error(s) found in manifest configuration");
        }
        Jar jar = analyzer.getJar();
        if (this.unpackBundle) {
            File outputFile = this.getOutputDirectory();
            for (Map.Entry entry : jar.getResources().entrySet()) {
                File entryFile = new File(outputFile, (String)entry.getKey());
                if (entryFile.exists() && ((Resource)entry.getValue()).lastModified() != 0L) continue;
                entryFile.getParentFile().mkdirs();
                FileOutputStream os = new FileOutputStream(entryFile);
                ((Resource)entry.getValue()).write((OutputStream)os);
                ((OutputStream)os).close();
            }
        }
        return analyzer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeManifest(Analyzer analyzer, File outputFile, boolean niceManifest) throws Exception {
        Properties properties = analyzer.getProperties();
        Manifest manifest = analyzer.getJar().getManifest();
        if (outputFile.exists() && properties.containsKey("Merge-Headers")) {
            Manifest analyzerManifest = manifest;
            manifest = new Manifest();
            FileInputStream inputStream = new FileInputStream(outputFile);
            try {
                manifest.read(inputStream);
            }
            finally {
                ((InputStream)inputStream).close();
            }
            Instructions instructions = new Instructions((Collection)ExtList.from((String)analyzer.getProperty("Merge-Headers")));
            ManifestPlugin.mergeManifest(instructions, manifest, analyzerManifest);
        } else {
            File parentFile = outputFile.getParentFile();
            parentFile.mkdirs();
        }
        ManifestPlugin.writeManifest(manifest, outputFile, niceManifest);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeManifest(Manifest manifest, File outputFile, boolean niceManifest) throws IOException {
        outputFile.getParentFile().mkdirs();
        FileOutputStream os = new FileOutputStream(outputFile);
        try {
            ManifestWriter.outputManifest(manifest, os, niceManifest);
        }
        finally {
            try {
                os.close();
            }
            catch (IOException e) {}
        }
    }

    public static String calculateExportsFromContents(Jar bundle) {
        String ddel = "";
        StringBuffer sb = new StringBuffer();
        Map map = bundle.getDirectories();
        for (Map.Entry entry : map.entrySet()) {
            String directory;
            if (entry.getValue() == null || ((Map)entry.getValue()).isEmpty() || (directory = (String)entry.getKey()).equals("META-INF") || directory.startsWith("META-INF/") || directory.equals("OSGI-OPT") || directory.startsWith("OSGI-OPT/") || directory.equals("/")) continue;
            if (directory.endsWith("/")) {
                directory = directory.substring(0, directory.length() - 1);
            }
            directory = directory.replace('/', '.');
            sb.append(ddel);
            sb.append(directory);
            ddel = ",";
        }
        return sb.toString();
    }
}

