/*
 * Decompiled with CFR 0.152.
 */
package org.scalafmt.cli;

import com.martiansoftware.nailgun.NGContext;
import java.io.InputStream;
import java.io.OutputStreamWriter;
import java.io.PrintStream;
import java.io.Serializable;
import java.util.concurrent.atomic.AtomicInteger;
import org.scalafmt.Error;
import org.scalafmt.Formatted;
import org.scalafmt.Scalafmt$;
import org.scalafmt.cli.CliArgParser$;
import org.scalafmt.cli.CliOptions;
import org.scalafmt.cli.CliOptions$;
import org.scalafmt.cli.CommonOptions;
import org.scalafmt.cli.DiffFiles;
import org.scalafmt.cli.FileFetchMode;
import org.scalafmt.cli.GitFiles$;
import org.scalafmt.cli.InputMethod;
import org.scalafmt.cli.InputMethod$StdinCode$;
import org.scalafmt.cli.RecursiveSearch$;
import org.scalafmt.cli.TermDisplay;
import org.scalafmt.cli.TermDisplay$;
import org.scalafmt.cli.WriteMode;
import org.scalafmt.config.Align;
import org.scalafmt.config.BinPack;
import org.scalafmt.config.Config$;
import org.scalafmt.config.ContinuationIndent;
import org.scalafmt.config.Docstrings;
import org.scalafmt.config.ImportSelectors;
import org.scalafmt.config.IndentOperator;
import org.scalafmt.config.LineEndings;
import org.scalafmt.config.Newlines;
import org.scalafmt.config.OptIn;
import org.scalafmt.config.ProjectFiles;
import org.scalafmt.config.RewriteSettings;
import org.scalafmt.config.ScalafmtConfig;
import org.scalafmt.config.ScalafmtRunner;
import org.scalafmt.config.Spaces;
import org.scalafmt.util.AbsoluteFile;
import org.scalafmt.util.AbsoluteFile$;
import org.scalafmt.util.FileOps$;
import org.scalafmt.util.GitOps;
import org.scalafmt.util.LogLevel;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.StringContext;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Range;
import scala.collection.immutable.Set;
import scala.collection.parallel.ParIterableLike;
import scala.io.Codec;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

public final class Cli$ {
    public static Cli$ MODULE$;

    static {
        new Cli$();
    }

    public void nailMain(NGContext nGContext) {
        AbsoluteFile workingDirectory = (AbsoluteFile)AbsoluteFile$.MODULE$.fromPath(nGContext.getWorkingDirectory()).getOrElse((Function0 & Serializable & scala.Serializable)() -> {
            throw new IllegalStateException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Expected absolute path, "})).s((Seq)Nil$.MODULE$) + new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"obtained nGContext.getWorkingDirectory = ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{nGContext.getWorkingDirectory()})));
        });
        CommonOptions x$3 = CliOptions$.MODULE$.default().common().copy(workingDirectory, nGContext.out, nGContext.in, nGContext.err);
        ScalafmtConfig x$4 = CliOptions$.MODULE$.default().copy$default$1();
        Set<Range> x$5 = CliOptions$.MODULE$.default().copy$default$2();
        Seq<AbsoluteFile> x$6 = CliOptions$.MODULE$.default().copy$default$3();
        Seq<String> x$7 = CliOptions$.MODULE$.default().copy$default$4();
        WriteMode x$8 = CliOptions$.MODULE$.default().copy$default$5();
        boolean x$9 = CliOptions$.MODULE$.default().copy$default$6();
        boolean x$10 = CliOptions$.MODULE$.default().copy$default$7();
        boolean x$11 = CliOptions$.MODULE$.default().copy$default$8();
        boolean x$12 = CliOptions$.MODULE$.default().copy$default$9();
        Option<Object> x$13 = CliOptions$.MODULE$.default().copy$default$10();
        boolean x$14 = CliOptions$.MODULE$.default().copy$default$11();
        Option<String> x$15 = CliOptions$.MODULE$.default().copy$default$12();
        String x$16 = CliOptions$.MODULE$.default().copy$default$13();
        Option<AbsoluteFile> x$17 = CliOptions$.MODULE$.default().copy$default$14();
        Function1<AbsoluteFile, GitOps> x$18 = CliOptions$.MODULE$.default().copy$default$16();
        boolean x$19 = CliOptions$.MODULE$.default().copy$default$17();
        this.mainWithOptions(nGContext.getArgs(), CliOptions$.MODULE$.default().copy(x$4, x$5, x$6, x$7, x$8, x$9, x$10, x$11, x$12, x$13, x$14, x$15, x$16, x$17, x$3, x$18, x$19));
    }

    public void main(String[] args, InputStream in, PrintStream out, PrintStream err, String workingDirectory) {
        InputStream x$20 = in;
        PrintStream x$21 = out;
        PrintStream x$22 = err;
        AbsoluteFile x$23 = (AbsoluteFile)AbsoluteFile$.MODULE$.fromPath(workingDirectory).get();
        CommonOptions x$24 = new CommonOptions(x$23, x$21, x$20, x$22);
        ScalafmtConfig x$25 = CliOptions$.MODULE$.default().copy$default$1();
        Set<Range> x$26 = CliOptions$.MODULE$.default().copy$default$2();
        Seq<AbsoluteFile> x$27 = CliOptions$.MODULE$.default().copy$default$3();
        Seq<String> x$28 = CliOptions$.MODULE$.default().copy$default$4();
        WriteMode x$29 = CliOptions$.MODULE$.default().copy$default$5();
        boolean x$30 = CliOptions$.MODULE$.default().copy$default$6();
        boolean x$31 = CliOptions$.MODULE$.default().copy$default$7();
        boolean x$32 = CliOptions$.MODULE$.default().copy$default$8();
        boolean x$33 = CliOptions$.MODULE$.default().copy$default$9();
        Option<Object> x$34 = CliOptions$.MODULE$.default().copy$default$10();
        boolean x$35 = CliOptions$.MODULE$.default().copy$default$11();
        Option<String> x$36 = CliOptions$.MODULE$.default().copy$default$12();
        String x$37 = CliOptions$.MODULE$.default().copy$default$13();
        Option<AbsoluteFile> x$38 = CliOptions$.MODULE$.default().copy$default$14();
        Function1<AbsoluteFile, GitOps> x$39 = CliOptions$.MODULE$.default().copy$default$16();
        boolean x$40 = CliOptions$.MODULE$.default().copy$default$17();
        CliOptions options = CliOptions$.MODULE$.default().copy(x$25, x$26, x$27, x$28, x$29, x$30, x$31, x$32, x$33, x$34, x$35, x$36, x$37, x$38, x$24, x$39, x$40);
        this.mainWithOptions(args, options);
    }

    public void main(String[] args) {
        this.mainWithOptions(args, CliOptions$.MODULE$.default());
    }

    public void mainWithOptions(String[] args, CliOptions options) {
        Option<CliOptions> option = this.getConfig(args, options);
        if (!(option instanceof Some)) {
            if (None$.MODULE$.equals(option)) {
                throw Error.UnableToParseCliOptions$.MODULE$;
            }
            throw new MatchError(option);
        }
        Some some = (Some)option;
        CliOptions x = (CliOptions)some.value();
        this.run(x);
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public Option<CliOptions> getConfig(String[] args, CliOptions init) {
        return CliArgParser$.MODULE$.scoptParser().parse((Seq)Predef$.MODULE$.wrapRefArray((Object[])args), (Object)init).map((Function1 & Serializable & scala.Serializable)parsed -> CliOptions$.MODULE$.auto(args, init, (CliOptions)parsed));
    }

    private boolean canFormat(AbsoluteFile path) {
        return this.canFormat(path.path());
    }

    private boolean canFormat(String path) {
        return path.endsWith(".scala") || path.endsWith(".sbt");
    }

    private Seq<AbsoluteFile> getFilesFromCliOptions(CliOptions options) {
        Seq seq;
        FileFetchMode fileFetchMode = options.fileFetchMode();
        boolean bl = GitFiles$.MODULE$.equals(fileFetchMode) ? true : RecursiveSearch$.MODULE$.equals(fileFetchMode);
        if (bl) {
            FileFetchMode fileFetchMode2 = fileFetchMode;
            GitFiles$ gitFiles$ = GitFiles$.MODULE$;
            Function1 & Serializable & scala.Serializable fetchFiles = !(fileFetchMode2 != null ? !fileFetchMode2.equals(gitFiles$) : gitFiles$ != null) ? (Function1 & Serializable & scala.Serializable)x$1 -> options.gitOps().lsTree(x$1) : (Function1 & Serializable & scala.Serializable)x$2 -> FileOps$.MODULE$.listFiles(x$2);
            seq = (Seq)options.files().flatMap((Function1 & Serializable & scala.Serializable)x0$1 -> {
                AbsoluteFile absoluteFile = x0$1;
                Seq seq = absoluteFile.jfile().isDirectory() ? (Seq)((TraversableLike)fetchFiles.apply((Object)absoluteFile)).filter((Function1 & Serializable & scala.Serializable)f -> BoxesRunTime.boxToBoolean((boolean)Cli$.canFormat$1(f, options))) : (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AbsoluteFile[]{absoluteFile}));
                return seq;
            }, Seq$.MODULE$.canBuildFrom());
        } else if (fileFetchMode instanceof DiffFiles) {
            DiffFiles diffFiles = (DiffFiles)fileFetchMode;
            String branch = diffFiles.branch();
            seq = (Seq)options.gitOps().diff(branch).filter((Function1 & Serializable & scala.Serializable)f -> BoxesRunTime.boxToBoolean((boolean)Cli$.canFormat$1(f, options)));
        } else {
            throw new MatchError((Object)fileFetchMode);
        }
        return seq;
    }

    private Seq<InputMethod> getInputMethods(CliOptions options) {
        Seq seq;
        if (options.stdIn()) {
            seq = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new InputMethod.StdinCode[]{InputMethod$StdinCode$.MODULE$.apply(options.assumeFilename(), options.common().in())}));
        } else {
            Seq<AbsoluteFile> projectFiles = this.getFilesFromCliOptions(options);
            seq = (Seq)projectFiles.map((Function1 & Serializable & scala.Serializable)file -> new InputMethod.FileContents((AbsoluteFile)file), Seq$.MODULE$.canBuildFrom());
        }
        return seq;
    }

    private void handleFile(InputMethod inputMethod, CliOptions options) {
        String input = inputMethod.readInput(options);
        Formatted formatResult = Scalafmt$.MODULE$.format(input, options.config(), options.range());
        Formatted formatted = formatResult;
        if (formatted instanceof Formatted.Success) {
            Formatted.Success success = (Formatted.Success)formatted;
            String formatted2 = success.formattedCode();
            inputMethod.write(formatted2, input, options);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (formatted instanceof Formatted.Failure) {
            BoxedUnit boxedUnit;
            Formatted.Failure failure = (Formatted.Failure)formatted;
            Throwable e = failure.e();
            if (options.config().runner().fatalWarnings()) {
                throw e;
            }
            if (options.config().runner().ignoreWarnings()) {
                boxedUnit = BoxedUnit.UNIT;
            } else {
                options.common().err().println(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " Error in ", ": ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{LogLevel.warn$.MODULE$, inputMethod.filename(), e})));
                boxedUnit = BoxedUnit.UNIT;
            }
            BoxedUnit boxedUnit2 = boxedUnit;
        } else {
            throw new MatchError((Object)formatted);
        }
    }

    public TermDisplay newTermDisplay(CliOptions options, Seq<InputMethod> inputMethods, String msg) {
        TermDisplay termDisplay;
        block0: {
            termDisplay = new TermDisplay(new OutputStreamWriter(options.info()), options.nonInteractive() || TermDisplay$.MODULE$.defaultFallbackMode());
            if (options.quiet() || !options.inPlace() && !options.testing() || inputMethods.length() <= 5) break block0;
            termDisplay.init();
            termDisplay.startTask(msg, options.common().workingDirectory().jfile());
            termDisplay.taskLength(msg, inputMethods.length(), 0L);
        }
        return termDisplay;
    }

    public void run(CliOptions options) {
        block2: {
            String termDisplayMessage;
            Seq<InputMethod> inputMethods = this.getInputMethods(options);
            if (inputMethods.isEmpty()) {
                throw Error.NoMatchingFiles$.MODULE$;
            }
            AtomicInteger counter = new AtomicInteger();
            String string = termDisplayMessage = options.testing() ? "Looking for unformatted files..." : "Reformatting...";
            if (options.debug()) {
                String pwd = options.common().workingDirectory().jfile().getPath();
                PrintStream out = options.info();
                out.println("Working directory: " + pwd);
                out.println("Formatting files: " + inputMethods.toList());
                out.println("Configuration: \n" + Config$.MODULE$.toHocon((Object)options.config().fields()).mkString("\n"));
            }
            ScalafmtRunner x$41 = options.config().runner().forSbt();
            String x$42 = options.config().copy$default$1();
            int x$43 = options.config().copy$default$2();
            Docstrings x$44 = options.config().copy$default$3();
            OptIn x$45 = options.config().copy$default$4();
            BinPack x$46 = options.config().copy$default$5();
            ContinuationIndent x$47 = options.config().copy$default$6();
            Align x$48 = options.config().copy$default$7();
            Spaces x$49 = options.config().copy$default$8();
            LineEndings x$50 = options.config().copy$default$9();
            Map x$51 = options.config().copy$default$10();
            RewriteSettings x$52 = options.config().copy$default$11();
            IndentOperator x$53 = options.config().copy$default$12();
            Newlines x$54 = options.config().copy$default$13();
            boolean x$55 = options.config().copy$default$15();
            ImportSelectors x$56 = options.config().copy$default$16();
            boolean x$57 = options.config().copy$default$17();
            boolean x$58 = options.config().copy$default$18();
            boolean x$59 = options.config().copy$default$19();
            boolean x$60 = options.config().copy$default$20();
            boolean x$61 = options.config().copy$default$21();
            boolean x$62 = options.config().copy$default$22();
            String x$63 = options.config().copy$default$23();
            Codec x$64 = options.config().copy$default$24();
            ProjectFiles x$65 = options.config().copy$default$25();
            CliOptions sbtOptions = options.copy(options.config().copy(x$42, x$43, x$44, x$45, x$46, x$47, x$48, x$49, x$50, x$51, x$52, x$53, x$54, x$41, x$55, x$56, x$57, x$58, x$59, x$60, x$61, x$62, x$63, x$64, x$65), options.copy$default$2(), options.copy$default$3(), options.copy$default$4(), options.copy$default$5(), options.copy$default$6(), options.copy$default$7(), options.copy$default$8(), options.copy$default$9(), options.copy$default$10(), options.copy$default$11(), options.copy$default$12(), options.copy$default$13(), options.copy$default$14(), options.copy$default$15(), options.copy$default$16(), options.copy$default$17());
            TermDisplay termDisplay = this.newTermDisplay(options, inputMethods, termDisplayMessage);
            ((ParIterableLike)inputMethods.par()).foreach((Function1 & Serializable & scala.Serializable)inputMethod -> {
                Cli$.$anonfun$run$1(this, options, counter, termDisplayMessage, sbtOptions, termDisplay, inputMethod);
                return BoxedUnit.UNIT;
            });
            termDisplay.stop();
            if (!options.testing()) break block2;
            options.common().out().println("All files are formatted with scalafmt :)");
        }
    }

    private static final boolean canFormat$1(AbsoluteFile f, CliOptions options$2) {
        return options$2.filterMatcher().matches(f);
    }

    public static final /* synthetic */ void $anonfun$run$1(Cli$ $this, CliOptions options$1, AtomicInteger counter$1, String termDisplayMessage$1, CliOptions sbtOptions$1, TermDisplay termDisplay$1, InputMethod inputMethod) {
        CliOptions inputConfig = inputMethod.isSbt() ? sbtOptions$1 : options$1;
        $this.handleFile(inputMethod, inputConfig);
        termDisplay$1.taskProgress(termDisplayMessage$1, counter$1.incrementAndGet());
    }

    private Cli$() {
        MODULE$ = this;
    }
}

