/*
 * Decompiled with CFR 0.152.
 */
package org.xerial.util.opt.impl;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import org.xerial.core.XerialException;
import org.xerial.util.Range;
import org.xerial.util.TypeInfo;
import org.xerial.util.opt.Argument;
import org.xerial.util.opt.OptionParserException;
import org.xerial.util.opt.impl.OptionSetter;
import org.xerial.util.opt.impl.OptionSetterViaField;
import org.xerial.util.opt.impl.OptionSetterViaMethod;

public class ArgumentItem {
    private final Argument argumentDescriptor;
    private final OptionSetter argumentSetter;

    public ArgumentItem(Method method) {
        this.argumentDescriptor = method.getAnnotation(Argument.class);
        if (this.argumentDescriptor == null) {
            throw new IllegalArgumentException(method + " is not for an option argument");
        }
        this.argumentSetter = new OptionSetterViaMethod(method);
    }

    public ArgumentItem(Field field) {
        this.argumentDescriptor = field.getAnnotation(Argument.class);
        if (this.argumentDescriptor == null) {
            throw new IllegalArgumentException(field + " is not for an option argument");
        }
        this.argumentSetter = new OptionSetterViaField(field);
    }

    public boolean equals(Object object) {
        if (object instanceof ArgumentItem) {
            ArgumentItem argumentItem = (ArgumentItem)object;
            return this.argumentDescriptor.equals(argumentItem.argumentDescriptor);
        }
        return false;
    }

    public int hashCode() {
        return this.argumentDescriptor.hashCode();
    }

    public boolean takesMultipleArguments() {
        return TypeInfo.isCollection(this.argumentSetter.getOptionDataType());
    }

    public static Range getRangeOf(ArgumentItem argumentItem) {
        int n = argumentItem.getArgumentDescriptor().index();
        int n2 = argumentItem.takesMultipleArguments() ? Integer.MAX_VALUE : n;
        return new Range(n, n2);
    }

    public Range getRange() {
        return ArgumentItem.getRangeOf(this);
    }

    public void set(Object object, Object object2) throws XerialException {
        this.argumentSetter.setOption(object, object2);
    }

    public Argument getArgumentDescriptor() {
        return this.argumentDescriptor;
    }

    public void initialize(Object object) throws OptionParserException {
        this.argumentSetter.initialize(object);
    }

    public String toString() {
        return String.format("name=%s, index=%s, required=%s", this.argumentDescriptor.name(), this.getRange().toString(), this.argumentDescriptor.required());
    }

    public String getArgumentName() {
        String string = this.argumentDescriptor.name();
        if (string == null || string.length() <= 0) {
            string = this.argumentSetter.getParameterName();
        }
        return string;
    }
}

