/*
 * Decompiled with CFR 0.152.
 */
package org.xerial.util.opt;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.lang.reflect.Modifier;
import java.net.URL;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.xerial.core.ErrorCode;
import org.xerial.core.XerialErrorCode;
import org.xerial.util.FileResource;
import org.xerial.util.PrefixTree;
import org.xerial.util.ResourceFilter;
import org.xerial.util.io.VirtualFile;
import org.xerial.util.log.Logger;
import org.xerial.util.opt.Command;
import org.xerial.util.opt.CommandHelpMessage;
import org.xerial.util.opt.CommandLauncherEventHandler;
import org.xerial.util.opt.CommandModule;
import org.xerial.util.opt.GlobalCommandOption;
import org.xerial.util.opt.OptionParser;
import org.xerial.util.opt.OptionParserException;

public class CommandModuleBase
implements CommandModule {
    private static Logger _logger = Logger.getLogger(CommandModuleBase.class);
    private PrefixTree<Command> commandList = new PrefixTree();
    private List<CommandLauncherEventHandler> eventHandlers = new ArrayList<CommandLauncherEventHandler>();
    private GlobalCommandOption globalOption = new GlobalCommandOption();
    private CommandHelpMessage message = new CommandHelpMessage();

    public void addEventHandler(CommandLauncherEventHandler commandLauncherEventHandler) {
        this.eventHandlers.add(commandLauncherEventHandler);
    }

    public void addModule(CommandModule commandModule) {
        if (this.commandList.findBy(commandModule.name()) != null) {
            _logger.warn("duplicate module (or command) name found: " + commandModule.name());
        }
        this.commandList.add(commandModule.name(), commandModule);
    }

    public void addCommand(Class<?> clazz) {
        if (Modifier.isAbstract(clazz.getModifiers()) || !Command.class.isAssignableFrom(clazz)) {
            return;
        }
        try {
            Class<?> clazz2 = clazz;
            Command command = (Command)clazz.newInstance();
            if (command == null) {
                return;
            }
            Command command2 = this.commandList.findBy(command.name());
            if (command2 != null && command2.name().equals(command.name())) {
                _logger.warn("duplicate command found: " + command.name());
            }
            this.commandList.add(command.name(), command);
        }
        catch (InstantiationException instantiationException) {
            _logger.error(instantiationException);
        }
        catch (IllegalAccessException illegalAccessException) {
            _logger.error(illegalAccessException);
        }
    }

    public void addCommandsIn(String string, boolean bl) {
        List<VirtualFile> list = FileResource.listResources(string, new ResourceFilter(){

            @Override
            public boolean accept(String string) {
                return string.endsWith(".class");
            }
        });
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        LinkedHashSet linkedHashSet = new LinkedHashSet();
        for (VirtualFile virtualFile : list) {
            String string2 = virtualFile.getLogicalPath();
            int n = string2.lastIndexOf(".");
            if (n <= 0 || !bl && string2.contains("/")) continue;
            String string3 = string + "." + string2.substring(0, n).replaceAll("/", ".");
            try {
                Class<?> clazz = Class.forName(string3, false, classLoader);
                this.addCommand(clazz);
            }
            catch (ClassNotFoundException classNotFoundException) {}
        }
    }

    @Override
    public Object getOptionHolder() {
        return this.globalOption;
    }

    public void printDefaultMessage() {
        System.out.println(this.message.defaultHeader);
        System.out.println(this.message.defaultMessage);
    }

    @Override
    public URL getHelpMessageResource() {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void printHelpMessage(URL uRL) {
        if (uRL == null) {
            return;
        }
        try {
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(uRL.openStream()));
            try {
                String string;
                while ((string = bufferedReader.readLine()) != null) {
                    System.out.println(string);
                }
            }
            finally {
                if (bufferedReader != null) {
                    bufferedReader.close();
                }
            }
        }
        catch (IOException iOException) {
            _logger.error("help file is not found: " + uRL);
        }
    }

    @Override
    public void printUsage() throws Exception {
        OptionParser optionParser = new OptionParser(this.getOptionHolder());
        if (this.globalOption.command == null) {
            CommandModuleBase.printHelpMessage(this.getHelpMessageResource());
            optionParser.printUsage();
            System.out.println("[sub commands]");
            for (String string : this.commandList.keySet()) {
                Command command = this.commandList.get(string);
                System.out.format("  %-15s\t%s", string, command.getOneLineDescription());
                System.out.println();
            }
            return;
        }
        Command command = this.getSubCommand(this.globalOption.command);
        OptionParser optionParser2 = new OptionParser(command.getOptionHolder());
        optionParser2.setIgnoreUnknownOption(true);
        if (CommandModule.class.isAssignableFrom(command.getClass())) {
            String[] stringArray = optionParser.getUnusedArguments();
            optionParser2.parse(stringArray);
            CommandModule commandModule = (CommandModule)CommandModule.class.cast(command);
            commandModule.printUsage();
        } else {
            CommandModuleBase.printHelpMessage(command.getHelpMessageResource());
            optionParser2.printUsage();
        }
    }

    public Set<String> getCommandNameSet() {
        return this.commandList.keySet();
    }

    public Command getSubCommand(String string) throws Exception {
        Command command = this.commandList.findBy(this.globalOption.command);
        if (command == null) {
            throw new OptionParserException((ErrorCode)XerialErrorCode.UNKNOWN_COMMAND, String.format("unkown command %s", this.globalOption.command));
        }
        return (Command)command.getClass().newInstance();
    }

    private void resetOption() {
        this.globalOption.command = null;
        this.globalOption.displayHelp = false;
    }

    @Override
    public void execute(String[] stringArray) throws Exception {
        this.resetOption();
        OptionParser optionParser = new OptionParser(this.getOptionHolder());
        optionParser.setIgnoreUnknownOption(true);
        optionParser.parse(stringArray);
        for (CommandLauncherEventHandler object2 : this.eventHandlers) {
            object2.afterReadingGlobalOptions(this.globalOption);
        }
        if (this.globalOption.displayHelp) {
            this.printUsage();
            return;
        }
        if (this.globalOption.command == null) {
            this.printDefaultMessage();
            return;
        }
        String[] stringArray2 = optionParser.getUnusedArguments();
        Command command = this.getSubCommand(this.globalOption.command);
        if (CommandModule.class.isInstance(command) || command.getOptionHolder() == null) {
            command.execute(this.globalOption, stringArray2);
        } else {
            OptionParser optionParser2 = new OptionParser(command.getOptionHolder());
            optionParser2.setIgnoreUnknownOption(true);
            optionParser2.parse(stringArray2);
            command.execute(this.globalOption, stringArray2);
        }
    }

    @Override
    public String getOneLineDescription() {
        return null;
    }

    @Override
    public String name() {
        return null;
    }

    public void setMessage(CommandHelpMessage commandHelpMessage) {
        this.message = commandHelpMessage;
    }

    public void setOptionHolder(GlobalCommandOption globalCommandOption) {
        this.globalOption = globalCommandOption;
    }

    @Override
    public void execute(GlobalCommandOption globalCommandOption, String[] stringArray) throws Exception {
        this.globalOption = globalCommandOption;
        this.execute(stringArray);
    }
}

