/*
 * Decompiled with CFR 0.152.
 */
package org.xerial.util.log;

import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import org.xerial.util.log.LogLevel;
import org.xerial.util.log.LogWriter;
import org.xerial.util.log.Logger;

public class SimpleLogWriter
implements LogWriter {
    private Writer logOut;
    private static String[] logPrefix = new String[]{"", "\u001b[0;32m", "", "\u001b[1;36m", "\u001b[1;33m", "\u001b[1;35m", "\u001b[1;31m", "", ""};
    public static final String NEW_LINE = System.getProperty("line.separator");

    public SimpleLogWriter() {
        this.logOut = new OutputStreamWriter(System.err);
    }

    public SimpleLogWriter(OutputStream outputStream) {
        this.logOut = new OutputStreamWriter(outputStream);
    }

    public SimpleLogWriter(Writer writer) {
        this.logOut = writer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void log(Logger logger, LogLevel logLevel, Object object) {
        if (this.logOut == null) {
            return;
        }
        try {
            SimpleLogWriter simpleLogWriter = this;
            synchronized (simpleLogWriter) {
                if (logger.isColorEnabled()) {
                    this.logOut.write(logPrefix[logLevel.ordinal()]);
                }
                this.logOut.write(String.format("[%s] %s", logger.getLoggerShortName(), object != null ? object.toString() : ""));
                if (logger.isColorEnabled()) {
                    this.logOut.write("\u001b[0m");
                }
                this.logOut.write(NEW_LINE);
                this.logOut.flush();
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }
}

