/*
 * Decompiled with CFR 0.152.
 */
package org.xerial.util.log;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.util.Properties;
import java.util.TreeMap;
import org.xerial.util.Optional;
import org.xerial.util.log.LogLevel;
import org.xerial.util.log.LogWriter;
import org.xerial.util.log.SimpleLogWriter;

public class Logger {
    private LogWriter writer = null;
    private LogLevel _threshold = LogLevel.UNSPECIFIED;
    private String _loggerFullName = "";
    private String _loggerShortName = "";
    private Logger _parentLogger = null;
    private Optional<Boolean> _useColor = new Optional();
    private static TreeMap<String, Logger> _loggerHolder;
    private static Logger _rootLogger;

    private Logger() {
    }

    private Logger(String string) {
        this._loggerFullName = string;
        String[] stringArray = this._loggerFullName.split("\\.");
        this._loggerShortName = stringArray[stringArray.length - 1];
        if (stringArray.length == 1) {
            this._parentLogger = _rootLogger;
        } else {
            String string2 = this.concatenate(stringArray, stringArray.length - 1);
            this._parentLogger = Logger.getLogger(string2);
        }
    }

    private String concatenate(String[] stringArray, int n) {
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < n - 1; ++i) {
            stringBuilder.append(stringArray[i]);
            stringBuilder.append(".");
        }
        stringBuilder.append(stringArray[n - 1]);
        return stringBuilder.toString();
    }

    public static Logger getLogger(Class<?> clazz) {
        return Logger.getLogger(clazz.getName());
    }

    public static Logger getLogger(Class<?> clazz, String string) {
        if (string == null || string.length() <= 0) {
            return Logger.getLogger(clazz);
        }
        return Logger.getLogger(String.format("%s-%s", clazz.getName(), string));
    }

    public static Logger getLogger(Package package_) {
        return Logger.getLogger(package_.getName());
    }

    public static synchronized Logger getLogger(String string) {
        if (string == null) {
            return _rootLogger;
        }
        if (_loggerHolder.containsKey(string)) {
            return _loggerHolder.get(string);
        }
        Logger logger = new Logger(string);
        _loggerHolder.put(string, logger);
        return logger;
    }

    public static Logger getRootLogger() {
        return _rootLogger;
    }

    public static void configure(String string) throws IOException {
        Logger.configure(new BufferedReader(new FileReader(string)));
    }

    public static void configure(Reader reader) throws IOException {
        int n;
        Properties properties = new Properties();
        StringBuilder stringBuilder = new StringBuilder();
        while ((n = reader.read()) > 0) {
            stringBuilder.append((char)n);
        }
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(stringBuilder.toString().getBytes());
        properties.load(byteArrayInputStream);
        for (Object object : properties.keySet()) {
            String[] stringArray = ((String)object).split("#");
            String string = stringArray[0];
            String string2 = properties.getProperty(object.toString());
            Logger logger = Logger.getLogger(string);
            if (stringArray.length <= 1) {
                logger.setLogLevel(string2);
                continue;
            }
            if (stringArray.length > 1) {
                String string3 = stringArray[1];
                if (string3.equals("color")) {
                    logger.enableColor(Boolean.parseBoolean(string2));
                    continue;
                }
                System.err.println("unknown configuration parameter: " + string3);
                continue;
            }
            System.err.println("Error in the logger configuration file: " + object);
        }
    }

    public String getLoggerName() {
        return this._loggerFullName;
    }

    public String getLoggerShortName() {
        return this._loggerShortName;
    }

    public void setLogLevel(LogLevel logLevel) {
        this._threshold = logLevel;
    }

    public void setLogLevel(String string) {
        for (LogLevel logLevel : LogLevel.values()) {
            if (!logLevel.name().equalsIgnoreCase(string)) continue;
            this.setLogLevel(logLevel);
            return;
        }
        this.warn("unknown log level: " + string);
    }

    public LogLevel getLogLevel() {
        return this._threshold;
    }

    public void setLogWriter(LogWriter logWriter) {
        if (logWriter == null) {
            throw new NullPointerException();
        }
        this.writer = logWriter;
    }

    public boolean trace(Object object) {
        this.log(LogLevel.TRACE, object);
        return true;
    }

    public boolean trace(String string, Object ... objectArray) {
        this.log(LogLevel.TRACE, string, objectArray);
        return true;
    }

    public boolean debug(Object object) {
        this.log(LogLevel.DEBUG, object);
        return true;
    }

    public boolean debug(String string, Object ... objectArray) {
        this.log(LogLevel.DEBUG, string, objectArray);
        return true;
    }

    public boolean info(Object object) {
        this.log(LogLevel.INFO, object);
        return true;
    }

    public boolean info(String string, Object ... objectArray) {
        this.log(LogLevel.INFO, string, objectArray);
        return true;
    }

    public boolean warn(Object object) {
        this.log(LogLevel.WARN, object);
        return true;
    }

    public boolean warn(String string, Object ... objectArray) {
        this.log(LogLevel.WARN, string, objectArray);
        return true;
    }

    public boolean error(Object object) {
        this.log(LogLevel.ERROR, object);
        return true;
    }

    public boolean error(String string, Object ... objectArray) {
        this.log(LogLevel.ERROR, string, objectArray);
        return true;
    }

    public boolean fatal(Object object) {
        this.log(LogLevel.FATAL, object);
        return true;
    }

    public boolean fatal(String string, Object ... objectArray) {
        this.log(LogLevel.FATAL, string, objectArray);
        return true;
    }

    public void enableColor(boolean bl) {
        this._useColor.set(bl);
    }

    public boolean isColorEnabled() {
        if (this._useColor.isUndefined()) {
            if (this._parentLogger != null) {
                boolean bl = this._parentLogger.isColorEnabled();
                this._useColor.set(bl);
            } else {
                this._useColor.set(false);
            }
        }
        return this._useColor.get();
    }

    public boolean isDebugEnabled() {
        return this.isEnabled(LogLevel.DEBUG);
    }

    public boolean isTraceEnabled() {
        return this.isEnabled(LogLevel.TRACE);
    }

    public boolean isInfoEnabled() {
        return this.isEnabled(LogLevel.INFO);
    }

    public boolean isWarnEnabled() {
        return this.isEnabled(LogLevel.WARN);
    }

    public boolean isErrorEnabled() {
        return this.isEnabled(LogLevel.ERROR);
    }

    public boolean isFatalEnalbed() {
        return this.isEnabled(LogLevel.FATAL);
    }

    public boolean isEnabled(LogLevel logLevel) {
        if (this._threshold == LogLevel.UNSPECIFIED) {
            Logger logger = this;
            while ((logger = logger._parentLogger) != null) {
                if (logger.getLogLevel() == LogLevel.UNSPECIFIED) continue;
                this._threshold = logger.getLogLevel();
                break;
            }
            if (this._threshold == LogLevel.UNSPECIFIED) {
                return false;
            }
        }
        return this._threshold.ordinal() <= logLevel.ordinal();
    }

    private LogWriter getLogWriter() {
        if (this.writer != null) {
            return this.writer;
        }
        if (this._parentLogger != null) {
            return this._parentLogger.getLogWriter();
        }
        return null;
    }

    protected void log(LogLevel logLevel, String string, Object ... objectArray) {
        this.log(logLevel, String.format(string, objectArray));
    }

    protected void log(LogLevel logLevel, Object object) {
        if (!this.isEnabled(logLevel)) {
            return;
        }
        LogWriter logWriter = this.getLogWriter();
        if (logWriter == null) {
            return;
        }
        try {
            logWriter.log(this, logLevel, object);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    static {
        String string;
        _loggerHolder = new TreeMap();
        _rootLogger = new Logger();
        _rootLogger.setLogLevel(LogLevel.INFO);
        _rootLogger.setLogWriter(new SimpleLogWriter());
        Logger._rootLogger._loggerFullName = "root";
        Logger._rootLogger._loggerShortName = "root";
        String string2 = System.getProperty("xerial.loglevel");
        if (string2 != null) {
            _rootLogger.setLogLevel(string2);
        } else {
            string2 = System.getProperty("loglevel");
            if (string2 != null) {
                _rootLogger.setLogLevel(string2);
            }
        }
        String string3 = System.getProperty("log.color");
        if (string3 != null) {
            Logger._rootLogger._useColor.set(Boolean.parseBoolean(string3));
        }
        if ((string = System.getProperty("log.config")) != null) {
            try {
                Logger.configure(string);
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
    }
}

