/*
 * Decompiled with CFR 0.152.
 */
package org.xerial.util.graph;

import java.util.HashMap;
import java.util.Stack;
import org.xerial.util.graph.Edge;
import org.xerial.util.graph.Graph;
import org.xerial.util.graph.GraphHelper;

public abstract class BreadthFirstSearch<NodeLabel, EdgeLabel> {
    private Graph<NodeLabel, EdgeLabel> _graph;
    private HashMap<NodeLabel, NodeColor> _nodeColor = new HashMap();
    private HashMap<NodeLabel, NodeLabel> _predecessor = new HashMap();
    private int _time;
    private HashMap<NodeLabel, Integer> _depth = new HashMap();
    private Stack<NodeLabel> nodeStack = new Stack();

    public void run(Graph<NodeLabel, EdgeLabel> graph) {
        this.run(graph, null);
    }

    public void run(Graph<NodeLabel, EdgeLabel> graph, NodeLabel NodeLabel) {
        this._graph = graph;
        this.nodeStack.clear();
        for (NodeLabel NodeLabel2 : this._graph.getNodeLabelSet()) {
            this.initializeNode(NodeLabel2);
            this._nodeColor.put(NodeLabel2, NodeColor.WHITE);
            this._predecessor.put(NodeLabel2, NodeLabel2);
        }
        this._time = 0;
        if (NodeLabel != null) {
            this.searchStart(NodeLabel);
        }
        for (NodeLabel NodeLabel2 : this._graph.getNodeLabelSet()) {
            this.searchStart(NodeLabel2);
        }
    }

    private void searchStart(NodeLabel NodeLabel) {
        NodeColor nodeColor = this._nodeColor.get(NodeLabel);
        assert (nodeColor != null);
        if (nodeColor != NodeColor.WHITE) {
            return;
        }
        this.startNode(NodeLabel);
        this.bfsVisit(NodeLabel);
    }

    private void bfsVisit(NodeLabel NodeLabel) {
        this.nodeStack.add(NodeLabel);
        this.discoverNode(NodeLabel);
        this._nodeColor.put(NodeLabel, NodeColor.GRAY);
        this._depth.put(NodeLabel, 0);
        while (!this.nodeStack.isEmpty()) {
            NodeLabel NodeLabel2 = this.nodeStack.pop();
            this.examineNode(NodeLabel2);
            for (Edge edge : this._graph.getOutEdgeSet(NodeLabel2)) {
                this.examineEdge(edge);
                NodeLabel NodeLabel3 = this._graph.getNodeLabel(edge.getDestNodeID());
                NodeColor nodeColor = this._nodeColor.get(NodeLabel3);
                assert (nodeColor != null);
                switch (nodeColor) {
                    case WHITE: {
                        this.treeEdge(edge);
                        this._nodeColor.put(NodeLabel3, NodeColor.GRAY);
                        this._depth.put(NodeLabel3, this._depth.get(NodeLabel2) + 1);
                        this._predecessor.put(NodeLabel3, NodeLabel2);
                        this.nodeStack.add(NodeLabel3);
                        this.discoverNode(NodeLabel3);
                        break;
                    }
                    case GRAY: {
                        this.backEdge(edge);
                        break;
                    }
                    case BLACK: {
                        this.forwardOrCrossEdge(edge);
                    }
                }
            }
            this.finishNode(NodeLabel2);
            this._nodeColor.put(NodeLabel2, NodeColor.BLACK);
        }
    }

    protected final Graph<NodeLabel, EdgeLabel> getGraph() {
        return this._graph;
    }

    protected NodeLabel getPredecessor(NodeLabel NodeLabel) {
        return this._predecessor.get(NodeLabel);
    }

    protected int getSearchDepth(NodeLabel NodeLabel) {
        return this._depth.get(NodeLabel);
    }

    protected EdgeLabel getEdgeLabel(Edge edge) {
        return this._graph.getEdgeLabel(edge);
    }

    protected NodeLabel getSourceNodeLabel(Edge edge) {
        return GraphHelper.getSourceNodeLabel(this._graph, edge);
    }

    protected NodeLabel getDestNodeLabel(Edge edge) {
        return GraphHelper.getDestNodeLabel(this._graph, edge);
    }

    protected String toString(Edge edge) {
        return GraphHelper.toString(this._graph, edge);
    }

    protected abstract void initializeNode(NodeLabel var1);

    protected abstract void startNode(NodeLabel var1);

    protected abstract void discoverNode(NodeLabel var1);

    protected abstract void examineNode(NodeLabel var1);

    protected abstract void examineEdge(Edge var1);

    protected abstract void treeEdge(Edge var1);

    protected abstract void finishNode(NodeLabel var1);

    protected abstract void backEdge(Edge var1);

    protected abstract void forwardOrCrossEdge(Edge var1);

    static enum NodeColor {
        WHITE,
        GRAY,
        BLACK;

    }
}

