/*
 * Decompiled with CFR 0.152.
 */
package org.xerial.util.graph;

import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.TreeSet;
import org.xerial.util.IndexedSet;
import org.xerial.util.StringUtil;
import org.xerial.util.graph.Edge;
import org.xerial.util.graph.EdgeTable;
import org.xerial.util.graph.Graph;
import org.xerial.util.graph.GraphvizHelper;

public class AdjacencyList<NodeLabel, EdgeLabel>
implements Graph<NodeLabel, EdgeLabel> {
    IndexedSet<NodeLabel> _nodeTable = new IndexedSet();
    EdgeTable<EdgeLabel> _edgeTable = new EdgeTable();

    public AdjacencyList() {
    }

    @Override
    public int addNode(NodeLabel NodeLabel) {
        int n = this._nodeTable.getIDwithAddition(NodeLabel);
        return n;
    }

    @Override
    public Edge addEdge(NodeLabel NodeLabel, NodeLabel NodeLabel2) {
        return this.addEdge(NodeLabel, NodeLabel2, null);
    }

    @Override
    public Edge addEdge(NodeLabel NodeLabel, NodeLabel NodeLabel2, EdgeLabel EdgeLabel) {
        int n = this._nodeTable.getIDwithAddition(NodeLabel);
        int n2 = this._nodeTable.getIDwithAddition(NodeLabel2);
        Edge edge = new Edge(n, n2);
        this._edgeTable.add(edge, EdgeLabel);
        return edge;
    }

    @Override
    public Edge addEdge(Edge edge, EdgeLabel EdgeLabel) {
        if (!this._nodeTable.containsID(edge.srcNodeID)) {
            throw new IllegalArgumentException("no node id is found: " + edge.srcNodeID);
        }
        if (!this._nodeTable.containsID(edge.destNodeID)) {
            throw new IllegalArgumentException("no node id is found: " + edge.destNodeID);
        }
        this._edgeTable.add(edge, EdgeLabel);
        return edge;
    }

    @Override
    public Edge addEdge(int n, int n2, EdgeLabel EdgeLabel) {
        return this.addEdge(new Edge(n, n2), EdgeLabel);
    }

    @Override
    public Collection<NodeLabel> getNodeLabelSet() {
        return this._nodeTable;
    }

    @Override
    public Collection<Integer> getNodeIDSet() {
        return this._nodeTable.getIDSet();
    }

    @Override
    public Collection<Integer> getDestNodeIDSetOf(int n) {
        return this._edgeTable.destNodeIDSet(n);
    }

    @Override
    public Collection<Integer> getSourceNodeIDSetOf(int n) {
        return this._edgeTable.sourceNodeIDSet(n);
    }

    @Override
    public int getNodeID(NodeLabel NodeLabel) {
        return this._nodeTable.getID(NodeLabel);
    }

    @Override
    public NodeLabel getNodeLabel(int n) {
        return this._nodeTable.getByID(n);
    }

    @Override
    public Collection<Edge> getOutEdgeSet(NodeLabel NodeLabel) {
        ArrayList<Edge> arrayList = new ArrayList<Edge>();
        int n = this.getNodeID(NodeLabel);
        for (Integer n2 : this._edgeTable.destNodeIDSet(n)) {
            arrayList.add(new Edge(n, n2));
        }
        return arrayList;
    }

    public List<NodeLabel> outNodeList(NodeLabel NodeLabel) {
        ArrayList<NodeLabel> arrayList = new ArrayList<NodeLabel>();
        int n = this.getNodeID(NodeLabel);
        for (Integer n2 : this._edgeTable.destNodeIDSet(n)) {
            arrayList.add(this.getNodeLabel(n2));
        }
        return arrayList;
    }

    @Override
    public Collection<Edge> getInEdgeSet(NodeLabel NodeLabel) {
        ArrayList<Edge> arrayList = new ArrayList<Edge>();
        int n = this.getNodeID(NodeLabel);
        for (Integer n2 : this._edgeTable.sourceNodeIDSet(n)) {
            arrayList.add(new Edge(n2, n));
        }
        return arrayList;
    }

    @Override
    public boolean hasNode(NodeLabel NodeLabel) {
        return this._nodeTable.contains(NodeLabel);
    }

    @Override
    public boolean hasEdge(NodeLabel NodeLabel, NodeLabel NodeLabel2) {
        Edge edge = new Edge(this.getNodeID(NodeLabel), this.getNodeID(NodeLabel2));
        return this.hasEdge(edge);
    }

    @Override
    public boolean hasEdge(Edge edge) {
        return this._edgeTable.hasEdge(edge);
    }

    @Override
    public void clear() {
        this._nodeTable.clear();
        this._edgeTable.clear();
    }

    @Override
    public int getNumNodes() {
        return this._nodeTable.size();
    }

    @Override
    public Collection<Edge> getEdgeSet() {
        ArrayList<Edge> arrayList = new ArrayList<Edge>();
        Collection<Integer> collection = this.getNodeIDSet();
        for (int n : collection) {
            for (Edge edge : this.getOutEdgeSet(this.getNodeLabel(n))) {
                arrayList.add(edge);
            }
        }
        return arrayList;
    }

    @Override
    public int getEdgeID(Edge edge) {
        return this._edgeTable.getEdgeID(edge);
    }

    @Override
    public EdgeLabel getEdgeLabel(Edge edge) {
        return this._edgeTable.getEdgeLabel(edge);
    }

    public EdgeLabel getEdgeLabel(NodeLabel NodeLabel, NodeLabel NodeLabel2) {
        return this._edgeTable.getEdgeLabel(new Edge(this.getNodeID(NodeLabel), this.getNodeID(NodeLabel2)));
    }

    @Override
    public void setNodeLabel(int n, NodeLabel NodeLabel) {
        this._nodeTable.set(n, NodeLabel);
    }

    @Override
    public void setEdgeLabel(Edge edge, EdgeLabel EdgeLabel) {
        this._edgeTable.setEdge(edge, EdgeLabel);
    }

    public String toString() {
        String string = this._nodeTable.toString();
        ArrayList<String> arrayList = new ArrayList<String>();
        for (Edge edge : this.getEdgeSet()) {
            EdgeLabel EdgeLabel = this.getEdgeLabel(edge);
            arrayList.add(String.format("(%s, %s)%s", this.getNodeLabel(edge.getSourceNodeID()), this.getNodeLabel(edge.getDestNodeID()), EdgeLabel != null ? ":" + EdgeLabel.toString() : ""));
        }
        return String.format("node (value, id):%s\nedge(node, node):\n%s", string, StringUtil.join(arrayList, ",\n"));
    }

    @Override
    public String toGraphViz() {
        StringWriter stringWriter = new StringWriter();
        GraphvizHelper graphvizHelper = new GraphvizHelper(stringWriter);
        graphvizHelper.beginDigraph("G");
        for (int i = 0; i < this._nodeTable.size(); ++i) {
            NodeLabel object = this._nodeTable.getByID(i);
            graphvizHelper.node(i + 1, object.toString());
        }
        for (Edge edge : this.getEdgeSet()) {
            EdgeLabel EdgeLabel = this.getEdgeLabel(edge);
            if (EdgeLabel != null) {
                graphvizHelper.edge(edge.srcNodeID + 1, edge.destNodeID + 1, EdgeLabel.toString());
                continue;
            }
            graphvizHelper.edge(edge.srcNodeID + 1, edge.destNodeID + 1);
        }
        graphvizHelper.endDigraph();
        return stringWriter.toString();
    }

    public static <NodeLabel, EdgeLabel> AdjacencyList<NodeLabel, EdgeLabel> copy(Graph<NodeLabel, EdgeLabel> graph) {
        TreeSet<Integer> treeSet = new TreeSet<Integer>();
        Object object = graph.getNodeIDSet().iterator();
        while (object.hasNext()) {
            int n = object.next();
            treeSet.add(n);
        }
        object = new IndexedSet();
        Object object2 = treeSet.iterator();
        while (object2.hasNext()) {
            int n = (Integer)object2.next();
            ((IndexedSet)object).add(graph.getNodeLabel(n));
        }
        object2 = new EdgeTable();
        for (Edge edge : graph.getEdgeSet()) {
            ((EdgeTable)object2).add(graph.getEdgeID(edge), graph.getEdgeLabel(edge), edge);
        }
        return new AdjacencyList<NodeLabel, EdgeLabel>(object, object2);
    }

    private AdjacencyList(IndexedSet<NodeLabel> indexedSet, EdgeTable<EdgeLabel> edgeTable) {
        this._nodeTable = indexedSet;
        this._edgeTable = edgeTable;
    }

    @Override
    public Collection<Integer> getEdgeIDSet() {
        return this._edgeTable.getEdgeIDSet();
    }

    @Override
    public EdgeLabel getEdgeLabel(int n) {
        return this._edgeTable.getEdgeLabel(n);
    }
}

