/*
 * Decompiled with CFR 0.152.
 */
package org.xerial.util;

import java.util.ArrayList;
import java.util.List;

public class PrioritySearchTree<E> {
    private Node root = null;
    private int lowerBoundOfX = 0;
    private int upperBoundOfX = Integer.MAX_VALUE;
    private int lowerBoundOfY = 0;
    private int uppperBoundOfY = Integer.MAX_VALUE;
    private int nodeCount = 0;

    public PrioritySearchTree() {
    }

    public PrioritySearchTree(int n, int n2, int n3, int n4) {
        this.lowerBoundOfX = n;
        this.upperBoundOfX = n2;
        this.lowerBoundOfY = n3;
        this.uppperBoundOfY = n4;
    }

    public void depthFirstSearch(Visitor<E> visitor) {
        this.dfs(this.root, visitor);
    }

    private void dfs(Node node, Visitor<E> visitor) {
        if (node == null) {
            return;
        }
        visitor.visit(node.elem);
        this.dfs(node.left, visitor);
        this.dfs(node.right, visitor);
    }

    public void clear() {
        this.root = null;
        this.nodeCount = 0;
    }

    public int size() {
        return this.nodeCount;
    }

    public List<E> rangeQuery(int n, int n2, int n3) {
        ArrayList arrayList = new ArrayList();
        this.rangeQuery_internal(this.root, new QueryBox(n, n2, n3), n, n2, arrayList);
        return arrayList;
    }

    boolean rangeQuery_internal(Node node, QueryBox queryBox, int n, int n2, List<E> list) {
        boolean bl = true;
        if (node != null && node.y <= queryBox.upperY) {
            if (queryBox.x1 <= node.x && node.x <= queryBox.x2) {
                list.add(node.elem);
            }
            int n3 = node.splitX;
            if (bl && queryBox.x1 < n3) {
                bl = this.rangeQuery_internal(node.left, queryBox, n, n3, list);
            }
            if (bl && n3 <= queryBox.x2) {
                bl = this.rangeQuery_internal(node.right, queryBox, n3, n2, list);
            }
        }
        return bl;
    }

    public void insert(E e, int n, int n2) {
        this.root = this.insert_internal(this.root, new Node(e, n, n2), this.lowerBoundOfX, this.upperBoundOfX);
    }

    public void remove(E e, int n, int n2) {
        this.root = this.remove_internal(this.root, new Node(e, n, n2), this.lowerBoundOfX, this.upperBoundOfX);
    }

    Node insert_internal(Node node, Node node2, int n, int n2) {
        if (node == null) {
            node = node2;
            node.splitX = (n + n2) / 2;
            ++this.nodeCount;
        } else {
            if (node2.y < node.y) {
                node.swap(node2);
            }
            if (node2.x < node.splitX) {
                node.left = this.insert_internal(node.left, node2, n, node.splitX);
            } else {
                node.right = this.insert_internal(node.right, node2, node.splitX, n2);
            }
        }
        return node;
    }

    /*
     * Enabled aggressive block sorting
     */
    Node remove_internal(Node node, Node node2, int n, int n2) {
        if (node == null) {
            return node;
        }
        if (node.elem.equals(node2.elem)) {
            if (node.left != null) {
                if (node.right == null) {
                    node.replaceWith(node.left);
                    node.left = this.remove_internal(node.left, node.left, n, n2);
                    return node;
                }
                if (node.left.y < node.right.y) {
                    node.replaceWith(node.left);
                    node.left = this.remove_internal(node.left, node.left, n, n2);
                    return node;
                }
                node.replaceWith(node.right);
                node.right = this.remove_internal(node.right, node.right, n, n2);
                return node;
            }
            if (node.right != null) {
                node.replaceWith(node.right);
                node.right = this.remove_internal(node.right, node.right, n, n2);
                return node;
            }
            --this.nodeCount;
            return null;
        }
        if (node2.x < node.splitX) {
            node.left = this.remove_internal(node.left, node2, n, node.splitX);
            return node;
        }
        node.right = this.remove_internal(node.right, node2, node.splitX, n2);
        return node;
    }

    private static class QueryBox {
        public final int x1;
        public final int x2;
        public final int upperY;

        public QueryBox(int n, int n2, int n3) {
            this.x1 = n;
            this.x2 = n2;
            this.upperY = n3;
        }
    }

    public static interface Visitor<E> {
        public void visit(E var1);
    }

    public class Node {
        public E elem;
        public int x;
        public int y;
        public int splitX;
        public Node left;
        public Node right;

        public Node(E e, int n, int n2) {
            if (e == null) {
                throw new NullPointerException("node cannot be null");
            }
            this.elem = e;
            this.x = n;
            this.y = n2;
        }

        public void swap(Node node) {
            int n = this.x;
            this.x = node.x;
            node.x = n;
            int n2 = this.y;
            this.y = node.y;
            node.y = n2;
            Object e = this.elem;
            this.elem = node.elem;
            node.elem = e;
        }

        public void replaceWith(Node node) {
            this.x = node.x;
            this.y = node.y;
            this.elem = node.elem;
        }
    }
}

