/*
 * Decompiled with CFR 0.152.
 */
package org.xerial.json;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import org.xerial.core.ErrorCode;
import org.xerial.core.XerialErrorCode;
import org.xerial.core.XerialException;
import org.xerial.json.impl.JSONToken;
import org.xerial.util.ArrayDeque;
import org.xerial.util.io.BufferedScanner;

public class JSONLexer {
    private BufferedScanner scanner;
    private ArrayDeque<Token> tokenQueue = new ArrayDeque();
    private long lineCount = 0L;
    private int posInLine = 0;
    private static final byte[] NULL = new byte[]{110, 117, 108, 108};
    private static final byte[] TRUE = new byte[]{116, 114, 117, 101};
    private static final byte[] FALSE = new byte[]{102, 97, 108, 115, 101};

    public JSONLexer(InputStream inputStream) {
        this(new BufferedScanner(inputStream));
    }

    public JSONLexer(Reader reader) {
        this(new BufferedScanner(reader));
    }

    public JSONLexer(String string) {
        this(new BufferedScanner(string));
    }

    public JSONLexer(BufferedScanner bufferedScanner) {
        this.scanner = bufferedScanner;
    }

    public void close() throws IOException {
        this.scanner.close();
    }

    public Token nextToken() throws XerialException {
        if (!this.tokenQueue.isEmpty()) {
            return this.tokenQueue.pollFirst();
        }
        if (this.scanner.hasReachedEOF()) {
            return null;
        }
        this.matchWhiteSpaces();
        this.scanner.resetMarks();
        this.scanner.mark();
        int n = this.LA(1);
        switch (n) {
            case 123: {
                this.consume();
                this.emit(JSONToken.LBrace);
                break;
            }
            case 125: {
                this.consume();
                this.emit(JSONToken.RBrace);
                break;
            }
            case 91: {
                this.consume();
                this.emit(JSONToken.LBracket);
                break;
            }
            case 93: {
                this.consume();
                this.emit(JSONToken.RBracket);
                break;
            }
            case 58: {
                this.consume();
                this.emit(JSONToken.Colon);
                break;
            }
            case 44: {
                this.consume();
                this.emit(JSONToken.Comma);
                break;
            }
            case 34: {
                this.parseString();
                break;
            }
            case -1: {
                return null;
            }
            default: {
                this.parseValue();
            }
        }
        return this.nextToken();
    }

    void matchWhiteSpaces() throws XerialException {
        block5: while (true) {
            int n = this.LA(1);
            switch (n) {
                case 9: 
                case 32: {
                    break;
                }
                case 13: {
                    if (this.LA(1) == 10) break;
                    ++this.lineCount;
                    this.posInLine = 0;
                    break;
                }
                case 10: {
                    ++this.lineCount;
                    this.posInLine = 0;
                    break;
                }
                default: {
                    break block5;
                }
            }
            this.consume();
        }
    }

    protected int LA(int n) throws XerialException {
        try {
            return this.scanner.LA(n);
        }
        catch (IOException iOException) {
            throw XerialException.convert(iOException);
        }
    }

    protected void consume() throws XerialException {
        try {
            int n = this.scanner.consume();
            switch (n) {
                case 13: {
                    if (this.scanner.LA(1) != 10) {
                        ++this.lineCount;
                        this.posInLine = 0;
                    }
                    break;
                }
                case 10: {
                    ++this.lineCount;
                    this.posInLine = 0;
                    break;
                }
                default: {
                    ++this.posInLine;
                    break;
                }
            }
        }
        catch (IOException iOException) {
            throw XerialException.convert(iOException);
        }
    }

    public void parseValue() throws XerialException {
        int n = this.LA(1);
        if (n == 45 || n >= 48 && n <= 57) {
            this.parseNumber();
            return;
        }
        if (this.match(NULL)) {
            this.emit(JSONToken.Null);
            return;
        }
        if (this.match(TRUE)) {
            this.emit(JSONToken.True);
            return;
        }
        if (this.match(FALSE)) {
            this.emit(JSONToken.False);
            return;
        }
        throw this.error("value", this.LA(1));
    }

    public void parseNumber() throws XerialException {
        int n;
        int n2 = this.LA(1);
        if (n2 == 45) {
            n = this.LA(2);
            if (n >= 48 && n <= 57) {
                this.consume();
                n2 = n;
            } else {
                throw this.error("Number", n2);
            }
        }
        if (n2 == 48) {
            this.consume();
        } else if (n2 >= 49 && n2 <= 57) {
            this.consume();
            this.matchDigit_s();
        } else {
            throw this.error("Number", n2);
        }
        n2 = this.LA(1);
        switch (n2) {
            case 46: {
                this.consume();
                this.matchDigit_p();
                n = this.LA(1);
                this.matchExp();
                this.emitText(JSONToken.Double);
                break;
            }
            default: {
                if (this.matchExp()) {
                    this.emitText(JSONToken.Double);
                    break;
                }
                this.emitText(JSONToken.Integer);
            }
        }
    }

    private void matchDigit_s() throws XerialException {
        int n;
        while ((n = this.LA(1)) >= 48 && n <= 57) {
            this.consume();
        }
    }

    private void matchDigit_p() throws XerialException {
        try {
            int n = this.scanner.LA(1);
            if (n < 48 || n > 57) {
                throw this.error("Digit+", n);
            }
            this.consume();
            this.matchDigit_s();
        }
        catch (IOException iOException) {
            throw XerialException.convert(iOException);
        }
    }

    private boolean matchExp() throws XerialException {
        int n = this.LA(1);
        if (n != 101 && n != 69) {
            return false;
        }
        this.consume();
        n = this.LA(1);
        if (n == 43 || n == 45) {
            this.consume();
        }
        this.matchDigit_p();
        return true;
    }

    boolean match(byte[] byArray) throws XerialException {
        int n;
        for (n = 0; n < byArray.length; ++n) {
            if (byArray[n] == this.LA(n + 1)) continue;
            return false;
        }
        for (n = 0; n < byArray.length; ++n) {
            this.consume();
        }
        return true;
    }

    void parseString() throws XerialException {
        this.match(34);
        boolean bl = true;
        block4: while (true) {
            int n = this.LA(1);
            switch (n) {
                case 34: {
                    this.consume();
                    this.emitString();
                    return;
                }
                case 92: {
                    this.matchEscapeSequence();
                    continue block4;
                }
            }
            this.consume();
        }
    }

    public void matchEscapeSequence() throws XerialException {
        try {
            this.match(92);
            int n = this.scanner.LA(1);
            switch (n) {
                case 34: 
                case 47: 
                case 92: 
                case 98: 
                case 102: 
                case 110: 
                case 114: 
                case 116: {
                    this.consume();
                    break;
                }
                case 117: {
                    this.consume();
                    for (int i = 0; i < 4; ++i) {
                        this.matchHexDigit();
                    }
                    break;
                }
                default: {
                    throw this.error("escape sequence", n);
                }
            }
        }
        catch (IOException iOException) {
            throw XerialException.convert(iOException);
        }
    }

    public void matchHexDigit() throws XerialException {
        int n = this.LA(1);
        if (!(n >= 48 && n <= 57 || n >= 65 && n <= 70 || n >= 97 && n >= 102)) {
            throw this.error("hex digit", n);
        }
        this.consume();
    }

    public void match(int n) throws XerialException {
        int n2 = this.LA(1);
        if (n2 != n) {
            throw new XerialException((ErrorCode)XerialErrorCode.PARSE_ERROR, String.format("expected:'%s' but found '%s'", n, n2));
        }
        this.consume();
    }

    private XerialException error(String string, int n) {
        return new XerialException((ErrorCode)XerialErrorCode.PARSE_ERROR, String.format("<%s> invalid char '%s'", string, n));
    }

    void emit(JSONToken jSONToken) {
        this.tokenQueue.add(new Token(jSONToken, null));
    }

    void emitText(JSONToken jSONToken) {
        this.tokenQueue.add(new Token(jSONToken, this.scanner.selectedRawString()));
    }

    void emitString() {
        this.tokenQueue.add(new Token(JSONToken.String, this.scanner.selectedRawString(1)));
    }

    public long getLineNumber() {
        return this.lineCount;
    }

    public int getPosInLine() {
        return this.posInLine;
    }

    public static class Token {
        public final JSONToken type;
        public final CharSequence str;

        public Token(JSONToken jSONToken, CharSequence charSequence) {
            this.type = jSONToken;
            this.str = charSequence;
        }

        public String toString() {
            return String.format("[%s] %s", new Object[]{this.type, this.str == null ? "" : this.str});
        }
    }
}

