/*
 * Decompiled with CFR 0.152.
 */
package io.github.soc.directories;

import io.github.soc.directories.UnsupportedOperatingSystemException;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.Locale;

final class Util {
    static final String operatingSystemName = System.getProperty("os.name");
    static final char operatingSystem;
    static final char LIN = 'l';
    static final char MAC = 'm';
    static final char WIN = 'w';

    private Util() {
        throw new Error();
    }

    static void requireNonNull(Object object) {
        if (object == null) {
            throw new NullPointerException();
        }
    }

    static String defaultIfNullOrEmpty(String string, String string2, String string3) {
        Util.requireNonNull(string3);
        if (string == null || string.isEmpty()) {
            return string2 + string3;
        }
        return string;
    }

    static String defaultIfNullOrEmptyExtended(String string, String string2, String string3, String string4) {
        Util.requireNonNull(string2);
        Util.requireNonNull(string3);
        Util.requireNonNull(string4);
        if (string == null || string.isEmpty()) {
            return string3 + string4;
        }
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static String runXDGUserDir(String string) {
        Process process;
        ProcessBuilder processBuilder = new ProcessBuilder("xdg-user-dir", string);
        try {
            process = processBuilder.start();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            return null;
        }
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(process.getInputStream()));
        try {
            String string2 = bufferedReader.readLine();
            return string2;
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            String string3 = null;
            return string3;
        }
        finally {
            process.destroy();
            try {
                bufferedReader.close();
            }
            catch (IOException iOException) {
                return null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static String runPowerShellCommand(String string) {
        Process process;
        ProcessBuilder processBuilder = new ProcessBuilder("powershell.exe", "-Command", "[Environment]::GetFolderPath([Environment+SpecialFolder]::" + string + ")");
        try {
            process = processBuilder.start();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            return null;
        }
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(process.getInputStream()));
        try {
            String string2 = bufferedReader.readLine();
            return string2;
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            String string3 = null;
            return string3;
        }
        finally {
            process.destroy();
            try {
                bufferedReader.close();
            }
            catch (IOException iOException) {
                return null;
            }
        }
    }

    static String stripQualification(String string) {
        int n = string.lastIndexOf(46) + 1;
        return string.substring(n);
    }

    static String trimAndReplaceSpacesWithHyphensThenLowerCase(String string) {
        StringBuilder stringBuilder = new StringBuilder(string.length());
        boolean bl = false;
        int n = string.codePointCount(0, string.length());
        for (int i = 0; i < n; ++i) {
            int n2 = string.codePointAt(i);
            if (n2 == 32) {
                if (!bl || !Util.codePointExistsAndNotSpace(string, n, i + 1)) continue;
                stringBuilder.append('-');
                bl = false;
                continue;
            }
            stringBuilder.appendCodePoint(Character.toLowerCase(n2));
            bl = true;
        }
        return stringBuilder.toString();
    }

    private static boolean codePointExistsAndNotSpace(String string, int n, int n2) {
        return n2 < n && string.codePointAt(n2) != 32;
    }

    static {
        String string = operatingSystemName.toLowerCase(Locale.ENGLISH);
        if (string.contains("linux")) {
            operatingSystem = (char)108;
        } else if (string.contains("mac")) {
            operatingSystem = (char)109;
        } else if (string.contains("windows")) {
            operatingSystem = (char)119;
        } else {
            throw new UnsupportedOperatingSystemException("Base directories are not supported on " + operatingSystemName);
        }
    }
}

