#   File:       VIm.make
#   Target:     VIm
#   Created:    Sunday, December 29, 2000 09:55:14 PM


MAKEFILE	= VIm.make
MondoBuild	= {MAKEFILE}  # Make blank to avoid rebuilds when makefile is modified

ObjDir		= :obj:
Includes	=  
				  -i :src:proto:
CFlags		= -w 2,35 -enum int
Sym-PPC		= -sym off

PPCCOptions	= {Includes} {CFlags} {Sym-PPC}


### Source Files ###

SrcFiles	=  
				  :src:buffer.c 
				  :src:charset.c 
				  :src:diff.c 
				  :src:digraph.c 
				  :src:edit.c 
				  :src:eval.c 
				  :src:ex_cmds.c 
				  :src:ex_cmds2.c 
				  :src:ex_docmd.c 
				  :src:ex_eval.c 
				  :src:ex_getln.c 
				  :src:fileio.c 
				  :src:fold.c 
				  :src:getchar.c 
				  :src:hashtable.c 
				  :src:gui.c 
				  :src:gui_mac.c 
				  :src:if_cscope.c 
				  :src:main.c 
				  :src:mark.c 
				  :src:memfile.c 
				  :src:memline.c 
				  :src:menu.c 
				  :src:message.c 
				  :src:misc1.c 
				  :src:misc2.c 
				  :src:move.c 
				  :src:multibyte.c 
				  :src:normal.c 
				  :src:ops.c 
				  :src:option.c 
				  :src:os_mac.c 
				  :src:pty.c 
				  :src:quickfix.c 
				  :src:regexp.c 
				  :src:screen.c 
				  :src:search.c 
				  :src:syntax.c 
				  :src:tag.c 
				  :src:term.c 
				  :src:termlib.c 
				  :src:ui.c 
				  :src:undo.c 
				  :src:version.c 
				  :src:window.c 
				  :src:wsdebug.c


### Object Files ###

ObjFiles-PPC    =  
				  "{ObjDir}buffer.c.x" 
				  "{ObjDir}charset.c.x" 
				  "{ObjDir}diff.c.x" 
				  "{ObjDir}digraph.c.x" 
				  "{ObjDir}edit.c.x" 
				  "{ObjDir}eval.c.x" 
				  "{ObjDir}ex_cmds.c.x" 
				  "{ObjDir}ex_cmds2.c.x" 
				  "{ObjDir}ex_docmd.c.x" 
				  "{ObjDir}ex_eval.c.x" 
				  "{ObjDir}ex_getln.c.x" 
				  "{ObjDir}fileio.c.x" 
				  "{ObjDir}fold.c.x" 
				  "{ObjDir}getchar.c.x" 
				  "{ObjDir}hashtable.c.x" 
				  "{ObjDir}gui.c.x" 
				  "{ObjDir}gui_mac.c.x" 
				  "{ObjDir}if_cscope.c.x" 
				  "{ObjDir}main.c.x" 
				  "{ObjDir}mark.c.x" 
				  "{ObjDir}memfile.c.x" 
				  "{ObjDir}memline.c.x" 
				  "{ObjDir}menu.c.x" 
				  "{ObjDir}message.c.x" 
				  "{ObjDir}misc1.c.x" 
				  "{ObjDir}misc2.c.x" 
				  "{ObjDir}move.c.x" 
				  "{ObjDir}multibyte.c.x" 
				  "{ObjDir}normal.c.x" 
				  "{ObjDir}ops.c.x" 
				  "{ObjDir}option.c.x" 
				  "{ObjDir}os_mac.c.x" 
				  "{ObjDir}pty.c.x" 
				  "{ObjDir}quickfix.c.x" 
				  "{ObjDir}regexp.c.x" 
				  "{ObjDir}screen.c.x" 
				  "{ObjDir}search.c.x" 
				  "{ObjDir}syntax.c.x" 
				  "{ObjDir}tag.c.x" 
				  "{ObjDir}term.c.x" 
				  "{ObjDir}termlib.c.x" 
				  "{ObjDir}ui.c.x" 
				  "{ObjDir}undo.c.x" 
				  "{ObjDir}version.c.x" 
				  "{ObjDir}window.c.x" 
				  "{ObjDir}wsdebug.c.x"


### Libraries ###

LibFiles-PPC    =  
				  "{SharedLibraries}InterfaceLib" 
				  "{SharedLibraries}MathLib" 
				  "{SharedLibraries}StdCLib" 
				  "{PPCLibraries}StdCRuntime.o" 
				  "{PPCLibraries}PPCStdCLib.o" 
				  "{PPCLibraries}PPCCRuntime.o" 
				  "{PPCLibraries}PPCToolLibs.o"


### Default Rules ###

.c.x    .c  {MondoBuild}
	{PPCC} {depDir}{default}.c -o {targDir}{default}.c.x {PPCCOptions}


### Build Rules ###

VIm    {ObjFiles-PPC} {LibFiles-PPC} {MondoBuild}
	PPCLink 
		-o {Targ} 
		{ObjFiles-PPC} 
		{LibFiles-PPC} 
		{Sym-PPC} 
		-mf -d 
		-t 'APPL' 
		-c 'VIM!'



### Required Dependencies ###

"{ObjDir}buffer.c.x"    :src:buffer.c
"{ObjDir}charset.c.x"    :src:charset.c
"{ObjDir}diff.c.x"    :src:diff.c
"{ObjDir}digraph.c.x"    :src:digraph.c
"{ObjDir}edit.c.x"    :src:edit.c
"{ObjDir}eval.c.x"    :src:eval.c
"{ObjDir}ex_cmds.c.x"    :src:ex_cmds.c
"{ObjDir}ex_cmds2.c.x"    :src:ex_cmds2.c
"{ObjDir}ex_docmd.c.x"    :src:ex_docmd.c
"{ObjDir}ex_eval.c.x"    :src:ex_eval.c
"{ObjDir}ex_getln.c.x"    :src:ex_getln.c
"{ObjDir}fileio.c.x"    :src:fileio.c
"{ObjDir}fold.c.x"    :src:fold.c
"{ObjDir}getchar.c.x"    :src:getchar.c
"{ObjDir}hashtable.c.x"    :src:hashtable.c
"{ObjDir}gui.c.x"    :src:gui.c
"{ObjDir}gui_mac.c.x"    :src:gui_mac.c
"{ObjDir}if_cscope.c.x"    :src:if_cscope.c
"{ObjDir}main.c.x"    :src:main.c
"{ObjDir}mark.c.x"    :src:mark.c
"{ObjDir}memfile.c.x"    :src:memfile.c
"{ObjDir}memline.c.x"    :src:memline.c
"{ObjDir}menu.c.x"    :src:menu.c
"{ObjDir}message.c.x"    :src:message.c
"{ObjDir}misc1.c.x"    :src:misc1.c
"{ObjDir}misc2.c.x"    :src:misc2.c
"{ObjDir}move.c.x"    :src:move.c
"{ObjDir}multibyte.c.x"    :src:multibyte.c
"{ObjDir}normal.c.x"    :src:normal.c
"{ObjDir}ops.c.x"    :src:ops.c
"{ObjDir}option.c.x"    :src:option.c
"{ObjDir}os_mac.c.x"    :src:os_mac.c
"{ObjDir}pty.c.x"    :src:pty.c
"{ObjDir}quickfix.c.x"    :src:quickfix.c
"{ObjDir}regexp.c.x"    :src:regexp.c
"{ObjDir}screen.c.x"    :src:screen.c
"{ObjDir}search.c.x"    :src:search.c
"{ObjDir}syntax.c.x"    :src:syntax.c
"{ObjDir}tag.c.x"    :src:tag.c
"{ObjDir}term.c.x"    :src:term.c
"{ObjDir}termlib.c.x"    :src:termlib.c
"{ObjDir}ui.c.x"    :src:ui.c
"{ObjDir}undo.c.x"    :src:undo.c
"{ObjDir}version.c.x"    :src:version.c
"{ObjDir}window.c.x"    :src:window.c
"{ObjDir}wsdebug.c.x"    :src:wsdebug.c


### Optional Dependencies ###
### Build this target to generate "include file" dependencies. ###

Dependencies    $OutOfDate
	MakeDepend 
		-append {MAKEFILE} 
		-ignore "{CIncludes}" 
		-objdir "{ObjDir}" 
		-objext .x 
		{Includes} 
		{SrcFiles}


#*** Dependencies: Cut here ***
# These dependencies were produced at 12:17:02 Uhr on Fre, 29. Dez 2000 by MakeDepend

:obj:buffer.c.x	  
	:src:buffer.c 
	:src:vim.h 
	:src:auto:config.h 
	:src:feature.h 
	:src:os_unix.h 
	:src:os_mac.h 
	:src:workshop.h 
	:src:ascii.h 
	:src:keymap.h 
	:src:term.h 
	:src:macros.h 
	:src:structs.h 
	:src:globals.h 
	:src:option.h 
	:src:ex_cmds.h 
	:src:proto.h 
	:src:integration.h 
	:src:wsdebug.h 
	:src:regexp.h 
	:src:gui.h 
	:src:farsi.h 
	:src:proto:os_unix.pro 
	:src:proto:os_mac.pro 
	:src:proto:buffer.pro 
	:src:proto:charset.pro 
	:src:proto:if_cscope.pro 
	:src:proto:diff.pro 
	:src:proto:digraph.pro 
	:src:proto:edit.pro 
	:src:proto:eval.pro 
	:src:proto:ex_cmds.pro 
	:src:proto:ex_cmds2.pro 
	:src:proto:ex_docmd.pro 
	:src:proto:ex_eval.pro 
	:src:proto:ex_getln.pro 
	:src:proto:fileio.pro 
	:src:proto:fold.pro 
	:src:proto:getchar.pro 
	:src:proto:hashtable.pro 
	:src:proto:hangulin.pro 
	:src:proto:main.pro 
	:src:proto:mark.pro 
	:src:proto:memfile.pro 
	:src:proto:memline.pro 
	:src:proto:menu.pro 
	:src:proto:message.pro 
	:src:proto:misc1.pro 
	:src:proto:misc2.pro 
	:src:proto:move.pro 
	:src:proto:multibyte.pro 
	:src:proto:normal.pro 
	:src:proto:ops.pro 
	:src:proto:option.pro 
	:src:proto:quickfix.pro 
	:src:proto:regexp.pro 
	:src:proto:screen.pro 
	:src:proto:search.pro 
	:src:proto:syntax.pro 
	:src:proto:tag.pro 
	:src:proto:term.pro 
	:src:proto:termlib.pro 
	:src:proto:ui.pro 
	:src:proto:undo.pro 
	:src:proto:version.pro 
	:src:proto:window.pro 
	:src:proto:if_python.pro 
	:src:proto:if_tcl.pro 
	:src:proto:if_ruby.pro 
	:src:proto:gui.pro 
	:src:proto:pty.pro 
	:src:proto:gui_gtk.pro 
	:src:proto:gui_gtk_x11.pro 
	:src:proto:gui_motif.pro 
	:src:proto:gui_athena.pro 
	:src:proto:gui_mac.pro 
	:src:proto:gui_x11.pro 
	:src:proto:workshop.pro 
	:src:proto:if_perl.pro 
	:src:proto:if_perlsfio.pro

:obj:charset.c.x	  
	:src:charset.c 
	:src:vim.h 
	:src:auto:config.h 
	:src:feature.h 
	:src:os_unix.h 
	:src:os_mac.h 
	:src:workshop.h 
	:src:ascii.h 
	:src:keymap.h 
	:src:term.h 
	:src:macros.h 
	:src:structs.h 
	:src:globals.h 
	:src:option.h 
	:src:ex_cmds.h 
	:src:proto.h 
	:src:integration.h 
	:src:wsdebug.h 
	:src:regexp.h 
	:src:gui.h 
	:src:farsi.h 
	:src:proto:os_unix.pro 
	:src:proto:os_mac.pro 
	:src:proto:buffer.pro 
	:src:proto:charset.pro 
	:src:proto:if_cscope.pro 
	:src:proto:diff.pro 
	:src:proto:digraph.pro 
	:src:proto:edit.pro 
	:src:proto:eval.pro 
	:src:proto:ex_cmds.pro 
	:src:proto:ex_cmds2.pro 
	:src:proto:ex_docmd.pro 
	:src:proto:ex_eval.pro 
	:src:proto:ex_getln.pro 
	:src:proto:fileio.pro 
	:src:proto:fold.pro 
	:src:proto:getchar.pro 
	:src:proto:hashtable.pro 
	:src:proto:hangulin.pro 
	:src:proto:main.pro 
	:src:proto:mark.pro 
	:src:proto:memfile.pro 
	:src:proto:memline.pro 
	:src:proto:menu.pro 
	:src:proto:message.pro 
	:src:proto:misc1.pro 
	:src:proto:misc2.pro 
	:src:proto:move.pro 
	:src:proto:multibyte.pro 
	:src:proto:normal.pro 
	:src:proto:ops.pro 
	:src:proto:option.pro 
	:src:proto:quickfix.pro 
	:src:proto:regexp.pro 
	:src:proto:screen.pro 
	:src:proto:search.pro 
	:src:proto:syntax.pro 
	:src:proto:tag.pro 
	:src:proto:term.pro 
	:src:proto:termlib.pro 
	:src:proto:ui.pro 
	:src:proto:undo.pro 
	:src:proto:version.pro 
	:src:proto:window.pro 
	:src:proto:if_python.pro 
	:src:proto:if_tcl.pro 
	:src:proto:if_ruby.pro 
	:src:proto:gui.pro 
	:src:proto:pty.pro 
	:src:proto:gui_gtk.pro 
	:src:proto:gui_gtk_x11.pro 
	:src:proto:gui_motif.pro 
	:src:proto:gui_athena.pro 
	:src:proto:gui_mac.pro 
	:src:proto:gui_x11.pro 
	:src:proto:workshop.pro 
	:src:proto:if_perl.pro 
	:src:proto:if_perlsfio.pro

:obj:diff.c.x	  
	:src:diff.c 
	:src:vim.h 
	:src:auto:config.h 
	:src:feature.h 
	:src:os_unix.h 
	:src:os_mac.h 
	:src:workshop.h 
	:src:ascii.h 
	:src:keymap.h 
	:src:term.h 
	:src:macros.h 
	:src:structs.h 
	:src:globals.h 
	:src:option.h 
	:src:ex_cmds.h 
	:src:proto.h 
	:src:integration.h 
	:src:wsdebug.h 
	:src:regexp.h 
	:src:gui.h 
	:src:farsi.h 
	:src:proto:os_unix.pro 
	:src:proto:os_mac.pro 
	:src:proto:buffer.pro 
	:src:proto:charset.pro 
	:src:proto:if_cscope.pro 
	:src:proto:diff.pro 
	:src:proto:digraph.pro 
	:src:proto:edit.pro 
	:src:proto:eval.pro 
	:src:proto:ex_cmds.pro 
	:src:proto:ex_cmds2.pro 
	:src:proto:ex_docmd.pro 
	:src:proto:ex_eval.pro 
	:src:proto:ex_getln.pro 
	:src:proto:fileio.pro 
	:src:proto:fold.pro 
	:src:proto:getchar.pro 
	:src:proto:hashtable.pro 
	:src:proto:hangulin.pro 
	:src:proto:main.pro 
	:src:proto:mark.pro 
	:src:proto:memfile.pro 
	:src:proto:memline.pro 
	:src:proto:menu.pro 
	:src:proto:message.pro 
	:src:proto:misc1.pro 
	:src:proto:misc2.pro 
	:src:proto:move.pro 
	:src:proto:multibyte.pro 
	:src:proto:normal.pro 
	:src:proto:ops.pro 
	:src:proto:option.pro 
	:src:proto:quickfix.pro 
	:src:proto:regexp.pro 
	:src:proto:screen.pro 
	:src:proto:search.pro 
	:src:proto:syntax.pro 
	:src:proto:tag.pro 
	:src:proto:term.pro 
	:src:proto:termlib.pro 
	:src:proto:ui.pro 
	:src:proto:undo.pro 
	:src:proto:version.pro 
	:src:proto:window.pro 
	:src:proto:if_python.pro 
	:src:proto:if_tcl.pro 
	:src:proto:if_ruby.pro 
	:src:proto:gui.pro 
	:src:proto:pty.pro 
	:src:proto:gui_gtk.pro 
	:src:proto:gui_gtk_x11.pro 
	:src:proto:gui_motif.pro 
	:src:proto:gui_athena.pro 
	:src:proto:gui_mac.pro 
	:src:proto:gui_x11.pro 
	:src:proto:workshop.pro 
	:src:proto:if_perl.pro 
	:src:proto:if_perlsfio.pro

:obj:digraph.c.x	  
	:src:digraph.c 
	:src:vim.h 
	:src:auto:config.h 
	:src:feature.h 
	:src:os_unix.h 
	:src:os_mac.h 
	:src:workshop.h 
	:src:ascii.h 
	:src:keymap.h 
	:src:term.h 
	:src:macros.h 
	:src:structs.h 
	:src:globals.h 
	:src:option.h 
	:src:ex_cmds.h 
	:src:proto.h 
	:src:integration.h 
	:src:wsdebug.h 
	:src:regexp.h 
	:src:gui.h 
	:src:farsi.h 
	:src:proto:os_unix.pro 
	:src:proto:os_mac.pro 
	:src:proto:buffer.pro 
	:src:proto:charset.pro 
	:src:proto:if_cscope.pro 
	:src:proto:diff.pro 
	:src:proto:digraph.pro 
	:src:proto:edit.pro 
	:src:proto:eval.pro 
	:src:proto:ex_cmds.pro 
	:src:proto:ex_cmds2.pro 
	:src:proto:ex_docmd.pro 
	:src:proto:ex_eval.pro 
	:src:proto:ex_getln.pro 
	:src:proto:fileio.pro 
	:src:proto:fold.pro 
	:src:proto:getchar.pro 
	:src:proto:hashtable.pro 
	:src:proto:hangulin.pro 
	:src:proto:main.pro 
	:src:proto:mark.pro 
	:src:proto:memfile.pro 
	:src:proto:memline.pro 
	:src:proto:menu.pro 
	:src:proto:message.pro 
	:src:proto:misc1.pro 
	:src:proto:misc2.pro 
	:src:proto:move.pro 
	:src:proto:multibyte.pro 
	:src:proto:normal.pro 
	:src:proto:ops.pro 
	:src:proto:option.pro 
	:src:proto:quickfix.pro 
	:src:proto:regexp.pro 
	:src:proto:screen.pro 
	:src:proto:search.pro 
	:src:proto:syntax.pro 
	:src:proto:tag.pro 
	:src:proto:term.pro 
	:src:proto:termlib.pro 
	:src:proto:ui.pro 
	:src:proto:undo.pro 
	:src:proto:version.pro 
	:src:proto:window.pro 
	:src:proto:if_python.pro 
	:src:proto:if_tcl.pro 
	:src:proto:if_ruby.pro 
	:src:proto:gui.pro 
	:src:proto:pty.pro 
	:src:proto:gui_gtk.pro 
	:src:proto:gui_gtk_x11.pro 
	:src:proto:gui_motif.pro 
	:src:proto:gui_athena.pro 
	:src:proto:gui_mac.pro 
	:src:proto:gui_x11.pro 
	:src:proto:workshop.pro 
	:src:proto:if_perl.pro 
	:src:proto:if_perlsfio.pro

:obj:edit.c.x	  
	:src:edit.c 
	:src:vim.h 
	:src:auto:config.h 
	:src:feature.h 
	:src:os_unix.h 
	:src:os_mac.h 
	:src:workshop.h 
	:src:ascii.h 
	:src:keymap.h 
	:src:term.h 
	:src:macros.h 
	:src:structs.h 
	:src:globals.h 
	:src:option.h 
	:src:ex_cmds.h 
	:src:proto.h 
	:src:integration.h 
	:src:wsdebug.h 
	:src:regexp.h 
	:src:gui.h 
	:src:farsi.h 
	:src:proto:os_unix.pro 
	:src:proto:os_mac.pro 
	:src:proto:buffer.pro 
	:src:proto:charset.pro 
	:src:proto:if_cscope.pro 
	:src:proto:diff.pro 
	:src:proto:digraph.pro 
	:src:proto:edit.pro 
	:src:proto:eval.pro 
	:src:proto:ex_cmds.pro 
	:src:proto:ex_cmds2.pro 
	:src:proto:ex_docmd.pro 
	:src:proto:ex_eval.pro 
	:src:proto:ex_getln.pro 
	:src:proto:fileio.pro 
	:src:proto:fold.pro 
	:src:proto:getchar.pro 
	:src:proto:hashtable.pro 
	:src:proto:hangulin.pro 
	:src:proto:main.pro 
	:src:proto:mark.pro 
	:src:proto:memfile.pro 
	:src:proto:memline.pro 
	:src:proto:menu.pro 
	:src:proto:message.pro 
	:src:proto:misc1.pro 
	:src:proto:misc2.pro 
	:src:proto:move.pro 
	:src:proto:multibyte.pro 
	:src:proto:normal.pro 
	:src:proto:ops.pro 
	:src:proto:option.pro 
	:src:proto:quickfix.pro 
	:src:proto:regexp.pro 
	:src:proto:screen.pro 
	:src:proto:search.pro 
	:src:proto:syntax.pro 
	:src:proto:tag.pro 
	:src:proto:term.pro 
	:src:proto:termlib.pro 
	:src:proto:ui.pro 
	:src:proto:undo.pro 
	:src:proto:version.pro 
	:src:proto:window.pro 
	:src:proto:if_python.pro 
	:src:proto:if_tcl.pro 
	:src:proto:if_ruby.pro 
	:src:proto:gui.pro 
	:src:proto:pty.pro 
	:src:proto:gui_gtk.pro 
	:src:proto:gui_gtk_x11.pro 
	:src:proto:gui_motif.pro 
	:src:proto:gui_athena.pro 
	:src:proto:gui_mac.pro 
	:src:proto:gui_x11.pro 
	:src:proto:workshop.pro 
	:src:proto:if_perl.pro 
	:src:proto:if_perlsfio.pro

:obj:eval.c.x	  
	:src:eval.c 
	:src:vim.h 
	:src:version.h 
	:src:auto:config.h 
	:src:feature.h 
	:src:os_unix.h 
	:src:os_mac.h 
	:src:workshop.h 
	:src:ascii.h 
	:src:keymap.h 
	:src:term.h 
	:src:macros.h 
	:src:structs.h 
	:src:globals.h 
	:src:option.h 
	:src:ex_cmds.h 
	:src:proto.h 
	:src:integration.h 
	:src:wsdebug.h 
	:src:regexp.h 
	:src:gui.h 
	:src:farsi.h 
	:src:proto:os_unix.pro 
	:src:proto:os_mac.pro 
	:src:proto:buffer.pro 
	:src:proto:charset.pro 
	:src:proto:if_cscope.pro 
	:src:proto:diff.pro 
	:src:proto:digraph.pro 
	:src:proto:edit.pro 
	:src:proto:eval.pro 
	:src:proto:ex_cmds.pro 
	:src:proto:ex_cmds2.pro 
	:src:proto:ex_docmd.pro 
	:src:proto:ex_eval.pro 
	:src:proto:ex_getln.pro 
	:src:proto:fileio.pro 
	:src:proto:fold.pro 
	:src:proto:getchar.pro 
	:src:proto:hashtable.pro 
	:src:proto:hangulin.pro 
	:src:proto:main.pro 
	:src:proto:mark.pro 
	:src:proto:memfile.pro 
	:src:proto:memline.pro 
	:src:proto:menu.pro 
	:src:proto:message.pro 
	:src:proto:misc1.pro 
	:src:proto:misc2.pro 
	:src:proto:move.pro 
	:src:proto:multibyte.pro 
	:src:proto:normal.pro 
	:src:proto:ops.pro 
	:src:proto:option.pro 
	:src:proto:quickfix.pro 
	:src:proto:regexp.pro 
	:src:proto:screen.pro 
	:src:proto:search.pro 
	:src:proto:syntax.pro 
	:src:proto:tag.pro 
	:src:proto:term.pro 
	:src:proto:termlib.pro 
	:src:proto:ui.pro 
	:src:proto:undo.pro 
	:src:proto:version.pro 
	:src:proto:window.pro 
	:src:proto:if_python.pro 
	:src:proto:if_tcl.pro 
	:src:proto:if_ruby.pro 
	:src:proto:gui.pro 
	:src:proto:pty.pro 
	:src:proto:gui_gtk.pro 
	:src:proto:gui_gtk_x11.pro 
	:src:proto:gui_motif.pro 
	:src:proto:gui_athena.pro 
	:src:proto:gui_mac.pro 
	:src:proto:gui_x11.pro 
	:src:proto:workshop.pro 
	:src:proto:if_perl.pro 
	:src:proto:if_perlsfio.pro

:obj:ex_cmds.c.x	  
	:src:ex_cmds.c 
	:src:vim.h 
	:src:auto:config.h 
	:src:feature.h 
	:src:os_unix.h 
	:src:os_mac.h 
	:src:workshop.h 
	:src:ascii.h 
	:src:keymap.h 
	:src:term.h 
	:src:macros.h 
	:src:structs.h 
	:src:globals.h 
	:src:option.h 
	:src:ex_cmds.h 
	:src:proto.h 
	:src:integration.h 
	:src:wsdebug.h 
	:src:regexp.h 
	:src:gui.h 
	:src:farsi.h 
	:src:proto:os_unix.pro 
	:src:proto:os_mac.pro 
	:src:proto:buffer.pro 
	:src:proto:charset.pro 
	:src:proto:if_cscope.pro 
	:src:proto:diff.pro 
	:src:proto:digraph.pro 
	:src:proto:edit.pro 
	:src:proto:eval.pro 
	:src:proto:ex_cmds.pro 
	:src:proto:ex_cmds2.pro 
	:src:proto:ex_docmd.pro 
	:src:proto:ex_eval.pro 
	:src:proto:ex_getln.pro 
	:src:proto:fileio.pro 
	:src:proto:fold.pro 
	:src:proto:getchar.pro 
	:src:proto:hashtable.pro 
	:src:proto:hangulin.pro 
	:src:proto:main.pro 
	:src:proto:mark.pro 
	:src:proto:memfile.pro 
	:src:proto:memline.pro 
	:src:proto:menu.pro 
	:src:proto:message.pro 
	:src:proto:misc1.pro 
	:src:proto:misc2.pro 
	:src:proto:move.pro 
	:src:proto:multibyte.pro 
	:src:proto:normal.pro 
	:src:proto:ops.pro 
	:src:proto:option.pro 
	:src:proto:quickfix.pro 
	:src:proto:regexp.pro 
	:src:proto:screen.pro 
	:src:proto:search.pro 
	:src:proto:syntax.pro 
	:src:proto:tag.pro 
	:src:proto:term.pro 
	:src:proto:termlib.pro 
	:src:proto:ui.pro 
	:src:proto:undo.pro 
	:src:proto:version.pro 
	:src:proto:window.pro 
	:src:proto:if_python.pro 
	:src:proto:if_tcl.pro 
	:src:proto:if_ruby.pro 
	:src:proto:gui.pro 
	:src:proto:pty.pro 
	:src:proto:gui_gtk.pro 
	:src:proto:gui_gtk_x11.pro 
	:src:proto:gui_motif.pro 
	:src:proto:gui_athena.pro 
	:src:proto:gui_mac.pro 
	:src:proto:gui_x11.pro 
	:src:proto:workshop.pro 
	:src:proto:if_perl.pro 
	:src:proto:if_perlsfio.pro

:obj:ex_cmds2.c.x	  
	:src:ex_cmds2.c 
	:src:vim.h 
	:src:auto:config.h 
	:src:feature.h 
	:src:os_unix.h 
	:src:os_mac.h 
	:src:workshop.h 
	:src:ascii.h 
	:src:keymap.h 
	:src:term.h 
	:src:macros.h 
	:src:structs.h 
	:src:globals.h 
	:src:option.h 
	:src:ex_cmds.h 
	:src:proto.h 
	:src:integration.h 
	:src:wsdebug.h 
	:src:regexp.h 
	:src:gui.h 
	:src:farsi.h 
	:src:proto:os_unix.pro 
	:src:proto:os_mac.pro 
	:src:proto:buffer.pro 
	:src:proto:charset.pro 
	:src:proto:if_cscope.pro 
	:src:proto:diff.pro 
	:src:proto:digraph.pro 
	:src:proto:edit.pro 
	:src:proto:eval.pro 
	:src:proto:ex_cmds.pro 
	:src:proto:ex_cmds2.pro 
	:src:proto:ex_docmd.pro 
	:src:proto:ex_eval.pro 
	:src:proto:ex_getln.pro 
	:src:proto:fileio.pro 
	:src:proto:fold.pro 
	:src:proto:getchar.pro 
	:src:proto:hashtable.pro 
	:src:proto:hangulin.pro 
	:src:proto:main.pro 
	:src:proto:mark.pro 
	:src:proto:memfile.pro 
	:src:proto:memline.pro 
	:src:proto:menu.pro 
	:src:proto:message.pro 
	:src:proto:misc1.pro 
	:src:proto:misc2.pro 
	:src:proto:move.pro 
	:src:proto:multibyte.pro 
	:src:proto:normal.pro 
	:src:proto:ops.pro 
	:src:proto:option.pro 
	:src:proto:quickfix.pro 
	:src:proto:regexp.pro 
	:src:proto:screen.pro 
	:src:proto:search.pro 
	:src:proto:syntax.pro 
	:src:proto:tag.pro 
	:src:proto:term.pro 
	:src:proto:termlib.pro 
	:src:proto:ui.pro 
	:src:proto:undo.pro 
	:src:proto:version.pro 
	:src:proto:window.pro 
	:src:proto:if_python.pro 
	:src:proto:if_tcl.pro 
	:src:proto:if_ruby.pro 
	:src:proto:gui.pro 
	:src:proto:pty.pro 
	:src:proto:gui_gtk.pro 
	:src:proto:gui_gtk_x11.pro 
	:src:proto:gui_motif.pro 
	:src:proto:gui_athena.pro 
	:src:proto:gui_mac.pro 
	:src:proto:gui_x11.pro 
	:src:proto:workshop.pro 
	:src:proto:if_perl.pro 
	:src:proto:if_perlsfio.pro

:obj:ex_docmd.c.x	  
	:src:ex_docmd.c 
	:src:vim.h 
	:src:ex_cmds.h 
	:src:auto:config.h 
	:src:feature.h 
	:src:os_unix.h 
	:src:os_mac.h 
	:src:workshop.h 
	:src:ascii.h 
	:src:keymap.h 
	:src:term.h 
	:src:macros.h 
	:src:structs.h 
	:src:globals.h 
	:src:option.h 
	:src:proto.h 
	:src:integration.h 
	:src:wsdebug.h 
	:src:regexp.h 
	:src:gui.h 
	:src:farsi.h 
	:src:proto:os_unix.pro 
	:src:proto:os_mac.pro 
	:src:proto:buffer.pro 
	:src:proto:charset.pro 
	:src:proto:if_cscope.pro 
	:src:proto:diff.pro 
	:src:proto:digraph.pro 
	:src:proto:edit.pro 
	:src:proto:eval.pro 
	:src:proto:ex_cmds.pro 
	:src:proto:ex_cmds2.pro 
	:src:proto:ex_docmd.pro 
	:src:proto:ex_eval.pro 
	:src:proto:ex_getln.pro 
	:src:proto:fileio.pro 
	:src:proto:fold.pro 
	:src:proto:getchar.pro 
	:src:proto:hashtable.pro 
	:src:proto:hangulin.pro 
	:src:proto:main.pro 
	:src:proto:mark.pro 
	:src:proto:memfile.pro 
	:src:proto:memline.pro 
	:src:proto:menu.pro 
	:src:proto:message.pro 
	:src:proto:misc1.pro 
	:src:proto:misc2.pro 
	:src:proto:move.pro 
	:src:proto:multibyte.pro 
	:src:proto:normal.pro 
	:src:proto:ops.pro 
	:src:proto:option.pro 
	:src:proto:quickfix.pro 
	:src:proto:regexp.pro 
	:src:proto:screen.pro 
	:src:proto:search.pro 
	:src:proto:syntax.pro 
	:src:proto:tag.pro 
	:src:proto:term.pro 
	:src:proto:termlib.pro 
	:src:proto:ui.pro 
	:src:proto:undo.pro 
	:src:proto:version.pro 
	:src:proto:window.pro 
	:src:proto:if_python.pro 
	:src:proto:if_tcl.pro 
	:src:proto:if_ruby.pro 
	:src:proto:gui.pro 
	:src:proto:pty.pro 
	:src:proto:gui_gtk.pro 
	:src:proto:gui_gtk_x11.pro 
	:src:proto:gui_motif.pro 
	:src:proto:gui_athena.pro 
	:src:proto:gui_mac.pro 
	:src:proto:gui_x11.pro 
	:src:proto:workshop.pro 
	:src:proto:if_perl.pro 
	:src:proto:if_perlsfio.pro

:obj:ex_eval.c.x	  
	:src:ex_eval.c 
	:src:vim.h 
	:src:ex_cmds.h 
	:src:auto:config.h 
	:src:feature.h 
	:src:os_unix.h 
	:src:os_mac.h 
	:src:workshop.h 
	:src:ascii.h 
	:src:keymap.h 
	:src:term.h 
	:src:macros.h 
	:src:structs.h 
	:src:globals.h 
	:src:option.h 
	:src:proto.h 
	:src:integration.h 
	:src:wsdebug.h 
	:src:regexp.h 
	:src:gui.h 
	:src:farsi.h 
	:src:proto:os_unix.pro 
	:src:proto:os_mac.pro 
	:src:proto:buffer.pro 
	:src:proto:charset.pro 
	:src:proto:if_cscope.pro 
	:src:proto:diff.pro 
	:src:proto:digraph.pro 
	:src:proto:edit.pro 
	:src:proto:eval.pro 
	:src:proto:ex_cmds.pro 
	:src:proto:ex_cmds2.pro 
	:src:proto:ex_docmd.pro 
	:src:proto:ex_eval.pro 
	:src:proto:ex_getln.pro 
	:src:proto:fileio.pro 
	:src:proto:fold.pro 
	:src:proto:getchar.pro 
	:src:proto:hashtable.pro 
	:src:proto:hangulin.pro 
	:src:proto:main.pro 
	:src:proto:mark.pro 
	:src:proto:memfile.pro 
	:src:proto:memline.pro 
	:src:proto:menu.pro 
	:src:proto:message.pro 
	:src:proto:misc1.pro 
	:src:proto:misc2.pro 
	:src:proto:move.pro 
	:src:proto:multibyte.pro 
	:src:proto:normal.pro 
	:src:proto:ops.pro 
	:src:proto:option.pro 
	:src:proto:quickfix.pro 
	:src:proto:regexp.pro 
	:src:proto:screen.pro 
	:src:proto:search.pro 
	:src:proto:syntax.pro 
	:src:proto:tag.pro 
	:src:proto:term.pro 
	:src:proto:termlib.pro 
	:src:proto:ui.pro 
	:src:proto:undo.pro 
	:src:proto:version.pro 
	:src:proto:window.pro 
	:src:proto:if_python.pro 
	:src:proto:if_tcl.pro 
	:src:proto:if_ruby.pro 
	:src:proto:gui.pro 
	:src:proto:pty.pro 
	:src:proto:gui_gtk.pro 
	:src:proto:gui_gtk_x11.pro 
	:src:proto:gui_motif.pro 
	:src:proto:gui_athena.pro 
	:src:proto:gui_mac.pro 
	:src:proto:gui_x11.pro 
	:src:proto:workshop.pro 
	:src:proto:if_perl.pro 
	:src:proto:if_perlsfio.pro

:obj:ex_getln.c.x	  
	:src:ex_getln.c 
	:src:vim.h 
	:src:auto:config.h 
	:src:feature.h 
	:src:os_unix.h 
	:src:os_mac.h 
	:src:workshop.h 
	:src:ascii.h 
	:src:keymap.h 
	:src:term.h 
	:src:macros.h 
	:src:structs.h 
	:src:globals.h 
	:src:option.h 
	:src:ex_cmds.h 
	:src:proto.h 
	:src:integration.h 
	:src:wsdebug.h 
	:src:regexp.h 
	:src:gui.h 
	:src:farsi.h 
	:src:proto:os_unix.pro 
	:src:proto:os_mac.pro 
	:src:proto:buffer.pro 
	:src:proto:charset.pro 
	:src:proto:if_cscope.pro 
	:src:proto:diff.pro 
	:src:proto:digraph.pro 
	:src:proto:edit.pro 
	:src:proto:eval.pro 
	:src:proto:ex_cmds.pro 
	:src:proto:ex_cmds2.pro 
	:src:proto:ex_docmd.pro 
	:src:proto:ex_eval.pro 
	:src:proto:ex_getln.pro 
	:src:proto:fileio.pro 
	:src:proto:fold.pro 
	:src:proto:getchar.pro 
	:src:proto:hashtable.pro 
	:src:proto:hangulin.pro 
	:src:proto:main.pro 
	:src:proto:mark.pro 
	:src:proto:memfile.pro 
	:src:proto:memline.pro 
	:src:proto:menu.pro 
	:src:proto:message.pro 
	:src:proto:misc1.pro 
	:src:proto:misc2.pro 
	:src:proto:move.pro 
	:src:proto:multibyte.pro 
	:src:proto:normal.pro 
	:src:proto:ops.pro 
	:src:proto:option.pro 
	:src:proto:quickfix.pro 
	:src:proto:regexp.pro 
	:src:proto:screen.pro 
	:src:proto:search.pro 
	:src:proto:syntax.pro 
	:src:proto:tag.pro 
	:src:proto:term.pro 
	:src:proto:termlib.pro 
	:src:proto:ui.pro 
	:src:proto:undo.pro 
	:src:proto:version.pro 
	:src:proto:window.pro 
	:src:proto:if_python.pro 
	:src:proto:if_tcl.pro 
	:src:proto:if_ruby.pro 
	:src:proto:gui.pro 
	:src:proto:pty.pro 
	:src:proto:gui_gtk.pro 
	:src:proto:gui_gtk_x11.pro 
	:src:proto:gui_motif.pro 
	:src:proto:gui_athena.pro 
	:src:proto:gui_mac.pro 
	:src:proto:gui_x11.pro 
	:src:proto:workshop.pro 
	:src:proto:if_perl.pro 
	:src:proto:if_perlsfio.pro

:obj:fileio.c.x	  
	:src:fileio.c 
	:src:vim.h 
	:src:auto:config.h 
	:src:feature.h 
	:src:os_unix.h 
	:src:os_mac.h 
	:src:workshop.h 
	:src:ascii.h 
	:src:keymap.h 
	:src:term.h 
	:src:macros.h 
	:src:structs.h 
	:src:globals.h 
	:src:option.h 
	:src:ex_cmds.h 
	:src:proto.h 
	:src:integration.h 
	:src:wsdebug.h 
	:src:regexp.h 
	:src:gui.h 
	:src:farsi.h 
	:src:proto:os_unix.pro 
	:src:proto:os_mac.pro 
	:src:proto:buffer.pro 
	:src:proto:charset.pro 
	:src:proto:if_cscope.pro 
	:src:proto:diff.pro 
	:src:proto:digraph.pro 
	:src:proto:edit.pro 
	:src:proto:eval.pro 
	:src:proto:ex_cmds.pro 
	:src:proto:ex_cmds2.pro 
	:src:proto:ex_docmd.pro 
	:src:proto:ex_eval.pro 
	:src:proto:ex_getln.pro 
	:src:proto:fileio.pro 
	:src:proto:fold.pro 
	:src:proto:getchar.pro 
	:src:proto:hashtable.pro 
	:src:proto:hangulin.pro 
	:src:proto:main.pro 
	:src:proto:mark.pro 
	:src:proto:memfile.pro 
	:src:proto:memline.pro 
	:src:proto:menu.pro 
	:src:proto:message.pro 
	:src:proto:misc1.pro 
	:src:proto:misc2.pro 
	:src:proto:move.pro 
	:src:proto:multibyte.pro 
	:src:proto:normal.pro 
	:src:proto:ops.pro 
	:src:proto:option.pro 
	:src:proto:quickfix.pro 
	:src:proto:regexp.pro 
	:src:proto:screen.pro 
	:src:proto:search.pro 
	:src:proto:syntax.pro 
	:src:proto:tag.pro 
	:src:proto:term.pro 
	:src:proto:termlib.pro 
	:src:proto:ui.pro 
	:src:proto:undo.pro 
	:src:proto:version.pro 
	:src:proto:window.pro 
	:src:proto:if_python.pro 
	:src:proto:if_tcl.pro 
	:src:proto:if_ruby.pro 
	:src:proto:gui.pro 
	:src:proto:pty.pro 
	:src:proto:gui_gtk.pro 
	:src:proto:gui_gtk_x11.pro 
	:src:proto:gui_motif.pro 
	:src:proto:gui_athena.pro 
	:src:proto:gui_mac.pro 
	:src:proto:gui_x11.pro 
	:src:proto:workshop.pro 
	:src:proto:if_perl.pro 
	:src:proto:if_perlsfio.pro

:obj:fold.c.x	  
	:src:fold.c 
	:src:vim.h 
	:src:auto:config.h 
	:src:feature.h 
	:src:os_unix.h 
	:src:os_mac.h 
	:src:workshop.h 
	:src:ascii.h 
	:src:keymap.h 
	:src:term.h 
	:src:macros.h 
	:src:structs.h 
	:src:globals.h 
	:src:option.h 
	:src:ex_cmds.h 
	:src:proto.h 
	:src:integration.h 
	:src:wsdebug.h 
	:src:regexp.h 
	:src:gui.h 
	:src:farsi.h 
	:src:proto:os_unix.pro 
	:src:proto:os_mac.pro 
	:src:proto:buffer.pro 
	:src:proto:charset.pro 
	:src:proto:if_cscope.pro 
	:src:proto:diff.pro 
	:src:proto:digraph.pro 
	:src:proto:edit.pro 
	:src:proto:eval.pro 
	:src:proto:ex_cmds.pro 
	:src:proto:ex_cmds2.pro 
	:src:proto:ex_docmd.pro 
	:src:proto:ex_eval.pro 
	:src:proto:ex_getln.pro 
	:src:proto:fileio.pro 
	:src:proto:fold.pro 
	:src:proto:getchar.pro 
	:src:proto:hashtable.pro 
	:src:proto:hangulin.pro 
	:src:proto:main.pro 
	:src:proto:mark.pro 
	:src:proto:memfile.pro 
	:src:proto:memline.pro 
	:src:proto:menu.pro 
	:src:proto:message.pro 
	:src:proto:misc1.pro 
	:src:proto:misc2.pro 
	:src:proto:move.pro 
	:src:proto:multibyte.pro 
	:src:proto:normal.pro 
	:src:proto:ops.pro 
	:src:proto:option.pro 
	:src:proto:quickfix.pro 
	:src:proto:regexp.pro 
	:src:proto:screen.pro 
	:src:proto:search.pro 
	:src:proto:syntax.pro 
	:src:proto:tag.pro 
	:src:proto:term.pro 
	:src:proto:termlib.pro 
	:src:proto:ui.pro 
	:src:proto:undo.pro 
	:src:proto:version.pro 
	:src:proto:window.pro 
	:src:proto:if_python.pro 
	:src:proto:if_tcl.pro 
	:src:proto:if_ruby.pro 
	:src:proto:gui.pro 
	:src:proto:pty.pro 
	:src:proto:gui_gtk.pro 
	:src:proto:gui_gtk_x11.pro 
	:src:proto:gui_motif.pro 
	:src:proto:gui_athena.pro 
	:src:proto:gui_mac.pro 
	:src:proto:gui_x11.pro 
	:src:proto:workshop.pro 
	:src:proto:if_perl.pro 
	:src:proto:if_perlsfio.pro

:obj:getchar.c.x	  
	:src:getchar.c 
	:src:vim.h 
	:src:auto:config.h 
	:src:feature.h 
	:src:os_unix.h 
	:src:os_mac.h 
	:src:workshop.h 
	:src:ascii.h 
	:src:keymap.h 
	:src:term.h 
	:src:macros.h 
	:src:structs.h 
	:src:globals.h 
	:src:option.h 
	:src:ex_cmds.h 
	:src:proto.h 
	:src:integration.h 
	:src:wsdebug.h 
	:src:regexp.h 
	:src:gui.h 
	:src:farsi.h 
	:src:proto:os_unix.pro 
	:src:proto:os_mac.pro 
	:src:proto:buffer.pro 
	:src:proto:charset.pro 
	:src:proto:if_cscope.pro 
	:src:proto:diff.pro 
	:src:proto:digraph.pro 
	:src:proto:edit.pro 
	:src:proto:eval.pro 
	:src:proto:ex_cmds.pro 
	:src:proto:ex_cmds2.pro 
	:src:proto:ex_docmd.pro 
	:src:proto:ex_eval.pro 
	:src:proto:ex_getln.pro 
	:src:proto:fileio.pro 
	:src:proto:fold.pro 
	:src:proto:getchar.pro 
	:src:proto:hangulin.pro 
	:src:proto:main.pro 
	:src:proto:mark.pro 
	:src:proto:memfile.pro 
	:src:proto:memline.pro 
	:src:proto:menu.pro 
	:src:proto:message.pro 
	:src:proto:misc1.pro 
	:src:proto:misc2.pro 
	:src:proto:move.pro 
	:src:proto:multibyte.pro 
	:src:proto:normal.pro 
	:src:proto:ops.pro 
	:src:proto:option.pro 
	:src:proto:quickfix.pro 
	:src:proto:regexp.pro 
	:src:proto:screen.pro 
	:src:proto:search.pro 
	:src:proto:syntax.pro 
	:src:proto:tag.pro 
	:src:proto:term.pro 
	:src:proto:termlib.pro 
	:src:proto:ui.pro 
	:src:proto:undo.pro 
	:src:proto:version.pro 
	:src:proto:window.pro 
	:src:proto:if_python.pro 
	:src:proto:if_tcl.pro 
	:src:proto:if_ruby.pro 
	:src:proto:gui.pro 
	:src:proto:pty.pro 
	:src:proto:gui_gtk.pro 
	:src:proto:gui_gtk_x11.pro 
	:src:proto:gui_motif.pro 
	:src:proto:gui_athena.pro 
	:src:proto:gui_mac.pro 
	:src:proto:gui_x11.pro 
	:src:proto:workshop.pro 
	:src:proto:if_perl.pro 
	:src:proto:if_perlsfio.pro

:obj:hashtable.c.x	  
	:src:hashtable.c 
	:src:vim.h 
	:src:auto:config.h 
	:src:feature.h 
	:src:os_unix.h 
	:src:os_mac.h 
	:src:workshop.h 
	:src:ascii.h 
	:src:keymap.h 
	:src:term.h 
	:src:macros.h 
	:src:structs.h 
	:src:globals.h 
	:src:option.h 
	:src:ex_cmds.h 
	:src:proto.h 
	:src:integration.h 
	:src:wsdebug.h 
	:src:regexp.h 
	:src:gui.h 
	:src:farsi.h 
	:src:proto:os_unix.pro 
	:src:proto:os_mac.pro 
	:src:proto:buffer.pro 
	:src:proto:charset.pro 
	:src:proto:if_cscope.pro 
	:src:proto:diff.pro 
	:src:proto:digraph.pro 
	:src:proto:edit.pro 
	:src:proto:eval.pro 
	:src:proto:ex_cmds.pro 
	:src:proto:ex_cmds2.pro 
	:src:proto:ex_docmd.pro 
	:src:proto:ex_eval.pro 
	:src:proto:ex_getln.pro 
	:src:proto:fileio.pro 
	:src:proto:fold.pro 
	:src:proto:getchar.pro 
	:src:proto:hashtable.pro 
	:src:proto:hangulin.pro 
	:src:proto:main.pro 
	:src:proto:mark.pro 
	:src:proto:memfile.pro 
	:src:proto:memline.pro 
	:src:proto:menu.pro 
	:src:proto:message.pro 
	:src:proto:misc1.pro 
	:src:proto:misc2.pro 
	:src:proto:move.pro 
	:src:proto:multibyte.pro 
	:src:proto:normal.pro 
	:src:proto:ops.pro 
	:src:proto:option.pro 
	:src:proto:quickfix.pro 
	:src:proto:regexp.pro 
	:src:proto:screen.pro 
	:src:proto:search.pro 
	:src:proto:syntax.pro 
	:src:proto:tag.pro 
	:src:proto:term.pro 
	:src:proto:termlib.pro 
	:src:proto:ui.pro 
	:src:proto:undo.pro 
	:src:proto:version.pro 
	:src:proto:window.pro 
	:src:proto:if_python.pro 
	:src:proto:if_tcl.pro 
	:src:proto:if_ruby.pro 
	:src:proto:gui.pro 
	:src:proto:pty.pro 
	:src:proto:gui_gtk.pro 
	:src:proto:gui_gtk_x11.pro 
	:src:proto:gui_motif.pro 
	:src:proto:gui_athena.pro 
	:src:proto:gui_mac.pro 
	:src:proto:gui_x11.pro 
	:src:proto:workshop.pro 
	:src:proto:if_perl.pro 
	:src:proto:if_perlsfio.pro

:obj:gui.c.x	  
	:src:gui.c 
	:src:vim.h 
	:src:auto:config.h 
	:src:feature.h 
	:src:os_unix.h 
	:src:os_mac.h 
	:src:workshop.h 
	:src:ascii.h 
	:src:keymap.h 
	:src:term.h 
	:src:macros.h 
	:src:structs.h 
	:src:globals.h 
	:src:option.h 
	:src:ex_cmds.h 
	:src:proto.h 
	:src:integration.h 
	:src:wsdebug.h 
	:src:regexp.h 
	:src:gui.h 
	:src:farsi.h 
	:src:proto:os_unix.pro 
	:src:proto:os_mac.pro 
	:src:proto:buffer.pro 
	:src:proto:charset.pro 
	:src:proto:if_cscope.pro 
	:src:proto:diff.pro 
	:src:proto:digraph.pro 
	:src:proto:edit.pro 
	:src:proto:eval.pro 
	:src:proto:ex_cmds.pro 
	:src:proto:ex_cmds2.pro 
	:src:proto:ex_docmd.pro 
	:src:proto:ex_eval.pro 
	:src:proto:ex_getln.pro 
	:src:proto:fileio.pro 
	:src:proto:fold.pro 
	:src:proto:getchar.pro 
	:src:proto:hashtable.pro 
	:src:proto:hangulin.pro 
	:src:proto:main.pro 
	:src:proto:mark.pro 
	:src:proto:memfile.pro 
	:src:proto:memline.pro 
	:src:proto:menu.pro 
	:src:proto:message.pro 
	:src:proto:misc1.pro 
	:src:proto:misc2.pro 
	:src:proto:move.pro 
	:src:proto:multibyte.pro 
	:src:proto:normal.pro 
	:src:proto:ops.pro 
	:src:proto:option.pro 
	:src:proto:quickfix.pro 
	:src:proto:regexp.pro 
	:src:proto:screen.pro 
	:src:proto:search.pro 
	:src:proto:syntax.pro 
	:src:proto:tag.pro 
	:src:proto:term.pro 
	:src:proto:termlib.pro 
	:src:proto:ui.pro 
	:src:proto:undo.pro 
	:src:proto:version.pro 
	:src:proto:window.pro 
	:src:proto:if_python.pro 
	:src:proto:if_tcl.pro 
	:src:proto:if_ruby.pro 
	:src:proto:gui.pro 
	:src:proto:pty.pro 
	:src:proto:gui_gtk.pro 
	:src:proto:gui_gtk_x11.pro 
	:src:proto:gui_motif.pro 
	:src:proto:gui_athena.pro 
	:src:proto:gui_mac.pro 
	:src:proto:gui_x11.pro 
	:src:proto:workshop.pro 
	:src:proto:if_perl.pro 
	:src:proto:if_perlsfio.pro

:obj:gui_mac.c.x	  
	:src:gui_mac.c 
	:src:vim.h 
	:src:globals.h 
	:src:option.h 
	:src:auto:config.h 
	:src:feature.h 
	:src:os_unix.h 
	:src:os_mac.h 
	:src:workshop.h 
	:src:ascii.h 
	:src:keymap.h 
	:src:term.h 
	:src:macros.h 
	:src:structs.h 
	:src:ex_cmds.h 
	:src:proto.h 
	:src:farsi.h 
	:src:integration.h 
	:src:wsdebug.h 
	:src:regexp.h 
	:src:gui.h 
	:src:proto:os_unix.pro 
	:src:proto:os_mac.pro 
	:src:proto:buffer.pro 
	:src:proto:charset.pro 
	:src:proto:if_cscope.pro 
	:src:proto:diff.pro 
	:src:proto:digraph.pro 
	:src:proto:edit.pro 
	:src:proto:eval.pro 
	:src:proto:ex_cmds.pro 
	:src:proto:ex_cmds2.pro 
	:src:proto:ex_docmd.pro 
	:src:proto:ex_eval.pro 
	:src:proto:ex_getln.pro 
	:src:proto:fileio.pro 
	:src:proto:fold.pro 
	:src:proto:getchar.pro 
	:src:proto:hashtable.pro 
	:src:proto:hangulin.pro 
	:src:proto:main.pro 
	:src:proto:mark.pro 
	:src:proto:memfile.pro 
	:src:proto:memline.pro 
	:src:proto:menu.pro 
	:src:proto:message.pro 
	:src:proto:misc1.pro 
	:src:proto:misc2.pro 
	:src:proto:move.pro 
	:src:proto:multibyte.pro 
	:src:proto:normal.pro 
	:src:proto:ops.pro 
	:src:proto:option.pro 
	:src:proto:quickfix.pro 
	:src:proto:regexp.pro 
	:src:proto:screen.pro 
	:src:proto:search.pro 
	:src:proto:syntax.pro 
	:src:proto:tag.pro 
	:src:proto:term.pro 
	:src:proto:termlib.pro 
	:src:proto:ui.pro 
	:src:proto:undo.pro 
	:src:proto:version.pro 
	:src:proto:window.pro 
	:src:proto:if_python.pro 
	:src:proto:if_tcl.pro 
	:src:proto:if_ruby.pro 
	:src:proto:gui.pro 
	:src:proto:pty.pro 
	:src:proto:gui_gtk.pro 
	:src:proto:gui_gtk_x11.pro 
	:src:proto:gui_motif.pro 
	:src:proto:gui_athena.pro 
	:src:proto:gui_mac.pro 
	:src:proto:gui_x11.pro 
	:src:proto:workshop.pro 
	:src:proto:if_perl.pro 
	:src:proto:if_perlsfio.pro

:src:gui_mac.r	  
	:src:gui_mac.r 
	"{RIncludes}"SysTypes.r 
	"{RIncludes}"Types.r 
	:src:version.h 
	"{RIncludes}"Fonts.r 
	"{RIncludes}"IntlResources.r 
	"{RIncludes}"Sound.r 
	"{RIncludes}"ConditionalMacros.r 
	"{RIncludes}"MacTypes.r 
	"{RIncludes}"Controls.r 
	"{RIncludes}"ControlDefinitions.r 
	"{RIncludes}"MacWindows.r 
	"{RIncludes}"Dialogs.r 
	"{RIncludes}"Menus.r 
	"{RIncludes}"Icons.r 
	"{RIncludes}"Finder.r 
	"{RIncludes}"Quickdraw.r 
	"{RIncludes}"Processes.r 
	"{RIncludes}"AppleEvents.r 
	"{RIncludes}"Script.r 
	"{RIncludes}"Collections.r 
	"{RIncludes}"PictUtils.r 
	"{RIncludes}"AEDataModel.r

:obj:if_cscope.c.x	  
	:src:if_cscope.c 
	:src:vim.h 
	:src:if_cscope.h 
	:src:auto:config.h 
	:src:feature.h 
	:src:os_unix.h 
	:src:os_mac.h 
	:src:workshop.h 
	:src:ascii.h 
	:src:keymap.h 
	:src:term.h 
	:src:macros.h 
	:src:structs.h 
	:src:globals.h 
	:src:option.h 
	:src:ex_cmds.h 
	:src:proto.h 
	:src:integration.h 
	:src:wsdebug.h 
	:src:regexp.h 
	:src:gui.h 
	:src:farsi.h 
	:src:proto:os_unix.pro 
	:src:proto:os_mac.pro 
	:src:proto:buffer.pro 
	:src:proto:charset.pro 
	:src:proto:if_cscope.pro 
	:src:proto:diff.pro 
	:src:proto:digraph.pro 
	:src:proto:edit.pro 
	:src:proto:eval.pro 
	:src:proto:ex_cmds.pro 
	:src:proto:ex_cmds2.pro 
	:src:proto:ex_docmd.pro 
	:src:proto:ex_eval.pro 
	:src:proto:ex_getln.pro 
	:src:proto:fileio.pro 
	:src:proto:fold.pro 
	:src:proto:getchar.pro 
	:src:proto:hashtable.pro 
	:src:proto:hangulin.pro 
	:src:proto:main.pro 
	:src:proto:mark.pro 
	:src:proto:memfile.pro 
	:src:proto:memline.pro 
	:src:proto:menu.pro 
	:src:proto:message.pro 
	:src:proto:misc1.pro 
	:src:proto:misc2.pro 
	:src:proto:move.pro 
	:src:proto:multibyte.pro 
	:src:proto:normal.pro 
	:src:proto:ops.pro 
	:src:proto:option.pro 
	:src:proto:quickfix.pro 
	:src:proto:regexp.pro 
	:src:proto:screen.pro 
	:src:proto:search.pro 
	:src:proto:syntax.pro 
	:src:proto:tag.pro 
	:src:proto:term.pro 
	:src:proto:termlib.pro 
	:src:proto:ui.pro 
	:src:proto:undo.pro 
	:src:proto:version.pro 
	:src:proto:window.pro 
	:src:proto:if_python.pro 
	:src:proto:if_tcl.pro 
	:src:proto:if_ruby.pro 
	:src:proto:gui.pro 
	:src:proto:pty.pro 
	:src:proto:gui_gtk.pro 
	:src:proto:gui_gtk_x11.pro 
	:src:proto:gui_motif.pro 
	:src:proto:gui_athena.pro 
	:src:proto:gui_mac.pro 
	:src:proto:gui_x11.pro 
	:src:proto:workshop.pro 
	:src:proto:if_perl.pro 
	:src:proto:if_perlsfio.pro

:obj:main.c.x	  
	:src:main.c 
	:src:vim.h 
	:src:farsi.c 
	:src:auto:config.h 
	:src:feature.h 
	:src:os_unix.h 
	:src:os_mac.h 
	:src:workshop.h 
	:src:ascii.h 
	:src:keymap.h 
	:src:term.h 
	:src:macros.h 
	:src:structs.h 
	:src:globals.h 
	:src:option.h 
	:src:ex_cmds.h 
	:src:proto.h 
	:src:integration.h 
	:src:wsdebug.h 
	:src:regexp.h 
	:src:gui.h 
	:src:farsi.h 
	:src:proto:os_unix.pro 
	:src:proto:os_mac.pro 
	:src:proto:buffer.pro 
	:src:proto:charset.pro 
	:src:proto:if_cscope.pro 
	:src:proto:diff.pro 
	:src:proto:digraph.pro 
	:src:proto:edit.pro 
	:src:proto:eval.pro 
	:src:proto:ex_cmds.pro 
	:src:proto:ex_cmds2.pro 
	:src:proto:ex_docmd.pro 
	:src:proto:ex_eval.pro 
	:src:proto:ex_getln.pro 
	:src:proto:fileio.pro 
	:src:proto:fold.pro 
	:src:proto:getchar.pro 
	:src:proto:hashtable.pro 
	:src:proto:hangulin.pro 
	:src:proto:main.pro 
	:src:proto:mark.pro 
	:src:proto:memfile.pro 
	:src:proto:memline.pro 
	:src:proto:menu.pro 
	:src:proto:message.pro 
	:src:proto:misc1.pro 
	:src:proto:misc2.pro 
	:src:proto:move.pro 
	:src:proto:multibyte.pro 
	:src:proto:normal.pro 
	:src:proto:ops.pro 
	:src:proto:option.pro 
	:src:proto:quickfix.pro 
	:src:proto:regexp.pro 
	:src:proto:screen.pro 
	:src:proto:search.pro 
	:src:proto:syntax.pro 
	:src:proto:tag.pro 
	:src:proto:term.pro 
	:src:proto:termlib.pro 
	:src:proto:ui.pro 
	:src:proto:undo.pro 
	:src:proto:version.pro 
	:src:proto:window.pro 
	:src:proto:if_python.pro 
	:src:proto:if_tcl.pro 
	:src:proto:if_ruby.pro 
	:src:proto:gui.pro 
	:src:proto:pty.pro 
	:src:proto:gui_gtk.pro 
	:src:proto:gui_gtk_x11.pro 
	:src:proto:gui_motif.pro 
	:src:proto:gui_athena.pro 
	:src:proto:gui_mac.pro 
	:src:proto:gui_x11.pro 
	:src:proto:workshop.pro 
	:src:proto:if_perl.pro 
	:src:proto:if_perlsfio.pro

:obj:mark.c.x	  
	:src:mark.c 
	:src:vim.h 
	:src:auto:config.h 
	:src:feature.h 
	:src:os_unix.h 
	:src:os_mac.h 
	:src:workshop.h 
	:src:ascii.h 
	:src:keymap.h 
	:src:term.h 
	:src:macros.h 
	:src:structs.h 
	:src:globals.h 
	:src:option.h 
	:src:ex_cmds.h 
	:src:proto.h 
	:src:integration.h 
	:src:wsdebug.h 
	:src:regexp.h 
	:src:gui.h 
	:src:farsi.h 
	:src:proto:os_unix.pro 
	:src:proto:os_mac.pro 
	:src:proto:buffer.pro 
	:src:proto:charset.pro 
	:src:proto:if_cscope.pro 
	:src:proto:diff.pro 
	:src:proto:digraph.pro 
	:src:proto:edit.pro 
	:src:proto:eval.pro 
	:src:proto:ex_cmds.pro 
	:src:proto:ex_cmds2.pro 
	:src:proto:ex_docmd.pro 
	:src:proto:ex_eval.pro 
	:src:proto:ex_getln.pro 
	:src:proto:fileio.pro 
	:src:proto:fold.pro 
	:src:proto:getchar.pro 
	:src:proto:hashtable.pro 
	:src:proto:hangulin.pro 
	:src:proto:main.pro 
	:src:proto:mark.pro 
	:src:proto:memfile.pro 
	:src:proto:memline.pro 
	:src:proto:menu.pro 
	:src:proto:message.pro 
	:src:proto:misc1.pro 
	:src:proto:misc2.pro 
	:src:proto:move.pro 
	:src:proto:multibyte.pro 
	:src:proto:normal.pro 
	:src:proto:ops.pro 
	:src:proto:option.pro 
	:src:proto:quickfix.pro 
	:src:proto:regexp.pro 
	:src:proto:screen.pro 
	:src:proto:search.pro 
	:src:proto:syntax.pro 
	:src:proto:tag.pro 
	:src:proto:term.pro 
	:src:proto:termlib.pro 
	:src:proto:ui.pro 
	:src:proto:undo.pro 
	:src:proto:version.pro 
	:src:proto:window.pro 
	:src:proto:if_python.pro 
	:src:proto:if_tcl.pro 
	:src:proto:if_ruby.pro 
	:src:proto:gui.pro 
	:src:proto:pty.pro 
	:src:proto:gui_gtk.pro 
	:src:proto:gui_gtk_x11.pro 
	:src:proto:gui_motif.pro 
	:src:proto:gui_athena.pro 
	:src:proto:gui_mac.pro 
	:src:proto:gui_x11.pro 
	:src:proto:workshop.pro 
	:src:proto:if_perl.pro 
	:src:proto:if_perlsfio.pro

:obj:memfile.c.x	  
	:src:memfile.c 
	:src:vim.h 
	:src:auto:config.h 
	:src:feature.h 
	:src:os_unix.h 
	:src:os_mac.h 
	:src:workshop.h 
	:src:ascii.h 
	:src:keymap.h 
	:src:term.h 
	:src:macros.h 
	:src:structs.h 
	:src:globals.h 
	:src:option.h 
	:src:ex_cmds.h 
	:src:proto.h 
	:src:integration.h 
	:src:wsdebug.h 
	:src:regexp.h 
	:src:gui.h 
	:src:farsi.h 
	:src:proto:os_unix.pro 
	:src:proto:os_mac.pro 
	:src:proto:buffer.pro 
	:src:proto:charset.pro 
	:src:proto:if_cscope.pro 
	:src:proto:diff.pro 
	:src:proto:digraph.pro 
	:src:proto:edit.pro 
	:src:proto:eval.pro 
	:src:proto:ex_cmds.pro 
	:src:proto:ex_cmds2.pro 
	:src:proto:ex_docmd.pro 
	:src:proto:ex_eval.pro 
	:src:proto:ex_getln.pro 
	:src:proto:fileio.pro 
	:src:proto:fold.pro 
	:src:proto:getchar.pro 
	:src:proto:hashtable.pro 
	:src:proto:hangulin.pro 
	:src:proto:main.pro 
	:src:proto:mark.pro 
	:src:proto:memfile.pro 
	:src:proto:memline.pro 
	:src:proto:menu.pro 
	:src:proto:message.pro 
	:src:proto:misc1.pro 
	:src:proto:misc2.pro 
	:src:proto:move.pro 
	:src:proto:multibyte.pro 
	:src:proto:normal.pro 
	:src:proto:ops.pro 
	:src:proto:option.pro 
	:src:proto:quickfix.pro 
	:src:proto:regexp.pro 
	:src:proto:screen.pro 
	:src:proto:search.pro 
	:src:proto:syntax.pro 
	:src:proto:tag.pro 
	:src:proto:term.pro 
	:src:proto:termlib.pro 
	:src:proto:ui.pro 
	:src:proto:undo.pro 
	:src:proto:version.pro 
	:src:proto:window.pro 
	:src:proto:if_python.pro 
	:src:proto:if_tcl.pro 
	:src:proto:if_ruby.pro 
	:src:proto:gui.pro 
	:src:proto:pty.pro 
	:src:proto:gui_gtk.pro 
	:src:proto:gui_gtk_x11.pro 
	:src:proto:gui_motif.pro 
	:src:proto:gui_athena.pro 
	:src:proto:gui_mac.pro 
	:src:proto:gui_x11.pro 
	:src:proto:workshop.pro 
	:src:proto:if_perl.pro 
	:src:proto:if_perlsfio.pro

:obj:memline.c.x	  
	:src:memline.c 
	:src:vim.h 
	:src:auto:config.h 
	:src:feature.h 
	:src:os_unix.h 
	:src:os_mac.h 
	:src:workshop.h 
	:src:ascii.h 
	:src:keymap.h 
	:src:term.h 
	:src:macros.h 
	:src:structs.h 
	:src:globals.h 
	:src:option.h 
	:src:ex_cmds.h 
	:src:proto.h 
	:src:integration.h 
	:src:wsdebug.h 
	:src:regexp.h 
	:src:gui.h 
	:src:farsi.h 
	:src:proto:os_unix.pro 
	:src:proto:os_mac.pro 
	:src:proto:buffer.pro 
	:src:proto:charset.pro 
	:src:proto:if_cscope.pro 
	:src:proto:diff.pro 
	:src:proto:digraph.pro 
	:src:proto:edit.pro 
	:src:proto:eval.pro 
	:src:proto:ex_cmds.pro 
	:src:proto:ex_cmds2.pro 
	:src:proto:ex_docmd.pro 
	:src:proto:ex_eval.pro 
	:src:proto:ex_getln.pro 
	:src:proto:fileio.pro 
	:src:proto:fold.pro 
	:src:proto:getchar.pro 
	:src:proto:hashtable.pro 
	:src:proto:hangulin.pro 
	:src:proto:main.pro 
	:src:proto:mark.pro 
	:src:proto:memfile.pro 
	:src:proto:memline.pro 
	:src:proto:menu.pro 
	:src:proto:message.pro 
	:src:proto:misc1.pro 
	:src:proto:misc2.pro 
	:src:proto:move.pro 
	:src:proto:multibyte.pro 
	:src:proto:normal.pro 
	:src:proto:ops.pro 
	:src:proto:option.pro 
	:src:proto:quickfix.pro 
	:src:proto:regexp.pro 
	:src:proto:screen.pro 
	:src:proto:search.pro 
	:src:proto:syntax.pro 
	:src:proto:tag.pro 
	:src:proto:term.pro 
	:src:proto:termlib.pro 
	:src:proto:ui.pro 
	:src:proto:undo.pro 
	:src:proto:version.pro 
	:src:proto:window.pro 
	:src:proto:if_python.pro 
	:src:proto:if_tcl.pro 
	:src:proto:if_ruby.pro 
	:src:proto:gui.pro 
	:src:proto:pty.pro 
	:src:proto:gui_gtk.pro 
	:src:proto:gui_gtk_x11.pro 
	:src:proto:gui_motif.pro 
	:src:proto:gui_athena.pro 
	:src:proto:gui_mac.pro 
	:src:proto:gui_x11.pro 
	:src:proto:workshop.pro 
	:src:proto:if_perl.pro 
	:src:proto:if_perlsfio.pro

:obj:menu.c.x	  
	:src:menu.c 
	:src:vim.h 
	:src:auto:config.h 
	:src:feature.h 
	:src:os_unix.h 
	:src:os_mac.h 
	:src:workshop.h 
	:src:ascii.h 
	:src:keymap.h 
	:src:term.h 
	:src:macros.h 
	:src:structs.h 
	:src:globals.h 
	:src:option.h 
	:src:ex_cmds.h 
	:src:proto.h 
	:src:integration.h 
	:src:wsdebug.h 
	:src:regexp.h 
	:src:gui.h 
	:src:farsi.h 
	:src:proto:os_unix.pro 
	:src:proto:os_mac.pro 
	:src:proto:buffer.pro 
	:src:proto:charset.pro 
	:src:proto:if_cscope.pro 
	:src:proto:diff.pro 
	:src:proto:digraph.pro 
	:src:proto:edit.pro 
	:src:proto:eval.pro 
	:src:proto:ex_cmds.pro 
	:src:proto:ex_cmds2.pro 
	:src:proto:ex_docmd.pro 
	:src:proto:ex_eval.pro 
	:src:proto:ex_getln.pro 
	:src:proto:fileio.pro 
	:src:proto:fold.pro 
	:src:proto:getchar.pro 
	:src:proto:hashtable.pro 
	:src:proto:hangulin.pro 
	:src:proto:main.pro 
	:src:proto:mark.pro 
	:src:proto:memfile.pro 
	:src:proto:memline.pro 
	:src:proto:menu.pro 
	:src:proto:message.pro 
	:src:proto:misc1.pro 
	:src:proto:misc2.pro 
	:src:proto:move.pro 
	:src:proto:multibyte.pro 
	:src:proto:normal.pro 
	:src:proto:ops.pro 
	:src:proto:option.pro 
	:src:proto:quickfix.pro 
	:src:proto:regexp.pro 
	:src:proto:screen.pro 
	:src:proto:search.pro 
	:src:proto:syntax.pro 
	:src:proto:tag.pro 
	:src:proto:term.pro 
	:src:proto:termlib.pro 
	:src:proto:ui.pro 
	:src:proto:undo.pro 
	:src:proto:version.pro 
	:src:proto:window.pro 
	:src:proto:if_python.pro 
	:src:proto:if_tcl.pro 
	:src:proto:if_ruby.pro 
	:src:proto:gui.pro 
	:src:proto:pty.pro 
	:src:proto:gui_gtk.pro 
	:src:proto:gui_gtk_x11.pro 
	:src:proto:gui_motif.pro 
	:src:proto:gui_athena.pro 
	:src:proto:gui_mac.pro 
	:src:proto:gui_x11.pro 
	:src:proto:workshop.pro 
	:src:proto:if_perl.pro 
	:src:proto:if_perlsfio.pro

:obj:message.c.x	  
	:src:message.c 
	:src:vim.h 
	:src:auto:config.h 
	:src:feature.h 
	:src:os_unix.h 
	:src:os_mac.h 
	:src:workshop.h 
	:src:ascii.h 
	:src:keymap.h 
	:src:term.h 
	:src:macros.h 
	:src:structs.h 
	:src:globals.h 
	:src:option.h 
	:src:ex_cmds.h 
	:src:proto.h 
	:src:integration.h 
	:src:wsdebug.h 
	:src:regexp.h 
	:src:gui.h 
	:src:farsi.h 
	:src:proto:os_unix.pro 
	:src:proto:os_mac.pro 
	:src:proto:buffer.pro 
	:src:proto:charset.pro 
	:src:proto:if_cscope.pro 
	:src:proto:diff.pro 
	:src:proto:digraph.pro 
	:src:proto:edit.pro 
	:src:proto:eval.pro 
	:src:proto:ex_cmds.pro 
	:src:proto:ex_cmds2.pro 
	:src:proto:ex_docmd.pro 
	:src:proto:ex_eval.pro 
	:src:proto:ex_getln.pro 
	:src:proto:fileio.pro 
	:src:proto:fold.pro 
	:src:proto:getchar.pro 
	:src:proto:hashtable.pro 
	:src:proto:hangulin.pro 
	:src:proto:main.pro 
	:src:proto:mark.pro 
	:src:proto:memfile.pro 
	:src:proto:memline.pro 
	:src:proto:menu.pro 
	:src:proto:message.pro 
	:src:proto:misc1.pro 
	:src:proto:misc2.pro 
	:src:proto:move.pro 
	:src:proto:multibyte.pro 
	:src:proto:normal.pro 
	:src:proto:ops.pro 
	:src:proto:option.pro 
	:src:proto:quickfix.pro 
	:src:proto:regexp.pro 
	:src:proto:screen.pro 
	:src:proto:search.pro 
	:src:proto:syntax.pro 
	:src:proto:tag.pro 
	:src:proto:term.pro 
	:src:proto:termlib.pro 
	:src:proto:ui.pro 
	:src:proto:undo.pro 
	:src:proto:version.pro 
	:src:proto:window.pro 
	:src:proto:if_python.pro 
	:src:proto:if_tcl.pro 
	:src:proto:if_ruby.pro 
	:src:proto:gui.pro 
	:src:proto:pty.pro 
	:src:proto:gui_gtk.pro 
	:src:proto:gui_gtk_x11.pro 
	:src:proto:gui_motif.pro 
	:src:proto:gui_athena.pro 
	:src:proto:gui_mac.pro 
	:src:proto:gui_x11.pro 
	:src:proto:workshop.pro 
	:src:proto:if_perl.pro 
	:src:proto:if_perlsfio.pro

:obj:misc1.c.x	  
	:src:misc1.c 
	:src:vim.h 
	:src:version.h 
	:src:auto:config.h 
	:src:feature.h 
	:src:os_unix.h 
	:src:os_mac.h 
	:src:workshop.h 
	:src:ascii.h 
	:src:keymap.h 
	:src:term.h 
	:src:macros.h 
	:src:structs.h 
	:src:globals.h 
	:src:option.h 
	:src:ex_cmds.h 
	:src:proto.h 
	:src:integration.h 
	:src:wsdebug.h 
	:src:regexp.h 
	:src:gui.h 
	:src:farsi.h 
	:src:proto:os_unix.pro 
	:src:proto:os_mac.pro 
	:src:proto:buffer.pro 
	:src:proto:charset.pro 
	:src:proto:if_cscope.pro 
	:src:proto:diff.pro 
	:src:proto:digraph.pro 
	:src:proto:edit.pro 
	:src:proto:eval.pro 
	:src:proto:ex_cmds.pro 
	:src:proto:ex_cmds2.pro 
	:src:proto:ex_docmd.pro 
	:src:proto:ex_eval.pro 
	:src:proto:ex_getln.pro 
	:src:proto:fileio.pro 
	:src:proto:fold.pro 
	:src:proto:getchar.pro 
	:src:proto:hashtable.pro 
	:src:proto:hangulin.pro 
	:src:proto:main.pro 
	:src:proto:mark.pro 
	:src:proto:memfile.pro 
	:src:proto:memline.pro 
	:src:proto:menu.pro 
	:src:proto:message.pro 
	:src:proto:misc1.pro 
	:src:proto:misc2.pro 
	:src:proto:move.pro 
	:src:proto:multibyte.pro 
	:src:proto:normal.pro 
	:src:proto:ops.pro 
	:src:proto:option.pro 
	:src:proto:quickfix.pro 
	:src:proto:regexp.pro 
	:src:proto:screen.pro 
	:src:proto:search.pro 
	:src:proto:syntax.pro 
	:src:proto:tag.pro 
	:src:proto:term.pro 
	:src:proto:termlib.pro 
	:src:proto:ui.pro 
	:src:proto:undo.pro 
	:src:proto:version.pro 
	:src:proto:window.pro 
	:src:proto:if_python.pro 
	:src:proto:if_tcl.pro 
	:src:proto:if_ruby.pro 
	:src:proto:gui.pro 
	:src:proto:pty.pro 
	:src:proto:gui_gtk.pro 
	:src:proto:gui_gtk_x11.pro 
	:src:proto:gui_motif.pro 
	:src:proto:gui_athena.pro 
	:src:proto:gui_mac.pro 
	:src:proto:gui_x11.pro 
	:src:proto:workshop.pro 
	:src:proto:if_perl.pro 
	:src:proto:if_perlsfio.pro

:obj:misc2.c.x	  
	:src:misc2.c 
	:src:vim.h 
	:src:auto:config.h 
	:src:feature.h 
	:src:os_unix.h 
	:src:os_mac.h 
	:src:workshop.h 
	:src:ascii.h 
	:src:keymap.h 
	:src:term.h 
	:src:macros.h 
	:src:structs.h 
	:src:globals.h 
	:src:option.h 
	:src:ex_cmds.h 
	:src:proto.h 
	:src:integration.h 
	:src:wsdebug.h 
	:src:regexp.h 
	:src:gui.h 
	:src:farsi.h 
	:src:proto:os_unix.pro 
	:src:proto:os_mac.pro 
	:src:proto:buffer.pro 
	:src:proto:charset.pro 
	:src:proto:if_cscope.pro 
	:src:proto:diff.pro 
	:src:proto:digraph.pro 
	:src:proto:edit.pro 
	:src:proto:eval.pro 
	:src:proto:ex_cmds.pro 
	:src:proto:ex_cmds2.pro 
	:src:proto:ex_docmd.pro 
	:src:proto:ex_eval.pro 
	:src:proto:ex_getln.pro 
	:src:proto:fileio.pro 
	:src:proto:fold.pro 
	:src:proto:getchar.pro 
	:src:proto:hashtable.pro 
	:src:proto:hangulin.pro 
	:src:proto:main.pro 
	:src:proto:mark.pro 
	:src:proto:memfile.pro 
	:src:proto:memline.pro 
	:src:proto:menu.pro 
	:src:proto:message.pro 
	:src:proto:misc1.pro 
	:src:proto:misc2.pro 
	:src:proto:move.pro 
	:src:proto:multibyte.pro 
	:src:proto:normal.pro 
	:src:proto:ops.pro 
	:src:proto:option.pro 
	:src:proto:quickfix.pro 
	:src:proto:regexp.pro 
	:src:proto:screen.pro 
	:src:proto:search.pro 
	:src:proto:syntax.pro 
	:src:proto:tag.pro 
	:src:proto:term.pro 
	:src:proto:termlib.pro 
	:src:proto:ui.pro 
	:src:proto:undo.pro 
	:src:proto:version.pro 
	:src:proto:window.pro 
	:src:proto:if_python.pro 
	:src:proto:if_tcl.pro 
	:src:proto:if_ruby.pro 
	:src:proto:gui.pro 
	:src:proto:pty.pro 
	:src:proto:gui_gtk.pro 
	:src:proto:gui_gtk_x11.pro 
	:src:proto:gui_motif.pro 
	:src:proto:gui_athena.pro 
	:src:proto:gui_mac.pro 
	:src:proto:gui_x11.pro 
	:src:proto:workshop.pro 
	:src:proto:if_perl.pro 
	:src:proto:if_perlsfio.pro

:obj:move.c.x	  
	:src:move.c 
	:src:vim.h 
	:src:auto:config.h 
	:src:feature.h 
	:src:os_unix.h 
	:src:os_mac.h 
	:src:workshop.h 
	:src:ascii.h 
	:src:keymap.h 
	:src:term.h 
	:src:macros.h 
	:src:structs.h 
	:src:globals.h 
	:src:option.h 
	:src:ex_cmds.h 
	:src:proto.h 
	:src:integration.h 
	:src:wsdebug.h 
	:src:regexp.h 
	:src:gui.h 
	:src:farsi.h 
	:src:proto:os_unix.pro 
	:src:proto:os_mac.pro 
	:src:proto:buffer.pro 
	:src:proto:charset.pro 
	:src:proto:if_cscope.pro 
	:src:proto:diff.pro 
	:src:proto:digraph.pro 
	:src:proto:edit.pro 
	:src:proto:eval.pro 
	:src:proto:ex_cmds.pro 
	:src:proto:ex_cmds2.pro 
	:src:proto:ex_docmd.pro 
	:src:proto:ex_eval.pro 
	:src:proto:ex_getln.pro 
	:src:proto:fileio.pro 
	:src:proto:fold.pro 
	:src:proto:getchar.pro 
	:src:proto:hashtable.pro 
	:src:proto:hangulin.pro 
	:src:proto:main.pro 
	:src:proto:mark.pro 
	:src:proto:memfile.pro 
	:src:proto:memline.pro 
	:src:proto:menu.pro 
	:src:proto:message.pro 
	:src:proto:misc1.pro 
	:src:proto:misc2.pro 
	:src:proto:move.pro 
	:src:proto:multibyte.pro 
	:src:proto:normal.pro 
	:src:proto:ops.pro 
	:src:proto:option.pro 
	:src:proto:quickfix.pro 
	:src:proto:regexp.pro 
	:src:proto:screen.pro 
	:src:proto:search.pro 
	:src:proto:syntax.pro 
	:src:proto:tag.pro 
	:src:proto:term.pro 
	:src:proto:termlib.pro 
	:src:proto:ui.pro 
	:src:proto:undo.pro 
	:src:proto:version.pro 
	:src:proto:window.pro 
	:src:proto:if_python.pro 
	:src:proto:if_tcl.pro 
	:src:proto:if_ruby.pro 
	:src:proto:gui.pro 
	:src:proto:pty.pro 
	:src:proto:gui_gtk.pro 
	:src:proto:gui_gtk_x11.pro 
	:src:proto:gui_motif.pro 
	:src:proto:gui_athena.pro 
	:src:proto:gui_mac.pro 
	:src:proto:gui_x11.pro 
	:src:proto:workshop.pro 
	:src:proto:if_perl.pro 
	:src:proto:if_perlsfio.pro

:obj:multibyte.c.x	  
	:src:multibyte.c 
	:src:vim.h 
	:src:globals.h 
	:src:option.h 
	:src:auto:config.h 
	:src:feature.h 
	:src:os_unix.h 
	:src:os_mac.h 
	:src:workshop.h 
	:src:ascii.h 
	:src:keymap.h 
	:src:term.h 
	:src:macros.h 
	:src:structs.h 
	:src:ex_cmds.h 
	:src:proto.h 
	:src:farsi.h 
	:src:integration.h 
	:src:wsdebug.h 
	:src:regexp.h 
	:src:gui.h 
	:src:proto:os_unix.pro 
	:src:proto:os_mac.pro 
	:src:proto:buffer.pro 
	:src:proto:charset.pro 
	:src:proto:if_cscope.pro 
	:src:proto:diff.pro 
	:src:proto:digraph.pro 
	:src:proto:edit.pro 
	:src:proto:eval.pro 
	:src:proto:ex_cmds.pro 
	:src:proto:ex_cmds2.pro 
	:src:proto:ex_docmd.pro 
	:src:proto:ex_eval.pro 
	:src:proto:ex_getln.pro 
	:src:proto:fileio.pro 
	:src:proto:fold.pro 
	:src:proto:getchar.pro 
	:src:proto:hashtable.pro 
	:src:proto:hangulin.pro 
	:src:proto:main.pro 
	:src:proto:mark.pro 
	:src:proto:memfile.pro 
	:src:proto:memline.pro 
	:src:proto:menu.pro 
	:src:proto:message.pro 
	:src:proto:misc1.pro 
	:src:proto:misc2.pro 
	:src:proto:move.pro 
	:src:proto:multibyte.pro 
	:src:proto:normal.pro 
	:src:proto:ops.pro 
	:src:proto:option.pro 
	:src:proto:quickfix.pro 
	:src:proto:regexp.pro 
	:src:proto:screen.pro 
	:src:proto:search.pro 
	:src:proto:syntax.pro 
	:src:proto:tag.pro 
	:src:proto:term.pro 
	:src:proto:termlib.pro 
	:src:proto:ui.pro 
	:src:proto:undo.pro 
	:src:proto:version.pro 
	:src:proto:window.pro 
	:src:proto:if_python.pro 
	:src:proto:if_tcl.pro 
	:src:proto:if_ruby.pro 
	:src:proto:gui.pro 
	:src:proto:pty.pro 
	:src:proto:gui_gtk.pro 
	:src:proto:gui_gtk_x11.pro 
	:src:proto:gui_motif.pro 
	:src:proto:gui_athena.pro 
	:src:proto:gui_mac.pro 
	:src:proto:gui_x11.pro 
	:src:proto:workshop.pro 
	:src:proto:if_perl.pro 
	:src:proto:if_perlsfio.pro

:obj:normal.c.x	  
	:src:normal.c 
	:src:vim.h 
	:src:auto:config.h 
	:src:feature.h 
	:src:os_unix.h 
	:src:os_mac.h 
	:src:workshop.h 
	:src:ascii.h 
	:src:keymap.h 
	:src:term.h 
	:src:macros.h 
	:src:structs.h 
	:src:globals.h 
	:src:option.h 
	:src:ex_cmds.h 
	:src:proto.h 
	:src:integration.h 
	:src:wsdebug.h 
	:src:regexp.h 
	:src:gui.h 
	:src:farsi.h 
	:src:proto:os_unix.pro 
	:src:proto:os_mac.pro 
	:src:proto:buffer.pro 
	:src:proto:charset.pro 
	:src:proto:if_cscope.pro 
	:src:proto:diff.pro 
	:src:proto:digraph.pro 
	:src:proto:edit.pro 
	:src:proto:eval.pro 
	:src:proto:ex_cmds.pro 
	:src:proto:ex_cmds2.pro 
	:src:proto:ex_docmd.pro 
	:src:proto:ex_eval.pro 
	:src:proto:ex_getln.pro 
	:src:proto:fileio.pro 
	:src:proto:fold.pro 
	:src:proto:getchar.pro 
	:src:proto:hashtable.pro 
	:src:proto:hangulin.pro 
	:src:proto:main.pro 
	:src:proto:mark.pro 
	:src:proto:memfile.pro 
	:src:proto:memline.pro 
	:src:proto:menu.pro 
	:src:proto:message.pro 
	:src:proto:misc1.pro 
	:src:proto:misc2.pro 
	:src:proto:move.pro 
	:src:proto:multibyte.pro 
	:src:proto:normal.pro 
	:src:proto:ops.pro 
	:src:proto:option.pro 
	:src:proto:quickfix.pro 
	:src:proto:regexp.pro 
	:src:proto:screen.pro 
	:src:proto:search.pro 
	:src:proto:syntax.pro 
	:src:proto:tag.pro 
	:src:proto:term.pro 
	:src:proto:termlib.pro 
	:src:proto:ui.pro 
	:src:proto:undo.pro 
	:src:proto:version.pro 
	:src:proto:window.pro 
	:src:proto:if_python.pro 
	:src:proto:if_tcl.pro 
	:src:proto:if_ruby.pro 
	:src:proto:gui.pro 
	:src:proto:pty.pro 
	:src:proto:gui_gtk.pro 
	:src:proto:gui_gtk_x11.pro 
	:src:proto:gui_motif.pro 
	:src:proto:gui_athena.pro 
	:src:proto:gui_mac.pro 
	:src:proto:gui_x11.pro 
	:src:proto:workshop.pro 
	:src:proto:if_perl.pro 
	:src:proto:if_perlsfio.pro

:obj:ops.c.x	  
	:src:ops.c 
	:src:vim.h 
	:src:auto:config.h 
	:src:feature.h 
	:src:os_unix.h 
	:src:os_mac.h 
	:src:workshop.h 
	:src:ascii.h 
	:src:keymap.h 
	:src:term.h 
	:src:macros.h 
	:src:structs.h 
	:src:globals.h 
	:src:option.h 
	:src:ex_cmds.h 
	:src:proto.h 
	:src:integration.h 
	:src:wsdebug.h 
	:src:regexp.h 
	:src:gui.h 
	:src:farsi.h 
	:src:proto:os_unix.pro 
	:src:proto:os_mac.pro 
	:src:proto:buffer.pro 
	:src:proto:charset.pro 
	:src:proto:if_cscope.pro 
	:src:proto:diff.pro 
	:src:proto:digraph.pro 
	:src:proto:edit.pro 
	:src:proto:eval.pro 
	:src:proto:ex_cmds.pro 
	:src:proto:ex_cmds2.pro 
	:src:proto:ex_docmd.pro 
	:src:proto:ex_eval.pro 
	:src:proto:ex_getln.pro 
	:src:proto:fileio.pro 
	:src:proto:fold.pro 
	:src:proto:getchar.pro 
	:src:proto:hashtable.pro 
	:src:proto:hangulin.pro 
	:src:proto:main.pro 
	:src:proto:mark.pro 
	:src:proto:memfile.pro 
	:src:proto:memline.pro 
	:src:proto:menu.pro 
	:src:proto:message.pro 
	:src:proto:misc1.pro 
	:src:proto:misc2.pro 
	:src:proto:move.pro 
	:src:proto:multibyte.pro 
	:src:proto:normal.pro 
	:src:proto:ops.pro 
	:src:proto:option.pro 
	:src:proto:quickfix.pro 
	:src:proto:regexp.pro 
	:src:proto:screen.pro 
	:src:proto:search.pro 
	:src:proto:syntax.pro 
	:src:proto:tag.pro 
	:src:proto:term.pro 
	:src:proto:termlib.pro 
	:src:proto:ui.pro 
	:src:proto:undo.pro 
	:src:proto:version.pro 
	:src:proto:window.pro 
	:src:proto:if_python.pro 
	:src:proto:if_tcl.pro 
	:src:proto:if_ruby.pro 
	:src:proto:gui.pro 
	:src:proto:pty.pro 
	:src:proto:gui_gtk.pro 
	:src:proto:gui_gtk_x11.pro 
	:src:proto:gui_motif.pro 
	:src:proto:gui_athena.pro 
	:src:proto:gui_mac.pro 
	:src:proto:gui_x11.pro 
	:src:proto:workshop.pro 
	:src:proto:if_perl.pro 
	:src:proto:if_perlsfio.pro

:obj:option.c.x	  
	:src:option.c 
	:src:vim.h 
	:src:auto:config.h 
	:src:feature.h 
	:src:os_unix.h 
	:src:os_mac.h 
	:src:workshop.h 
	:src:ascii.h 
	:src:keymap.h 
	:src:term.h 
	:src:macros.h 
	:src:structs.h 
	:src:globals.h 
	:src:option.h 
	:src:ex_cmds.h 
	:src:proto.h 
	:src:integration.h 
	:src:wsdebug.h 
	:src:regexp.h 
	:src:gui.h 
	:src:farsi.h 
	:src:proto:os_unix.pro 
	:src:proto:os_mac.pro 
	:src:proto:buffer.pro 
	:src:proto:charset.pro 
	:src:proto:if_cscope.pro 
	:src:proto:diff.pro 
	:src:proto:digraph.pro 
	:src:proto:edit.pro 
	:src:proto:eval.pro 
	:src:proto:ex_cmds.pro 
	:src:proto:ex_cmds2.pro 
	:src:proto:ex_docmd.pro 
	:src:proto:ex_eval.pro 
	:src:proto:ex_getln.pro 
	:src:proto:fileio.pro 
	:src:proto:fold.pro 
	:src:proto:getchar.pro 
	:src:proto:hashtable.pro 
	:src:proto:hangulin.pro 
	:src:proto:main.pro 
	:src:proto:mark.pro 
	:src:proto:memfile.pro 
	:src:proto:memline.pro 
	:src:proto:menu.pro 
	:src:proto:message.pro 
	:src:proto:misc1.pro 
	:src:proto:misc2.pro 
	:src:proto:move.pro 
	:src:proto:multibyte.pro 
	:src:proto:normal.pro 
	:src:proto:ops.pro 
	:src:proto:option.pro 
	:src:proto:quickfix.pro 
	:src:proto:regexp.pro 
	:src:proto:screen.pro 
	:src:proto:search.pro 
	:src:proto:syntax.pro 
	:src:proto:tag.pro 
	:src:proto:term.pro 
	:src:proto:termlib.pro 
	:src:proto:ui.pro 
	:src:proto:undo.pro 
	:src:proto:version.pro 
	:src:proto:window.pro 
	:src:proto:if_python.pro 
	:src:proto:if_tcl.pro 
	:src:proto:if_ruby.pro 
	:src:proto:gui.pro 
	:src:proto:pty.pro 
	:src:proto:gui_gtk.pro 
	:src:proto:gui_gtk_x11.pro 
	:src:proto:gui_motif.pro 
	:src:proto:gui_athena.pro 
	:src:proto:gui_mac.pro 
	:src:proto:gui_x11.pro 
	:src:proto:workshop.pro 
	:src:proto:if_perl.pro 
	:src:proto:if_perlsfio.pro

:obj:os_mac.c.x	  
	:src:os_mac.c 
	:src:vim.h 
	:src:globals.h 
	:src:option.h 
	:src:auto:config.h 
	:src:feature.h 
	:src:os_unix.h 
	:src:os_mac.h 
	:src:workshop.h 
	:src:ascii.h 
	:src:keymap.h 
	:src:term.h 
	:src:macros.h 
	:src:structs.h 
	:src:ex_cmds.h 
	:src:proto.h 
	:src:farsi.h 
	:src:integration.h 
	:src:wsdebug.h 
	:src:regexp.h 
	:src:gui.h 
	:src:proto:os_unix.pro 
	:src:proto:os_mac.pro 
	:src:proto:buffer.pro 
	:src:proto:charset.pro 
	:src:proto:if_cscope.pro 
	:src:proto:diff.pro 
	:src:proto:digraph.pro 
	:src:proto:edit.pro 
	:src:proto:eval.pro 
	:src:proto:ex_cmds.pro 
	:src:proto:ex_cmds2.pro 
	:src:proto:ex_docmd.pro 
	:src:proto:ex_eval.pro 
	:src:proto:ex_getln.pro 
	:src:proto:fileio.pro 
	:src:proto:fold.pro 
	:src:proto:getchar.pro 
	:src:proto:hashtable.pro 
	:src:proto:hangulin.pro 
	:src:proto:main.pro 
	:src:proto:mark.pro 
	:src:proto:memfile.pro 
	:src:proto:memline.pro 
	:src:proto:menu.pro 
	:src:proto:message.pro 
	:src:proto:misc1.pro 
	:src:proto:misc2.pro 
	:src:proto:move.pro 
	:src:proto:multibyte.pro 
	:src:proto:normal.pro 
	:src:proto:ops.pro 
	:src:proto:option.pro 
	:src:proto:quickfix.pro 
	:src:proto:regexp.pro 
	:src:proto:screen.pro 
	:src:proto:search.pro 
	:src:proto:syntax.pro 
	:src:proto:tag.pro 
	:src:proto:term.pro 
	:src:proto:termlib.pro 
	:src:proto:ui.pro 
	:src:proto:undo.pro 
	:src:proto:version.pro 
	:src:proto:window.pro 
	:src:proto:if_python.pro 
	:src:proto:if_tcl.pro 
	:src:proto:if_ruby.pro 
	:src:proto:gui.pro 
	:src:proto:pty.pro 
	:src:proto:gui_gtk.pro 
	:src:proto:gui_gtk_x11.pro 
	:src:proto:gui_motif.pro 
	:src:proto:gui_athena.pro 
	:src:proto:gui_mac.pro 
	:src:proto:gui_x11.pro 
	:src:proto:workshop.pro 
	:src:proto:if_perl.pro 
	:src:proto:if_perlsfio.pro

:obj:pty.c.x	  
	:src:pty.c 
	:src:vim.h 
	:src:auto:config.h 
	:src:feature.h 
	:src:os_unix.h 
	:src:os_mac.h 
	:src:workshop.h 
	:src:ascii.h 
	:src:keymap.h 
	:src:term.h 
	:src:macros.h 
	:src:structs.h 
	:src:globals.h 
	:src:option.h 
	:src:ex_cmds.h 
	:src:proto.h 
	:src:integration.h 
	:src:wsdebug.h 
	:src:regexp.h 
	:src:gui.h 
	:src:farsi.h 
	:src:proto:os_unix.pro 
	:src:proto:os_mac.pro 
	:src:proto:buffer.pro 
	:src:proto:charset.pro 
	:src:proto:if_cscope.pro 
	:src:proto:diff.pro 
	:src:proto:digraph.pro 
	:src:proto:edit.pro 
	:src:proto:eval.pro 
	:src:proto:ex_cmds.pro 
	:src:proto:ex_cmds2.pro 
	:src:proto:ex_docmd.pro 
	:src:proto:ex_eval.pro 
	:src:proto:ex_getln.pro 
	:src:proto:fileio.pro 
	:src:proto:fold.pro 
	:src:proto:getchar.pro 
	:src:proto:hashtable.pro 
	:src:proto:hangulin.pro 
	:src:proto:main.pro 
	:src:proto:mark.pro 
	:src:proto:memfile.pro 
	:src:proto:memline.pro 
	:src:proto:menu.pro 
	:src:proto:message.pro 
	:src:proto:misc1.pro 
	:src:proto:misc2.pro 
	:src:proto:move.pro 
	:src:proto:multibyte.pro 
	:src:proto:normal.pro 
	:src:proto:ops.pro 
	:src:proto:option.pro 
	:src:proto:quickfix.pro 
	:src:proto:regexp.pro 
	:src:proto:screen.pro 
	:src:proto:search.pro 
	:src:proto:syntax.pro 
	:src:proto:tag.pro 
	:src:proto:term.pro 
	:src:proto:termlib.pro 
	:src:proto:ui.pro 
	:src:proto:undo.pro 
	:src:proto:version.pro 
	:src:proto:window.pro 
	:src:proto:if_python.pro 
	:src:proto:if_tcl.pro 
	:src:proto:if_ruby.pro 
	:src:proto:gui.pro 
	:src:proto:pty.pro 
	:src:proto:gui_gtk.pro 
	:src:proto:gui_gtk_x11.pro 
	:src:proto:gui_motif.pro 
	:src:proto:gui_athena.pro 
	:src:proto:gui_mac.pro 
	:src:proto:gui_x11.pro 
	:src:proto:workshop.pro 
	:src:proto:if_perl.pro 
	:src:proto:if_perlsfio.pro

:obj:quickfix.c.x	  
	:src:quickfix.c 
	:src:vim.h 
	:src:auto:config.h 
	:src:feature.h 
	:src:os_unix.h 
	:src:os_mac.h 
	:src:workshop.h 
	:src:ascii.h 
	:src:keymap.h 
	:src:term.h 
	:src:macros.h 
	:src:structs.h 
	:src:globals.h 
	:src:option.h 
	:src:ex_cmds.h 
	:src:proto.h 
	:src:integration.h 
	:src:wsdebug.h 
	:src:regexp.h 
	:src:gui.h 
	:src:farsi.h 
	:src:proto:os_unix.pro 
	:src:proto:os_mac.pro 
	:src:proto:buffer.pro 
	:src:proto:charset.pro 
	:src:proto:if_cscope.pro 
	:src:proto:diff.pro 
	:src:proto:digraph.pro 
	:src:proto:edit.pro 
	:src:proto:eval.pro 
	:src:proto:ex_cmds.pro 
	:src:proto:ex_cmds2.pro 
	:src:proto:ex_docmd.pro 
	:src:proto:ex_eval.pro 
	:src:proto:ex_getln.pro 
	:src:proto:fileio.pro 
	:src:proto:fold.pro 
	:src:proto:getchar.pro 
	:src:proto:hashtable.pro 
	:src:proto:hangulin.pro 
	:src:proto:main.pro 
	:src:proto:mark.pro 
	:src:proto:memfile.pro 
	:src:proto:memline.pro 
	:src:proto:menu.pro 
	:src:proto:message.pro 
	:src:proto:misc1.pro 
	:src:proto:misc2.pro 
	:src:proto:move.pro 
	:src:proto:multibyte.pro 
	:src:proto:normal.pro 
	:src:proto:ops.pro 
	:src:proto:option.pro 
	:src:proto:quickfix.pro 
	:src:proto:regexp.pro 
	:src:proto:screen.pro 
	:src:proto:search.pro 
	:src:proto:syntax.pro 
	:src:proto:tag.pro 
	:src:proto:term.pro 
	:src:proto:termlib.pro 
	:src:proto:ui.pro 
	:src:proto:undo.pro 
	:src:proto:version.pro 
	:src:proto:window.pro 
	:src:proto:if_python.pro 
	:src:proto:if_tcl.pro 
	:src:proto:if_ruby.pro 
	:src:proto:gui.pro 
	:src:proto:pty.pro 
	:src:proto:gui_gtk.pro 
	:src:proto:gui_gtk_x11.pro 
	:src:proto:gui_motif.pro 
	:src:proto:gui_athena.pro 
	:src:proto:gui_mac.pro 
	:src:proto:gui_x11.pro 
	:src:proto:workshop.pro 
	:src:proto:if_perl.pro 
	:src:proto:if_perlsfio.pro

:obj:regexp.c.x	  
	:src:regexp.c 
	:src:vim.h 
	:src:option.h 
	:src:auto:config.h 
	:src:feature.h 
	:src:os_unix.h 
	:src:os_mac.h 
	:src:workshop.h 
	:src:ascii.h 
	:src:keymap.h 
	:src:term.h 
	:src:macros.h 
	:src:structs.h 
	:src:globals.h 
	:src:ex_cmds.h 
	:src:proto.h 
	:src:integration.h 
	:src:wsdebug.h 
	:src:regexp.h 
	:src:gui.h 
	:src:farsi.h 
	:src:proto:os_unix.pro 
	:src:proto:os_mac.pro 
	:src:proto:buffer.pro 
	:src:proto:charset.pro 
	:src:proto:if_cscope.pro 
	:src:proto:diff.pro 
	:src:proto:digraph.pro 
	:src:proto:edit.pro 
	:src:proto:eval.pro 
	:src:proto:ex_cmds.pro 
	:src:proto:ex_cmds2.pro 
	:src:proto:ex_docmd.pro 
	:src:proto:ex_eval.pro 
	:src:proto:ex_getln.pro 
	:src:proto:fileio.pro 
	:src:proto:fold.pro 
	:src:proto:getchar.pro 
	:src:proto:hashtable.pro 
	:src:proto:hangulin.pro 
	:src:proto:main.pro 
	:src:proto:mark.pro 
	:src:proto:memfile.pro 
	:src:proto:memline.pro 
	:src:proto:menu.pro 
	:src:proto:message.pro 
	:src:proto:misc1.pro 
	:src:proto:misc2.pro 
	:src:proto:move.pro 
	:src:proto:multibyte.pro 
	:src:proto:normal.pro 
	:src:proto:ops.pro 
	:src:proto:option.pro 
	:src:proto:quickfix.pro 
	:src:proto:regexp.pro 
	:src:proto:screen.pro 
	:src:proto:search.pro 
	:src:proto:syntax.pro 
	:src:proto:tag.pro 
	:src:proto:term.pro 
	:src:proto:termlib.pro 
	:src:proto:ui.pro 
	:src:proto:undo.pro 
	:src:proto:version.pro 
	:src:proto:window.pro 
	:src:proto:if_python.pro 
	:src:proto:if_tcl.pro 
	:src:proto:if_ruby.pro 
	:src:proto:gui.pro 
	:src:proto:pty.pro 
	:src:proto:gui_gtk.pro 
	:src:proto:gui_gtk_x11.pro 
	:src:proto:gui_motif.pro 
	:src:proto:gui_athena.pro 
	:src:proto:gui_mac.pro 
	:src:proto:gui_x11.pro 
	:src:proto:workshop.pro 
	:src:proto:if_perl.pro 
	:src:proto:if_perlsfio.pro

:obj:screen.c.x	  
	:src:screen.c 
	:src:vim.h 
	:src:auto:config.h 
	:src:feature.h 
	:src:os_unix.h 
	:src:os_mac.h 
	:src:workshop.h 
	:src:ascii.h 
	:src:keymap.h 
	:src:term.h 
	:src:macros.h 
	:src:structs.h 
	:src:globals.h 
	:src:option.h 
	:src:ex_cmds.h 
	:src:proto.h 
	:src:integration.h 
	:src:wsdebug.h 
	:src:regexp.h 
	:src:gui.h 
	:src:farsi.h 
	:src:proto:os_unix.pro 
	:src:proto:os_mac.pro 
	:src:proto:buffer.pro 
	:src:proto:charset.pro 
	:src:proto:if_cscope.pro 
	:src:proto:diff.pro 
	:src:proto:digraph.pro 
	:src:proto:edit.pro 
	:src:proto:eval.pro 
	:src:proto:ex_cmds.pro 
	:src:proto:ex_cmds2.pro 
	:src:proto:ex_docmd.pro 
	:src:proto:ex_eval.pro 
	:src:proto:ex_getln.pro 
	:src:proto:fileio.pro 
	:src:proto:fold.pro 
	:src:proto:getchar.pro 
	:src:proto:hashtable.pro 
	:src:proto:hangulin.pro 
	:src:proto:main.pro 
	:src:proto:mark.pro 
	:src:proto:memfile.pro 
	:src:proto:memline.pro 
	:src:proto:menu.pro 
	:src:proto:message.pro 
	:src:proto:misc1.pro 
	:src:proto:misc2.pro 
	:src:proto:move.pro 
	:src:proto:multibyte.pro 
	:src:proto:normal.pro 
	:src:proto:ops.pro 
	:src:proto:option.pro 
	:src:proto:quickfix.pro 
	:src:proto:regexp.pro 
	:src:proto:screen.pro 
	:src:proto:search.pro 
	:src:proto:syntax.pro 
	:src:proto:tag.pro 
	:src:proto:term.pro 
	:src:proto:termlib.pro 
	:src:proto:ui.pro 
	:src:proto:undo.pro 
	:src:proto:version.pro 
	:src:proto:window.pro 
	:src:proto:if_python.pro 
	:src:proto:if_tcl.pro 
	:src:proto:if_ruby.pro 
	:src:proto:gui.pro 
	:src:proto:pty.pro 
	:src:proto:gui_gtk.pro 
	:src:proto:gui_gtk_x11.pro 
	:src:proto:gui_motif.pro 
	:src:proto:gui_athena.pro 
	:src:proto:gui_mac.pro 
	:src:proto:gui_x11.pro 
	:src:proto:workshop.pro 
	:src:proto:if_perl.pro 
	:src:proto:if_perlsfio.pro

:obj:search.c.x	  
	:src:search.c 
	:src:vim.h 
	:src:auto:config.h 
	:src:feature.h 
	:src:os_unix.h 
	:src:os_mac.h 
	:src:workshop.h 
	:src:ascii.h 
	:src:keymap.h 
	:src:term.h 
	:src:macros.h 
	:src:structs.h 
	:src:globals.h 
	:src:option.h 
	:src:ex_cmds.h 
	:src:proto.h 
	:src:integration.h 
	:src:wsdebug.h 
	:src:regexp.h 
	:src:gui.h 
	:src:farsi.h 
	:src:proto:os_unix.pro 
	:src:proto:os_mac.pro 
	:src:proto:buffer.pro 
	:src:proto:charset.pro 
	:src:proto:if_cscope.pro 
	:src:proto:diff.pro 
	:src:proto:digraph.pro 
	:src:proto:edit.pro 
	:src:proto:eval.pro 
	:src:proto:ex_cmds.pro 
	:src:proto:ex_cmds2.pro 
	:src:proto:ex_docmd.pro 
	:src:proto:ex_eval.pro 
	:src:proto:ex_getln.pro 
	:src:proto:fileio.pro 
	:src:proto:fold.pro 
	:src:proto:getchar.pro 
	:src:proto:hashtable.pro 
	:src:proto:hangulin.pro 
	:src:proto:main.pro 
	:src:proto:mark.pro 
	:src:proto:memfile.pro 
	:src:proto:memline.pro 
	:src:proto:menu.pro 
	:src:proto:message.pro 
	:src:proto:misc1.pro 
	:src:proto:misc2.pro 
	:src:proto:move.pro 
	:src:proto:multibyte.pro 
	:src:proto:normal.pro 
	:src:proto:ops.pro 
	:src:proto:option.pro 
	:src:proto:quickfix.pro 
	:src:proto:regexp.pro 
	:src:proto:screen.pro 
	:src:proto:search.pro 
	:src:proto:syntax.pro 
	:src:proto:tag.pro 
	:src:proto:term.pro 
	:src:proto:termlib.pro 
	:src:proto:ui.pro 
	:src:proto:undo.pro 
	:src:proto:version.pro 
	:src:proto:window.pro 
	:src:proto:if_python.pro 
	:src:proto:if_tcl.pro 
	:src:proto:if_ruby.pro 
	:src:proto:gui.pro 
	:src:proto:pty.pro 
	:src:proto:gui_gtk.pro 
	:src:proto:gui_gtk_x11.pro 
	:src:proto:gui_motif.pro 
	:src:proto:gui_athena.pro 
	:src:proto:gui_mac.pro 
	:src:proto:gui_x11.pro 
	:src:proto:workshop.pro 
	:src:proto:if_perl.pro 
	:src:proto:if_perlsfio.pro

:obj:syntax.c.x	  
	:src:syntax.c 
	:src:vim.h 
	:src:auto:config.h 
	:src:feature.h 
	:src:os_unix.h 
	:src:os_mac.h 
	:src:workshop.h 
	:src:ascii.h 
	:src:keymap.h 
	:src:term.h 
	:src:macros.h 
	:src:structs.h 
	:src:globals.h 
	:src:option.h 
	:src:ex_cmds.h 
	:src:proto.h 
	:src:integration.h 
	:src:wsdebug.h 
	:src:regexp.h 
	:src:gui.h 
	:src:farsi.h 
	:src:proto:os_unix.pro 
	:src:proto:os_mac.pro 
	:src:proto:buffer.pro 
	:src:proto:charset.pro 
	:src:proto:if_cscope.pro 
	:src:proto:diff.pro 
	:src:proto:digraph.pro 
	:src:proto:edit.pro 
	:src:proto:eval.pro 
	:src:proto:ex_cmds.pro 
	:src:proto:ex_cmds2.pro 
	:src:proto:ex_docmd.pro 
	:src:proto:ex_eval.pro 
	:src:proto:ex_getln.pro 
	:src:proto:fileio.pro 
	:src:proto:fold.pro 
	:src:proto:getchar.pro 
	:src:proto:hashtable.pro 
	:src:proto:hangulin.pro 
	:src:proto:main.pro 
	:src:proto:mark.pro 
	:src:proto:memfile.pro 
	:src:proto:memline.pro 
	:src:proto:menu.pro 
	:src:proto:message.pro 
	:src:proto:misc1.pro 
	:src:proto:misc2.pro 
	:src:proto:move.pro 
	:src:proto:multibyte.pro 
	:src:proto:normal.pro 
	:src:proto:ops.pro 
	:src:proto:option.pro 
	:src:proto:quickfix.pro 
	:src:proto:regexp.pro 
	:src:proto:screen.pro 
	:src:proto:search.pro 
	:src:proto:syntax.pro 
	:src:proto:tag.pro 
	:src:proto:term.pro 
	:src:proto:termlib.pro 
	:src:proto:ui.pro 
	:src:proto:undo.pro 
	:src:proto:version.pro 
	:src:proto:window.pro 
	:src:proto:if_python.pro 
	:src:proto:if_tcl.pro 
	:src:proto:if_ruby.pro 
	:src:proto:gui.pro 
	:src:proto:pty.pro 
	:src:proto:gui_gtk.pro 
	:src:proto:gui_gtk_x11.pro 
	:src:proto:gui_motif.pro 
	:src:proto:gui_athena.pro 
	:src:proto:gui_mac.pro 
	:src:proto:gui_x11.pro 
	:src:proto:workshop.pro 
	:src:proto:if_perl.pro 
	:src:proto:if_perlsfio.pro

:obj:tag.c.x	  
	:src:tag.c 
	:src:vim.h 
	:src:auto:config.h 
	:src:feature.h 
	:src:os_unix.h 
	:src:os_mac.h 
	:src:workshop.h 
	:src:ascii.h 
	:src:keymap.h 
	:src:term.h 
	:src:macros.h 
	:src:structs.h 
	:src:globals.h 
	:src:option.h 
	:src:ex_cmds.h 
	:src:proto.h 
	:src:integration.h 
	:src:wsdebug.h 
	:src:regexp.h 
	:src:gui.h 
	:src:farsi.h 
	:src:proto:os_unix.pro 
	:src:proto:os_mac.pro 
	:src:proto:buffer.pro 
	:src:proto:charset.pro 
	:src:proto:if_cscope.pro 
	:src:proto:diff.pro 
	:src:proto:digraph.pro 
	:src:proto:edit.pro 
	:src:proto:eval.pro 
	:src:proto:ex_cmds.pro 
	:src:proto:ex_cmds2.pro 
	:src:proto:ex_docmd.pro 
	:src:proto:ex_eval.pro 
	:src:proto:ex_getln.pro 
	:src:proto:fileio.pro 
	:src:proto:fold.pro 
	:src:proto:getchar.pro 
	:src:proto:hashtable.pro 
	:src:proto:hangulin.pro 
	:src:proto:main.pro 
	:src:proto:mark.pro 
	:src:proto:memfile.pro 
	:src:proto:memline.pro 
	:src:proto:menu.pro 
	:src:proto:message.pro 
	:src:proto:misc1.pro 
	:src:proto:misc2.pro 
	:src:proto:move.pro 
	:src:proto:multibyte.pro 
	:src:proto:normal.pro 
	:src:proto:ops.pro 
	:src:proto:option.pro 
	:src:proto:quickfix.pro 
	:src:proto:regexp.pro 
	:src:proto:screen.pro 
	:src:proto:search.pro 
	:src:proto:syntax.pro 
	:src:proto:tag.pro 
	:src:proto:term.pro 
	:src:proto:termlib.pro 
	:src:proto:ui.pro 
	:src:proto:undo.pro 
	:src:proto:version.pro 
	:src:proto:window.pro 
	:src:proto:if_python.pro 
	:src:proto:if_tcl.pro 
	:src:proto:if_ruby.pro 
	:src:proto:gui.pro 
	:src:proto:pty.pro 
	:src:proto:gui_gtk.pro 
	:src:proto:gui_gtk_x11.pro 
	:src:proto:gui_motif.pro 
	:src:proto:gui_athena.pro 
	:src:proto:gui_mac.pro 
	:src:proto:gui_x11.pro 
	:src:proto:workshop.pro 
	:src:proto:if_perl.pro 
	:src:proto:if_perlsfio.pro

:obj:term.c.x	  
	:src:term.c 
	:src:vim.h 
	:src:auto:config.h 
	:src:feature.h 
	:src:os_unix.h 
	:src:os_mac.h 
	:src:workshop.h 
	:src:ascii.h 
	:src:keymap.h 
	:src:term.h 
	:src:macros.h 
	:src:structs.h 
	:src:globals.h 
	:src:option.h 
	:src:ex_cmds.h 
	:src:proto.h 
	:src:integration.h 
	:src:wsdebug.h 
	:src:regexp.h 
	:src:gui.h 
	:src:farsi.h 
	:src:proto:os_unix.pro 
	:src:proto:os_mac.pro 
	:src:proto:buffer.pro 
	:src:proto:charset.pro 
	:src:proto:if_cscope.pro 
	:src:proto:diff.pro 
	:src:proto:digraph.pro 
	:src:proto:edit.pro 
	:src:proto:eval.pro 
	:src:proto:ex_cmds.pro 
	:src:proto:ex_cmds2.pro 
	:src:proto:ex_docmd.pro 
	:src:proto:ex_eval.pro 
	:src:proto:ex_getln.pro 
	:src:proto:fileio.pro 
	:src:proto:fold.pro 
	:src:proto:getchar.pro 
	:src:proto:hashtable.pro 
	:src:proto:hangulin.pro 
	:src:proto:main.pro 
	:src:proto:mark.pro 
	:src:proto:memfile.pro 
	:src:proto:memline.pro 
	:src:proto:menu.pro 
	:src:proto:message.pro 
	:src:proto:misc1.pro 
	:src:proto:misc2.pro 
	:src:proto:move.pro 
	:src:proto:multibyte.pro 
	:src:proto:normal.pro 
	:src:proto:ops.pro 
	:src:proto:option.pro 
	:src:proto:quickfix.pro 
	:src:proto:regexp.pro 
	:src:proto:screen.pro 
	:src:proto:search.pro 
	:src:proto:syntax.pro 
	:src:proto:tag.pro 
	:src:proto:term.pro 
	:src:proto:termlib.pro 
	:src:proto:ui.pro 
	:src:proto:undo.pro 
	:src:proto:version.pro 
	:src:proto:window.pro 
	:src:proto:if_python.pro 
	:src:proto:if_tcl.pro 
	:src:proto:if_ruby.pro 
	:src:proto:gui.pro 
	:src:proto:pty.pro 
	:src:proto:gui_gtk.pro 
	:src:proto:gui_gtk_x11.pro 
	:src:proto:gui_motif.pro 
	:src:proto:gui_athena.pro 
	:src:proto:gui_mac.pro 
	:src:proto:gui_x11.pro 
	:src:proto:workshop.pro 
	:src:proto:if_perl.pro 
	:src:proto:if_perlsfio.pro

:obj:termlib.c.x	  
	:src:termlib.c 
	:src:vim.h 
	:src:proto:termlib.pro 
	:src:auto:config.h 
	:src:feature.h 
	:src:os_unix.h 
	:src:os_mac.h 
	:src:workshop.h 
	:src:ascii.h 
	:src:keymap.h 
	:src:term.h 
	:src:macros.h 
	:src:structs.h 
	:src:globals.h 
	:src:option.h 
	:src:ex_cmds.h 
	:src:proto.h 
	:src:integration.h 
	:src:wsdebug.h 
	:src:regexp.h 
	:src:gui.h 
	:src:farsi.h 
	:src:proto:os_unix.pro 
	:src:proto:os_mac.pro 
	:src:proto:buffer.pro 
	:src:proto:charset.pro 
	:src:proto:if_cscope.pro 
	:src:proto:diff.pro 
	:src:proto:digraph.pro 
	:src:proto:edit.pro 
	:src:proto:eval.pro 
	:src:proto:ex_cmds.pro 
	:src:proto:ex_cmds2.pro 
	:src:proto:ex_docmd.pro 
	:src:proto:ex_eval.pro 
	:src:proto:ex_getln.pro 
	:src:proto:fileio.pro 
	:src:proto:fold.pro 
	:src:proto:getchar.pro 
	:src:proto:hashtable.pro 
	:src:proto:hangulin.pro 
	:src:proto:main.pro 
	:src:proto:mark.pro 
	:src:proto:memfile.pro 
	:src:proto:memline.pro 
	:src:proto:menu.pro 
	:src:proto:message.pro 
	:src:proto:misc1.pro 
	:src:proto:misc2.pro 
	:src:proto:move.pro 
	:src:proto:multibyte.pro 
	:src:proto:normal.pro 
	:src:proto:ops.pro 
	:src:proto:option.pro 
	:src:proto:quickfix.pro 
	:src:proto:regexp.pro 
	:src:proto:screen.pro 
	:src:proto:search.pro 
	:src:proto:syntax.pro 
	:src:proto:tag.pro 
	:src:proto:term.pro 
	:src:proto:ui.pro 
	:src:proto:undo.pro 
	:src:proto:version.pro 
	:src:proto:window.pro 
	:src:proto:if_python.pro 
	:src:proto:if_tcl.pro 
	:src:proto:if_ruby.pro 
	:src:proto:gui.pro 
	:src:proto:pty.pro 
	:src:proto:gui_gtk.pro 
	:src:proto:gui_gtk_x11.pro 
	:src:proto:gui_motif.pro 
	:src:proto:gui_athena.pro 
	:src:proto:gui_mac.pro 
	:src:proto:gui_x11.pro 
	:src:proto:workshop.pro 
	:src:proto:if_perl.pro 
	:src:proto:if_perlsfio.pro

:obj:ui.c.x	  
	:src:ui.c 
	:src:vim.h 
	:src:auto:config.h 
	:src:feature.h 
	:src:os_unix.h 
	:src:os_mac.h 
	:src:workshop.h 
	:src:ascii.h 
	:src:keymap.h 
	:src:term.h 
	:src:macros.h 
	:src:structs.h 
	:src:globals.h 
	:src:option.h 
	:src:ex_cmds.h 
	:src:proto.h 
	:src:integration.h 
	:src:wsdebug.h 
	:src:regexp.h 
	:src:gui.h 
	:src:farsi.h 
	:src:proto:os_unix.pro 
	:src:proto:os_mac.pro 
	:src:proto:buffer.pro 
	:src:proto:charset.pro 
	:src:proto:if_cscope.pro 
	:src:proto:diff.pro 
	:src:proto:digraph.pro 
	:src:proto:edit.pro 
	:src:proto:eval.pro 
	:src:proto:ex_cmds.pro 
	:src:proto:ex_cmds2.pro 
	:src:proto:ex_docmd.pro 
	:src:proto:ex_eval.pro 
	:src:proto:ex_getln.pro 
	:src:proto:fileio.pro 
	:src:proto:fold.pro 
	:src:proto:getchar.pro 
	:src:proto:hashtable.pro 
	:src:proto:hangulin.pro 
	:src:proto:main.pro 
	:src:proto:mark.pro 
	:src:proto:memfile.pro 
	:src:proto:memline.pro 
	:src:proto:menu.pro 
	:src:proto:message.pro 
	:src:proto:misc1.pro 
	:src:proto:misc2.pro 
	:src:proto:move.pro 
	:src:proto:multibyte.pro 
	:src:proto:normal.pro 
	:src:proto:ops.pro 
	:src:proto:option.pro 
	:src:proto:quickfix.pro 
	:src:proto:regexp.pro 
	:src:proto:screen.pro 
	:src:proto:search.pro 
	:src:proto:syntax.pro 
	:src:proto:tag.pro 
	:src:proto:term.pro 
	:src:proto:termlib.pro 
	:src:proto:ui.pro 
	:src:proto:undo.pro 
	:src:proto:version.pro 
	:src:proto:window.pro 
	:src:proto:if_python.pro 
	:src:proto:if_tcl.pro 
	:src:proto:if_ruby.pro 
	:src:proto:gui.pro 
	:src:proto:pty.pro 
	:src:proto:gui_gtk.pro 
	:src:proto:gui_gtk_x11.pro 
	:src:proto:gui_motif.pro 
	:src:proto:gui_athena.pro 
	:src:proto:gui_mac.pro 
	:src:proto:gui_x11.pro 
	:src:proto:workshop.pro 
	:src:proto:if_perl.pro 
	:src:proto:if_perlsfio.pro

:obj:undo.c.x	  
	:src:undo.c 
	:src:vim.h 
	:src:auto:config.h 
	:src:feature.h 
	:src:os_unix.h 
	:src:os_mac.h 
	:src:workshop.h 
	:src:ascii.h 
	:src:keymap.h 
	:src:term.h 
	:src:macros.h 
	:src:structs.h 
	:src:globals.h 
	:src:option.h 
	:src:ex_cmds.h 
	:src:proto.h 
	:src:integration.h 
	:src:wsdebug.h 
	:src:regexp.h 
	:src:gui.h 
	:src:farsi.h 
	:src:proto:os_unix.pro 
	:src:proto:os_mac.pro 
	:src:proto:buffer.pro 
	:src:proto:charset.pro 
	:src:proto:if_cscope.pro 
	:src:proto:diff.pro 
	:src:proto:digraph.pro 
	:src:proto:edit.pro 
	:src:proto:eval.pro 
	:src:proto:ex_cmds.pro 
	:src:proto:ex_cmds2.pro 
	:src:proto:ex_docmd.pro 
	:src:proto:ex_eval.pro 
	:src:proto:ex_getln.pro 
	:src:proto:fileio.pro 
	:src:proto:fold.pro 
	:src:proto:getchar.pro 
	:src:proto:hashtable.pro 
	:src:proto:hangulin.pro 
	:src:proto:main.pro 
	:src:proto:mark.pro 
	:src:proto:memfile.pro 
	:src:proto:memline.pro 
	:src:proto:menu.pro 
	:src:proto:message.pro 
	:src:proto:misc1.pro 
	:src:proto:misc2.pro 
	:src:proto:move.pro 
	:src:proto:multibyte.pro 
	:src:proto:normal.pro 
	:src:proto:ops.pro 
	:src:proto:option.pro 
	:src:proto:quickfix.pro 
	:src:proto:regexp.pro 
	:src:proto:screen.pro 
	:src:proto:search.pro 
	:src:proto:syntax.pro 
	:src:proto:tag.pro 
	:src:proto:term.pro 
	:src:proto:termlib.pro 
	:src:proto:ui.pro 
	:src:proto:undo.pro 
	:src:proto:version.pro 
	:src:proto:window.pro 
	:src:proto:if_python.pro 
	:src:proto:if_tcl.pro 
	:src:proto:if_ruby.pro 
	:src:proto:gui.pro 
	:src:proto:pty.pro 
	:src:proto:gui_gtk.pro 
	:src:proto:gui_gtk_x11.pro 
	:src:proto:gui_motif.pro 
	:src:proto:gui_athena.pro 
	:src:proto:gui_mac.pro 
	:src:proto:gui_x11.pro 
	:src:proto:workshop.pro 
	:src:proto:if_perl.pro 
	:src:proto:if_perlsfio.pro

:obj:version.c.x	  
	:src:version.c 
	:src:vim.h 
	:src:version.h 
	:src:auto:config.h 
	:src:feature.h 
	:src:os_unix.h 
	:src:os_mac.h 
	:src:workshop.h 
	:src:ascii.h 
	:src:keymap.h 
	:src:term.h 
	:src:macros.h 
	:src:structs.h 
	:src:globals.h 
	:src:option.h 
	:src:ex_cmds.h 
	:src:proto.h 
	:src:integration.h 
	:src:wsdebug.h 
	:src:regexp.h 
	:src:gui.h 
	:src:farsi.h 
	:src:proto:os_unix.pro 
	:src:proto:os_mac.pro 
	:src:proto:buffer.pro 
	:src:proto:charset.pro 
	:src:proto:if_cscope.pro 
	:src:proto:diff.pro 
	:src:proto:digraph.pro 
	:src:proto:edit.pro 
	:src:proto:eval.pro 
	:src:proto:ex_cmds.pro 
	:src:proto:ex_cmds2.pro 
	:src:proto:ex_docmd.pro 
	:src:proto:ex_eval.pro 
	:src:proto:ex_getln.pro 
	:src:proto:fileio.pro 
	:src:proto:fold.pro 
	:src:proto:getchar.pro 
	:src:proto:hashtable.pro 
	:src:proto:hangulin.pro 
	:src:proto:main.pro 
	:src:proto:mark.pro 
	:src:proto:memfile.pro 
	:src:proto:memline.pro 
	:src:proto:menu.pro 
	:src:proto:message.pro 
	:src:proto:misc1.pro 
	:src:proto:misc2.pro 
	:src:proto:move.pro 
	:src:proto:multibyte.pro 
	:src:proto:normal.pro 
	:src:proto:ops.pro 
	:src:proto:option.pro 
	:src:proto:quickfix.pro 
	:src:proto:regexp.pro 
	:src:proto:screen.pro 
	:src:proto:search.pro 
	:src:proto:syntax.pro 
	:src:proto:tag.pro 
	:src:proto:term.pro 
	:src:proto:termlib.pro 
	:src:proto:ui.pro 
	:src:proto:undo.pro 
	:src:proto:version.pro 
	:src:proto:window.pro 
	:src:proto:if_python.pro 
	:src:proto:if_tcl.pro 
	:src:proto:if_ruby.pro 
	:src:proto:gui.pro 
	:src:proto:pty.pro 
	:src:proto:gui_gtk.pro 
	:src:proto:gui_gtk_x11.pro 
	:src:proto:gui_motif.pro 
	:src:proto:gui_athena.pro 
	:src:proto:gui_mac.pro 
	:src:proto:gui_x11.pro 
	:src:proto:workshop.pro 
	:src:proto:if_perl.pro 
	:src:proto:if_perlsfio.pro

:obj:window.c.x	  
	:src:window.c 
	:src:vim.h 
	:src:auto:config.h 
	:src:feature.h 
	:src:os_unix.h 
	:src:os_mac.h 
	:src:workshop.h 
	:src:ascii.h 
	:src:keymap.h 
	:src:term.h 
	:src:macros.h 
	:src:structs.h 
	:src:globals.h 
	:src:option.h 
	:src:ex_cmds.h 
	:src:proto.h 
	:src:integration.h 
	:src:wsdebug.h 
	:src:regexp.h 
	:src:gui.h 
	:src:farsi.h 
	:src:proto:os_unix.pro 
	:src:proto:os_mac.pro 
	:src:proto:buffer.pro 
	:src:proto:charset.pro 
	:src:proto:if_cscope.pro 
	:src:proto:diff.pro 
	:src:proto:digraph.pro 
	:src:proto:edit.pro 
	:src:proto:eval.pro 
	:src:proto:ex_cmds.pro 
	:src:proto:ex_cmds2.pro 
	:src:proto:ex_docmd.pro 
	:src:proto:ex_eval.pro 
	:src:proto:ex_getln.pro 
	:src:proto:fileio.pro 
	:src:proto:fold.pro 
	:src:proto:getchar.pro 
	:src:proto:hashtable.pro 
	:src:proto:hangulin.pro 
	:src:proto:main.pro 
	:src:proto:mark.pro 
	:src:proto:memfile.pro 
	:src:proto:memline.pro 
	:src:proto:menu.pro 
	:src:proto:message.pro 
	:src:proto:misc1.pro 
	:src:proto:misc2.pro 
	:src:proto:move.pro 
	:src:proto:multibyte.pro 
	:src:proto:normal.pro 
	:src:proto:ops.pro 
	:src:proto:option.pro 
	:src:proto:quickfix.pro 
	:src:proto:regexp.pro 
	:src:proto:screen.pro 
	:src:proto:search.pro 
	:src:proto:syntax.pro 
	:src:proto:tag.pro 
	:src:proto:term.pro 
	:src:proto:termlib.pro 
	:src:proto:ui.pro 
	:src:proto:undo.pro 
	:src:proto:version.pro 
	:src:proto:window.pro 
	:src:proto:if_python.pro 
	:src:proto:if_tcl.pro 
	:src:proto:if_ruby.pro 
	:src:proto:gui.pro 
	:src:proto:pty.pro 
	:src:proto:gui_gtk.pro 
	:src:proto:gui_gtk_x11.pro 
	:src:proto:gui_motif.pro 
	:src:proto:gui_athena.pro 
	:src:proto:gui_mac.pro 
	:src:proto:gui_x11.pro 
	:src:proto:workshop.pro 
	:src:proto:if_perl.pro 
	:src:proto:if_perlsfio.pro

:obj:wsdebug.c.x	  
	:src:wsdebug.c 
	:src:vim.h 
	:src:auto:config.h 
	:src:feature.h 
	:src:os_unix.h 
	:src:os_mac.h 
	:src:workshop.h 
	:src:ascii.h 
	:src:keymap.h 
	:src:term.h 
	:src:macros.h 
	:src:structs.h 
	:src:globals.h 
	:src:option.h 
	:src:ex_cmds.h 
	:src:proto.h 
	:src:integration.h 
	:src:wsdebug.h 
	:src:regexp.h 
	:src:gui.h 
	:src:farsi.h 
	:src:proto:os_unix.pro 
	:src:proto:os_mac.pro 
	:src:proto:buffer.pro 
	:src:proto:charset.pro 
	:src:proto:if_cscope.pro 
	:src:proto:diff.pro 
	:src:proto:digraph.pro 
	:src:proto:edit.pro 
	:src:proto:eval.pro 
	:src:proto:ex_cmds.pro 
	:src:proto:ex_cmds2.pro 
	:src:proto:ex_docmd.pro 
	:src:proto:ex_eval.pro 
	:src:proto:ex_getln.pro 
	:src:proto:fileio.pro 
	:src:proto:fold.pro 
	:src:proto:getchar.pro 
	:src:proto:hashtable.pro 
	:src:proto:hangulin.pro 
	:src:proto:main.pro 
	:src:proto:mark.pro 
	:src:proto:memfile.pro 
	:src:proto:memline.pro 
	:src:proto:menu.pro 
	:src:proto:message.pro 
	:src:proto:misc1.pro 
	:src:proto:misc2.pro 
	:src:proto:move.pro 
	:src:proto:multibyte.pro 
	:src:proto:normal.pro 
	:src:proto:ops.pro 
	:src:proto:option.pro 
	:src:proto:quickfix.pro 
	:src:proto:regexp.pro 
	:src:proto:screen.pro 
	:src:proto:search.pro 
	:src:proto:syntax.pro 
	:src:proto:tag.pro 
	:src:proto:term.pro 
	:src:proto:termlib.pro 
	:src:proto:ui.pro 
	:src:proto:undo.pro 
	:src:proto:version.pro 
	:src:proto:window.pro 
	:src:proto:if_python.pro 
	:src:proto:if_tcl.pro 
	:src:proto:if_ruby.pro 
	:src:proto:gui.pro 
	:src:proto:pty.pro 
	:src:proto:gui_gtk.pro 
	:src:proto:gui_gtk_x11.pro 
	:src:proto:gui_motif.pro 
	:src:proto:gui_athena.pro 
	:src:proto:gui_mac.pro 
	:src:proto:gui_x11.pro 
	:src:proto:workshop.pro 
	:src:proto:if_perl.pro 
	:src:proto:if_perlsfio.pro
