/* Function prototypes and error codes for ENCLIB.C
**    and DECLIB.C. By A.Salvatucci, 1994           */
#ifndef __ENCDEC_H__
#define __ENCDEC_H__

typedef struct tagTYPEINFO
{
    WORD    rtTypeID;
    WORD    rtResourceCount;
    DWORD   rtReserved;
    /** <rtResourceCount> NAMEINFOs follow here... **/
}TYPEINFO;
typedef TYPEINFO FAR *LPTYPEINFO;

typedef struct tagNAMEINFO
{
    WORD    wOffset;  /** Offset to res in file **/ 
    WORD    wLength;  /** Length in file **/
    WORD    wFlags;
    WORD    wResNumber; 
    WORD    hResSeg;    
    WORD    wUsageCnt;    
}NAMEINFO;
typedef NAMEINFO FAR *LPNAMEINFO;

typedef int (CALLBACK *CRPROC)(BYTE FAR *buffer, WORD len);

int crEncryptResources(LPSTR szExeName,LPCSTR*lpResTypeList);
int crSetEncryptHandler(CRPROC lpAnEncryptHandler);
int crDecryptON(HINSTANCE hAnInstance, LPCSTR lpResType);
int crSetDecryptHandler(CRPROC lpADecryptHandler);

#define CR_SUCCESS              0

/** I/O errors **/
#define CR_ERR_OPENFILE         1
#define CR_ERR_READFILE         2
#define CR_ERR_WRITEFILE        3
#define CR_ERR_BADFILEFORMAT    4

/** Memory errors **/
#define CR_ERR_ALLOCMEM         5

/** Other errors **/
#define CR_ERR_NORESOURCES      6

#endif
