/*
Borland C++ v4.5:
  bcc -DSTRICT -c -dc -ml! -WDE -vi -v flcplay.c
  tlink /v /A=16 /c /C /l /s /Twd c0dl.obj+flcplay.obj,\
        flcplay.dll,,cwl+noehwl+import+wing,flcplay.def
  implib flcplay.lib flcplay.dll
Visual C++ v1.5:
  cl -DSTRICT /c /nologo /W3 /Zp /GDs /GEdme /ALw flcplay.c
  link /nologo /NOE /align:16 /NOD /MAP:FULL /LINE \
        flcplay.obj,,,LDLLcew libw mmsystem toolhelp \
        wing,flcplay.def
  implib flcplay.lib flcplay.dll
 */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <windows.h>
#include <windowsx.h>
#include <toolhelp.h>
#include "wing.h"       // get this from WinG SDK!

#define _FLC_C
struct TFLIC;
typedef struct TFLIC *HFLIC;
#include "flcplay.h"

struct TFLIC;
typedef struct TFLIC *HFLIC;
#pragma warning(disable:4103)     // Disable pack warning
#pragma pack(1)

typedef BYTE _huge *HPBYTE;

#define FLC_MAGIC       0xAF12
#define FRAME_CHUNK     0xF1FA
#define COLOR_256       4
#define DELTA_FLC       7
#define COLOR_64        11
#define DELTA_FLI       12
#define BLACK           13
#define BYTE_RUN        15
#define LITERAL         16
#define PSTAMP          18

#define FLC_PAL         0x0001
#define FLC_FRAME       0x0002
#define FLC_EOF         0x0004

typedef struct _FLC_HDR {
    DWORD dwFileSize;
    WORD  wMagic;       // 0xAF12
    WORD  wFrames;      // Number of frames (no ring frame)
    WORD  wWidth;
    WORD  wHeight;
    WORD  wDepth;       // Color depth (8)
    WORD  wFlags;
    DWORD dwSpeed;      // mSecs to delay between frames
    WORD  wReserved;
    DWORD dwCreation;   // MS-DOS formatted date and time
    DWORD dwCreator;    // Anim Pro creator number or "FLIB"
    DWORD dwUpdated;    // Update MS-DOS date and time
    DWORD dwUpdater;    // Updater number
    WORD  wAspectX;
    WORD  wAspectY;
    BYTE  wUnused1[38];
    DWORD dwFrame1Off;
    DWORD dwFrame2Off;
    BYTE  wUnused2[40]; // Totals 128 byes
} FLC_HDR;

typedef struct _CHUNK_HDR {
    DWORD dwChunkSize;
    WORD  wMagic;
    WORD  wSubChunks;
    BYTE  wUnused[8];
} CHUNK_HDR;

typedef struct _DATA_HDR {
    DWORD dwDataSize;
    WORD  wType;
} DATA_HDR;

#define WIDTHBYTES(i)   ((WORD)((i + 31) & (~31)) / 8)

typedef struct TFLCFILE {
    WORD  wFrames;
    WORD  wCurFrame;
    WORD  wWidth;
    WORD  wHeight;
    DWORD dwSpeed;
    WORD  wWidthBytes;
    HFILE fh;
    DWORD dwFrame1Off;
    DWORD dwFrame2Off;
    } TFLCFILE;


#define STAT_OK             0
#define STAT_PLAYING        1
#define STAT_FILE_OPEN_ERR  2
#define STAT_CREATE_BM_ERR  3

typedef void (CALLBACK* TASKPROC)(WORD, WORD);
#define NEW(x)  ((x*)malloc(sizeof(x)))

enum { EMPTY = 0, PLAYING = 1, STOPPED = 2, STEPPING = 3,
       CLOSING = 4, CLOSED = 5 };

typedef struct  TFLIC
    {
    HDC       hWinGDC;          // Global WinG DC
    LPRGBQUAD pWinGColors;      // Global color table
    char      szFlcFile[256];   // Flc filename
    int       State;
    HWND      Window;           // non-NULL if playing
    TFLCFILE  FlicFile;
    }   TFLIC;

typedef struct TTASK
    {
    HWND        Window;
    TFLCFILE   *FlcFile;
    }          TTASK;

//----------------------------------------------------------
int   FlcOpen(TFLCFILE *FlcFile, const char *szFile);
int   FlcReadNextFrame(TFLCFILE *FlcFile, LPRGBQUAD pColors,
                       HPBYTE pBits);
void  FlcClose(TFLCFILE *FlcFile);
int   FlcWidth(TFLCFILE *FlcFile);
int   FlcHeight(TFLCFILE *FlcFile);
DWORD FlcSpeed(TFLCFILE *FlcFile);

//----------------------------------------------------------
int WINAPI MMTaskCreate(TASKPROC lpTaskProc,
                LPWORD lphTask, WORD wParamA, WORD wParamB);
void CALLBACK __export TaskCallback(WORD a, WORD b);
HBITMAP WinGHdrCreateBitmap(HDC hWinGDC,
        int nWidth, int nHeight, void FAR * FAR *ppBits);



#ifdef __BORLANDC__
    #pragma argsused
#endif
int CALLBACK LibMain(HINSTANCE This, WORD DataSeg,
                     WORD HeapSize, LPSTR CommandLine)
    {
    return TRUE;
    }

#ifdef __BORLANDC__
    #pragma argsused
#endif
int CALLBACK WEP(int ExitType)
    {
    return TRUE;
    }

HFLIC WINAPI __export FlicCreate()
    {
    TFLIC  *Flic = NEW(TFLIC);
    if(Flic != 0)
        {
        memset(Flic, 0, sizeof(TFLIC));
        Flic->hWinGDC       = WinGCreateDC();
        Flic->State         = CLOSED;
        Flic->pWinGColors   = (LPRGBQUAD)
                              malloc(256*sizeof(RGBQUAD));
        if(Flic->pWinGColors == 0)
            {
            free(Flic);
            Flic    = 0;
            }
        }
    return Flic;
    }

int WINAPI __export FlicDestroy(HFLIC Flic)
    {
    if(Flic != 0)
        {
        if(Flic->State != CLOSED)
            return FALSE;
        else
            {
            DeleteDC(Flic->hWinGDC);
            free(Flic->pWinGColors);
            free(Flic);
            }
        }
    return TRUE;
    }

int WINAPI __export FlicOpen(HFLIC Flic, const char FAR*
                            FileName, HWND Window)
    {
    if(Flic != 0)
        {
        if(Flic->State != CLOSED)
            return FALSE;
        strcpy(Flic->szFlcFile, FileName);
        // if can't open file...
        if(FlcOpen(&Flic->FlicFile, FileName) < 0)
            return FALSE;
        // else we are ready to roll, spawn flic player task
        else
            {
            static WORD Dummy;
            FlcClose(&Flic->FlicFile);
            Flic->Window    = Window;
            Flic->State     = STOPPED;
            MMTaskCreate(TaskCallback, &Dummy,
                LOWORD(Flic), HIWORD(Flic));
            return TRUE;
            }
        }
    return FALSE;
    }

int WINAPI __export FlicStep(HFLIC Flic)
    {
    if(Flic)
        {
        Flic->State     = STEPPING;
        return TRUE;
        }
    else
        return FALSE;
    }

int WINAPI __export FlicPlay(HFLIC Flic)
    {
    if(Flic)
        {
        Flic->State     = PLAYING;
        return TRUE;
        }
    else
        return FALSE;
    }

int WINAPI __export FlicStop(HFLIC Flic)
    {
    if(Flic)
        {
        Flic->State     = STOPPED;
        return TRUE;
        }
    else
        return FALSE;
    }

int WINAPI __export FlicClose(HFLIC Flic)
    {
    if(Flic != NULL)
        {
        Flic->State = CLOSING;
        return TRUE;
        }
    else
        return FALSE;
    }


int WINAPI __export FlicIsClosed(HFLIC Flic)
    {
    if(Flic)
        return Flic->State == CLOSED;
    else
        return FALSE;
    }

int WINAPI __export FlicIsPlaying(HFLIC Flic)
    {
    if(Flic)
        return Flic->State == PLAYING
            || Flic->State == STEPPING;
    else
        return FALSE;
    }

int WINAPI __export FlicWidth(HFLIC Flic)
    {
    if(Flic)
        return Flic->FlicFile.wWidth;
    else
        return 0;
    }

int WINAPI __export FlicHeight(HFLIC Flic)
    {
    if(Flic)
        return Flic->FlicFile.wHeight;
    else
        return 0;
    }
int WINAPI __export FlicFrameCount(HFLIC Flic)
    {
    if(Flic)
        return Flic->FlicFile.wFrames;
    else
        return 0;
    }

int WINAPI __export FlicCurrentFrame(HFLIC Flic)
    {
    if(Flic)
        return Flic->FlicFile.wCurFrame;
    else
        return -1;
    }




int HandleChunk(TFLCFILE *FlcFile, HPBYTE pChunk, WORD wType,
            LPRGBQUAD pColors, HPBYTE pFrame);

int FlcOpen(TFLCFILE *FlcFile, const char *szFile)
{
    // Open the flc file and read the header data.
    FLC_HDR Header;

    memset(FlcFile, 0, sizeof(*FlcFile));
    if ((FlcFile->fh = _lopen(szFile, READ)) == HFILE_ERROR)
        return -1;
    _lread(FlcFile->fh, &Header, sizeof(Header));
    if (Header.wMagic != FLC_MAGIC) {
        _lclose(FlcFile->fh);
        return -2;
    }
    FlcFile->wFrames = Header.wFrames;
    FlcFile->wWidth  = Header.wWidth;
    FlcFile->wHeight = Header.wHeight;
    FlcFile->dwSpeed = Header.dwSpeed ? Header.dwSpeed : 71;
    FlcFile->wWidthBytes =
        WIDTHBYTES(Header.wWidth * Header.wDepth);
    FlcFile->dwFrame1Off = Header.dwFrame1Off;
    FlcFile->dwFrame2Off = Header.dwFrame2Off;

    // Prepare for reading first frame
    _llseek(FlcFile->fh, Header.dwFrame1Off, SEEK_SET);
    return 0;
}

//----------------------------------------------------------
int FlcWidth(TFLCFILE *FlcFile)
{    return (int)FlcFile->wWidth;    }

//----------------------------------------------------------
int FlcHeight(TFLCFILE *FlcFile)
{    return (int)FlcFile->wHeight;   }

//----------------------------------------------------------
DWORD FlcSpeed(TFLCFILE *FlcFile)
{    return FlcFile->dwSpeed;    }

//----------------------------------------------------------
FlcReadNextFrame(TFLCFILE *FlcFile, LPRGBQUAD pColors,
        HPBYTE pBits)
{
    // Read the next frame from the flc file. The flc unit
    // is a chunk, which can consist of color info and
    // frame data.
    int rc = 0, nChunk;
    WORD        i;
    CHUNK_HDR   ChunkHdr;
    DATA_HDR    DataHdr;
    HPBYTE      pChunk;

    if (FlcFile->wCurFrame == FlcFile->wFrames) {
        // Prepare for reading first frame
        _llseek(FlcFile->fh, FlcFile->dwFrame1Off, SEEK_SET);
        FlcFile->wCurFrame = 0;
        return FLC_EOF;
    }

    _lread(FlcFile->fh, &ChunkHdr, sizeof(ChunkHdr));
    if (ChunkHdr.wMagic != 0xF1FA) // Invalid chunk header
        return FLC_EOF;

    for (i = 0; i < ChunkHdr.wSubChunks; i++) {
        _lread(FlcFile->fh, &DataHdr, sizeof(DataHdr));
        pChunk = malloc((unsigned)DataHdr.dwDataSize
            - sizeof(DataHdr));
        if (pChunk == NULL)
            return -3;
        _hread(FlcFile->fh, pChunk,
            DataHdr.dwDataSize - sizeof(DataHdr));
        if ((nChunk = HandleChunk(FlcFile, pChunk,
                DataHdr.wType, pColors, pBits))
                                        == COLOR_256)
            rc |= FLC_PAL;
        else if (nChunk > 0)
            rc |= FLC_FRAME;
        free(pChunk);
    }
    FlcFile->wCurFrame++;

    return rc;
}

void FlcClose(TFLCFILE *FlcFile)
{    _lclose(FlcFile->fh);   }

int HandleChunk(TFLCFILE *FlcFile, HPBYTE pChunk, WORD wType,
            LPRGBQUAD pColors, HPBYTE pFrame)
{
    int rc = -1;
    WORD i, j, k, wCount;
    WORD wPackets, wColorCount, wNoOfBytes, wLines, wWord;
    BYTE cSkipCount, cCount, cByte, cType;
    HPBYTE pScanLine, pScanStart;

    switch (wType) {

    case COLOR_256:
        wPackets = *(WORD _huge *)pChunk;
        pChunk += 2;
        for (i = 0; i < wPackets; i++) {
            cSkipCount = *pChunk++;
            pColors += cSkipCount;
            wColorCount = ((cByte=*pChunk++) != '\0')
                 ? cByte : 256;
            for (j = 0; j < wColorCount; j++) {
                pColors->rgbRed = *pChunk++;
                pColors->rgbGreen = *pChunk++;
                pColors->rgbBlue = *pChunk++;
                pColors->rgbReserved = 0;
                pColors++;
            }
        }
        rc = wType;
        break;

    case BYTE_RUN: // Byte run length compression
        for (i = FlcFile->wHeight - 1; (int)i >= 0; i--) {
            pScanLine = pFrame;
            pScanLine +=
                ((DWORD)i * (DWORD)FlcFile->wWidthBytes);
            cCount = *pChunk++;
            // Process scanline
            wNoOfBytes = 0;
            while (wNoOfBytes < FlcFile->wWidth) {
                cCount = *pChunk++;
                if ((char)cCount < 0) {
                    // Negative: pixel count
                    cCount = -(char)cCount;
                    hmemcpy(pScanLine,
                            pChunk, (WORD)cCount);
                    pScanLine += (WORD)cCount;
                    pChunk += cCount;
                }
                else {
                    // One pixel; repeat it cCount times
                    _fmemset(pScanLine,
                            *pChunk++, (WORD)cCount);
                    pScanLine += (WORD)cCount;
                }
                wNoOfBytes += (WORD)cCount;
            }
        }
        rc = wType;
        break;

    case DELTA_FLI: // Byte sized delta compression
        pScanLine = pFrame;
        pScanLine += ((DWORD)(FlcFile->wHeight - 1)
                    * (DWORD)FlcFile->wWidthBytes);
        pScanLine -= *(WORD _huge *)pChunk *
                        (DWORD)FlcFile->wWidthBytes;
        pChunk += 2;
        wLines = *(WORD _huge *)pChunk;
        pChunk += 2;
        for (i = 0; i < wLines; i++) {

            pScanStart = pScanLine;
            wPackets = (WORD)*pChunk++;
            for (j = 0; j < wPackets; j++) {
                pScanLine += *pChunk++; // Column skip
                cCount = *pChunk++;
                if ((char)cCount < 0) {
                    cCount = -(char)cCount;
                    _fmemset(pScanLine,
                            *pChunk++, (WORD)cCount);
                    pScanLine += (WORD)cCount;
                }
                else {
                    hmemcpy(pScanLine,
                            pChunk, (WORD)cCount);
                    pScanLine += (WORD)cCount;
                    pChunk += cCount;
                }
            }

            pScanLine = pScanStart -
                        (DWORD)FlcFile->wWidthBytes;
        }
        rc = wType;
        break;

    case DELTA_FLC: // Word sized delta compression
        pScanLine = pFrame;
        pScanLine += ((DWORD)(FlcFile->wHeight - 1)
                    * (DWORD)FlcFile->wWidthBytes);
        wLines = *(WORD _huge *)pChunk;
        pChunk += 2;
        for (i = 0; i < wLines; i++) {

            wWord = *(WORD _huge *)pChunk;
            pChunk += 2;
            while ((int)wWord < 0) {

                if (wWord & 0x4000) { // Test for bit 14
                    // Line skip count
                    pScanLine -= ((DWORD)-(int)wWord *
                                (DWORD)FlcFile->wWidthBytes);
                }
                else {
                    // Last byte of this line
                    cByte = (BYTE)(wWord & 0x00FF);
                    *(pScanLine +
                        (DWORD)FlcFile->wWidth - 1) = cByte;

                }
                wWord = *(WORD _huge *)pChunk;
                pChunk += 2;
            }

            pScanStart = pScanLine;
            // Read line packets
            wPackets = wWord;
            for (j = 0; j < wPackets; j++) {
                pScanLine += *pChunk++; // Column skip
                cType = *pChunk++;      // Packet type
                if ((char)cType > 0) {
                    // Copy cType words of pixel data
                    hmemcpy(pScanLine,
                            pChunk, (WORD)cType * 2);
                    pScanLine += (WORD)cType * 2;
                    pChunk += (WORD)cType * 2;
                }
                else {
                    // Replicate the word -cType times
                    wCount = (WORD)-(char)cType * 2;
                    for (k = 0; k < wCount; k += 2) {
                        *(WORD _huge *)(pScanLine + k) =
                                    *(WORD _huge *)pChunk;
                    }
                    pScanLine += wCount;
                    pChunk += 2;
                }
            }
            pScanLine = pScanStart -
                        (DWORD)FlcFile->wWidthBytes;
        }
        rc = wType;
        break;

    default:
        break;
    }
    return rc;
}


//----------------------------------------------------------
HPALETTE CreateIdentPal(RGBQUAD _far aRGB[])
{
    // Try to create an identity palette from the RGBQUADs.
    int i, nStatCols;
    HDC hDC;
    struct {
        WORD Version;
        WORD NumberOfEntries;
        PALETTEENTRY aEntries[256];
    } Palette = { 0x300, 256 };

    hDC = GetDC(NULL);
    if (GetSystemPaletteUse(hDC) == SYSPAL_NOSTATIC) {
        return NULL;
    }
    else {
        // For SYSPAL_STATIC, only set the non-static colors
        nStatCols = GetDeviceCaps(hDC, NUMRESERVED);
        GetSystemPaletteEntries(hDC, 0, 256,
                                Palette.aEntries);
        // Zero the peFlags of the lower static colors
        for (i = 0; i < (nStatCols / 2); i++)
            Palette.aEntries[i].peFlags = 0;

        // Set the palette entries to the DIB colors
        for ( ; i < 256 - (nStatCols / 2); i++)    {
            Palette.aEntries[i].peRed   = aRGB[i].rgbRed;
            Palette.aEntries[i].peGreen = aRGB[i].rgbGreen;
            Palette.aEntries[i].peBlue  = aRGB[i].rgbBlue;
            Palette.aEntries[i].peFlags = PC_NOCOLLAPSE;
        }
        for (; i < 256 - (nStatCols / 2); i++)
            Palette.aEntries[i].peFlags = PC_NOCOLLAPSE;

        // Zero the peFlags of the upper static colors
        for (i = 256 - (nStatCols / 2); i < 256; i++)
            Palette.aEntries[i].peFlags = 0;
    }
    ReleaseDC(NULL, hDC);

    return CreatePalette((LOGPALETTE *)&Palette);
}

#ifdef __BORLANDC__
    #pragma argsused
#endif
void CALLBACK __export TaskCallback(WORD a, WORD b)
{
    // Callback for MMTask proc. Beware: SS != DS
    TFLIC*      TaskInfo= (TFLIC *)MAKELP(b, a);
    HWND        hWnd    = TaskInfo->Window;
    TFLCFILE*   FlcFile = &TaskInfo->FlicFile;
    int         rc      = 0;
    HDC         hDC;
    MSG         msg;
    HBITMAP     hWinGBM, hOldBM;
    HPALETTE    hPal = NULL;
    HPBYTE      pWinGBits;
    DWORD       dwTick;
    TIMERINFO   TI = { sizeof(TI), 0L, 0L };

    // if error in opening file
    if(FlcOpen(&TaskInfo->FlicFile, TaskInfo->szFlcFile) < 0)
        {
        TaskInfo->Window    = 0;
        return;
        }
    if ((hWinGBM = WinGHdrCreateBitmap
            (TaskInfo->hWinGDC, FlcWidth(FlcFile),
                FlcHeight(FlcFile), &(LPVOID)pWinGBits))
                    == NULL) {
        FlcClose(FlcFile);
        return;
        }
    hDC         = GetDC(hWnd);
    hOldBM      = SelectObject(TaskInfo->hWinGDC, hWinGBM);

    TimerCount(&TI);            // Get start time
    dwTick = TI.dwmsSinceStart;

    while(TaskInfo->State != CLOSING) {
        if (PeekMessage(&msg, NULL, 0, 0, PM_REMOVE))
            DispatchMessage(&msg);
        TimerCount(&TI);
        if(TaskInfo->State == STOPPED
            || TaskInfo->State == CLOSING)
            continue;
        else if(TaskInfo->State == STEPPING)
            {
            // stop after this frame
            TaskInfo->State = STOPPED;
            // fake time so frame will be bitblted
            TI.dwmsSinceStart = FlcFile->dwSpeed + dwTick;
            }
        if ((TI.dwmsSinceStart - dwTick) >= FlcFile->dwSpeed) {
            rc = FlcReadNextFrame(FlcFile,
                TaskInfo->pWinGColors, pWinGBits);
            if (rc & FLC_PAL) {
                /// New color info, create a palette
                if (hPal != NULL)
                    DeleteObject(hPal);
                hPal=CreateIdentPal(TaskInfo->pWinGColors);
                SelectPalette(hDC, hPal, FALSE);
                RealizePalette(hDC);
                WinGSetDIBColorTable(TaskInfo->hWinGDC,
                             0, 256, TaskInfo->pWinGColors);
            }
            if (rc & FLC_FRAME) {
                WinGBitBlt(hDC, 0, 0, FlcWidth(FlcFile),
                 FlcHeight(FlcFile),TaskInfo->hWinGDC,0,0);
            }
            dwTick = TI.dwmsSinceStart;
        }
        else {
            // Could do pre-read frame here
        }
    }

    SelectObject(TaskInfo->hWinGDC, hOldBM);
    DeleteObject(hWinGBM);          // and delete it
    if (hPal != NULL)
        DeleteObject(hPal);         // Remove the palette
    FlcClose(FlcFile);              // Close the flc file
    ReleaseDC(hWnd, hDC);           // Don't forget

    TaskInfo->State     = CLOSED;
    return;
}

//----------------------------------------------------------
HBITMAP WinGHdrCreateBitmap(HDC hWinGDC,
            int nWidth, int nHeight, void FAR * FAR *ppBits)
{
    struct {
        BITMAPINFOHEADER  Header;
        RGBQUAD           aColors[256];
    } BmHdr;

    if(WinGRecommendDIBFormat((LPBITMAPINFO)&BmHdr) == 0)
        return NULL;
    // Create the WinG bitmap, make sure it's 8 bpp
    BmHdr.Header.biBitCount = 8;
    BmHdr.Header.biCompression = BI_RGB;
    BmHdr.Header.biWidth = nWidth;
    BmHdr.Header.biHeight = nHeight;
    return WinGCreateBitmap(hWinGDC,
                (LPBITMAPINFO)&BmHdr, ppBits);
}
