/*
   fixrtf.c -- Robert Mashlan (rmashlan@r2m.com)

   This file compiles to a DOS program.  The program is
   used to translate the special character RTF tokens that
   Microsoft Word 6.0 generates, but the help compiler does
   not understand.
   
   fixrtf makes the following translations:

   \lquote    to \'91
   \rquote    to \'92
   \ldblquote to \'93
   \rdblquote to \'94
   \bullet    to \'95
   \endash    to \'96
   \emdash    to \'97

Borland C++ v4.5:
    bcc -c -ms -vi fixrtf.c
    tlink /A=16 /c /C /l /s /Tde \
        c0s.obj+fixrtf.obj,fixrtf.exe,,cs.lib
Visual C++ v1.5:
    cl /c  /W3 /Zp /Gs /AS fixrtf.c
    link /nologo /NOE /MAP:FULL /LINE \
        fixrtf.obj,fixrtf.exe,fixrtf,,;
*/

#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <ctype.h>

int convert( const char *infn, const char *outfn )
{
   FILE *fi, *fo;
   int state = 0;
   char token[80];
   int  tokeni;
   int  nesting;
   unsigned int bin;

   fi = fopen(infn,"rb");
   if(!fi) {
      printf("unable to open %s for reading\n",infn);
      return errno;
   }
   fo = fopen(outfn,"wb");
   if( !fo) {
      fclose(fi);
      printf("unable to open %s for writing\n",outfn);
      return errno;
   }
   while(1) {
      int again = 0;
      int inchar = getc(fi);
      if( inchar == EOF )
         break;

      do {
         again = 0;
         switch(state) {
            case 0:
               if(inchar == '{')
                  nesting++;
               if(inchar == '}')
                  nesting--;
               if(inchar == '\\' ) {
                  state++;
                  tokeni = 0;
               } else
                  putc(inchar,fo);
               break;

            case 1:
               switch(inchar) {
                  // control symbol without parameters
                  case '-' :
                  case ':' :
                  case '\\' :
                  case '{' :
                  case '}' :
                  case '|' :
                     putc('\\',fo);
                     putc(inchar,fo);
                     state--;
                     break;

                  default:
                     tokeni = 0;
                     token[tokeni++] = '\\';
                     token[tokeni++] = inchar;
                     state++;
                     break;
               }
               break;

            case 2:
               if(isalnum(inchar)||inchar=='-') {
                  token[tokeni++] = inchar;
               } else {
                  token[tokeni] = 0;
                  if( strncmp(token,"\\bin",4) == 0 ) {
                     bin = atoi(token+4);
                     state = 3;
                     fputs(token,fo);
                     break;
                  }
                  if( strcmp(token,"\\rquote")==0 ) {
                     fputs("\\'92",fo);
                     state = 0;
                     break;
                  }
                  if( strcmp(token,"\\lquote")==0 ) {
                     fputs("\\'91",fo);
                     state = 0;
                     break;
                  }
                  if( strcmp(token,"\\ldblquote")==0 ) {
                     fputs("\\'93",fo);
                     state = 0;
                     break;
                  }
                  if( strcmp(token,"\\rdblquote")==0 ) {
                     fputs("\\'94",fo);
                     state = 0;
                     break;

                  }
                  if( strcmp(token,"\\bullet")==0 ) {
                     fputs("\\'95",fo);
                     state = 0;
                     break;
                  }
                  if( strcmp(token,"\\endash")==0 ) {
                     fputs("\\'96",fo);
                     state = 0;
                     break;
                  }
                  if( strcmp(token,"\\emdash")==0 ) {
                     fputs("\\'97",fo);
                     state = 0;
                     break;
                  }
                  fputs(token,fo);
                  state = 0;
                  again = 1;
               }
               break;


            case 3:
               // reading binary data
               putc(inchar,fo);
               bin--;
               if(!bin)
                  state = 0;
               break;
         }
      } while(again);
   }
   fclose(fi);
   fclose(fo);
   return 0;
}

int main( int argc, char **argv )
{
   if( argc > 1 ) {
      int i;
      for(i=1;i<argc;i++) {
         int r;
         char infn[80];
         char* outfn = argv[i];
         /* form back up file name (use .bak extension) */
         _splitpath(outfn,infn,NULL,NULL,NULL);
         _splitpath(outfn,NULL,infn+strlen(infn),NULL,NULL);
         _splitpath(outfn,NULL,NULL,infn+strlen(infn),NULL);
         strcat(infn,".bak");
         unlink(infn); /* delete old backup file */
         /* rename file to backup file */
         if( rename(outfn,infn) ) {
            printf("error renaming %s\n",outfn);
            return errno;
         }
         r = convert(infn,outfn);
         if(r)
            return r;
      }
   } else {
      printf("This program converts an .RTF file that has "
             "special character tokens that\n"
             "the help compiler doesn't understand. "
             "Place .RTF file to be converted\n"
             "on the command line. The orignal is saved to "
             "have a .bak extension\n");
   }
   return 0;
}
