///////////////////////////////////////////////////////
// mousetrk.c                                        //
// -- DLL tracks mouse movement and informs windows  //
//    of when the pointer enters and leaves.         //
///////////////////////////////////////////////////////
#include <windows.h>
#include "mousetrk.h"

HHOOK hhok;
UINT  wmMouseTrack;

LRESULT CALLBACK __export LwMouseProc(int wCode,
  WPARAM wParam, LPARAM lParam);

#ifdef __BORLANDC__
    #pragma argsused
#endif
int CALLBACK LibMain(HINSTANCE hins, WORD ds,
  WORD cbHeap, LPSTR lsz)
///////////////////////////////////////////////////////
// -- Initialization entry point.                    //
// -- Install the mouse message hook and register    //
//    the enter/exit notification message.           //
///////////////////////////////////////////////////////
    {
    return NULL != (hhok = SetWindowsHookEx(WH_MOUSE,
        LwMouseProc, hins, NULL)) &&
      NULL != (wmMouseTrack =
        RegisterWindowMessage(szMouseTrack));
    }

#ifdef __BORLANDC__
    #pragma argsused
#endif
int CALLBACK __export WEP(int wExitCode)
    {
OutputDebugString("Removing Message HOOk!");
    // -- Remove the message hook.
    if (NULL != hhok)
        UnhookWindowsHookEx(hhok);
    return 1;
    }

LRESULT CALLBACK __export LwMouseProc(int wCode,
  WPARAM wParam, LPARAM lParam)
///////////////////////////////////////////////////////
// -- Mouse hook procedure.                          //
// -- Gets called every time a mouse message is      //
//    returned to a task's message pump.             //
///////////////////////////////////////////////////////
    {
    static HWND         hwndLast;
    LPMOUSEHOOKSTRUCT   lpmhs;

    // Ignore message if we must (wCode < 0), or if
    // mouse has been captured.
    if (0 <= wCode && GetCapture() == NULL)
        {
        lpmhs = (LPMOUSEHOOKSTRUCT)lParam;
        if (lpmhs->hwnd != hwndLast)
            { // New window under mouse.
            if (IsWindow(hwndLast))
                PostMessage(hwndLast, wmMouseTrack,
                  FALSE, MAKELONG(lpmhs->hwnd, 0));
            if (IsWindow(lpmhs->hwnd))
                PostMessage(lpmhs->hwnd, wmMouseTrack,
                  TRUE, MAKELONG(hwndLast, 0));
            hwndLast = lpmhs->hwnd;
            }
        }

    return CallNextHookEx(hhok, wCode, wParam, lParam);
    }
