// WMASTER.CPP
#define STRICT
#include <windows.h>
#include <windowsx.h>
#include <stdio.h>
#include <string.h>
#include <stdlib.h>

const char globalClassName[] = "WMASTER";

HWND globalEditWnd; 
const DWORD EditStyle = WS_CHILDWINDOW | ES_AUTOHSCROLL
    | ES_AUTOVSCROLL | ES_LEFT | ES_MULTILINE
    | WS_VSCROLL | WS_HSCROLL;

// update edit box 4 times per second
const UINT globalUpdateInterval = 250;

// name of the file we communicate through                                     
char globalPipeFilename[144];
HFILE globalPipeFile;

// for the OS/2 hack: did we activate our window yet
BOOL globalDidActivate = FALSE;

// a fairly simple window proc
LRESULT CALLBACK __export Main_Wnd_Proc (HWND wnd,
    UINT msg, WPARAM wparm, LPARAM lparm )
{
    LRESULT result = 0;
    switch (msg)
    {
      case WM_CREATE:
        // an edit control to put the text in
        globalEditWnd = CreateWindow("edit", "", EditStyle,
           0,0,100,100, wnd, 0, GetWindowInstance(wnd), 0);
        SetWindowFont(globalEditWnd,
           GetStockFont(ANSI_FIXED_FONT), FALSE);
        ShowWindow(globalEditWnd, SW_SHOW);
    // trigger for looking at the pipe file
        SetTimer(wnd, 1, globalUpdateInterval, 0);
        result = 0;
        break;
      case WM_SIZE:
    // make sure the edit window resizes with the frame
        MoveWindow(globalEditWnd, 0, 0, LOWORD(lparm),
           HIWORD(lparm), TRUE);
        break;
      case WM_DESTROY:
        PostQuitMessage(0);
        break;
      case WM_TIMER:
        { 
        // need a new scope to avoid C++ errors
        // add anything new to the buffer
        // simple and stupid - don't bother about edit size limit
        char buf[400];
        UINT readSz;
        BOOL gotData = FALSE;
        while ((readSz = _lread(globalPipeFile, buf, sizeof(buf)-1)) > 0)
           {
           // terminate text and put it into the buffer
           buf[readSz] = '\0';
           Edit_ReplaceSel(globalEditWnd, buf);
           gotData = TRUE;
           }
        // OS/2 hack: if we see some data and we haven't
        // reactivated the window yet, activate it
        if (gotData && !globalDidActivate)
            {
            SetWindowPos(wnd, HWND_TOP, 0, 0, 0, 0,
                SWP_NOSIZE | SWP_NOMOVE);
            globalDidActivate = TRUE;
            }
        }
        break;   
      default:
          result = DefWindowProc(wnd, msg, wparm, lparm);
          break;
    }             
    return result;
}

int PASCAL WinMain(HINSTANCE instance,
    HINSTANCE prev_instance, LPSTR cmd_line, int cmd_show)
{
    // make sure we have work
    if (!*cmd_line) {
        MessageBox(0, "Usage: WMASTER dos-command options...", 0, 
            MB_OK);
        return 1;
    } 
    // get ourselves a 'pipe'
    GetTempFileName(0, "TEST", 0, globalPipeFilename);

    // Win 3.1 OpenFile can't create with a shared mode open
    // so do it in two steps
    globalPipeFile = _lcreat(globalPipeFilename, 0);
    if (globalPipeFile == -1)
    {
        MessageBox(0, "Can't create work file!!", 0, MB_OK);
        exit(2);
    }           
    _lclose(globalPipeFile);
    globalPipeFile = _lopen(globalPipeFilename, READ | OF_SHARE_DENY_NONE);
    if (globalPipeFile == -1)
    {
        MessageBox(0, "Can't re-open work file!!", 0, MB_OK);
        exit(3);
    }
    
    // a window to display the captured text
    if (!prev_instance)
    {
        // make a simple window class
        WNDCLASS wc;
        memset(&wc, 0, sizeof(wc));
        wc.lpfnWndProc = Main_Wnd_Proc;
        wc.hInstance = instance;
        wc.hIcon = LoadIcon(0, IDI_APPLICATION);
        wc.hCursor = LoadCursor(0, IDC_ARROW);
        wc.hbrBackground = HBRUSH(COLOR_WINDOW+1);
        wc.lpszClassName = globalClassName;
        if (!RegisterClass(&wc))
        {
            MessageBox(0, "Can't register window class", NULL,
                MB_ICONSTOP | MB_OK);
            return 1;
        }
    }                    
    HWND wnd = CreateWindow(globalClassName, "Window Master",
        WS_OVERLAPPEDWINDOW, CW_USEDEFAULT, 0,
        CW_USEDEFAULT, 0, 0, 0, instance, 0);
    if (!wnd)
    {
        MessageBox(0, "Can't create window", NULL,
            MB_ICONSTOP | MB_OK);
        return 2;
    }                
    ShowWindow(wnd, cmd_show);

    // start the slave
    char slaveName[256];
    wsprintf(slaveName, "WSLAVE %s %s",
        globalPipeFilename, cmd_line);
    UINT slaveInst = WinExec(slaveName, SW_SHOWMINNOACTIVE);
    if (slaveInst < 32)
    {
        MessageBox(0, "Can't exec", 0, MB_OK);
        return 1;
    }
    // do the normal Windows thing
    MSG msg;
    while (GetMessage(&msg, 0, 0, 0))
    {
        TranslateMessage(&msg);
        DispatchMessage(&msg);
    }
    // clean up
    _lclose(globalPipeFile);
    remove(globalPipeFilename);
    return msg.wParam;
}
