/*****************************************************/
/* teedll.c                                          */
/* -- DLL receives notifications from wddjtee.386    */
/*    and informs client tasks.                      */
/* -- To build: cc -2 -wd -d -DSTRICT teedll.c       */
/*****************************************************/
#include <windows.h>
#include "wddjtee.h"

LPFN_VXD lpfnVxD;    /* VxD entry point. */
HWND     hwndClient; /* Client window. */

void CALLBACK __export
  WddjTeeNotifyProc(WORD nfc, DWORD hvm);
int CALLBACK __export WEP(int wExit);

int CALLBACK LibMain(HINSTANCE hins, WORD ds,
  WORD cbHeap, LPSTR lsz)
/*****************************************************/
/* -- Register with wddjtee.386.                     */
/*****************************************************/
    {
    BOOL fVal = FALSE;

    /* Get VxD entry point. */
    _asm push es;
    _asm push di;
    _asm xor  di, di;
    _asm mov  es, di;
    _asm mov  ax, 0x1684;
    _asm mov  bx, wWddjTeeDeviceId;
    _asm int  0x2f;
    _asm mov  word ptr [lpfnVxD], di;
    _asm mov  word ptr [lpfnVxD + 2], es;
    if (NULL == lpfnVxD)
        goto LExit;

    /* Make sure expected version is installed. */
    _asm mov  ax, apiGetVersion;
    if ((WORD)(*lpfnVxD)() != wWddjTeeVersion)
        goto LExit;

    /* Register notification callback. */
    _asm push cs;
    _asm pop  es;
    _asm mov  di, offset WddjTeeNotifyProc;
    _asm mov  ax, apiRegister;
    (*lpfnVxD)();
    fVal = TRUE;

LExit:
    _asm pop  di;
    _asm pop  es;
    return fVal;
    }

int CALLBACK __export WEP(int wExit)
/*****************************************************/
/* -- Remove notification callback.                  */
/*****************************************************/
    {
    _asm push es;
    _asm xor  ax, ax;
    _asm mov  es, ax;
    _asm mov  di, ax;
    _asm mov  ax, apiRegister;
    (*lpfnVxD)();
    return TRUE;
    }

BOOL CALLBACK __export FRegisterWnd(HWND hwnd)
/*****************************************************/
/* -- Register a window to notify.                   */
/*****************************************************/
    {
    if (NULL == hwndClient)
        {
        hwndClient = hwnd;
        return TRUE;
        }
    return FALSE; /* Someone beat you to it! */
    }

BOOL CALLBACK __export FUnregisterWnd(HWND hwnd)
/*****************************************************/
/* -- Remove a window to notify.                     */
/*****************************************************/
    {
    if (hwndClient == hwnd)
        {
        hwndClient = NULL;
        return TRUE;
        }
    return FALSE;
    }

void CALLBACK __export
WddjTeeNotifyProc(WORD nfc, DWORD hvm)
/*****************************************************/
/* -- Notify all registered windows.                 */
/*****************************************************/
    {
    if (NULL != hwndClient)
        PostMessage(hwndClient, nfc + WM_USER, 0, hvm);
    }

UINT CALLBACK __export CchReadHvm(DWORD hvm,
  LPSTR lprgch)
/*****************************************************/
/* -- Read the output for the given VM.              */
/*****************************************************/
    {
    LPFN_VXD lpfnVxDT = lpfnVxD;
    UINT     cb;

    _asm push ds;
    _asm push es;
    _asm pusha;
    _asm mov  dx, word ptr [hvm + 2];
    _asm mov  bx, word ptr [hvm];
    _asm mov  ds, word ptr [lprgch + 2];
    _asm mov  si, word ptr [lprgch];
    _asm mov  ax, apiRead;
    (*lpfnVxDT)();
    _asm mov  cb, ax;
    _asm popa;
    _asm pop  es;
    _asm pop  ds;
    return cb;
    }
