//--dialog.cpp---------------------------------------------------
// Implements class BDialog, a TDialog descendant that
//
//   o supports modality via TApplication::BeginModal
//   o supports command enabling of controls
//
// Copyright 1993-1994 Robert Arnson
//---------------------------------------------------------------

#define _OWLPCH
#include <owl/owlpch.h>
#include <owl/button.h>
#include "dialog.h"

//
//--class BDialog------------------------------------------------
//

DEFINE_RESPONSE_TABLE1(BDialog, TDialog)
END_RESPONSE_TABLE;

BDialog::BDialog(TWindow* parent,
                 TResId   resId,
                 TModule* module)
  : TDialog(parent, resId, module)
{
  Modality = FALSE;
}

//--Execute, Destroy, and CloseWindow----------------------------
// Support BeginModal-style pseudomodal dialogs
//---------------------------------------------------------------
int
BDialog::Execute(int flags)
{
  //
  // only do BeginModal if an MB_ flag is specified
  //
  if (!flags)
    return TDialog::Execute();

  //
  // create and show (if necessary) the dialog--remember that
  // Create always returns true (or throws an exception)
  //
  Create();
  if (!TWindow::Attr.Style & WS_VISIBLE)
    Show(SW_SHOW);

  //
  // begin modality!
  //
  Modality = TRUE;
  TWindow* modalWindow = flags & (MB_SYSTEMMODAL | MB_TASKMODAL)
                         ? this : Parent;
  return GetApplication()->BeginModal(modalWindow, flags);
}

void
BDialog::Destroy(int retValue)
{
  if (Modality)
    GetApplication()->EndModal(retValue);
  TDialog::Destroy(retValue);
}

void
BDialog::CloseWindow(int retValue)
{
  if (Modality) {
    if (CanClose()) {
      TransferData(tdGetData);
      Destroy(retValue);
    }
  } else
    TDialog::CloseWindow(retValue);
}



//--BButtonEnabler-----------------------------------------------
// Add command enabling for buttons (push buttons, check boxes,
// and radio buttons)--not just menus and gadgets
//---------------------------------------------------------------
class BButtonEnabler : public TCommandEnabler
{
  public:
    BButtonEnabler(TButton* button, HWND hWndReceiver)
      : TCommandEnabler(button->Attr.Id, hWndReceiver)
        { Button = button; }

    void Enable(BOOL enable);
    void SetText(const char far* str);
    void SetCheck(int check);

  protected:
    TButton* Button;
};

void
BButtonEnabler::Enable(BOOL enable)
{
  TCommandEnabler::Enable(enable);
  Button->EnableWindow(enable);
}

void
BButtonEnabler::SetText(const char far* str)
{
  //
  // to prevent flicker, only change the button caption
  // if it's different from the current caption
  //
  int length = Button->GetWindowTextLength() + 1;
  char* text = new char[length];
  Button->GetWindowText(text, length);
  if (strcmp(str, text))
    Button->SetWindowText(str);
  delete [] text;
}

void
BButtonEnabler::SetCheck(int check)
{
  Button->HandleMessage(BM_SETSTYLE, check, MAKELPARAM(TRUE, 0));
  if (check == BS_DEFPUSHBUTTON)
    Button->Parent->HandleMessage(DM_SETDEFID, WPARAM(Button->Attr.Id));
}

//--IdleAction and DoEnabling------------------------------------
// Iterates over child window objects, calling their command
// enablers
//---------------------------------------------------------------
static
void
DoEnabling(TWindow* ctl, void*)
{
  //
  // we'll get called for all child window objects; make sure
  // we only try to enable those derived from TButton
  //
  TButton* button = TYPESAFE_DOWNCAST(ctl, TButton);

  if (button) {
    TWindow* parent = button->Parent;

    //
    // call a command enabler (EV_COMMAND_ENABLE), if it exists
    //
    BButtonEnabler enabler(button, *parent);
    parent->HandleMessage(WM_COMMAND_ENABLE, 0, LPARAM(&enabler));
    //
    // note that we *don't* walk the focus chain or try to defer
    // to the application; I'm assuming that many dialog boxes
    // are going to have the same button IDs (eg, IDOK), so
    // command enabling needs to be localized to the dialog box
    //
    // nor do we disable the command if there isn't a
    // corresponding command handler; you wouldn't always want to
    // have a handler for every single check box or radio button
    // for which you'd constructed an interface object
    //
  }
}

BOOL
BDialog::IdleAction(long idleCount)
{
  if (!idleCount)
    ForEach(DoEnabling);
  return TDialog::IdleAction(idleCount);
}
