/*
 * BUG009E.CPP
 *
 * This program demonstrates a couple of simple C++ programming errors.
 * In foo1(), the programmer has attempted to return a reference to a
 * temporary object.  The temporary's lifetime expires upon the exit
 * from the function, so this is clearly erroneous.  Likewise, in foo2()
 * the programmer has attempted to return a reference to an automatic
 * object, which is also only viable inside foo2().
 *
 * This error is not flagged by Microsoft's Visual C++ compiler, even
 * using /W4, which is supposed to be the maximum warning setting.
 * Borland, Symantec, and Watcom all correctly flag this as an error or
 * warning.
 *
 * This program should produce erroneous output, perhaps looking like
 * this:
 *
 *     i=716 j=716 k=20
 *
 */

#include <stdio.h>

const int &foo1()
{
    return 5;
}

const int &foo2()
{
    int a = 10;
    return a;
}

int foo3()
{
    return 20;
}

main()
{
    const int &i = foo1();
    const int &j = foo2();
    const int k = foo3();
    printf( "i=%d j=%d k=%d\n", i, j, k );
    return 1;
}

