///////////////////////////////////////////////////////
// xnordemo.c                                        //
// -- Program demonstrates XNORing text to the       //
//    screen.                                        //
// -- To build: cc -d -DSTRICT xnordemo.c xnortext.c //
///////////////////////////////////////////////////////
#include <windows.h>
#include "xnortext.h"

static const char szClass[] = "XnorText";

LRESULT CALLBACK __export LwWndProc(HWND hwnd, UINT wm,
  WPARAM wParam, LPARAM lParam);

#ifdef __BORLANDC__
    #pragma argsused
#endif
int PASCAL WinMain(HINSTANCE hins, HINSTANCE hinsPrev,
  LPSTR lpsz, int wShow)
///////////////////////////////////////////////////////
// -- Entry point.                                   //
///////////////////////////////////////////////////////
    {
    HWND    hwnd;
    MSG     msg;

    if (NULL == hinsPrev)
        { // Register main window class.
        WNDCLASS    wcs;

        wcs.style = 0;
        wcs.lpfnWndProc = LwWndProc;
        wcs.cbClsExtra = 0;
        wcs.cbWndExtra = sizeof(HLOCAL);
        wcs.hInstance = hins;
        wcs.hIcon = LoadIcon(NULL, IDI_APPLICATION);
        wcs.hCursor = LoadCursor(NULL, IDC_ARROW);
        wcs.hbrBackground = (HBRUSH)(COLOR_WINDOW + 1);
        wcs.lpszMenuName = NULL;
        wcs.lpszClassName = szClass;
        if (!RegisterClass(&wcs))
            return 0;
        }

    msg.wParam = 0;
    if (NULL != (hwnd = CreateWindow(szClass, szClass,
      WS_OVERLAPPEDWINDOW, CW_USEDEFAULT,
      CW_USEDEFAULT, CW_USEDEFAULT, CW_USEDEFAULT,
      NULL, NULL, hins, NULL)))
        {
        ShowWindow(hwnd, wShow);
        while (GetMessage(&msg, NULL, 0, 0))
            {
            TranslateMessage(&msg);
            DispatchMessage(&msg);
            }
        }

    return msg.wParam;
    }

LRESULT CALLBACK __export LwWndProc(HWND hwnd, UINT wm,
  WPARAM wParam, LPARAM lParam)
///////////////////////////////////////////////////////
// -- Main window procedure.                         //
///////////////////////////////////////////////////////
    {
    switch (wm)
        {
    default:
        break;

    case WM_PAINT: // Just eat the paint.
        {
        PAINTSTRUCT wps;

        BeginPaint(hwnd, &wps);
        EndPaint(hwnd, &wps);
        }
        return FALSE;

    case WM_ERASEBKGND: // Eat the erase background.
        return TRUE;

    case WM_DESTROY:
        PostQuitMessage(0);
        break;

    case WM_LBUTTONDOWN: // Begin dragging the
        {                // rectangle and text.
        RECT    rc;

        rc.left = LOWORD(lParam) - 10;
        rc.top = HIWORD(lParam) - 10;
        rc.right = rc.left + 50;
        rc.bottom = rc.top + 50;
        SetWindowWord(hwnd, 0,
          (WORD)HdriBeginDrag(hwnd, (POINT *)&lParam,
            &rc, "31"));
        }
        break;

    case WM_MOUSEMOVE: // Move the rectangle and text.
        DragDri((HLOCAL)GetWindowWord(hwnd, 0),
          (POINT *)&lParam);
        break;

    case WM_LBUTTONUP: // Nuke the rectangle and text.
        EndDragDri((HLOCAL)GetWindowWord(hwnd, 0),
          (POINT *)&lParam);
        SetWindowWord(hwnd, 0, 0);
        break;
        }

    return DefWindowProc(hwnd, wm, wParam, lParam);
    }
