#include <stdio.h>
#include <io.h>
#include <fcntl.h>
#include <string.h>
#include <memory.h>
#include <stdlib.h>
#include "qprint.h"

/* Global Variables */
char *FileName;
char UserName[50];
int  MaxServers;

int GetUserID(unsigned char ConnectNo, char *userID) {
  struct GetConnectionInfoRequest Request;
  struct GetConnectionInfoReply Reply;
  unsigned int retCode;

  memset(&Request, 0, sizeof(Request));
  Request.BufferLength = sizeof(Request)-2;
  Request.RequestType = GET_USER_ID;
  Request.Connection = ConnectNo;

  memset(&Reply, 0, sizeof(Reply));
  Reply.BufferLength = sizeof(Reply)-2;

  retCode=NetwareInterface(&Request, &Reply, 0xE300);
  strcpy(userID, Reply.ObjectName);
  return retCode;
}

unsigned int CreateJob(unsigned long QueueID) {
  struct CreateJobRequest Request;
  struct CreateJobReply Reply;
  char *rootname;

  rootname = strrchr(FileName, '\\');
  if (rootname==NULL)
    rootname = strrchr(FileName, ':');

  if (rootname==NULL)
    rootname = FileName;
  else
    rootname++;

  memset(&Reply, 0, sizeof(Reply));
  memset(&Request, 0, sizeof(Request));

  /* Set up generic part of job structure */
  Request.BufferLength = sizeof(Request)-2;
  Request.RequestType  = CREATE_JOB;
  Request.QueueID      = QueueID;
  Request.TargetServer  = 0xFFFFFFFF;
  Request.JobType       = 0;
  Request.JobFlags      = 0x10;
  memset(Request.ExecutionTime, 0xFF, 6);
  Request.VersionNumber = 0;
  Request.TabSize       = 8;
  Request.Copies        = SWAPBYTES(1);
  Request.Flags         = NOTIFY_MASK | BANNER_MASK
                          | DEFAULT_MASK;
  Request.MaxLines      = SWAPBYTES(66);
  Request.MaxChars      = SWAPBYTES(132);
  strcpy(Request.FormName, "Standard");
  strcpy(Request.BannerFileName, rootname);
  strcpy(Request.HeaderFileName, rootname);
  strcpy(Request.Description, "Made with QPrint");
  strncpy(Request.Path, FileName, rootname-FileName);
  strcpy(Request.Banner, UserName);
  Reply.BufferLength = sizeof(Reply)-2;

  /* Now submit the job request to NetWare. */
  if (NetwareInterface(&Request, &Reply, 0xE300))
    return 0xFFFF;
  else
    return Reply.JobNumber;
}

int StartJob(unsigned long QueueID,
             unsigned int JobNumber) {
  struct StartJobRequest Request;
  struct StartJobReply Reply;
  unsigned int retCode;

  memset(&Reply, 0, sizeof(Reply));
  memset(&Request, 0, sizeof(Request));
  Request.BufferLength = sizeof(Request)-2;
  Request.RequestType  = START_JOB;
  Request.QueueID      = QueueID;
  Request.JobNumber    = JobNumber;
  Reply.BufferLength   = sizeof(Reply)-2;

  /* Now submit the job request to NetWare. */
  retCode=NetwareInterface(&Request, &Reply, 0xE300);

  if (retCode != 0)
    printf("Start Job error: %i\n", retCode);

  return retCode;
}

unsigned long GetQueueID(char *QueueName) {
  struct GetBinderyIDRequest Request;
  struct GetBinderyIDReply Reply;
  memset(&Reply, 0, sizeof(Reply));
  memset(&Request, 0, sizeof(Request));

  Request.BufferLength = sizeof(Request)-2;
  Request.RequestType  = GET_BINDERY_ID;
  Request.ObjectType   = SWAPBYTES(PRINT_QUEUE);
  Request.NameLength   = strlen(QueueName);
  strcpy(Request.ObjectName, QueueName);
  Reply.BufferLength = sizeof(Reply)-2;

  if (NetwareInterface(&Request, &Reply, 0xE300)==0L)
    return Reply.ObjectID;
  else
    return 0xFFFFFFFF;
}

void CopyFile(int outHandle, int inHandle) {
  char tempBuffer[80];
  int  returnCode;
  do {
     returnCode = read(inHandle, tempBuffer, 80);
     if (returnCode > 0) 
       write(outHandle, tempBuffer, returnCode);

  } while (returnCode > 0);
}

int GetServerConnection(char *serverName) {
  char *FileServerArray, *ConnectInfo;
  int loop;

  ConnectInfo=GetNetwareTable(CONNECT_ID_TABLE);
  FileServerArray=GetNetwareTable(SERVER_NAME_TABLE);

  for (loop=0;loop<MaxServers;loop++) {
    if (ConnectInfo[CONNECT_INFO_SIZE * loop] !=0 &&
        strcmpi(serverName, FileServerArray +
                        (SERVER_NAME_SIZE*loop))==0)
      return loop+1;
  }
  return 0;
}

void ListAllQueues(void) {
  char *FileServerArray, *ConnectInfo;
  int loop;
  struct ScanBinderyRequest Request;
  struct ScanBinderyReply Reply;

  memset(&Reply, 0, sizeof(Reply));
  memset(&Request, 0, sizeof(Request));

  Request.BufferLength = sizeof(Request)-2;
  Request.RequestType  = SCAN_BINDERY;
  Request.ObjectType   = SWAPBYTES(PRINT_QUEUE);
  Request.NameLength   = 48;
  Request.LastObjectID = 0xFFFFFFFF;
  strcpy(Request.ObjectName, "*");
  Reply.BufferLength = sizeof(Reply)-2;

  ConnectInfo=GetNetwareTable(CONNECT_ID_TABLE);
  FileServerArray=GetNetwareTable(SERVER_NAME_TABLE);
  printf("Available print queues are:\n");
  for (loop=0;loop<MaxServers;loop++) {
    if ( *(ConnectInfo+CONNECT_INFO_SIZE*loop)) {
      SetPreferredConnection(loop+1);
      Request.LastObjectID = 0xFFFFFFFF;
      while (NetwareInterface(&Request, &Reply,
                                    0xE300) == 0L) {
        printf("%s\\%s\n", FileServerArray+
          SERVER_NAME_SIZE*loop, Reply.ObjectName);
        Request.LastObjectID = Reply.ObjectID;
      }
    }
  }
}

void main(int argc, char *argv[])
{
  char *QueueName;
  unsigned long QueueID;
  unsigned int JobNumber;
  int inHandle, outHandle, ServerConnection;
  unsigned char ConnID;

  MaxServers = 8; 
  ConnID=GetConnection();  /* Get connection number */
  if ((GetUserID(ConnID, UserName) != 0) ||
     (UserName[0]==0) ) {
    printf("You are not logged in to Novell.\n"); 
    exit(1);
  }

  if (argc != 3 && argc != 4) {
    printf("Usage: Qprint filename queue [Server]\n");
    ListAllQueues();
    exit(1);
  }

  if (argc == 4) {
    ServerConnection=GetServerConnection(argv[3]);
    if (ServerConnection == 0) {
      printf("You're not logged into %s\n", argv[3]);
      exit(1);
    }
    SetPreferredConnection(ServerConnection);
  }

  FileName = argv[1];
  inHandle = open(FileName, O_RDONLY);
  if (inHandle < 0) {
     printf("Could not open file %s\n",FileName);
     exit(1);
  }

  QueueName = argv[2];
  QueueID = GetQueueID(QueueName);
  if (QueueID == 0xFFFFFFFF) {
    printf("Could not find Queue %s.\n",QueueName);
    exit(1);
  }

  JobNumber = CreateJob(QueueID);
  if (JobNumber == 0xFFFF) {
    printf("Could not create job.\n");
    exit(1);
  }

  outHandle = open("NETQ", O_RDWR);
  if (outHandle < 0) {
     printf("Could not open NETQ\n");
     exit(1);
  }

  CopyFile(outHandle, inHandle);
  close(outHandle);
  close(inHandle);
  StartJob(QueueID, JobNumber);
  printf("File %s submitted to queue %s\n", FileName, QueueName);
}

 
