Listing 1: Demonstrating the tellg() bug in Borland's C++ 4.5 runtime
library

//
// This program demonstrates a bug in Borland's C++ 4.5
// run time library.  The program simply sits in a loop
// reading in lines from this source file and sending
// them to cout.  It works properly until you put
// the call to tellg() in the loop.  For some reason,
// tellg() changes the position of the input pointer,
// resulting in mangled output.
//
// To see the bug, compile like this:
//
// bcc bug013.cpp
//
// To see it work properly:
//
// bcc -DNO_BUG bug013.cpp
//
// Note that the bug shows up in both the 16 and 32 bit
// versions of the iostreams library.
//

#include <fstream.h>
#include <stdio.h>

int main()
{
    ifstream input( "bug013.cpp" );

    while ( input ) {
        char line[ 256 ];
        input.getline( line, 256 );
        cout << line << endl;
#if !defined( NO_BUG )
        input.tellg();
#endif
    }
    return 1;
}

