// uart_typ.c - determine type of UART

#include  "uart.h"

unsigned uart_type(unsigned addr)
    {
    unsigned iir;
    outp(addr+SCR, 0x12);
    if (inp(addr+SCR) != 0x12) return(1);   // INS8250-B
    outp(addr+FCR, 0x01);                   // enable FIFOs
    iir = inp(addr+IIR);
    outp(addr+FCR, 0x00);                   // reset FIFOs
    if ((iir & 0xc0) == 0x00) return(2);    // NS16450
    if ((iir & 0xc0) == 0x80) return(3);    // NS16550
    if ((iir & 0xc0) == 0xc0) return(4);    // NS16550A
    return(0);                              // unknown
    }

