/*  magic.c - list ALL serial port I/O addresses,
 *      designations & IRQs. IRQ == -1 implies interrupt
 *      conflict, faulty UART or bad jumper setting
 */
#include <stdio.h>
#include "uart.h"
void main(void)
    {
    unsigned io_addr, count;
    unsigned char irr_isr;
    int irq;
    unsigned char*name[]=
        {
        "Unknown","INS8250-B","NS16450","NS16550","NS16550A"
        };
    for(io_addr=0x0100; io_addr < 0x0400; io_addr += 0x0008)
         if (uart_check(io_addr))
            {
            printf("\nI/O address = %x, name = %s, ",
                io_addr,name[uart_type(io_addr)]);
            // bit-n (from the right) => IRQn
            irr_isr = uart_irq(io_addr);
            irq     = -1;
            for (count=0; irr_isr!=0; irr_isr>>=1, ++irq)
                count += irr_isr&0x01;
            printf("IRQ = %d", (count == 1 ) ? irq : -1);
            }
}
