/*
 * various utilities, like stream readers, error handlers, etc.
 */
#include "passwd.h"
#include <signal.h>

/*
 * determine if password is in the contents of file "name"
 */
int strfp(neg, str, name, fopn, fclo)
int neg;		/* 1 if success on finding line, 0 if not */
char *str;		/* string to be scanned for */
char *name;		/* file or program name */
FILE *(*fopn)();	/* opens stream */
int (*fclo)();		/* closes stream */
{
	char buf[BUFSIZ];		/* buffer for read (output) word */
	FILE *fp;			/* points to (output) stream */
	void (*child)();

	child = signal(SIGCHLD, SIG_IGN);
	/*
	 * open the file or output stream
	 */
	if ((fp = (*fopn)(name, "r")) == FI_NULL){
		sysyyerror(name);
		(void) signal(SIGCHLD, child);
		return(!neg);
	}

	/*
	 * read each line and compare
	 */
	while(mgets(buf, BUFSIZ, fp)){
		if (strncmp(str, buf, pwsig) == 0){
			/*
			 * a match; report success
			 */
			(void) (*fclo)(fp);
			(void) signal(SIGCHLD, child);
			return(neg);
		}
	}

	/*
	 * close the stream; report failure
	 */
	(void) (*fclo)(fp);
	(void) signal(SIGCHLD, child);
	return(!neg);
}

/*
 * determine if password is matched by a string in the contents of file "name"
 */
int patfp(neg, pat, name, fopn, fclo)
int neg;		/* 1 if success on finding line, 0 if not */
char *pat;		/* pattern to be scanned for */
char *name;		/* file or program name */
FILE *(*fopn)();	/* opens stream */
int (*fclo)();		/* closes stream */
{
	char buf[BUFSIZ];		/* buffer for read (output) word */
	FILE *fp;			/* points to (output) stream */
	void (*child)();

	/*
	 * if matching, set up the right routine
	 */
	if (smatch(pat))
		return(neg);

	child = signal(SIGCHLD, SIG_IGN);
	/*
	 * open the file or output stream
	 */
	if ((fp = (*fopn)(name, "r")) == FI_NULL){
		sysyyerror(name);
		(void) signal(SIGCHLD, child);
		return(!neg);
	}

	/*
	 * read each line and compare
	 */
	while(mgets(buf, BUFSIZ, fp)){
		if (match(buf)){
			/*
			 * a match; report success
			 */
			(void) (*fclo)(fp);
			(void) signal(SIGCHLD, child);
			return(neg);
		}
	}

	/*
	 * close the stream; report failure
	 */
	(void) (*fclo)(fp);
	(void) signal(SIGCHLD, child);
	return(!neg);
}

/*
 * determine if password matches a pattern in the contents of file "name"
 */
int patinfp(neg, str, name, fopn, fclo)
int neg;		/* 1 if success on finding line, 0 if not */
char *str;		/* string to be scanned for */
char *name;		/* file or program name */
FILE *(*fopn)();	/* opens stream */
int (*fclo)();		/* closes stream */
{
	char buf[BUFSIZ];		/* buffer for read (output) word */
	FILE *fp;			/* points to (output) stream */
	void (*child)();

	child = signal(SIGCHLD, SIG_IGN);
	/*
	 * open the file or output stream
	 */
	if ((fp = (*fopn)(name, "r")) == FI_NULL){
		sysyyerror(name);
		(void) signal(SIGCHLD, child);
		return(!neg);
	}

	/*
	 * read each line and compare
	 */
	while(mgets(buf, BUFSIZ, fp)){
		if (smatch(buf) == 0 && match(str)){
			/*
			 * a match; report success
			 */
			(void) (*fclo)(fp);
			(void) signal(SIGCHLD, child);
			return(neg);
		}
	}

	/*
	 * close the stream; report failure
	 */
	(void) (*fclo)(fp);
	(void) signal(SIGCHLD, child);
	return(!neg);
}

/*
 * like fgets, but it clobbers the newline and returns 0 on EOF,
 * nonzero on nonEOF; only loads pwsig chars
 */
mgets(buf, n, fp)
char buf[];		/* input goes here */
int n;			/* size of buf[] */
FILE *fp;		/* points to stream being read */
{
	register int c;		/* input character */
	register char *b = buf;	/* walks buffer storing characters */

	/*
	 * load characters until: bufferis full; or EOF is found;
	 * or line ends
	 */
	while(n-- > 1 && (c = getc(fp)) != EOF && c != '\n')
		*b++ = c;
	/*
	 * terminate the input buffer
	 * if ended by EOF, return 0
	 */
	if (n <= 1 || c == '\n')
		*b = '\0';
	else if (c == EOF && b == buf)
		return(0);
	/*
	 * not EOF -- return nonzero
	 */
	return(1);
}

/*
 * get the first line of output from a file or program
 */
firstline(name, buf, nbuf, fopn, fclo)
char *name;			/* file name or program */
char *buf;			/* return buffer */
int nbuf;			/* size of buffer */
FILE *(*fopn)();		/* opens stream */
int (*fclo)();			/* closes stream */
{
	int rval = 1;			/* return value */
	FILE *fp;			/* points to (output) stream */
	void (*child)();

	child = signal(SIGCHLD, SIG_IGN);
	/*
	 * open the file or output stream
	 */
	if ((fp = (*fopn)(name, "r")) == FI_NULL){
		sysyyerror(name);
		(void) signal(SIGCHLD, child);
		return(0);
	}

	/*
	 * read and save first line; error on EOF
	 * otherwise just toss the rest of the lines
	 */
	rval = mgets(buf, nbuf, fp);

	/*
	 * close the stream; report failure
	 */
	(void) (*fclo)(fp);
	(void) signal(SIGCHLD, child);
	return(rval);
}
