/* WINKRNL.H - Miscellaneous prototypes not in WINDOWS.H
 *
 *  Copyright 1992, Cherry Hill Software
 *  All Rights Reserved.
 *
 */

#ifndef WINVER
#define WINVER	0x0300
#endif


/* (Otherwise) Undocumented kernel functions */

extern WORD FAR PASCAL AllocSelectorArray(WORD nSelectors) ;
extern WORD FAR PASCAL AllocCStoDSAlias(WORD selCode) ;
extern DWORD FAR PASCAL SelectorAccessRights(WORD wSel, WORD fSet, WORD
wRights) ;
#if (WINVER == 0x0300)
extern VOID FAR PASCAL SetSelectorBase(WORD wSel, DWORD dwBase) ;
extern VOID FAR PASCAL SetSelectorLimit(WORD wSel, DWORD dwLimit) ;
extern DWORD FAR PASCAL GetSelectorBase(WORD wSel) ;
extern DWORD FAR PASCAL GetSelectorLimit(WORD wSel) ;
#endif

extern FAR _WINFLAGS ;
#define FastGetWinFlags() ((DWORD)(&_WINFLAGS))

extern _AHINCR ;
#define GetHugeSpacing() ((WORD)(&_AHINCR))

/* Pre-defined selectors to real-mode memory */
extern _0000h, _0040h, _A000h, _B000h, _C000h, _D000h, _E000h, _F000h ;
#define GetPtrToSeg(sel) ((VOID FAR *)MAKELONG(0,(WORD)&sel))


/* The following prototypes are from the SYSTEM driver and require the
 * the following IMPORTs in the linker definition file:
 *
 *   IMPORTS
 *	CREATESYSTEMTIMER   = SYSTEM.2
 *	KILLSYSTEMTIMER     = SYSTEM.3
 *	GETSYSTEMMSECCOUNT  = SYSTEM.6
 *
 *  These are available during driver initialization at Windows boot-time.
 */
extern WORD FAR PASCAL CreateSystemTimer(WORD wFreq, FARPROC lpCallback) ;
extern WORD FAR PASCAL KillSystemTimer(WORD wTimerHandle) ;
extern DWORD FAR PASCAL GetSystemMSecCount(VOID) ;
