#ifndef _INC_REGKEY
#define _INC_REGKEY

#define REGKEY_MAX 256

class CRegKey
{
private:
	HKEY 	m_hKey;							// Registration Key HANDLE
	char 	m_SubKey[REGKEY_MAX];			// Name of the sub-key
	char 	m_Value[REGKEY_MAX];			// Contains the key-value

public:
	CRegKey(void);							// Constructor contructs rootkey open
	CRegKey(char *SubKey);					// Constructor contructs subkey of root
	~CRegKey(void);							// Destructor closes m_hKey if open
	BOOL Open(void);						// Open the root key
	BOOL Open(char *SubKey);				// Open a sub-key of the current key
	BOOL Close(void);						// Close the key
	
	char *QueryName( int iSubKey );
	
	// These are QueryValue functions
	char *operator[](int subscript);		// Operator of array like access
	char *QueryValue( void );				// Fetches the value of the open key
	char *QueryValue( char *SubKey );		// Fetches the value of a sub-key of an open key
};

#endif // _INC_REGKEY
