/* - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
** Create a simple polymorphic inheritance mechanism in C++.
*/
#include <iostream.h>
#include <string.h>

class Object
{
public:
	virtual char *GetName() = 0;
	virtual char *FavoriteSaying() = 0;
};

class Devo : public Object
{
private:
	char *FavSaying;
public:
	Devo();
	char *GetName();
	char *FavoriteSaying();
};

Devo::Devo()
{
	FavSaying = "Whip it, into shape.";
};

char *Devo:: GetName()
{
	return "Devo - the Band";
}

char *Devo:: FavoriteSaying()
{
	return FavSaying;
}


class DogCow : public Object
{
private:
	char			DogCowTime[32];
	long 			DogCowArray[33];
public:
	DogCow();
	char *GetName();
	char *FavoriteSaying();
};

DogCow::DogCow()
{
	for (int i=0; i<33; ++i)
		DogCowArray[i] = i;
	strcpy( DogCowTime, "12 MOON" );
}

char *DogCow:: GetName()
{
	return "DogCow - the Maccessory";
}

char *DogCow:: FavoriteSaying()
{
	return "Moof.  Moof.  Moof.";
}


main()
{
Devo *pDevo = new Devo();
DogCow *pDogCow = new DogCow();
	if (pDevo && pDogCow )
		{
	Object *Objects[5];
	int i;													  
		cout << "Invoking virtual methods on pDevo\n";
		cout << pDevo->GetName() << '\n';
		cout << pDevo->FavoriteSaying() << '\n';

		cout << "Invoking virtual methods on DogCow.\n";
		cout << pDogCow->GetName() << '\n';
		cout << pDogCow->FavoriteSaying() << '\n';

		cout << "Putting pDevo and pDogCow into a generic collection.\n";
		Objects[0] = pDevo;
		Objects[1] = pDogCow;
		Objects[2] = pDevo;
		Objects[3] = pDevo;
		Objects[4] = pDogCow;

		cout << "Enumerating GetName over collection.\n";
		for (i=0; i<5; ++i)
			{
			cout << Objects[i]->GetName() << '\n';
			}

		cout << "Enumerating FavoriteSaying over collection.\n";
		for (i=0; i<5; ++i)
			{
			cout << Objects[i]->FavoriteSaying() << '\n';
			}

		delete pDevo;
		delete pDogCow;
		}
	return 0;
}
