/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.client.internal.rest.jersey.subsystem.repository;

import org.sonatype.nexus.client.core.subsystem.repository.HostedRepository;
import org.sonatype.nexus.client.core.subsystem.repository.RepositoryStatus;
import org.sonatype.nexus.client.internal.rest.jersey.subsystem.repository.JerseyRepository;
import org.sonatype.nexus.client.rest.jersey.JerseyNexusClient;
import org.sonatype.nexus.rest.model.RepositoryResource;

public class JerseyHostedRepository<T extends HostedRepository>
extends JerseyRepository<T, RepositoryResource, RepositoryStatus>
implements HostedRepository<T> {
    static final String REPO_TYPE = "hosted";
    static final String PROVIDER_ROLE = "org.sonatype.nexus.proxy.repository.Repository";

    public JerseyHostedRepository(JerseyNexusClient nexusClient, String id) {
        super(nexusClient, id);
    }

    public JerseyHostedRepository(JerseyNexusClient nexusClient, RepositoryResource resource) {
        super(nexusClient, resource);
    }

    @Override
    protected RepositoryResource createSettings() {
        RepositoryResource settings = new RepositoryResource();
        settings.setRepoType(REPO_TYPE);
        settings.setProviderRole(PROVIDER_ROLE);
        settings.setExposed(true);
        settings.setWritePolicy("ALLOW_WRITE_ONCE");
        settings.setBrowseable(true);
        settings.setIndexable(false);
        settings.setRepoPolicy("MIXED");
        return settings;
    }

    private T me() {
        return (T)this;
    }

    @Override
    public T withRepoPolicy(String policy) {
        ((RepositoryResource)this.settings()).setRepoPolicy(policy);
        return this.me();
    }

    @Override
    public T readOnly() {
        ((RepositoryResource)this.settings()).setWritePolicy("READ_ONLY");
        return this.me();
    }

    @Override
    public T allowRedeploy() {
        ((RepositoryResource)this.settings()).setWritePolicy("ALLOW_WRITE");
        return this.me();
    }

    @Override
    public T disableRedeploy() {
        ((RepositoryResource)this.settings()).setWritePolicy("ALLOW_WRITE_ONCE");
        return this.me();
    }

    @Override
    public T enableBrowsing() {
        ((RepositoryResource)this.settings()).setBrowseable(true);
        return this.me();
    }

    @Override
    public T disableBrowsing() {
        ((RepositoryResource)this.settings()).setBrowseable(false);
        return this.me();
    }

    @Override
    public boolean isBrowsable() {
        return ((RepositoryResource)this.settings()).isBrowseable();
    }
}

