/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.maven.staging.workflow;

import com.sonatype.nexus.staging.api.dto.StagingActionDTO;
import com.sonatype.nexus.staging.client.StagingWorkflowV2Service;
import com.sonatype.nexus.staging.client.StagingWorkflowV3Service;
import java.util.Arrays;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Mojo;
import org.sonatype.nexus.maven.staging.StagingAction;
import org.sonatype.nexus.maven.staging.workflow.AbstractStagingBuildActionMojo;

@Mojo(name="release", requiresOnline=true)
public class ReleaseStageRepositoryMojo
extends AbstractStagingBuildActionMojo {
    @Override
    public void doExecute(StagingWorkflowV2Service stagingWorkflow) throws MojoExecutionException, MojoFailureException {
        this.getLog().info((CharSequence)("Releasing staging repository with IDs=" + Arrays.toString(this.getStagingRepositoryIds())));
        String description = this.getDescriptionWithDefaultsForAction(StagingAction.RELEASE);
        if (stagingWorkflow instanceof StagingWorkflowV3Service) {
            StagingWorkflowV3Service v3 = (StagingWorkflowV3Service)stagingWorkflow;
            StagingActionDTO action = new StagingActionDTO();
            action.setDescription(description);
            action.setStagedRepositoryIds(Arrays.asList(this.getStagingRepositoryIds()));
            action.setAutoDropAfterRelease(this.isAutoDropAfterRelease());
            v3.releaseStagingRepositories(action);
        } else {
            stagingWorkflow.releaseStagingRepositories(description, this.getStagingRepositoryIds());
        }
        this.getLog().info((CharSequence)"Released");
    }
}

