/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.scm.provider.git.util;

import java.io.File;
import java.io.IOException;
import java.io.Reader;
import org.apache.maven.scm.providers.gitlib.settings.Settings;
import org.apache.maven.scm.providers.gitlib.settings.io.xpp3.GitXpp3Reader;
import org.codehaus.plexus.util.ReaderFactory;
import org.codehaus.plexus.util.xml.pull.XmlPullParserException;

public class GitUtil {
    protected static final String GIT_SETTINGS_FILENAME = "git-settings.xml";
    public static final File DEFAULT_SETTINGS_DIRECTORY;
    private static File settingsDirectory;
    private static Settings settings;

    private GitUtil() {
    }

    public static Settings getSettings() {
        if (settings == null) {
            settings = GitUtil.readSettings();
        }
        return settings;
    }

    public static Settings readSettings() {
        File settingsFile = GitUtil.getSettingsFile();
        if (settingsFile.exists()) {
            GitXpp3Reader reader = new GitXpp3Reader();
            try {
                return reader.read((Reader)ReaderFactory.newXmlReader((File)settingsFile));
            }
            catch (IOException iOException) {
            }
            catch (XmlPullParserException e) {
                String message = settingsFile.getAbsolutePath() + " isn't well formed. SKIPPED." + e.getMessage();
                System.err.println(message);
            }
        }
        return new Settings();
    }

    public static void setSettingsDirectory(File directory) {
        settingsDirectory = directory;
        settings = GitUtil.readSettings();
    }

    public static File getSettingsFile() {
        return new File(settingsDirectory, GIT_SETTINGS_FILENAME);
    }

    static {
        settingsDirectory = DEFAULT_SETTINGS_DIRECTORY = new File(System.getProperty("user.home"), ".scm");
    }
}

