/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.client.internal.rest.jersey.subsystem.repository;

import javax.inject.Named;
import javax.inject.Singleton;
import org.sonatype.nexus.client.core.spi.subsystem.repository.RepositoryFactory;
import org.sonatype.nexus.client.core.subsystem.repository.HostedRepository;
import org.sonatype.nexus.client.core.subsystem.repository.Repository;
import org.sonatype.nexus.client.internal.rest.jersey.subsystem.repository.JerseyHostedRepository;
import org.sonatype.nexus.client.rest.jersey.JerseyNexusClient;
import org.sonatype.nexus.rest.model.RepositoryBaseResource;
import org.sonatype.nexus.rest.model.RepositoryResource;

@Named
@Singleton
public class JerseyHostedRepositoryFactory
implements RepositoryFactory<HostedRepository> {
    @Override
    public int canAdapt(RepositoryBaseResource resource) {
        int score = 0;
        if (resource instanceof RepositoryResource) {
            ++score;
        }
        if ("hosted".equals(resource.getRepoType())) {
            ++score;
        }
        return score;
    }

    @Override
    public JerseyHostedRepository adapt(JerseyNexusClient nexusClient, RepositoryBaseResource resource) {
        return new JerseyHostedRepository(nexusClient, (RepositoryResource)resource);
    }

    @Override
    public boolean canCreate(Class<? extends Repository> type) {
        return HostedRepository.class.equals(type);
    }

    @Override
    public JerseyHostedRepository create(JerseyNexusClient nexusClient, String id) {
        return new JerseyHostedRepository(nexusClient, id);
    }
}

