/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.spice.zapper.client.hc4;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collections;
import java.util.List;
import org.apache.http.entity.AbstractHttpEntity;
import org.sonatype.spice.zapper.codec.Codec;
import org.sonatype.spice.zapper.internal.Check;
import org.sonatype.spice.zapper.internal.Payload;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ZapperEntity
extends AbstractHttpEntity {
    private final Payload payload;
    private final List<Codec> codecs;
    private final int BUFFER_SIZE = 2048;

    public ZapperEntity(Payload payload) {
        this(payload, Collections.emptyList());
    }

    public ZapperEntity(Payload payload, List<Codec> codecs) {
        this.payload = Check.notNull(payload, Payload.class);
        this.codecs = Check.notNull(codecs, Codec.class);
    }

    public boolean isRepeatable() {
        return true;
    }

    public long getContentLength() {
        if (this.codecs.isEmpty()) {
            return this.payload.getLength();
        }
        return -1L;
    }

    public InputStream getContent() throws IOException, IllegalStateException {
        return this.payload.getContent();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeTo(OutputStream _outstream) throws IOException {
        block8: {
            InputStream instream = this.getContent();
            OutputStream outstream = _outstream;
            for (Codec codec : this.codecs) {
                outstream = codec.encode(outstream);
            }
            try {
                int l;
                byte[] buffer = new byte[2048];
                if (this.getContentLength() < 0L) {
                    int l2;
                    while ((l2 = instream.read(buffer)) != -1) {
                        outstream.write(buffer, 0, l2);
                    }
                    break block8;
                }
                for (long remaining = this.getContentLength(); remaining > 0L; remaining -= (long)l) {
                    l = instream.read(buffer, 0, (int)Math.min(2048L, remaining));
                    if (l == -1) {
                        break;
                    }
                    outstream.write(buffer, 0, l);
                }
            }
            finally {
                outstream.close();
                instream.close();
            }
        }
    }

    public boolean isStreaming() {
        return false;
    }
}

