#!/bin/bash

#   .
# Ʈ Ű.

ROOT_UID=0         # Ʈ $UID  0.
E_WRONG_USER=65    # Ʈ ƴ.

FILE=/swap
BLOCKSIZE=1024
MINBLOCKS=40
SUCCESS=0

if [ "$UID" -ne "$ROOT_UID" ]
then
  echo; echo " ũƮ Ʈ ų  ֽϴ."; echo
  exit $E_WRONG_USER
fi  
  

if [ -n "$1" ]
then
  blocks=$1
else
  blocks=$MINBLOCKS              # ɾٿ    
fi                               # 40  ⺻ Ʈ.

if [ "$blocks" -lt $MINBLOCKS ]
then
  blocks=$MINBLOCKS              # ּ 40 ̾ ˴ϴ.
fi  


echo "Creating swap file of size $blocks blocks (KB)."
dd if=/dev/zero of=$FILE bs=$BLOCKSIZE count=$blocks  # Zero out file.

mkswap $FILE $blocks             # Designate it a swap file.
swapon $FILE                     # Activate swap file.

echo "Swap file created and activated."

exit $SUCCESS
