#!/bin/bash
# sieve.sh

# 佺׳׽ ü(Sieve of Erastosthenes)
# Ҽ ãִ  ˰.

#  ũƮ Ȱ C α׷     մϴ.

LOWER_LIMIT=1       # 1 .
UPPER_LIMIT=1000    # 1000 .
# (ð ü   ٸ     Ƶ ˴ϴ.)

PRIME=1
NON_PRIME=0

let SPLIT=UPPER_LIMIT/2
# ȭ:
#  Ѱ ݸ Ȯ    ʿ.


declare -a Primes
# Primes[]  迭.


initialize ()
{
# 迭 ʱȭ.

i=$LOWER_LIMIT
until [ "$i" -gt "$UPPER_LIMIT" ]
do
  Primes[i]=$PRIME
  let "i += 1"
done
# ˰   迭   (Ҽ) .
}

print_primes ()
{
# Primes[]  Ҽ  ͵ ݴϴ.

i=$LOWER_LIMIT

until [ "$i" -gt "$UPPER_LIMIT" ]
do

  if [ "${Primes[i]}" -eq "$PRIME" ]
  then
    printf "%8d" $i
    # ڴ 8 ĭ ༭ ڰ ݴϴ.
  fi
  
  let "i += 1"
  
done

}

sift () # Ҽ ƴ  ɷϴ.
{

let i=$LOWER_LIMIT+1
# 1  Ҽ  ˰ , 2  մϴ.

until [ "$i" -gt "$UPPER_LIMIT" ]
do

if [ "${Primes[i]}" -eq "$PRIME" ]
# ̹ ɷ (Ҽ ƴ ) ǳʶݴϴ.
then

  t=$i

  while [ "$t" -le "$UPPER_LIMIT" ]
  do
    let "t += $i "
    Primes[t]=$NON_PRIME
    #   Ҽ ƴ϶ ǥմϴ.
  done

fi  

  let "i += 1"
done  


}


# Լ  θϴ.
initialize
sift
print_primes
# ̷ ٷ  α׷̶ Ѵϴ.

echo

exit 0



# ----------------------------------------------- #
#  ڵ  ʽϴ.

# ̰ Stephane Chazelas     ӵ   ϴ.

# Ҽ ִ Ѱ踦 ɾٿ  ־ ˴ϴ.

UPPER_LIMIT=$1                  # ɾٿ Է.
let SPLIT=UPPER_LIMIT/2         # ִ ߰.

Primes=( '' $(seq $UPPER_LIMIT) )

i=1
until (( ( i += 1 ) > SPLIT ))  # ߰ Ȯ ʿ.
do
  if [[ -n $Primes[i] ]]
  then
    t=$i
    until (( ( t += i ) > UPPER_LIMIT ))
    do
      Primes[t]=
    done
  fi  
done  
echo ${Primes[*]}

exit 0
