# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from msrest.serialization import Model


class OperationListResult(Model):
    """Result of the request to list Media Services operations.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar value: List of Media Services operations supported by the
     Microsoft.Media resource provider.
    :vartype value: list of :class:`Operation
     <azure.mgmt.media.models.Operation>`
    :ivar next_link: URL to get the next set of operation list results if
     there are any.
    :vartype next_link: str
    """

    _validation = {
        'value': {'readonly': True},
        'next_link': {'readonly': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[Operation]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(self):
        self.value = None
        self.next_link = None
