# -*- coding: utf-8 -*-
info = {
    "name": "ml",
    "date_order": "DMY",
    "january": [
        "ജനുവരി",
        "ജനു"
    ],
    "february": [
        "ഫെബ്രുവരി",
        "ഫെബ്രു"
    ],
    "march": [
        "മാർച്ച്",
        "മാർ"
    ],
    "april": [
        "ഏപ്രിൽ",
        "ഏപ്രി"
    ],
    "may": [
        "മേയ്"
    ],
    "june": [
        "ജൂൺ"
    ],
    "july": [
        "ജൂലൈ"
    ],
    "august": [
        "ഓഗസ്റ്റ്",
        "ഓഗ"
    ],
    "september": [
        "സെപ്റ്റംബർ",
        "സെപ്റ്റം"
    ],
    "october": [
        "ഒക്‌ടോബർ",
        "ഒക്ടോ"
    ],
    "november": [
        "നവംബർ",
        "നവം"
    ],
    "december": [
        "ഡിസംബർ",
        "ഡിസം"
    ],
    "monday": [
        "തിങ്കളാഴ്‌ച",
        "തിങ്കൾ"
    ],
    "tuesday": [
        "ചൊവ്വാഴ്‌ച",
        "ചൊവ്വ",
        "ചൊവ്വാഴ്ച"
    ],
    "wednesday": [
        "ബുധനാഴ്‌ച",
        "ബുധൻ"
    ],
    "thursday": [
        "വ്യാഴാഴ്‌ച",
        "വ്യാഴം"
    ],
    "friday": [
        "വെള്ളിയാഴ്‌ച",
        "വെള്ളി"
    ],
    "saturday": [
        "ശനിയാഴ്‌ച",
        "ശനി"
    ],
    "sunday": [
        "ഞായറാഴ്‌ച",
        "ഞായർ"
    ],
    "am": [
        "am"
    ],
    "pm": [
        "pm"
    ],
    "year": [
        "വർഷം",
        "വ"
    ],
    "month": [
        "മാസം",
        "മാ"
    ],
    "week": [
        "ആഴ്ച",
        "ആ"
    ],
    "day": [
        "ദിവസം"
    ],
    "hour": [
        "മണിക്കൂർ",
        "മ"
    ],
    "minute": [
        "മിനിറ്റ്",
        "മി"
    ],
    "second": [
        "സെക്കൻഡ്",
        "സെ"
    ],
    "relative-type": {
        "1 year ago": [
            "കഴിഞ്ഞ വർഷം"
        ],
        "0 year ago": [
            "ഈ വർ‌ഷം"
        ],
        "in 1 year": [
            "അടുത്തവർഷം"
        ],
        "1 month ago": [
            "കഴിഞ്ഞ മാസം"
        ],
        "0 month ago": [
            "ഈ മാസം"
        ],
        "in 1 month": [
            "അടുത്ത മാസം"
        ],
        "1 week ago": [
            "കഴിഞ്ഞ ആഴ്‌ച"
        ],
        "0 week ago": [
            "ഈ ആഴ്ച"
        ],
        "in 1 week": [
            "അടുത്ത ആഴ്ച"
        ],
        "1 day ago": [
            "ഇന്നലെ"
        ],
        "0 day ago": [
            "ഇന്ന്"
        ],
        "in 1 day": [
            "നാളെ"
        ],
        "0 hour ago": [
            "ഈ മണിക്കൂറിൽ"
        ],
        "0 minute ago": [
            "ഈ മിനിറ്റിൽ"
        ],
        "0 second ago": [
            "ഇപ്പോൾ"
        ]
    },
    "relative-type-regex": {
        "in \\1 year": [
            "(\\d+) വർഷത്തിൽ"
        ],
        "\\1 year ago": [
            "(\\d+) വർഷം മുമ്പ്"
        ],
        "in \\1 month": [
            "(\\d+) മാസത്തിൽ"
        ],
        "\\1 month ago": [
            "(\\d+) മാസം മുമ്പ്"
        ],
        "in \\1 week": [
            "(\\d+) ആഴ്ചയിൽ"
        ],
        "\\1 week ago": [
            "(\\d+) ആഴ്ച മുമ്പ്"
        ],
        "in \\1 day": [
            "(\\d+) ദിവസത്തിൽ"
        ],
        "\\1 day ago": [
            "(\\d+) ദിവസം മുമ്പ്"
        ],
        "in \\1 hour": [
            "(\\d+) മണിക്കൂറിൽ"
        ],
        "\\1 hour ago": [
            "(\\d+) മണിക്കൂർ മുമ്പ്"
        ],
        "in \\1 minute": [
            "(\\d+) മിനിറ്റിൽ"
        ],
        "\\1 minute ago": [
            "(\\d+) മിനിറ്റ് മുമ്പ്"
        ],
        "in \\1 second": [
            "(\\d+) സെക്കൻഡിൽ"
        ],
        "\\1 second ago": [
            "(\\d+) സെക്കൻഡ് മുമ്പ്"
        ]
    },
    "locale_specific": {},
    "skip": [
        " ",
        ".",
        ",",
        ";",
        "-",
        "/",
        "'",
        "|",
        "@",
        "[",
        "]",
        "，"
    ]
}