# Node Foundation CTC Meeting 2016-06-15

## Links

* **Audio Recording**: https://www.youtube.com/watch?v=qWX8i9SKatQ
* **GitHub Issue**: https://github.com/nodejs/node/issues/7307
* **Minutes Google Doc**: <https://docs.google.com/document/d/1e7JdFHVtMtW9_o0Gi3NNz6g7TK50q4u9LYKFzBeHOQ8>
* _Previous Minutes Google Doc: <https://docs.google.com/document/d/1G_sywyzJFPDzLv-KiG21L_4cIAP9_awQnP00ox8Nyiw>_

## Present

* Bradley Meck @bmeck (observer/GoDaddy)
* Сковорода Никита Андреевич @ChALkeR (CTC)
* Chris Dickinson @chrisdickinson (CTC)
* Evan Lucas @evanlucas (CTC)
* Jeremiah Senkpiel @Fishrock123 (CTC)
* John-David Dalton @jdalton (observer/Microsoft)
* Josh Gavant @joshgav (observer/Microsoft)
* Michael Dawson @mhdawson (CTC)
* Brian White @mscdex (CTC)
* Ali Ijaz Sheikh @ofrobots (CTC)
* Alexis Campailla @orangemocha (CTC)
* Rod Vagg @rvagg (CTC)
* Rich Trott @Trott (CTC)
* Trevor Norris @trevnorris (CTC)

## Agenda

Extracted from **ctc-agenda** labelled issues and pull requests from the **nodejs org** prior to the meeting.

### nodejs/node

* url: return valid file: urls fom url.format() [#7234](https://github.com/nodejs/node/pull/7234)
* http: don't inherit from Object.prototype [#6102](https://github.com/nodejs/node/pull/6102)

### Standup

* Bradley Meck @bmeck
    * fleshing out a proposal for if we could disambiguate the grammars for Script and Module.

* Сковорода Никита Андреевич @ChALkeR (CTC)
    * some issue/PRs reviews

* Chris Dickinson @chrisdickinson (CTC)
      * NodeConf
      * modules.guide

* Evan Lucas @evanlucas (CTC)
    * Preparing for security release

* Jeremiah Senkpiel @Fishrock123 (CTC)
    * (Previous week: fixed the primary OS X stdio bug)
    * NodeConf

* Fedor Indutny @indutny (CTC)
    * fixing bugs, reviewing PRs, working on llnode

* Josh Gavant @joshgav
    * debug protocol stuff

* Michael Dawson @mhdawson (CTC)
    * Still chasing PPC machine issues
    * AIX/malloc(0) issue
    * ABI stable module API work with Stefan/Ian, filling in Nan examples
    * Input on some benchmarking related PRs
    * Other misc reviews/lands
    * Keeping up with issues

* Brian White @mscdex (CTC)
    * Landed some old PRs
    * Submitting PRs to fix some regressions
    * Reviewed PRs and issues

* Ali Ijaz Sheikh @ofrobots (CTC)
    * More work on v8_inspector
    * Starting to look at backporting some V8 fixes for LTS

* Alexis Campailla @orangemocha (CTC)
    * Landed a fix for node-gyp, broke with VS update 3

* Rod Vagg @rvagg (CTC)
    * Alpine Linux in CI
    * Security release hoo haa
    * Reviews & discussions
    * Electron / Node relationship
    * New CTC repo
    * Jenkins upkeep

* Rich Trott @Trott (CTC)
    * Setting up the next onboarding
    * Facilitated a session on releases at NodeConf. Will share notes with Build WG, LTS WG, and people who can sign releases.

* Trevor Norris @trevnorris (CTC)
    * Finished updating AsyncWrap EP and now investigating proposed implementation.
    * Helping identify old issue in Atom editor in regards to writing to disk.


### Review of last meeting  
* Tracking issue: stdio problems [#6980](https://github.com/nodejs/node/issues/6980)
* module: expose `Module._runInThisContext` [#6288](https://github.com/nodejs/node/pull/6288)


## Minutes


### url: return valid file: urls from url.format() [#7234](https://github.com/nodejs/node/pull/7234)

@trott: semver-major change, needs approval from CTC.
Real fix will be @jasnell’s HTTP compliance work.

In browsers `file:/home/joshgav/myfile.txt` is auto-corrected to `file:///home/joshgav/myfile.txt` (i.e. slashes are prepended to the path and hostname is an empty string). This change institutes the same in Node.js.

Are there other protocols which require additional slashes (`//`) if hostname isn’t specified? Yes, but hard to heuristically determine if needed.


### http: don't inherit from Object.prototype [#6102](https://github.com/nodejs/node/pull/6102)

Replace headers object ({}) in req/res with StorageObject, which doesn’t delegate to Object.prototype. But this will break anyone using regular `Object` methods on header props.

@trevnorris: Why don’t we intercept calls to properties with checks to an internal dictionary of actual headers? If the key isn’t there, then try to call Object.prototype.

How would that effect perf?

It’s the right decision because otherwise can’t use headers with certain names like `__proto__`.

Better to do a deprecation cycle. How? Insert something (proxy) between actual call to property, would issue deprecation warning first. This would be temporary, eventually this interceptor/proxy would go away.


### ES6 Modules [node-eps/002-es6-modules.md](https://github.com/nodejs/node-eps/blob/master/002-es6-modules.md)

Need to disambiguate ES6 modules and regular scripts (which include CJS modules). Cannot determine if file is module, script, etc. from code itself. For this reason Node decided to use `.mjs` extension for ES6 modules.

New proposal: If `import` or `export` keywords are in module code, then use module goal. So no need for extra metadata or file extension. But would have to parse file to check for presence of these keywords.

https://github.com/bmeck/UnambiguousJavaScriptGrammar
replaces https://github.com/nodejs/node-eps/blob/master/002-es6-modules.md#51-determining-if-source-is-an-es-module

This would be part of ECMA262 so browsers would do the same, but needs to be ironed out in TC39. On [agenda][TC39 Agenda] for 7/26 TC39 meeting.

What if nothing is imported or exported? Could do `export default null` to export nothing.

Starting off, preferred goal when preparing code would be CommonJS/script, later on could change to ES6/module.

Caching is more feasible.

Provides more seamless flow from CJS to ES6 in the future.

Will packaging tools need to implement parsing logic too to package properly? Yes, but there are possibilities listed in the repo.

What other differences between scripts and modules?
- `await` keyword only in modules according to ECMA262
- `modules.root` in package.json is intended to allow mirrored directory structure for use with ES6; but technically all it does is redirect file system calls and it could be used for other purposes, so it’s not reliable.

Purpose of modules.root - allows redirection within a module, e.g. `module/file.js` doesn’t necessarily resolve to `./file.js` within the directory, could be redirected to `${module.root}/file.js`. This allows side-by-side CJS and ES6 among other things.

What about for human reading? How can people differentiate at a glance between CJS and ES6?
- `import`’s are generally at the top, `export`s at the bottom. If you see `import` it’s an ES6 module.

How are browsers dealing with this? Older browsers which encounter `<script type=”module”>` and don’t recognize the type will skip it. Loading is asynchronous by default.

Are browsers concerned about transition period from CJS to ES6? How do they load older scripts, e.g. jQuery?

**Should Node move this forward as alternative to `.mjs` proposal?**

TBD. What does TC39 think of this? It’s on agenda for next F2F (see above).


### Q/A on public fora
None.

## Next Meeting
2016-06-22

[TC39 Agenda]: https://github.com/tc39/agendas/blob/master/2016/07.md
