/*
 * Copyright (c) 2003, 2007-14 Matteo Frigo
 * Copyright (c) 2003, 2007-14 Massachusetts Institute of Technology
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 *
 */

/* This file was automatically generated --- DO NOT EDIT */
/* Generated on Sat Jul 30 16:46:08 EDT 2016 */

#include "codelet-rdft.h"

#ifdef HAVE_FMA

/* Generated by: ../../../genfft/gen_r2cf.native -fma -reorder-insns -schedule-for-pipeline -compact -variables 4 -pipeline-latency 4 -n 64 -name r2cf_64 -include r2cf.h */

/*
 * This function contains 394 FP additions, 196 FP multiplications,
 * (or, 198 additions, 0 multiplications, 196 fused multiply/add),
 * 133 stack variables, 15 constants, and 128 memory accesses
 */
#include "r2cf.h"

static void r2cf_64(R *R0, R *R1, R *Cr, R *Ci, stride rs, stride csr, stride csi, INT v, INT ivs, INT ovs)
{
     DK(KP773010453, +0.773010453362736960810906609758469800971041293);
     DK(KP995184726, +0.995184726672196886244836953109479921575474869);
     DK(KP098491403, +0.098491403357164253077197521291327432293052451);
     DK(KP820678790, +0.820678790828660330972281985331011598767386482);
     DK(KP956940335, +0.956940335732208864935797886980269969482849206);
     DK(KP881921264, +0.881921264348355029712756863660388349508442621);
     DK(KP534511135, +0.534511135950791641089685961295362908582039528);
     DK(KP303346683, +0.303346683607342391675883946941299872384187453);
     DK(KP980785280, +0.980785280403230449126182236134239036973933731);
     DK(KP198912367, +0.198912367379658006911597622644676228597850501);
     DK(KP831469612, +0.831469612302545237078788377617905756738560812);
     DK(KP668178637, +0.668178637919298919997757686523080761552472251);
     DK(KP923879532, +0.923879532511286756128183189396788286822416626);
     DK(KP414213562, +0.414213562373095048801688724209698078569671875);
     DK(KP707106781, +0.707106781186547524400844362104849039284835938);
     {
	  INT i;
	  for (i = v; i > 0; i = i - 1, R0 = R0 + ivs, R1 = R1 + ivs, Cr = Cr + ovs, Ci = Ci + ovs, MAKE_VOLATILE_STRIDE(256, rs), MAKE_VOLATILE_STRIDE(256, csr), MAKE_VOLATILE_STRIDE(256, csi)) {
	       E T5n, T5o;
	       {
		    E T11, T2j, T4P, T5P, T3D, T5p, T3d, Tf, T1k, T1H, T5D, T4l, T5A, T4a, T3i;
		    E T2U, T1R, T2e, T5K, T4G, T5H, T4v, T3l, T31, T5s, T42, T5t, T3Z, T2n, T1b;
		    E T3f, TZ, T5v, T3T, T5w, T3Q, T2m, T18, T3e, TK, T3K, T5Q, T4S, T5q, T14;
		    E T2k, T3p, Tu, T4w, T1U, T5E, T4h, T5B, T4o, T3j, T2X, T1I, T1z, T1Z, T4A;
		    E T24, T4x, T1X, T20;
		    {
			 E TN, T3V, TS, TX, T3X, TQ, T40, TT;
			 {
			      E T1g, T46, T1B, T1G, T47, T1j, T4j, T1C;
			      {
				   E T4, T3z, T3, T3B, Td, T5, T8, T9;
				   {
					E T1, T2, Tb, Tc;
					T1 = R0[0];
					T2 = R0[WS(rs, 16)];
					Tb = R0[WS(rs, 28)];
					Tc = R0[WS(rs, 12)];
					T4 = R0[WS(rs, 8)];
					T3z = T1 - T2;
					T3 = T1 + T2;
					T3B = Tb - Tc;
					Td = Tb + Tc;
					T5 = R0[WS(rs, 24)];
					T8 = R0[WS(rs, 4)];
					T9 = R0[WS(rs, 20)];
				   }
				   {
					E T1E, T1F, T1h, T1i;
					{
					     E T1e, T4N, T6, T3A, Ta, T1f;
					     T1e = R1[0];
					     T4N = T4 - T5;
					     T6 = T4 + T5;
					     T3A = T8 - T9;
					     Ta = T8 + T9;
					     T1f = R1[WS(rs, 16)];
					     {
						  E T7, T3C, T4O, Te;
						  T11 = T3 - T6;
						  T7 = T3 + T6;
						  T3C = T3A + T3B;
						  T4O = T3B - T3A;
						  T2j = Td - Ta;
						  Te = Ta + Td;
						  T4P = FNMS(KP707106781, T4O, T4N);
						  T5P = FMA(KP707106781, T4O, T4N);
						  T3D = FMA(KP707106781, T3C, T3z);
						  T5p = FNMS(KP707106781, T3C, T3z);
						  T3d = T7 - Te;
						  Tf = T7 + Te;
						  T1g = T1e + T1f;
						  T46 = T1e - T1f;
					     }
					}
					T1E = R1[WS(rs, 4)];
					T1F = R1[WS(rs, 20)];
					T1h = R1[WS(rs, 8)];
					T1i = R1[WS(rs, 24)];
					T1B = R1[WS(rs, 28)];
					T1G = T1E + T1F;
					T47 = T1E - T1F;
					T1j = T1h + T1i;
					T4j = T1h - T1i;
					T1C = R1[WS(rs, 12)];
				   }
			      }
			      {
				   E T1N, T4r, T28, T2d, T4s, T1Q, T4E, T29;
				   {
					E T2b, T2c, T1O, T1P;
					{
					     E T2S, T48, T1D, T1L, T1M, T4k, T49, T2T;
					     T1L = R1[WS(rs, 31)];
					     T1M = R1[WS(rs, 15)];
					     T2S = T1g + T1j;
					     T1k = T1g - T1j;
					     T48 = T1B - T1C;
					     T1D = T1B + T1C;
					     T1N = T1L + T1M;
					     T4r = T1L - T1M;
					     T4k = T47 - T48;
					     T49 = T47 + T48;
					     T2T = T1G + T1D;
					     T1H = T1D - T1G;
					     T5D = FNMS(KP707106781, T4k, T4j);
					     T4l = FMA(KP707106781, T4k, T4j);
					     T5A = FNMS(KP707106781, T49, T46);
					     T4a = FMA(KP707106781, T49, T46);
					     T3i = T2S - T2T;
					     T2U = T2S + T2T;
					     T2b = R1[WS(rs, 3)];
					     T2c = R1[WS(rs, 19)];
					}
					T1O = R1[WS(rs, 7)];
					T1P = R1[WS(rs, 23)];
					T28 = R1[WS(rs, 27)];
					T2d = T2b + T2c;
					T4s = T2b - T2c;
					T1Q = T1O + T1P;
					T4E = T1P - T1O;
					T29 = R1[WS(rs, 11)];
				   }
				   {
					E TV, TW, TO, TP;
					{
					     E T2Z, T4t, T2a, TL, TM, T4F, T4u, T30;
					     TL = R0[WS(rs, 31)];
					     TM = R0[WS(rs, 15)];
					     T2Z = T1N + T1Q;
					     T1R = T1N - T1Q;
					     T4t = T28 - T29;
					     T2a = T28 + T29;
					     TN = TL + TM;
					     T3V = TL - TM;
					     T4F = T4t - T4s;
					     T4u = T4s + T4t;
					     T30 = T2d + T2a;
					     T2e = T2a - T2d;
					     T5K = FNMS(KP707106781, T4F, T4E);
					     T4G = FMA(KP707106781, T4F, T4E);
					     T5H = FNMS(KP707106781, T4u, T4r);
					     T4v = FMA(KP707106781, T4u, T4r);
					     T3l = T2Z - T30;
					     T31 = T2Z + T30;
					     TV = R0[WS(rs, 27)];
					     TW = R0[WS(rs, 11)];
					}
					TO = R0[WS(rs, 7)];
					TP = R0[WS(rs, 23)];
					TS = R0[WS(rs, 3)];
					TX = TV + TW;
					T3X = TV - TW;
					TQ = TO + TP;
					T40 = TO - TP;
					TT = R0[WS(rs, 19)];
				   }
			      }
			 }
			 {
			      E Ti, T3E, Tn, Ts, T3I, Tl, T3F, To;
			      {
				   E Ty, T3M, TD, TI, T3O, TB, T3R, TE;
				   {
					E TG, TH, Tz, TA;
					{
					     E T19, TR, T3W, TU, Tw, Tx;
					     Tw = R0[WS(rs, 1)];
					     Tx = R0[WS(rs, 17)];
					     T19 = TN - TQ;
					     TR = TN + TQ;
					     T3W = TS - TT;
					     TU = TS + TT;
					     Ty = Tw + Tx;
					     T3M = Tw - Tx;
					     {
						  E T41, T3Y, T1a, TY;
						  T41 = T3W - T3X;
						  T3Y = T3W + T3X;
						  T1a = TX - TU;
						  TY = TU + TX;
						  T5s = FNMS(KP707106781, T41, T40);
						  T42 = FMA(KP707106781, T41, T40);
						  T5t = FNMS(KP707106781, T3Y, T3V);
						  T3Z = FMA(KP707106781, T3Y, T3V);
						  T2n = FMA(KP414213562, T19, T1a);
						  T1b = FNMS(KP414213562, T1a, T19);
						  T3f = TR - TY;
						  TZ = TR + TY;
						  TG = R0[WS(rs, 29)];
						  TH = R0[WS(rs, 13)];
					     }
					}
					Tz = R0[WS(rs, 9)];
					TA = R0[WS(rs, 25)];
					TD = R0[WS(rs, 5)];
					TI = TG + TH;
					T3O = TG - TH;
					TB = Tz + TA;
					T3R = Tz - TA;
					TE = R0[WS(rs, 21)];
				   }
				   {
					E Tq, Tr, Tj, Tk;
					{
					     E T16, TC, T3N, TF, Tg, Th;
					     Tg = R0[WS(rs, 2)];
					     Th = R0[WS(rs, 18)];
					     T16 = Ty - TB;
					     TC = Ty + TB;
					     T3N = TD - TE;
					     TF = TD + TE;
					     Ti = Tg + Th;
					     T3E = Tg - Th;
					     {
						  E T3S, T3P, T17, TJ;
						  T3S = T3N - T3O;
						  T3P = T3N + T3O;
						  T17 = TI - TF;
						  TJ = TF + TI;
						  T5v = FNMS(KP707106781, T3S, T3R);
						  T3T = FMA(KP707106781, T3S, T3R);
						  T5w = FNMS(KP707106781, T3P, T3M);
						  T3Q = FMA(KP707106781, T3P, T3M);
						  T2m = FNMS(KP414213562, T16, T17);
						  T18 = FMA(KP414213562, T17, T16);
						  T3e = TC - TJ;
						  TK = TC + TJ;
						  Tq = R0[WS(rs, 6)];
						  Tr = R0[WS(rs, 22)];
					     }
					}
					Tj = R0[WS(rs, 10)];
					Tk = R0[WS(rs, 26)];
					Tn = R0[WS(rs, 30)];
					Ts = Tq + Tr;
					T3I = Tq - Tr;
					Tl = Tj + Tk;
					T3F = Tj - Tk;
					To = R0[WS(rs, 14)];
				   }
			      }
			      {
				   E T1n, T4b, T1s, T4f, T1x, T4c, T1q, T1t;
				   {
					E T1v, T1w, T1o, T1p;
					{
					     E T1l, T4Q, T3G, Tm, T12, Tp, T3H, T1m;
					     T1l = R1[WS(rs, 2)];
					     T4Q = FMA(KP414213562, T3E, T3F);
					     T3G = FNMS(KP414213562, T3F, T3E);
					     Tm = Ti + Tl;
					     T12 = Ti - Tl;
					     Tp = Tn + To;
					     T3H = Tn - To;
					     T1m = R1[WS(rs, 18)];
					     T1v = R1[WS(rs, 6)];
					     {
						  E T4R, T3J, Tt, T13;
						  T4R = FNMS(KP414213562, T3H, T3I);
						  T3J = FMA(KP414213562, T3I, T3H);
						  Tt = Tp + Ts;
						  T13 = Tp - Ts;
						  T1n = T1l + T1m;
						  T4b = T1l - T1m;
						  T3K = T3G + T3J;
						  T5Q = T3J - T3G;
						  T4S = T4Q + T4R;
						  T5q = T4Q - T4R;
						  T14 = T12 + T13;
						  T2k = T13 - T12;
						  T3p = Tt - Tm;
						  Tu = Tm + Tt;
						  T1w = R1[WS(rs, 22)];
					     }
					}
					T1o = R1[WS(rs, 10)];
					T1p = R1[WS(rs, 26)];
					T1s = R1[WS(rs, 30)];
					T4f = T1v - T1w;
					T1x = T1v + T1w;
					T4c = T1o - T1p;
					T1q = T1o + T1p;
					T1t = R1[WS(rs, 14)];
				   }
				   {
					E T22, T23, T1V, T1W;
					{
					     E T1S, T4d, T4m, T2V, T1r, T4e, T1u, T1T;
					     T1S = R1[WS(rs, 1)];
					     T4d = FNMS(KP414213562, T4c, T4b);
					     T4m = FMA(KP414213562, T4b, T4c);
					     T2V = T1n + T1q;
					     T1r = T1n - T1q;
					     T4e = T1s - T1t;
					     T1u = T1s + T1t;
					     T1T = R1[WS(rs, 17)];
					     T22 = R1[WS(rs, 5)];
					     {
						  E T4g, T4n, T2W, T1y;
						  T4g = FMA(KP414213562, T4f, T4e);
						  T4n = FNMS(KP414213562, T4e, T4f);
						  T2W = T1u + T1x;
						  T1y = T1u - T1x;
						  T4w = T1S - T1T;
						  T1U = T1S + T1T;
						  T5E = T4g - T4d;
						  T4h = T4d + T4g;
						  T5B = T4m - T4n;
						  T4o = T4m + T4n;
						  T3j = T2W - T2V;
						  T2X = T2V + T2W;
						  T1I = T1y - T1r;
						  T1z = T1r + T1y;
						  T23 = R1[WS(rs, 21)];
					     }
					}
					T1V = R1[WS(rs, 9)];
					T1W = R1[WS(rs, 25)];
					T1Z = R1[WS(rs, 29)];
					T4A = T23 - T22;
					T24 = T22 + T23;
					T4x = T1W - T1V;
					T1X = T1V + T1W;
					T20 = R1[WS(rs, 13)];
				   }
			      }
			 }
		    }
		    {
			 E T4C, T5L, T4J, T5I, T26, T2f, T3q, T3h, T3w, T3s, T3o, T3r, T3t;
			 {
			      E T2R, T37, T2Y, T3a, T39, T3m, T3b, T35, Tv, T10, T34, T3c, T3x, T3y;
			      {
				   E T4y, T4H, T32, T1Y, T4z, T21;
				   T2R = Tf - Tu;
				   Tv = Tf + Tu;
				   T4y = FMA(KP414213562, T4x, T4w);
				   T4H = FNMS(KP414213562, T4w, T4x);
				   T32 = T1U + T1X;
				   T1Y = T1U - T1X;
				   T4z = T1Z - T20;
				   T21 = T1Z + T20;
				   T10 = TK + TZ;
				   T37 = TZ - TK;
				   T2Y = T2U - T2X;
				   T3a = T2U + T2X;
				   {
					E T4B, T4I, T33, T25;
					T4B = FNMS(KP414213562, T4A, T4z);
					T4I = FMA(KP414213562, T4z, T4A);
					T33 = T21 + T24;
					T25 = T21 - T24;
					T39 = Tv + T10;
					T4C = T4y + T4B;
					T5L = T4B - T4y;
					T4J = T4H + T4I;
					T5I = T4I - T4H;
					T34 = T32 + T33;
					T3m = T33 - T32;
					T26 = T1Y + T25;
					T2f = T25 - T1Y;
				   }
			      }
			      Cr[WS(csr, 16)] = Tv - T10;
			      T3b = T31 + T34;
			      T35 = T31 - T34;
			      Ci[WS(csi, 16)] = T3b - T3a;
			      T3c = T3a + T3b;
			      {
				   E T3k, T3u, T3v, T3n, T36, T38, T3g;
				   T3g = T3e + T3f;
				   T3q = T3f - T3e;
				   Cr[0] = T39 + T3c;
				   Cr[WS(csr, 32)] = T39 - T3c;
				   T36 = T2Y + T35;
				   T38 = T35 - T2Y;
				   T3x = FNMS(KP707106781, T3g, T3d);
				   T3h = FMA(KP707106781, T3g, T3d);
				   Ci[WS(csi, 8)] = FMA(KP707106781, T38, T37);
				   Ci[WS(csi, 24)] = FMS(KP707106781, T38, T37);
				   Cr[WS(csr, 8)] = FMA(KP707106781, T36, T2R);
				   Cr[WS(csr, 24)] = FNMS(KP707106781, T36, T2R);
				   T3k = FMA(KP414213562, T3j, T3i);
				   T3u = FNMS(KP414213562, T3i, T3j);
				   T3v = FMA(KP414213562, T3l, T3m);
				   T3n = FNMS(KP414213562, T3m, T3l);
				   T3y = T3v - T3u;
				   T3w = T3u + T3v;
				   T3s = T3n - T3k;
				   T3o = T3k + T3n;
			      }
			      Cr[WS(csr, 12)] = FMA(KP923879532, T3y, T3x);
			      Cr[WS(csr, 20)] = FNMS(KP923879532, T3y, T3x);
			 }
			 Cr[WS(csr, 4)] = FMA(KP923879532, T3o, T3h);
			 Cr[WS(csr, 28)] = FNMS(KP923879532, T3o, T3h);
			 T3r = FNMS(KP707106781, T3q, T3p);
			 T3t = FMA(KP707106781, T3q, T3p);
			 {
			      E T27, T2g, T2v, T1d, T2r, T2p, T2s, T1K, T6l, T6m;
			      {
				   E T15, T2o, T2P, T2z, T2l, T1c, T1A, T1J, T2D, T2L, T2J, T2M, T2C, T2E, T2N;
				   E T2F;
				   {
					E T2H, T2I, T2x, T2y, T2A, T2B;
					T15 = FMA(KP707106781, T14, T11);
					T2x = FNMS(KP707106781, T14, T11);
					T2y = T2n - T2m;
					T2o = T2m + T2n;
					Ci[WS(csi, 4)] = FMA(KP923879532, T3w, T3t);
					Ci[WS(csi, 28)] = FMS(KP923879532, T3w, T3t);
					Ci[WS(csi, 20)] = FMA(KP923879532, T3s, T3r);
					Ci[WS(csi, 12)] = FMS(KP923879532, T3s, T3r);
					T2P = FNMS(KP923879532, T2y, T2x);
					T2z = FMA(KP923879532, T2y, T2x);
					T2l = FMA(KP707106781, T2k, T2j);
					T2H = FNMS(KP707106781, T2k, T2j);
					T2I = T1b - T18;
					T1c = T18 + T1b;
					T1A = FMA(KP707106781, T1z, T1k);
					T2A = FNMS(KP707106781, T1z, T1k);
					T2B = FNMS(KP707106781, T1I, T1H);
					T1J = FMA(KP707106781, T1I, T1H);
					T27 = FMA(KP707106781, T26, T1R);
					T2D = FNMS(KP707106781, T26, T1R);
					T2L = FNMS(KP923879532, T2I, T2H);
					T2J = FMA(KP923879532, T2I, T2H);
					T2M = FMA(KP668178637, T2A, T2B);
					T2C = FNMS(KP668178637, T2B, T2A);
					T2E = FNMS(KP707106781, T2f, T2e);
					T2g = FMA(KP707106781, T2f, T2e);
				   }
				   T2N = FNMS(KP668178637, T2D, T2E);
				   T2F = FMA(KP668178637, T2E, T2D);
				   T2v = FNMS(KP923879532, T1c, T15);
				   T1d = FMA(KP923879532, T1c, T15);
				   {
					E T2Q, T2O, T2K, T2G;
					T2Q = T2M - T2N;
					T2O = T2M + T2N;
					T2K = T2F - T2C;
					T2G = T2C + T2F;
					Cr[WS(csr, 10)] = FMA(KP831469612, T2Q, T2P);
					Cr[WS(csr, 22)] = FNMS(KP831469612, T2Q, T2P);
					Ci[WS(csi, 26)] = FNMS(KP831469612, T2O, T2L);
					Ci[WS(csi, 6)] = -(FMA(KP831469612, T2O, T2L));
					Ci[WS(csi, 22)] = FMS(KP831469612, T2K, T2J);
					Ci[WS(csi, 10)] = FMA(KP831469612, T2K, T2J);
					Cr[WS(csr, 6)] = FMA(KP831469612, T2G, T2z);
					Cr[WS(csr, 26)] = FNMS(KP831469612, T2G, T2z);
				   }
				   T2r = FMA(KP923879532, T2o, T2l);
				   T2p = FNMS(KP923879532, T2o, T2l);
				   T2s = FNMS(KP198912367, T1A, T1J);
				   T1K = FMA(KP198912367, T1J, T1A);
			      }
			      {
				   E T63, T5r, T5R, T6d, T5J, T5M, T6e, T5y, T6j, T6b, T66, T67, T64, T5U, T5Z;
				   E T5G;
				   {
					E T5S, T5u, T5x, T5T, T2t, T2h;
					T63 = FMA(KP923879532, T5q, T5p);
					T5r = FNMS(KP923879532, T5q, T5p);
					T5R = FNMS(KP923879532, T5Q, T5P);
					T6d = FMA(KP923879532, T5Q, T5P);
					T2t = FMA(KP198912367, T27, T2g);
					T2h = FNMS(KP198912367, T2g, T27);
					T5S = FNMS(KP668178637, T5s, T5t);
					T5u = FMA(KP668178637, T5t, T5s);
					{
					     E T2w, T2u, T2q, T2i;
					     T2w = T2t - T2s;
					     T2u = T2s + T2t;
					     T2q = T2h - T1K;
					     T2i = T1K + T2h;
					     Cr[WS(csr, 14)] = FMA(KP980785280, T2w, T2v);
					     Cr[WS(csr, 18)] = FNMS(KP980785280, T2w, T2v);
					     Ci[WS(csi, 30)] = FMS(KP980785280, T2u, T2r);
					     Ci[WS(csi, 2)] = FMA(KP980785280, T2u, T2r);
					     Ci[WS(csi, 18)] = FMA(KP980785280, T2q, T2p);
					     Ci[WS(csi, 14)] = FMS(KP980785280, T2q, T2p);
					     Cr[WS(csr, 2)] = FMA(KP980785280, T2i, T1d);
					     Cr[WS(csr, 30)] = FNMS(KP980785280, T2i, T1d);
					     T5x = FNMS(KP668178637, T5w, T5v);
					     T5T = FMA(KP668178637, T5v, T5w);
					}
					{
					     E T69, T6a, T5C, T5F;
					     T5J = FNMS(KP923879532, T5I, T5H);
					     T69 = FMA(KP923879532, T5I, T5H);
					     T6a = FNMS(KP923879532, T5L, T5K);
					     T5M = FMA(KP923879532, T5L, T5K);
					     T6e = T5x + T5u;
					     T5y = T5u - T5x;
					     T6j = FNMS(KP303346683, T69, T6a);
					     T6b = FMA(KP303346683, T6a, T69);
					     T66 = FMA(KP923879532, T5B, T5A);
					     T5C = FNMS(KP923879532, T5B, T5A);
					     T5F = FNMS(KP923879532, T5E, T5D);
					     T67 = FMA(KP923879532, T5E, T5D);
					     T64 = T5T + T5S;
					     T5U = T5S - T5T;
					     T5Z = FMA(KP534511135, T5C, T5F);
					     T5G = FNMS(KP534511135, T5F, T5C);
					}
				   }
				   {
					E T61, T6i, T68, T62;
					{
					     E T5z, T5Y, T5N, T5X, T5V, T60, T5W, T5O;
					     T61 = FNMS(KP831469612, T5y, T5r);
					     T5z = FMA(KP831469612, T5y, T5r);
					     T6i = FNMS(KP303346683, T66, T67);
					     T68 = FMA(KP303346683, T67, T66);
					     T5Y = FMA(KP534511135, T5J, T5M);
					     T5N = FNMS(KP534511135, T5M, T5J);
					     T5X = FNMS(KP831469612, T5U, T5R);
					     T5V = FMA(KP831469612, T5U, T5R);
					     T60 = T5Y - T5Z;
					     T62 = T5Z + T5Y;
					     T5W = T5N - T5G;
					     T5O = T5G + T5N;
					     Ci[WS(csi, 27)] = FMA(KP881921264, T60, T5X);
					     Ci[WS(csi, 5)] = FMS(KP881921264, T60, T5X);
					     Cr[WS(csr, 5)] = FMA(KP881921264, T5O, T5z);
					     Cr[WS(csr, 27)] = FNMS(KP881921264, T5O, T5z);
					     Ci[WS(csi, 21)] = FMS(KP881921264, T5W, T5V);
					     Ci[WS(csi, 11)] = FMA(KP881921264, T5W, T5V);
					}
					{
					     E T6g, T6f, T6h, T6k, T65, T6c;
					     T6l = FNMS(KP831469612, T64, T63);
					     T65 = FMA(KP831469612, T64, T63);
					     T6c = T68 + T6b;
					     T6g = T6b - T68;
					     T6f = FNMS(KP831469612, T6e, T6d);
					     T6h = FMA(KP831469612, T6e, T6d);
					     Cr[WS(csr, 11)] = FMA(KP881921264, T62, T61);
					     Cr[WS(csr, 21)] = FNMS(KP881921264, T62, T61);
					     Cr[WS(csr, 3)] = FMA(KP956940335, T6c, T65);
					     Cr[WS(csr, 29)] = FNMS(KP956940335, T6c, T65);
					     T6k = T6i - T6j;
					     T6m = T6i + T6j;
					     Ci[WS(csi, 29)] = FMS(KP956940335, T6k, T6h);
					     Ci[WS(csi, 3)] = FMA(KP956940335, T6k, T6h);
					     Ci[WS(csi, 19)] = FMA(KP956940335, T6g, T6f);
					     Ci[WS(csi, 13)] = FMS(KP956940335, T6g, T6f);
					}
				   }
			      }
			      {
				   E T55, T3L, T4T, T5f, T4D, T4K, T5g, T44, T5l, T5d, T58, T59, T56, T4W, T51;
				   E T4q;
				   {
					E T4U, T3U, T43, T4V;
					T55 = FNMS(KP923879532, T3K, T3D);
					T3L = FMA(KP923879532, T3K, T3D);
					T4T = FMA(KP923879532, T4S, T4P);
					T5f = FNMS(KP923879532, T4S, T4P);
					Cr[WS(csr, 13)] = FNMS(KP956940335, T6m, T6l);
					Cr[WS(csr, 19)] = FMA(KP956940335, T6m, T6l);
					T4U = FMA(KP198912367, T3Q, T3T);
					T3U = FNMS(KP198912367, T3T, T3Q);
					T43 = FMA(KP198912367, T42, T3Z);
					T4V = FNMS(KP198912367, T3Z, T42);
					{
					     E T5b, T5c, T4i, T4p;
					     T4D = FMA(KP923879532, T4C, T4v);
					     T5b = FNMS(KP923879532, T4C, T4v);
					     T5c = FNMS(KP923879532, T4J, T4G);
					     T4K = FMA(KP923879532, T4J, T4G);
					     T5g = T43 - T3U;
					     T44 = T3U + T43;
					     T5l = FNMS(KP820678790, T5b, T5c);
					     T5d = FMA(KP820678790, T5c, T5b);
					     T58 = FNMS(KP923879532, T4h, T4a);
					     T4i = FMA(KP923879532, T4h, T4a);
					     T4p = FMA(KP923879532, T4o, T4l);
					     T59 = FNMS(KP923879532, T4o, T4l);
					     T56 = T4U - T4V;
					     T4W = T4U + T4V;
					     T51 = FMA(KP098491403, T4i, T4p);
					     T4q = FNMS(KP098491403, T4p, T4i);
					}
				   }
				   {
					E T53, T5k, T5a, T54;
					{
					     E T45, T50, T4L, T4Z, T4X, T52, T4Y, T4M;
					     T53 = FNMS(KP980785280, T44, T3L);
					     T45 = FMA(KP980785280, T44, T3L);
					     T5k = FNMS(KP820678790, T58, T59);
					     T5a = FMA(KP820678790, T59, T58);
					     T50 = FMA(KP098491403, T4D, T4K);
					     T4L = FNMS(KP098491403, T4K, T4D);
					     T4Z = FMA(KP980785280, T4W, T4T);
					     T4X = FNMS(KP980785280, T4W, T4T);
					     T52 = T50 - T51;
					     T54 = T51 + T50;
					     T4Y = T4L - T4q;
					     T4M = T4q + T4L;
					     Ci[WS(csi, 31)] = FMA(KP995184726, T52, T4Z);
					     Ci[WS(csi, 1)] = FMS(KP995184726, T52, T4Z);
					     Cr[WS(csr, 1)] = FMA(KP995184726, T4M, T45);
					     Cr[WS(csr, 31)] = FNMS(KP995184726, T4M, T45);
					     Ci[WS(csi, 17)] = FMS(KP995184726, T4Y, T4X);
					     Ci[WS(csi, 15)] = FMA(KP995184726, T4Y, T4X);
					}
					{
					     E T5i, T5h, T5j, T5m, T57, T5e;
					     T5n = FNMS(KP980785280, T56, T55);
					     T57 = FMA(KP980785280, T56, T55);
					     T5e = T5a + T5d;
					     T5i = T5d - T5a;
					     T5h = FNMS(KP980785280, T5g, T5f);
					     T5j = FMA(KP980785280, T5g, T5f);
					     Cr[WS(csr, 15)] = FMA(KP995184726, T54, T53);
					     Cr[WS(csr, 17)] = FNMS(KP995184726, T54, T53);
					     Cr[WS(csr, 7)] = FMA(KP773010453, T5e, T57);
					     Cr[WS(csr, 25)] = FNMS(KP773010453, T5e, T57);
					     T5m = T5k - T5l;
					     T5o = T5k + T5l;
					     Ci[WS(csi, 25)] = FMS(KP773010453, T5m, T5j);
					     Ci[WS(csi, 7)] = FMA(KP773010453, T5m, T5j);
					     Ci[WS(csi, 23)] = FMA(KP773010453, T5i, T5h);
					     Ci[WS(csi, 9)] = FMS(KP773010453, T5i, T5h);
					}
				   }
			      }
			 }
		    }
	       }
	       Cr[WS(csr, 9)] = FNMS(KP773010453, T5o, T5n);
	       Cr[WS(csr, 23)] = FMA(KP773010453, T5o, T5n);
	  }
     }
}

static const kr2c_desc desc = { 64, "r2cf_64", {198, 0, 196, 0}, &GENUS };

void X(codelet_r2cf_64) (planner *p) {
     X(kr2c_register) (p, r2cf_64, &desc);
}

#else				/* HAVE_FMA */

/* Generated by: ../../../genfft/gen_r2cf.native -compact -variables 4 -pipeline-latency 4 -n 64 -name r2cf_64 -include r2cf.h */

/*
 * This function contains 394 FP additions, 124 FP multiplications,
 * (or, 342 additions, 72 multiplications, 52 fused multiply/add),
 * 106 stack variables, 15 constants, and 128 memory accesses
 */
#include "r2cf.h"

static void r2cf_64(R *R0, R *R1, R *Cr, R *Ci, stride rs, stride csr, stride csi, INT v, INT ivs, INT ovs)
{
     DK(KP773010453, +0.773010453362736960810906609758469800971041293);
     DK(KP634393284, +0.634393284163645498215171613225493370675687095);
     DK(KP098017140, +0.098017140329560601994195563888641845861136673);
     DK(KP995184726, +0.995184726672196886244836953109479921575474869);
     DK(KP290284677, +0.290284677254462367636192375817395274691476278);
     DK(KP956940335, +0.956940335732208864935797886980269969482849206);
     DK(KP471396736, +0.471396736825997648556387625905254377657460319);
     DK(KP881921264, +0.881921264348355029712756863660388349508442621);
     DK(KP195090322, +0.195090322016128267848284868477022240927691618);
     DK(KP980785280, +0.980785280403230449126182236134239036973933731);
     DK(KP555570233, +0.555570233019602224742830813948532874374937191);
     DK(KP831469612, +0.831469612302545237078788377617905756738560812);
     DK(KP382683432, +0.382683432365089771728459984030398866761344562);
     DK(KP923879532, +0.923879532511286756128183189396788286822416626);
     DK(KP707106781, +0.707106781186547524400844362104849039284835938);
     {
	  INT i;
	  for (i = v; i > 0; i = i - 1, R0 = R0 + ivs, R1 = R1 + ivs, Cr = Cr + ovs, Ci = Ci + ovs, MAKE_VOLATILE_STRIDE(256, rs), MAKE_VOLATILE_STRIDE(256, csr), MAKE_VOLATILE_STRIDE(256, csi)) {
	       E T4l, T5a, T15, T3n, T2T, T3Q, T7, Te, Tf, T4A, T4L, T1X, T3B, T23, T3y;
	       E T5I, T66, T4R, T52, T2j, T3F, T2H, T3I, T5P, T69, T1i, T3t, T1l, T3u, TZ;
	       E T63, T4v, T58, T1r, T3r, T1u, T3q, TK, T62, T4s, T57, Tm, Tt, Tu, T4o;
	       E T5b, T1c, T3R, T2Q, T3o, T1M, T3z, T5L, T67, T26, T3C, T4H, T4M, T2y, T3J;
	       E T5S, T6a, T2C, T3G, T4Y, T53;
	       {
		    E T3, T11, Td, T13, T6, T2S, Ta, T12, T14, T2R;
		    {
			 E T1, T2, Tb, Tc;
			 T1 = R0[0];
			 T2 = R0[WS(rs, 16)];
			 T3 = T1 + T2;
			 T11 = T1 - T2;
			 Tb = R0[WS(rs, 28)];
			 Tc = R0[WS(rs, 12)];
			 Td = Tb + Tc;
			 T13 = Tb - Tc;
		    }
		    {
			 E T4, T5, T8, T9;
			 T4 = R0[WS(rs, 8)];
			 T5 = R0[WS(rs, 24)];
			 T6 = T4 + T5;
			 T2S = T4 - T5;
			 T8 = R0[WS(rs, 4)];
			 T9 = R0[WS(rs, 20)];
			 Ta = T8 + T9;
			 T12 = T8 - T9;
		    }
		    T4l = T3 - T6;
		    T5a = Td - Ta;
		    T14 = KP707106781 * (T12 + T13);
		    T15 = T11 + T14;
		    T3n = T11 - T14;
		    T2R = KP707106781 * (T13 - T12);
		    T2T = T2R - T2S;
		    T3Q = T2S + T2R;
		    T7 = T3 + T6;
		    Te = Ta + Td;
		    Tf = T7 + Te;
	       }
	       {
		    E T1P, T4J, T21, T4y, T1S, T4K, T1W, T4z;
		    {
			 E T1N, T1O, T1Z, T20;
			 T1N = R1[WS(rs, 28)];
			 T1O = R1[WS(rs, 12)];
			 T1P = T1N - T1O;
			 T4J = T1N + T1O;
			 T1Z = R1[0];
			 T20 = R1[WS(rs, 16)];
			 T21 = T1Z - T20;
			 T4y = T1Z + T20;
		    }
		    {
			 E T1Q, T1R, T1U, T1V;
			 T1Q = R1[WS(rs, 4)];
			 T1R = R1[WS(rs, 20)];
			 T1S = T1Q - T1R;
			 T4K = T1Q + T1R;
			 T1U = R1[WS(rs, 8)];
			 T1V = R1[WS(rs, 24)];
			 T1W = T1U - T1V;
			 T4z = T1U + T1V;
		    }
		    T4A = T4y - T4z;
		    T4L = T4J - T4K;
		    {
			 E T1T, T22, T5G, T5H;
			 T1T = KP707106781 * (T1P - T1S);
			 T1X = T1T - T1W;
			 T3B = T1W + T1T;
			 T22 = KP707106781 * (T1S + T1P);
			 T23 = T21 + T22;
			 T3y = T21 - T22;
			 T5G = T4y + T4z;
			 T5H = T4K + T4J;
			 T5I = T5G + T5H;
			 T66 = T5G - T5H;
		    }
	       }
	       {
		    E T2b, T4P, T2G, T4Q, T2e, T51, T2h, T50;
		    {
			 E T29, T2a, T2E, T2F;
			 T29 = R1[WS(rs, 31)];
			 T2a = R1[WS(rs, 15)];
			 T2b = T29 - T2a;
			 T4P = T29 + T2a;
			 T2E = R1[WS(rs, 7)];
			 T2F = R1[WS(rs, 23)];
			 T2G = T2E - T2F;
			 T4Q = T2E + T2F;
		    }
		    {
			 E T2c, T2d, T2f, T2g;
			 T2c = R1[WS(rs, 3)];
			 T2d = R1[WS(rs, 19)];
			 T2e = T2c - T2d;
			 T51 = T2c + T2d;
			 T2f = R1[WS(rs, 27)];
			 T2g = R1[WS(rs, 11)];
			 T2h = T2f - T2g;
			 T50 = T2f + T2g;
		    }
		    T4R = T4P - T4Q;
		    T52 = T50 - T51;
		    {
			 E T2i, T2D, T5N, T5O;
			 T2i = KP707106781 * (T2e + T2h);
			 T2j = T2b + T2i;
			 T3F = T2b - T2i;
			 T2D = KP707106781 * (T2h - T2e);
			 T2H = T2D - T2G;
			 T3I = T2G + T2D;
			 T5N = T4P + T4Q;
			 T5O = T51 + T50;
			 T5P = T5N + T5O;
			 T69 = T5N - T5O;
		    }
	       }
	       {
		    E TN, T1e, TX, T1g, TQ, T1k, TU, T1f, T1h, T1j;
		    {
			 E TL, TM, TV, TW;
			 TL = R0[WS(rs, 31)];
			 TM = R0[WS(rs, 15)];
			 TN = TL + TM;
			 T1e = TL - TM;
			 TV = R0[WS(rs, 27)];
			 TW = R0[WS(rs, 11)];
			 TX = TV + TW;
			 T1g = TV - TW;
		    }
		    {
			 E TO, TP, TS, TT;
			 TO = R0[WS(rs, 7)];
			 TP = R0[WS(rs, 23)];
			 TQ = TO + TP;
			 T1k = TO - TP;
			 TS = R0[WS(rs, 3)];
			 TT = R0[WS(rs, 19)];
			 TU = TS + TT;
			 T1f = TS - TT;
		    }
		    T1h = KP707106781 * (T1f + T1g);
		    T1i = T1e + T1h;
		    T3t = T1e - T1h;
		    T1j = KP707106781 * (T1g - T1f);
		    T1l = T1j - T1k;
		    T3u = T1k + T1j;
		    {
			 E TR, TY, T4t, T4u;
			 TR = TN + TQ;
			 TY = TU + TX;
			 TZ = TR + TY;
			 T63 = TR - TY;
			 T4t = TN - TQ;
			 T4u = TX - TU;
			 T4v = FNMS(KP382683432, T4u, KP923879532 * T4t);
			 T58 = FMA(KP382683432, T4t, KP923879532 * T4u);
		    }
	       }
	       {
		    E Ty, T1s, TI, T1n, TB, T1q, TF, T1o, T1p, T1t;
		    {
			 E Tw, Tx, TG, TH;
			 Tw = R0[WS(rs, 1)];
			 Tx = R0[WS(rs, 17)];
			 Ty = Tw + Tx;
			 T1s = Tw - Tx;
			 TG = R0[WS(rs, 29)];
			 TH = R0[WS(rs, 13)];
			 TI = TG + TH;
			 T1n = TG - TH;
		    }
		    {
			 E Tz, TA, TD, TE;
			 Tz = R0[WS(rs, 9)];
			 TA = R0[WS(rs, 25)];
			 TB = Tz + TA;
			 T1q = Tz - TA;
			 TD = R0[WS(rs, 5)];
			 TE = R0[WS(rs, 21)];
			 TF = TD + TE;
			 T1o = TD - TE;
		    }
		    T1p = KP707106781 * (T1n - T1o);
		    T1r = T1p - T1q;
		    T3r = T1q + T1p;
		    T1t = KP707106781 * (T1o + T1n);
		    T1u = T1s + T1t;
		    T3q = T1s - T1t;
		    {
			 E TC, TJ, T4q, T4r;
			 TC = Ty + TB;
			 TJ = TF + TI;
			 TK = TC + TJ;
			 T62 = TC - TJ;
			 T4q = Ty - TB;
			 T4r = TI - TF;
			 T4s = FMA(KP923879532, T4q, KP382683432 * T4r);
			 T57 = FNMS(KP382683432, T4q, KP923879532 * T4r);
		    }
	       }
	       {
		    E Ti, T16, Ts, T1a, Tl, T17, Tp, T19, T4m, T4n;
		    {
			 E Tg, Th, Tq, Tr;
			 Tg = R0[WS(rs, 2)];
			 Th = R0[WS(rs, 18)];
			 Ti = Tg + Th;
			 T16 = Tg - Th;
			 Tq = R0[WS(rs, 6)];
			 Tr = R0[WS(rs, 22)];
			 Ts = Tq + Tr;
			 T1a = Tq - Tr;
		    }
		    {
			 E Tj, Tk, Tn, To;
			 Tj = R0[WS(rs, 10)];
			 Tk = R0[WS(rs, 26)];
			 Tl = Tj + Tk;
			 T17 = Tj - Tk;
			 Tn = R0[WS(rs, 30)];
			 To = R0[WS(rs, 14)];
			 Tp = Tn + To;
			 T19 = Tn - To;
		    }
		    Tm = Ti + Tl;
		    Tt = Tp + Ts;
		    Tu = Tm + Tt;
		    T4m = Ti - Tl;
		    T4n = Tp - Ts;
		    T4o = KP707106781 * (T4m + T4n);
		    T5b = KP707106781 * (T4n - T4m);
		    {
			 E T18, T1b, T2O, T2P;
			 T18 = FNMS(KP382683432, T17, KP923879532 * T16);
			 T1b = FMA(KP923879532, T19, KP382683432 * T1a);
			 T1c = T18 + T1b;
			 T3R = T1b - T18;
			 T2O = FNMS(KP923879532, T1a, KP382683432 * T19);
			 T2P = FMA(KP382683432, T16, KP923879532 * T17);
			 T2Q = T2O - T2P;
			 T3o = T2P + T2O;
		    }
	       }
	       {
		    E T1A, T4E, T1K, T4C, T1D, T4F, T1H, T4B;
		    {
			 E T1y, T1z, T1I, T1J;
			 T1y = R1[WS(rs, 30)];
			 T1z = R1[WS(rs, 14)];
			 T1A = T1y - T1z;
			 T4E = T1y + T1z;
			 T1I = R1[WS(rs, 10)];
			 T1J = R1[WS(rs, 26)];
			 T1K = T1I - T1J;
			 T4C = T1I + T1J;
		    }
		    {
			 E T1B, T1C, T1F, T1G;
			 T1B = R1[WS(rs, 6)];
			 T1C = R1[WS(rs, 22)];
			 T1D = T1B - T1C;
			 T4F = T1B + T1C;
			 T1F = R1[WS(rs, 2)];
			 T1G = R1[WS(rs, 18)];
			 T1H = T1F - T1G;
			 T4B = T1F + T1G;
		    }
		    {
			 E T1E, T1L, T5J, T5K;
			 T1E = FNMS(KP923879532, T1D, KP382683432 * T1A);
			 T1L = FMA(KP382683432, T1H, KP923879532 * T1K);
			 T1M = T1E - T1L;
			 T3z = T1L + T1E;
			 T5J = T4B + T4C;
			 T5K = T4E + T4F;
			 T5L = T5J + T5K;
			 T67 = T5K - T5J;
		    }
		    {
			 E T24, T25, T4D, T4G;
			 T24 = FNMS(KP382683432, T1K, KP923879532 * T1H);
			 T25 = FMA(KP923879532, T1A, KP382683432 * T1D);
			 T26 = T24 + T25;
			 T3C = T25 - T24;
			 T4D = T4B - T4C;
			 T4G = T4E - T4F;
			 T4H = KP707106781 * (T4D + T4G);
			 T4M = KP707106781 * (T4G - T4D);
		    }
	       }
	       {
		    E T2m, T4S, T2w, T4W, T2p, T4T, T2t, T4V;
		    {
			 E T2k, T2l, T2u, T2v;
			 T2k = R1[WS(rs, 1)];
			 T2l = R1[WS(rs, 17)];
			 T2m = T2k - T2l;
			 T4S = T2k + T2l;
			 T2u = R1[WS(rs, 5)];
			 T2v = R1[WS(rs, 21)];
			 T2w = T2u - T2v;
			 T4W = T2u + T2v;
		    }
		    {
			 E T2n, T2o, T2r, T2s;
			 T2n = R1[WS(rs, 9)];
			 T2o = R1[WS(rs, 25)];
			 T2p = T2n - T2o;
			 T4T = T2n + T2o;
			 T2r = R1[WS(rs, 29)];
			 T2s = R1[WS(rs, 13)];
			 T2t = T2r - T2s;
			 T4V = T2r + T2s;
		    }
		    {
			 E T2q, T2x, T5Q, T5R;
			 T2q = FNMS(KP382683432, T2p, KP923879532 * T2m);
			 T2x = FMA(KP923879532, T2t, KP382683432 * T2w);
			 T2y = T2q + T2x;
			 T3J = T2x - T2q;
			 T5Q = T4S + T4T;
			 T5R = T4V + T4W;
			 T5S = T5Q + T5R;
			 T6a = T5R - T5Q;
		    }
		    {
			 E T2A, T2B, T4U, T4X;
			 T2A = FNMS(KP923879532, T2w, KP382683432 * T2t);
			 T2B = FMA(KP382683432, T2m, KP923879532 * T2p);
			 T2C = T2A - T2B;
			 T3G = T2B + T2A;
			 T4U = T4S - T4T;
			 T4X = T4V - T4W;
			 T4Y = KP707106781 * (T4U + T4X);
			 T53 = KP707106781 * (T4X - T4U);
		    }
	       }
	       {
		    E Tv, T10, T5X, T5Y, T5Z, T60;
		    Tv = Tf + Tu;
		    T10 = TK + TZ;
		    T5X = Tv + T10;
		    T5Y = T5I + T5L;
		    T5Z = T5P + T5S;
		    T60 = T5Y + T5Z;
		    Cr[WS(csr, 16)] = Tv - T10;
		    Ci[WS(csi, 16)] = T5Z - T5Y;
		    Cr[WS(csr, 32)] = T5X - T60;
		    Cr[0] = T5X + T60;
	       }
	       {
		    E T5F, T5V, T5U, T5W, T5M, T5T;
		    T5F = Tf - Tu;
		    T5V = TZ - TK;
		    T5M = T5I - T5L;
		    T5T = T5P - T5S;
		    T5U = KP707106781 * (T5M + T5T);
		    T5W = KP707106781 * (T5T - T5M);
		    Cr[WS(csr, 24)] = T5F - T5U;
		    Ci[WS(csi, 24)] = T5W - T5V;
		    Cr[WS(csr, 8)] = T5F + T5U;
		    Ci[WS(csi, 8)] = T5V + T5W;
	       }
	       {
		    E T65, T6l, T6k, T6m, T6c, T6g, T6f, T6h;
		    {
			 E T61, T64, T6i, T6j;
			 T61 = T7 - Te;
			 T64 = KP707106781 * (T62 + T63);
			 T65 = T61 + T64;
			 T6l = T61 - T64;
			 T6i = FNMS(KP382683432, T66, KP923879532 * T67);
			 T6j = FMA(KP382683432, T69, KP923879532 * T6a);
			 T6k = T6i + T6j;
			 T6m = T6j - T6i;
		    }
		    {
			 E T68, T6b, T6d, T6e;
			 T68 = FMA(KP923879532, T66, KP382683432 * T67);
			 T6b = FNMS(KP382683432, T6a, KP923879532 * T69);
			 T6c = T68 + T6b;
			 T6g = T6b - T68;
			 T6d = KP707106781 * (T63 - T62);
			 T6e = Tt - Tm;
			 T6f = T6d - T6e;
			 T6h = T6e + T6d;
		    }
		    Cr[WS(csr, 28)] = T65 - T6c;
		    Ci[WS(csi, 28)] = T6k - T6h;
		    Cr[WS(csr, 4)] = T65 + T6c;
		    Ci[WS(csi, 4)] = T6h + T6k;
		    Ci[WS(csi, 12)] = T6f + T6g;
		    Cr[WS(csr, 12)] = T6l + T6m;
		    Ci[WS(csi, 20)] = T6g - T6f;
		    Cr[WS(csr, 20)] = T6l - T6m;
	       }
	       {
		    E T5n, T5D, T5x, T5z, T5q, T5A, T5t, T5B;
		    {
			 E T5l, T5m, T5v, T5w;
			 T5l = T4l - T4o;
			 T5m = T58 - T57;
			 T5n = T5l + T5m;
			 T5D = T5l - T5m;
			 T5v = T4v - T4s;
			 T5w = T5b - T5a;
			 T5x = T5v - T5w;
			 T5z = T5w + T5v;
		    }
		    {
			 E T5o, T5p, T5r, T5s;
			 T5o = T4A - T4H;
			 T5p = T4M - T4L;
			 T5q = FMA(KP831469612, T5o, KP555570233 * T5p);
			 T5A = FNMS(KP555570233, T5o, KP831469612 * T5p);
			 T5r = T4R - T4Y;
			 T5s = T53 - T52;
			 T5t = FNMS(KP555570233, T5s, KP831469612 * T5r);
			 T5B = FMA(KP555570233, T5r, KP831469612 * T5s);
		    }
		    {
			 E T5u, T5C, T5y, T5E;
			 T5u = T5q + T5t;
			 Cr[WS(csr, 26)] = T5n - T5u;
			 Cr[WS(csr, 6)] = T5n + T5u;
			 T5C = T5A + T5B;
			 Ci[WS(csi, 6)] = T5z + T5C;
			 Ci[WS(csi, 26)] = T5C - T5z;
			 T5y = T5t - T5q;
			 Ci[WS(csi, 10)] = T5x + T5y;
			 Ci[WS(csi, 22)] = T5y - T5x;
			 T5E = T5B - T5A;
			 Cr[WS(csr, 22)] = T5D - T5E;
			 Cr[WS(csr, 10)] = T5D + T5E;
		    }
	       }
	       {
		    E T4x, T5j, T5d, T5f, T4O, T5g, T55, T5h;
		    {
			 E T4p, T4w, T59, T5c;
			 T4p = T4l + T4o;
			 T4w = T4s + T4v;
			 T4x = T4p + T4w;
			 T5j = T4p - T4w;
			 T59 = T57 + T58;
			 T5c = T5a + T5b;
			 T5d = T59 - T5c;
			 T5f = T5c + T59;
		    }
		    {
			 E T4I, T4N, T4Z, T54;
			 T4I = T4A + T4H;
			 T4N = T4L + T4M;
			 T4O = FMA(KP980785280, T4I, KP195090322 * T4N);
			 T5g = FNMS(KP195090322, T4I, KP980785280 * T4N);
			 T4Z = T4R + T4Y;
			 T54 = T52 + T53;
			 T55 = FNMS(KP195090322, T54, KP980785280 * T4Z);
			 T5h = FMA(KP195090322, T4Z, KP980785280 * T54);
		    }
		    {
			 E T56, T5i, T5e, T5k;
			 T56 = T4O + T55;
			 Cr[WS(csr, 30)] = T4x - T56;
			 Cr[WS(csr, 2)] = T4x + T56;
			 T5i = T5g + T5h;
			 Ci[WS(csi, 2)] = T5f + T5i;
			 Ci[WS(csi, 30)] = T5i - T5f;
			 T5e = T55 - T4O;
			 Ci[WS(csi, 14)] = T5d + T5e;
			 Ci[WS(csi, 18)] = T5e - T5d;
			 T5k = T5h - T5g;
			 Cr[WS(csr, 18)] = T5j - T5k;
			 Cr[WS(csr, 14)] = T5j + T5k;
		    }
	       }
	       {
		    E T3p, T41, T4c, T3S, T3w, T4b, T49, T4h, T3P, T42, T3E, T3W, T46, T4g, T3L;
		    E T3X;
		    {
			 E T3s, T3v, T3A, T3D;
			 T3p = T3n + T3o;
			 T41 = T3n - T3o;
			 T4c = T3R - T3Q;
			 T3S = T3Q + T3R;
			 T3s = FMA(KP831469612, T3q, KP555570233 * T3r);
			 T3v = FNMS(KP555570233, T3u, KP831469612 * T3t);
			 T3w = T3s + T3v;
			 T4b = T3v - T3s;
			 {
			      E T47, T48, T3N, T3O;
			      T47 = T3F - T3G;
			      T48 = T3J - T3I;
			      T49 = FNMS(KP471396736, T48, KP881921264 * T47);
			      T4h = FMA(KP471396736, T47, KP881921264 * T48);
			      T3N = FNMS(KP555570233, T3q, KP831469612 * T3r);
			      T3O = FMA(KP555570233, T3t, KP831469612 * T3u);
			      T3P = T3N + T3O;
			      T42 = T3O - T3N;
			 }
			 T3A = T3y + T3z;
			 T3D = T3B + T3C;
			 T3E = FMA(KP956940335, T3A, KP290284677 * T3D);
			 T3W = FNMS(KP290284677, T3A, KP956940335 * T3D);
			 {
			      E T44, T45, T3H, T3K;
			      T44 = T3y - T3z;
			      T45 = T3C - T3B;
			      T46 = FMA(KP881921264, T44, KP471396736 * T45);
			      T4g = FNMS(KP471396736, T44, KP881921264 * T45);
			      T3H = T3F + T3G;
			      T3K = T3I + T3J;
			      T3L = FNMS(KP290284677, T3K, KP956940335 * T3H);
			      T3X = FMA(KP290284677, T3H, KP956940335 * T3K);
			 }
		    }
		    {
			 E T3x, T3M, T3V, T3Y;
			 T3x = T3p + T3w;
			 T3M = T3E + T3L;
			 Cr[WS(csr, 29)] = T3x - T3M;
			 Cr[WS(csr, 3)] = T3x + T3M;
			 T3V = T3S + T3P;
			 T3Y = T3W + T3X;
			 Ci[WS(csi, 3)] = T3V + T3Y;
			 Ci[WS(csi, 29)] = T3Y - T3V;
		    }
		    {
			 E T3T, T3U, T3Z, T40;
			 T3T = T3P - T3S;
			 T3U = T3L - T3E;
			 Ci[WS(csi, 13)] = T3T + T3U;
			 Ci[WS(csi, 19)] = T3U - T3T;
			 T3Z = T3p - T3w;
			 T40 = T3X - T3W;
			 Cr[WS(csr, 19)] = T3Z - T40;
			 Cr[WS(csr, 13)] = T3Z + T40;
		    }
		    {
			 E T43, T4a, T4f, T4i;
			 T43 = T41 + T42;
			 T4a = T46 + T49;
			 Cr[WS(csr, 27)] = T43 - T4a;
			 Cr[WS(csr, 5)] = T43 + T4a;
			 T4f = T4c + T4b;
			 T4i = T4g + T4h;
			 Ci[WS(csi, 5)] = T4f + T4i;
			 Ci[WS(csi, 27)] = T4i - T4f;
		    }
		    {
			 E T4d, T4e, T4j, T4k;
			 T4d = T4b - T4c;
			 T4e = T49 - T46;
			 Ci[WS(csi, 11)] = T4d + T4e;
			 Ci[WS(csi, 21)] = T4e - T4d;
			 T4j = T41 - T42;
			 T4k = T4h - T4g;
			 Cr[WS(csr, 21)] = T4j - T4k;
			 Cr[WS(csr, 11)] = T4j + T4k;
		    }
	       }
	       {
		    E T1d, T33, T3e, T2U, T1w, T3d, T3b, T3j, T2N, T34, T28, T2Y, T38, T3i, T2J;
		    E T2Z;
		    {
			 E T1m, T1v, T1Y, T27;
			 T1d = T15 - T1c;
			 T33 = T15 + T1c;
			 T3e = T2T + T2Q;
			 T2U = T2Q - T2T;
			 T1m = FMA(KP195090322, T1i, KP980785280 * T1l);
			 T1v = FNMS(KP195090322, T1u, KP980785280 * T1r);
			 T1w = T1m - T1v;
			 T3d = T1v + T1m;
			 {
			      E T39, T3a, T2L, T2M;
			      T39 = T2j + T2y;
			      T3a = T2H + T2C;
			      T3b = FNMS(KP098017140, T3a, KP995184726 * T39);
			      T3j = FMA(KP995184726, T3a, KP098017140 * T39);
			      T2L = FNMS(KP195090322, T1l, KP980785280 * T1i);
			      T2M = FMA(KP980785280, T1u, KP195090322 * T1r);
			      T2N = T2L - T2M;
			      T34 = T2M + T2L;
			 }
			 T1Y = T1M - T1X;
			 T27 = T23 - T26;
			 T28 = FMA(KP634393284, T1Y, KP773010453 * T27);
			 T2Y = FNMS(KP634393284, T27, KP773010453 * T1Y);
			 {
			      E T36, T37, T2z, T2I;
			      T36 = T1X + T1M;
			      T37 = T23 + T26;
			      T38 = FMA(KP098017140, T36, KP995184726 * T37);
			      T3i = FNMS(KP098017140, T37, KP995184726 * T36);
			      T2z = T2j - T2y;
			      T2I = T2C - T2H;
			      T2J = FNMS(KP634393284, T2I, KP773010453 * T2z);
			      T2Z = FMA(KP773010453, T2I, KP634393284 * T2z);
			 }
		    }
		    {
			 E T1x, T2K, T2X, T30;
			 T1x = T1d + T1w;
			 T2K = T28 + T2J;
			 Cr[WS(csr, 25)] = T1x - T2K;
			 Cr[WS(csr, 7)] = T1x + T2K;
			 T2X = T2U + T2N;
			 T30 = T2Y + T2Z;
			 Ci[WS(csi, 7)] = T2X + T30;
			 Ci[WS(csi, 25)] = T30 - T2X;
		    }
		    {
			 E T2V, T2W, T31, T32;
			 T2V = T2N - T2U;
			 T2W = T2J - T28;
			 Ci[WS(csi, 9)] = T2V + T2W;
			 Ci[WS(csi, 23)] = T2W - T2V;
			 T31 = T1d - T1w;
			 T32 = T2Z - T2Y;
			 Cr[WS(csr, 23)] = T31 - T32;
			 Cr[WS(csr, 9)] = T31 + T32;
		    }
		    {
			 E T35, T3c, T3h, T3k;
			 T35 = T33 + T34;
			 T3c = T38 + T3b;
			 Cr[WS(csr, 31)] = T35 - T3c;
			 Cr[WS(csr, 1)] = T35 + T3c;
			 T3h = T3e + T3d;
			 T3k = T3i + T3j;
			 Ci[WS(csi, 1)] = T3h + T3k;
			 Ci[WS(csi, 31)] = T3k - T3h;
		    }
		    {
			 E T3f, T3g, T3l, T3m;
			 T3f = T3d - T3e;
			 T3g = T3b - T38;
			 Ci[WS(csi, 15)] = T3f + T3g;
			 Ci[WS(csi, 17)] = T3g - T3f;
			 T3l = T33 - T34;
			 T3m = T3j - T3i;
			 Cr[WS(csr, 17)] = T3l - T3m;
			 Cr[WS(csr, 15)] = T3l + T3m;
		    }
	       }
	  }
     }
}

static const kr2c_desc desc = { 64, "r2cf_64", {342, 72, 52, 0}, &GENUS };

void X(codelet_r2cf_64) (planner *p) {
     X(kr2c_register) (p, r2cf_64, &desc);
}

#endif				/* HAVE_FMA */
