/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.client;

import com.sleepycat.client.SDatabaseEntry;
import com.sleepycat.client.SDatabaseEntryBase;
import com.sleepycat.thrift.TDbt;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;

public class SMultipleDataEntry
implements SDatabaseEntryBase {
    private int batchSize;
    private List<SDatabaseEntry> entries = new LinkedList<SDatabaseEntry>();
    private Iterator<SDatabaseEntry> iterator;

    void setEntriesFromDbts(List<TDbt> list) {
        this.entries.clear();
        list.forEach(tDbt -> this.entries.add(new SDatabaseEntry((TDbt)tDbt)));
        this.iterator = this.entries.iterator();
    }

    <T> List<T> map(Function<SDatabaseEntry, T> function) {
        return this.entries.stream().map(function::apply).collect(Collectors.toList());
    }

    public int getBatchSize() {
        return this.batchSize;
    }

    public void setBatchSize(int n) {
        this.batchSize = n;
    }

    public void append(byte[] byArray) {
        this.entries.add(new SDatabaseEntry(byArray));
    }

    public boolean next(SDatabaseEntry sDatabaseEntry) {
        if (this.iterator.hasNext()) {
            sDatabaseEntry.setDataFromTDbt((TDbt)this.iterator.next().getThriftObj());
            return true;
        }
        return false;
    }
}

