/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.server.config;

import com.sleepycat.server.config.PropertyHelper;
import com.sleepycat.server.util.FileUtils;
import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.nio.file.attribute.PosixFilePermission;
import java.security.AccessControlException;
import java.util.Properties;
import org.apache.thrift.TProcessorFactory;
import org.apache.thrift.protocol.TCompactProtocol;
import org.apache.thrift.protocol.TProtocolFactory;
import org.apache.thrift.server.THsHaServer;
import org.apache.thrift.server.TServer;
import org.apache.thrift.server.TThreadPoolServer;
import org.apache.thrift.transport.TNonblockingServerSocket;
import org.apache.thrift.transport.TNonblockingServerTransport;
import org.apache.thrift.transport.TSSLTransportFactory;
import org.apache.thrift.transport.TServerSocket;
import org.apache.thrift.transport.TServerTransport;
import org.apache.thrift.transport.TTransportException;

public class BdbServerConfig {
    private static final String PORT = "port";
    private static final String WORKERS = "workers";
    private static final String SSL_HOST = "ssl.host";
    private static final String KEY_STORE = "ssl.keyStore";
    private static final String KEY_STORE_PWD = "ssl.keyStore.password";
    private static final String KEY_STORE_TYPE = "ssl.keyStore.type";
    private static final String KEY_STORE_MANAGER = "ssl.keyStore.manager";
    private static final String TRUST_STORE = "ssl.trustStore";
    private static final String TRUST_STORE_PWD = "ssl.trustStore.password";
    private static final String TRUST_STORE_TYPE = "ssl.trustStore.type";
    private static final String TRUST_STORE_MANAGER = "ssl.trustStore.manager";
    private PropertyHelper properties;

    public BdbServerConfig(Properties properties) {
        this.properties = new PropertyHelper(properties);
    }

    public TServer createServer(TProcessorFactory tProcessorFactory) throws TTransportException, UnknownHostException {
        if (this.isSslEnabled()) {
            return this.createSslServer(tProcessorFactory);
        }
        return this.createHsHaServer(tProcessorFactory);
    }

    private TServer createSslServer(TProcessorFactory tProcessorFactory) throws TTransportException, UnknownHostException {
        TSSLTransportFactory.TSSLTransportParameters tSSLTransportParameters = new TSSLTransportFactory.TSSLTransportParameters();
        if (!this.properties.getString(KEY_STORE, "").isEmpty()) {
            this.configureKeyStore(tSSLTransportParameters);
        }
        if (!this.properties.getString(TRUST_STORE, "").isEmpty()) {
            this.configureTrustStore(tSSLTransportParameters);
        }
        TServerSocket tServerSocket = TSSLTransportFactory.getServerSocket((int)this.getPort(), (int)0, (InetAddress)InetAddress.getByName(this.properties.getString(SSL_HOST, null)), (TSSLTransportFactory.TSSLTransportParameters)tSSLTransportParameters);
        TThreadPoolServer.Args args = new TThreadPoolServer.Args((TServerTransport)tServerSocket);
        args.maxWorkerThreads(this.getWorkers()).minWorkerThreads(this.getWorkers());
        args.protocolFactory((TProtocolFactory)new TCompactProtocol.Factory());
        args.processorFactory(tProcessorFactory);
        return new TThreadPoolServer(args);
    }

    private void configureKeyStore(TSSLTransportFactory.TSSLTransportParameters tSSLTransportParameters) {
        String string = this.properties.getString(KEY_STORE, "");
        String string2 = this.properties.getString(KEY_STORE_PWD, "");
        String string3 = this.properties.getString(KEY_STORE_TYPE, null);
        String string4 = this.properties.getString(KEY_STORE_MANAGER, null);
        this.checkKeyStorePermission(string);
        tSSLTransportParameters.setKeyStore(string, string2, string4, string3);
    }

    private void configureTrustStore(TSSLTransportFactory.TSSLTransportParameters tSSLTransportParameters) {
        String string = this.properties.getString(TRUST_STORE, "");
        String string2 = this.properties.getString(TRUST_STORE_PWD, "");
        String string3 = this.properties.getString(TRUST_STORE_TYPE, null);
        String string4 = this.properties.getString(TRUST_STORE_MANAGER, null);
        this.checkKeyStorePermission(string);
        tSSLTransportParameters.setTrustStore(string, string2, string4, string3);
    }

    private void checkKeyStorePermission(String string) throws AccessControlException {
        try {
            if (FileUtils.hasAnyPermission(string, PosixFilePermission.OTHERS_READ, PosixFilePermission.OTHERS_WRITE, PosixFilePermission.OTHERS_EXECUTE)) {
                throw new AccessControlException("The key store file '" + string + "' must not be globally accessible.");
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private TServer createHsHaServer(TProcessorFactory tProcessorFactory) throws TTransportException {
        TNonblockingServerSocket tNonblockingServerSocket = new TNonblockingServerSocket(this.getPort());
        THsHaServer.Args args = new THsHaServer.Args((TNonblockingServerTransport)tNonblockingServerSocket);
        args.workerThreads(this.getWorkers()).processorFactory(tProcessorFactory);
        args.protocolFactory((TProtocolFactory)new TCompactProtocol.Factory());
        return new THsHaServer(args);
    }

    private boolean isSslEnabled() {
        return !this.properties.getString(SSL_HOST, "").isEmpty();
    }

    public int getPort() {
        return this.properties.getInt(PORT, "8080", 0, 65535);
    }

    private int getWorkers() {
        return this.properties.getInt(WORKERS, "20", 1, Integer.MAX_VALUE);
    }
}

