/* ebfc.h: Shared functions and definitions.
 *
 * Copyright (C) 1999-2001 by Brian Raiter, under the GNU General
 * Public License. No warranty. See COPYING for details.
 */

#ifndef	_ebfc_h_
#define	_ebfc_h_

#include	"elfparts.h"

#ifndef TRUE
#define	TRUE		1
#define	FALSE		0
#endif

/* The following is a list of all the types of elf parts that can
 * appear in a file generated by this program. The numbers assigned to
 * each type are used as indices into the blueprint's part list.
 */
enum
{
    P_EHDR = 0,
    P_PHDRTAB, P_HASH, P_DYNSYM, P_DYNSTR, P_TEXT, P_REL,
    P_GOT, P_DYNAMIC, P_DATA,
    P_SHSTRTAB, P_COMMENT, P_SYMTAB, P_STRTAB, P_SHDRTAB,
    P_COUNT
};

/* Outputs a formatted error message on stderr. If fmt is NULL, then
 * uses the error message supplied by perror(). Always returns false.
 */
extern int err(char const *fmt, ...);

/* Reads the contents of the given file as a Brainfuck program and
 * compiles it into the text segment of the blueprint, as a global
 * function with the given name and for the given target. Relocations
 * and other fixups are added as appropriate, though with incomplete
 * values. The return value is false if a fatal error occurs.
 */
extern int translatebrainfuck(char const *filename, blueprint const *bp,
			      int codetype, char const *function,
			      int compressed);

/* Completes the relocations and other fixups that were added by
 * the previous function.
 */
extern void createfixups(blueprint const *bp, int codetype,
			 char const *function);

#endif
