/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.client;

import com.sleepycat.client.SLogSequenceNumber;
import com.sleepycat.thrift.TActiveTxnStat;
import com.sleepycat.thrift.TTransactionStat;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;

public class STransactionStats {
    private final TTransactionStat stat;
    private final SLogSequenceNumber lastCkp;

    STransactionStats(TTransactionStat tTransactionStat) {
        this.stat = tTransactionStat;
        this.lastCkp = new SLogSequenceNumber(tTransactionStat.lastCkpFile, tTransactionStat.lastCkpOffset);
    }

    public int getNumRestores() {
        return this.stat.numRestores;
    }

    public SLogSequenceNumber getLastCkp() {
        return this.lastCkp;
    }

    public long getTimeCkp() {
        return this.stat.timeCkp;
    }

    public int getLastTxnId() {
        return this.stat.lastTxnId;
    }

    public int getInittxns() {
        return this.stat.inittxns;
    }

    public int getMaxTxns() {
        return this.stat.maxTxns;
    }

    public long getNaborts() {
        return this.stat.naborts;
    }

    public long getNumBegins() {
        return this.stat.numBegins;
    }

    public long getNumCommits() {
        return this.stat.numCommits;
    }

    public int getNactive() {
        return this.stat.nactive;
    }

    public int getNumSnapshot() {
        return this.stat.numSnapshot;
    }

    public int getMaxNactive() {
        return this.stat.maxNactive;
    }

    public int getMaxNsnapshot() {
        return this.stat.maxNsnapshot;
    }

    public long getRegionWait() {
        return this.stat.regionWait;
    }

    public long getRegionNowait() {
        return this.stat.regionNowait;
    }

    public long getRegSize() {
        return this.stat.regSize;
    }

    public Active[] getTxnarray() {
        List<Active> list = this.stat.activeTxns.stream().map(Active::new).collect(Collectors.toList());
        return list.toArray(new Active[list.size()]);
    }

    public String toString() {
        return "TransactionStats:\n  nrestores=" + this.getNumRestores() + "\n  last_ckp=" + this.getLastCkp() + "\n  time_ckp=" + this.getTimeCkp() + "\n  last_txnid=" + this.getLastTxnId() + "\n  inittxns=" + this.getInittxns() + "\n  maxtxns=" + this.getMaxTxns() + "\n  naborts=" + this.getNaborts() + "\n  nbegins=" + this.getNumBegins() + "\n  ncommits=" + this.getNumCommits() + "\n  nactive=" + this.getNactive() + "\n  nsnapshot=" + this.getNumSnapshot() + "\n  maxnactive=" + this.getMaxNactive() + "\n  maxnsnapshot=" + this.getMaxNsnapshot() + "\n  region_wait=" + this.getRegionWait() + "\n  region_nowait=" + this.getRegionNowait() + "\n  regsize=" + this.getRegSize() + "\n  txnarray=" + Arrays.toString(this.getTxnarray());
    }

    public static class Active {
        private final TActiveTxnStat stat;
        private final SLogSequenceNumber lsn;
        private final SLogSequenceNumber readLsn;

        Active(TActiveTxnStat tActiveTxnStat) {
            this.stat = tActiveTxnStat;
            this.lsn = new SLogSequenceNumber(tActiveTxnStat.lsnFile, tActiveTxnStat.lsnOffset);
            this.readLsn = new SLogSequenceNumber(tActiveTxnStat.readLsnFile, tActiveTxnStat.readLsnOffset);
        }

        public int getTxnId() {
            return this.stat.txnId;
        }

        public int getParentId() {
            return this.stat.parentId;
        }

        public int getPid() {
            return this.stat.pid;
        }

        public SLogSequenceNumber getLsn() {
            return this.lsn;
        }

        public SLogSequenceNumber getReadLsn() {
            return this.readLsn;
        }

        public int getMultiversionRef() {
            return this.stat.multiversionRef;
        }

        public int getPriority() {
            return this.stat.priority;
        }

        public String getName() {
            return this.stat.name;
        }

        public String toString() {
            return "Active:\n      txnid=" + this.getTxnId() + "\n      parentid=" + this.getParentId() + "\n      pid=" + this.getPid() + "\n      lsn=" + this.getLsn() + "\n      read_lsn=" + this.getReadLsn() + "\n      mvcc_ref=" + this.getMultiversionRef() + "\n      priority=" + this.getPriority() + "\n      name=" + this.getName();
        }
    }
}

