/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.client;

import com.sleepycat.client.SCursorConfig;
import com.sleepycat.client.SDatabase;
import com.sleepycat.client.SDatabaseEntry;
import com.sleepycat.client.SDatabaseException;
import com.sleepycat.client.SEnvironment;
import com.sleepycat.client.SLockMode;
import com.sleepycat.client.SOperationStatus;
import com.sleepycat.client.SSecondaryConfig;
import com.sleepycat.client.SSecondaryCursor;
import com.sleepycat.client.STransaction;
import com.sleepycat.thrift.BdbService;
import com.sleepycat.thrift.TCursor;
import com.sleepycat.thrift.TDatabase;
import com.sleepycat.thrift.TDbGetConfig;
import com.sleepycat.thrift.TDbGetMode;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

public class SSecondaryDatabase
extends SDatabase {
    private final SDatabase primary;
    private final SSecondaryConfig config;

    SSecondaryDatabase(TDatabase tDatabase, String string, String string2, BdbService.Client client, SEnvironment sEnvironment, SDatabase sDatabase, SSecondaryConfig sSecondaryConfig) {
        super(tDatabase, string, string2, client, sEnvironment);
        this.primary = sDatabase;
        this.config = sSecondaryConfig;
        sDatabase.associate(this);
    }

    @Override
    public void close() throws SDatabaseException {
        this.primary.disassociate(this);
        super.close();
    }

    public SDatabase getPrimaryDatabase() {
        return this.primary;
    }

    public SOperationStatus get(STransaction sTransaction, SDatabaseEntry sDatabaseEntry, SDatabaseEntry sDatabaseEntry2, SDatabaseEntry sDatabaseEntry3, SLockMode sLockMode) throws SDatabaseException {
        if (sDatabaseEntry.getPartial()) {
            throw new IllegalArgumentException("Partial secondary key is not supported.");
        }
        return this.dbPGet(sTransaction, sDatabaseEntry, sDatabaseEntry2, sDatabaseEntry3, sLockMode, TDbGetMode.DEFAULT);
    }

    public SOperationStatus getSearchBoth(STransaction sTransaction, SDatabaseEntry sDatabaseEntry, SDatabaseEntry sDatabaseEntry2, SDatabaseEntry sDatabaseEntry3, SLockMode sLockMode) throws SDatabaseException {
        if (sDatabaseEntry.getPartial()) {
            throw new IllegalArgumentException("Partial secondary key is not supported.");
        }
        return this.dbPGet(sTransaction, sDatabaseEntry, sDatabaseEntry2, sDatabaseEntry3, sLockMode, TDbGetMode.GET_BOTH);
    }

    public SOperationStatus getSearchRecordNumber(STransaction sTransaction, SDatabaseEntry sDatabaseEntry, SDatabaseEntry sDatabaseEntry2, SDatabaseEntry sDatabaseEntry3, SLockMode sLockMode) throws SDatabaseException {
        return this.dbPGet(sTransaction, sDatabaseEntry, sDatabaseEntry2, sDatabaseEntry3, sLockMode, TDbGetMode.SET_RECNO);
    }

    private SOperationStatus dbPGet(STransaction sTransaction, SDatabaseEntry sDatabaseEntry, SDatabaseEntry sDatabaseEntry2, SDatabaseEntry sDatabaseEntry3, SLockMode sLockMode, TDbGetMode tDbGetMode) {
        return this.remotePGet(sDatabaseEntry, sDatabaseEntry2, sDatabaseEntry3, tKeyDataWithPKey -> {
            TDbGetConfig tDbGetConfig = this.createConfig(sDatabaseEntry3, sLockMode).setMode(tDbGetMode);
            return this.client.dbGetWithPKey(this.tDb, STransaction.nullSafeGet(sTransaction), tKeyDataWithPKey, tDbGetConfig);
        });
    }

    @Override
    public SSecondaryCursor openCursor(STransaction sTransaction, SCursorConfig sCursorConfig) throws SDatabaseException {
        return this.remoteCall(() -> {
            TCursor tCursor = this.client.openCursor(this.tDb, STransaction.nullSafeGet(sTransaction), SCursorConfig.nullSafeGet(sCursorConfig));
            return new SSecondaryCursor(tCursor, this, this.client);
        });
    }

    Set<SDatabaseEntry> calculateSKeys(SDatabaseEntry sDatabaseEntry, SDatabaseEntry sDatabaseEntry2) {
        if (this.config.getKeyCreator() != null) {
            SDatabaseEntry sDatabaseEntry3 = new SDatabaseEntry();
            if (this.config.getKeyCreator().createSecondaryKey(this, sDatabaseEntry, sDatabaseEntry2, sDatabaseEntry3)) {
                return Collections.singleton(sDatabaseEntry3);
            }
        } else if (this.config.getMultiKeyCreator() != null) {
            HashSet<SDatabaseEntry> hashSet = new HashSet<SDatabaseEntry>();
            this.config.getMultiKeyCreator().createSecondaryKeys(this, sDatabaseEntry, sDatabaseEntry2, hashSet);
            return hashSet;
        }
        return Collections.emptySet();
    }
}

